/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.capability;

import com.interactivemesh.j3d.capability.CapBitSelectorFrame;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

final class CapBitSelector {
    Preferences packPref = null;
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String LOCX = "locX";
    private static final String LOCY = "locY";
    static final String DIV_LOC = "divLocation";
    private static final String FONT_FAM = "ffamilie";
    private static final String FONT_SIZE = "fstyle";
    private static final String FONT_STYLE = "fsize";
    SelectorTheme theme = null;

    public static void main(String[] args) {
        new CapBitSelector();
    }

    private CapBitSelector() {
        long allBits = 0L;
        int i = 0;
        while (i < 48) {
            long bit = 1L << i;
            System.out.println("allBits = " + i + " / " + (allBits |= bit));
            ++i;
        }
        System.out.println("allBits = " + allBits);
        System.out.println("BinaryString = " + Long.toBinaryString(allBits));
        System.out.println("HexString = " + Long.toHexString(allBits));
        System.out.println("OctalString = " + Long.toOctalString(allBits));
        double pow = Math.pow(2.0, 48.0);
        System.out.println("Math.pow(2, 48) - 1 = " + (pow -= 1.0));
        this.packPref = Preferences.userNodeForPackage(this.getClass());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                int fontSize = 14;
                if (screenSize.height < 1024) {
                    fontSize = 11;
                } else if (screenSize.height < 1200) {
                    fontSize = 12;
                }
                Font defaultFont = new Font("Lucida Sans", 1, fontSize);
                Font font = new Font(CapBitSelector.this.packPref.get(CapBitSelector.FONT_FAM, "Lucida Sans"), CapBitSelector.this.packPref.getInt(CapBitSelector.FONT_SIZE, 1), CapBitSelector.this.packPref.getInt(CapBitSelector.FONT_STYLE, fontSize));
                try {
                    CapBitSelector.this.theme = new SelectorTheme(font, defaultFont);
                    MetalLookAndFeel metalLnF = new MetalLookAndFeel();
                    MetalLookAndFeel.setCurrentTheme(CapBitSelector.this.theme);
                    UIManager.setLookAndFeel(metalLnF);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Dimension defaultSize = new Dimension((int)((double)screenSize.width * 0.5), (int)((double)screenSize.height * 0.75));
                Point defaultLoc = new Point((screenSize.width - defaultSize.width) / 2, (screenSize.height - defaultSize.height) / 2);
                Dimension frameSize = new Dimension(CapBitSelector.this.packPref.getInt(CapBitSelector.WIDTH, defaultSize.width), CapBitSelector.this.packPref.getInt(CapBitSelector.HEIGHT, defaultSize.height));
                Point frameLoc = new Point(CapBitSelector.this.packPref.getInt(CapBitSelector.LOCX, defaultLoc.x), CapBitSelector.this.packPref.getInt(CapBitSelector.LOCY, defaultLoc.y));
                if (frameLoc.x > frameSize.width - 10) {
                    frameLoc.x = 10;
                }
                if (frameLoc.y > frameSize.height - 10) {
                    frameLoc.y = 10;
                }
                final CapBitSelectorFrame frame = new CapBitSelectorFrame(CapBitSelector.this, CapBitSelector.this.theme.getFont());
                frame.setTitle("InteractiveMesh : CapBitSelector");
                frame.setDefaultCloseOperation(3);
                frame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent event) {
                        CapBitSelector.this.setFramePrefs(frame);
                    }

                    public void windowClosed(WindowEvent event) {
                        CapBitSelector.this.setFramePrefs(frame);
                    }
                });
                frame.setPreferredSize(frameSize);
                frame.setLocation(frameLoc);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    void setFramePrefs(CapBitSelectorFrame frame) {
        frame.setPrefs();
        this.packPref.putInt(LOCX, frame.getLocation().x);
        this.packPref.putInt(LOCY, frame.getLocation().y);
        this.packPref.putInt(WIDTH, frame.getWidth());
        this.packPref.putInt(HEIGHT, frame.getHeight());
    }

    final class SelectorTheme
    extends OceanTheme {
        private ColorUIResource black = new ColorUIResource(new Color(0, 0, 0));
        private Font font = null;
        private FontUIResource fontRes = null;
        private Font fontDefault = null;

        private SelectorTheme(Font font, Font dFont) {
            this.font = font;
            this.fontRes = new FontUIResource(font);
            this.fontDefault = dFont;
        }

        Font getDefaultFont() {
            return this.fontDefault;
        }

        Font getFont() {
            return this.font;
        }

        void setFont(Font font) {
            this.font = font;
            this.fontRes = new FontUIResource(font);
            CapBitSelector.this.packPref.put(CapBitSelector.FONT_FAM, font.getFamily());
            CapBitSelector.this.packPref.putInt(CapBitSelector.FONT_SIZE, font.getStyle());
            CapBitSelector.this.packPref.putInt(CapBitSelector.FONT_STYLE, font.getSize());
        }

        public ColorUIResource getBlack() {
            return this.black;
        }

        public FontUIResource getSystemTextFont() {
            return this.fontRes;
        }

        public FontUIResource getControlTextFont() {
            return this.fontRes;
        }

        public FontUIResource getMenuTextFont() {
            return this.fontRes;
        }

        public FontUIResource getUserTextFont() {
            return this.fontRes;
        }
    }
}

