/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.obj;

import com.interactivemesh.jfx.image.ImageFactory;
import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.obj.ObjImportOption;
import com.interactivemesh.jfx.importer.obj.ObjModelImporterImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;

final class MtlMaterial {
    private ObjModelImporterImpl oSh3DImporter = null;
    private final HashMap<String, OMaterial> rOMaterials;
    private final HashMap<String, PhongMaterial> materials;
    private final IdentityHashMap<Image, FilePath> imagePaths;
    private boolean asWritableImage = false;
    private final ImageFactory imgFactory;

    MtlMaterial(ObjModelImporterImpl objModelImporterImpl) throws ImportException {
        this.oSh3DImporter = objModelImporterImpl;
        this.rOMaterials = new HashMap();
        this.materials = new HashMap();
        this.imagePaths = new IdentityHashMap();
        this.imgFactory = new ImageFactory();
    }

    void clear() {
        this.rOMaterials.clear();
        this.materials.clear();
        this.imagePaths.clear();
    }

    void close() {
        this.imgFactory.close();
        this.oSh3DImporter = null;
    }

    void setOptions(EnumSet<ObjImportOption> enumSet) {
        this.asWritableImage = enumSet.contains((Object)ObjImportOption.MAP_WRITABLEIMAGE);
    }

    HashMap<String, PhongMaterial> getAllUsedMaterials() {
        return this.materials;
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        return this.imagePaths;
    }

    PhongMaterial getMaterial(String string, boolean bl, boolean bl2) throws ImportException {
        Object object;
        if (this.rOMaterials.isEmpty() && (string == null || string.length() < 1)) {
            return null;
        }
        if (bl2 && (object = this.materials.get(string)) != null) {
            return object;
        }
        object = this.rOMaterials.get(string);
        if (object == null) {
            throw new ImportException("Material not found in mtl-file, name = >" + string + "<");
        }
        PhongMaterial phongMaterial = new PhongMaterial();
        if (((OMaterial)object).Kd != null) {
            phongMaterial.setDiffuseColor(((OMaterial)object).Kd);
        }
        if (((OMaterial)object).Ks != null) {
            phongMaterial.setSpecularColor(((OMaterial)object).Ks);
        }
        if (((OMaterial)object).Ns != 1.0) {
            phongMaterial.setSpecularPower(((OMaterial)object).Ns);
        }
        if (((OMaterial)object).mapKd != null) {
            phongMaterial.setDiffuseMap(((OMaterial)object).mapKd);
        }
        if (((OMaterial)object).mapKs != null) {
            phongMaterial.setSpecularMap(((OMaterial)object).mapKs);
        }
        if (((OMaterial)object).mapBump != null) {
            phongMaterial.setBumpMap(((OMaterial)object).mapBump);
        }
        this.materials.put(string, phongMaterial);
        return phongMaterial;
    }

    PhongMaterial createNoTexMatFrom(PhongMaterial phongMaterial, String string) {
        PhongMaterial phongMaterial2 = new PhongMaterial();
        phongMaterial2.setDiffuseColor(phongMaterial.getDiffuseColor());
        phongMaterial2.setSpecularColor(phongMaterial.getSpecularColor());
        phongMaterial2.setSpecularPower(phongMaterial.getSpecularPower());
        this.materials.put(string, phongMaterial2);
        return phongMaterial2;
    }

    void readMaterialFile(URL uRL, ObjModelImporterImpl.BaseURL baseURL, EnumSet<ObjImportOption> enumSet) throws ImportException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "ISO-8859-1"));
            this.readFile(bufferedReader, this.rOMaterials, baseURL);
        }
        catch (IOException e) {
            System.out.println("OShapeImporter : mtl-file not found = " + uRL);
            return;
        }
    }

    private void readFile(BufferedReader bufferedReader, HashMap<String, OMaterial> hashMap, ObjModelImporterImpl.BaseURL baseURL) throws ImportException {
        String string = null;
        String string2 = null;
        OMaterial oMaterial = null;
        try {
            while ((string = bufferedReader.readLine()) != null) {
                String string3;
                string2 = this.oSh3DImporter.firstWordOf(string);
                if (string2.equals("newmtl")) {
                    if (string.length() <= string.indexOf(108) + 1) continue;
                    string3 = this.oSh3DImporter.trimString(string.substring("newmtl".length()));
                    if (string3 == null || string3.length() < 1) {
                        string3 = 'M' + Long.toString(System.currentTimeMillis());
                        System.out.println("Can't read newmtl due to missing name = \"" + string + "\"");
                    }
                    oMaterial = new OMaterial();
                    hashMap.put(string3, oMaterial);
                    continue;
                }
                if (string2.equals("Ka")) {
                    if (oMaterial != null) continue;
                    continue;
                }
                if (string2.equals("Kd")) {
                    if (oMaterial == null) continue;
                    oMaterial.Kd = this.readColor(string);
                    continue;
                }
                if (string2.equals("Ks")) {
                    if (oMaterial == null) continue;
                    oMaterial.Ks = this.readColor(string);
                    continue;
                }
                if (string2.equals("Ke")) {
                    if (oMaterial != null) continue;
                    continue;
                }
                if (string2.equals("illum")) {
                    if (oMaterial != null) continue;
                    continue;
                }
                if (string2.equals("d")) {
                    if (oMaterial != null) continue;
                    continue;
                }
                if (string2.equals("Ns")) {
                    if (oMaterial == null) continue;
                    string3 = this.oSh3DImporter.firstWordOf(string.substring(string.indexOf(115) + 1));
                    oMaterial.Ns = Float.parseFloat(string3);
                    if (oMaterial.Ns < 1.0) {
                        oMaterial.Ns = 1.0;
                        continue;
                    }
                    if (!(oMaterial.Ns > 128.0)) continue;
                    oMaterial.Ns = 128.0;
                    continue;
                }
                if (string2.equals("map_Kd")) {
                    if (oMaterial == null) continue;
                    string3 = this.oSh3DImporter.trimString(string.substring("map_Kd".length()));
                    oMaterial.mapKd = this.readImage(string3, baseURL);
                    continue;
                }
                if (string2.equals("map_Ks")) {
                    if (oMaterial == null) continue;
                    string3 = this.oSh3DImporter.trimString(string.substring("map_Ks".length()));
                    oMaterial.mapKs = this.readImage(string3, baseURL);
                    continue;
                }
                if (string2.equalsIgnoreCase("bump") || string2.equalsIgnoreCase("map_Bump")) {
                    if (oMaterial == null) continue;
                    string3 = null;
                    string3 = string2.equalsIgnoreCase("bump") ? this.oSh3DImporter.trimString(string.substring("bump".length())) : this.oSh3DImporter.trimString(string.substring("map_Bump".length()));
                    oMaterial.mapBump = this.readImage(string3, baseURL);
                    continue;
                }
                if (string2.length() <= 0 || string.startsWith("#") || string2.equals("Ni") || string2.equals("Tf") || string2.equals("Tr") || string2.equals("sharpness") || string2.equals("map_Ka") || string2.equals("map_Ns")) continue;
                System.out.println("OShapeAppearance : Unsupported line = \"" + string + "\"");
            }
        }
        catch (IOException e) {
            throw new ImportException("Material readFile", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Color readColor(String string) throws ImportException {
        float[] fArray = new float[3];
        int n = 32;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 32;
        string = string.substring(string.indexOf(75) + 2);
        int n6 = 0;
        int n7 = string.length();
        try {
            block2: while (true) {
                if (n6 < n7 && n4 < 3) {
                    n5 = string.charAt(n6);
                    if (n5 <= n) {
                        ++n6;
                        continue;
                    }
                } else {
                    if (n2 <= n3) return new Color((double)fArray[0], (double)fArray[1], (double)fArray[2], 1.0);
                    fArray[n4] = Float.parseFloat(string.substring(n2));
                    if (fArray[n4] > 1.0f) {
                        fArray[n4] = 1.0f;
                        return new Color((double)fArray[0], (double)fArray[1], (double)fArray[2], 1.0);
                    }
                    if (!(fArray[n4] < 0.0f)) return new Color((double)fArray[0], (double)fArray[1], (double)fArray[2], 1.0);
                    fArray[n4] = 0.0f;
                    return new Color((double)fArray[0], (double)fArray[1], (double)fArray[2], 1.0);
                }
                n2 = n6++;
                while (true) {
                    if (n6 >= n7) continue block2;
                    n5 = string.charAt(n6);
                    if (n5 <= n) {
                        n3 = n6;
                        fArray[n4] = Float.parseFloat(string.substring(n2, n3));
                        if (fArray[n4] > 1.0f) {
                            fArray[n4] = 1.0f;
                        } else if (fArray[n4] < 0.0f) {
                            fArray[n4] = 0.0f;
                        }
                        ++n4;
                        ++n6;
                        continue block2;
                    }
                    ++n6;
                }
                break;
            }
        }
        catch (NumberFormatException e) {
            throw new ImportException("Material readColor", e);
        }
    }

    private Image readImage(String string, ObjModelImporterImpl.BaseURL baseURL) {
        URL uRL = null;
        uRL = this.oSh3DImporter.getUrlForAbsolutPath(string = string.replace('\\', '/'));
        if (uRL == null) {
            uRL = this.oSh3DImporter.getUrlForRelativePath(baseURL, string);
        }
        if (uRL == null) {
            throw new ImportException("Can't create URL for image path = \n" + string);
        }
        String string2 = uRL.toExternalForm();
        int n = string2.lastIndexOf(46) + 1;
        String string3 = string2.substring(n);
        WritableImage writableImage = null;
        try {
            if (string3.equalsIgnoreCase("tga")) {
                writableImage = this.imgFactory.readImage(string3, uRL);
            } else if (string3.equalsIgnoreCase("tif") || string3.equalsIgnoreCase("tiff")) {
                writableImage = this.imgFactory.readImage(string3, uRL);
            } else {
                if (this.asWritableImage) {
                    writableImage = this.imgFactory.readImage(string3, uRL);
                }
                if (writableImage == null) {
                    writableImage = new Image(string2);
                }
            }
        }
        catch (IOException e) {
            throw new ImportException("Can't create image for URL = \n" + uRL.toString(), e);
        }
        if (writableImage != null) {
            this.imagePaths.put((Image)writableImage, new FilePath(string, uRL));
            return writableImage;
        }
        throw new ImportException("Can't create image for URL = \n" + uRL.toString());
    }

    private final class OMaterial {
        private Color Kd = null;
        private Color Ks = null;
        private double Ns = 1.0;
        private Image mapKd = null;
        private Image mapKs = null;
        private Image mapBump = null;

        private OMaterial() {
        }
    }
}

