/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.obj;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.obj.MeshSmoother;
import com.interactivemesh.jfx.importer.obj.MtlMaterial;
import com.interactivemesh.jfx.importer.obj.Normalizer;
import com.interactivemesh.jfx.importer.obj.ObjImportOption;
import com.interactivemesh.jfx.importer.obj.ObjModelImporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.scene.image.Image;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;

final class ObjModelImporterImpl {
    private static int SIZE = 32768;
    private VS_N globalNormalState = VS_N.NULL;
    private URL baseUrlU = null;
    private String basePathU = null;
    private boolean isUserBase = false;
    private BaseURL baseUrlUser = null;
    private BaseURL baseUrlObj = null;
    private double creaseAngle = Math.toRadians(45.0);
    private final EnumSet<ObjImportOption> objOpts = EnumSet.of(ObjImportOption.NONE);
    private final Normalizer normalizer;
    private final MeshSmoother smoother;
    private final MtlMaterial materials;
    private LineReader lReader = null;
    private final HashMap<PhongMaterial, PhongMaterial> matNoTexMatMap;
    private final ArrayList<ObjShape> objShapes;
    private final HashMap<String, ObjGroup> objGroupsFace;
    private int coordsLength = 0;
    private int coordsSize = 0;
    private float[] coordsList = null;
    private int texsLength = 0;
    private int texsSize = 0;
    private float[] texsList = null;
    private int normalsLength = 0;
    private int normalsSize = 0;
    private float[] normalsList = null;
    private String currGroupName = "Group";
    private String currMaterialName = "";
    private Vertex currVertex = null;
    private HashMap<Integer, SmGr> smGrs = null;
    private SmGr currSmGr = null;
    private static final int NO_SMOOTH_GROUPS = -2;
    private boolean isSmGrChanged = true;
    private int currSmGrId = -2;
    private boolean isVeryFirstFace = true;
    private boolean isGrpMatVertChangeFace = true;
    private int[] indCtsListFace = null;
    private ListInfo indCtsListInfoFace = null;
    private int[] startIndicesFace = null;
    private int[] smGrpIdPerFace = null;
    private ListInfo vertIndsListInfoFace = null;
    private int[] coordIndsListFace = null;
    private int[] normalIndsListFace = null;
    private int[] texIndsListFace = null;
    private ObjShapeFace currObjShapeFace = null;
    private final HashMap<String, MeshView> namedMeshViews = new HashMap();
    private MeshView[] importedMeshViews = null;
    private boolean isClosed = false;
    private final ObjModelImporter importer;
    private int[] vertsDone = null;
    private int[] resetInds = null;

    ObjModelImporterImpl(ObjModelImporter objModelImporter) {
        this.importer = objModelImporter;
        this.normalizer = new Normalizer();
        this.smoother = new MeshSmoother();
        this.materials = new MtlMaterial(this);
        this.matNoTexMatMap = new HashMap();
        this.objGroupsFace = new HashMap();
        this.objShapes = new ArrayList();
    }

    double getCreaseAngle() {
        return Math.toDegrees(this.creaseAngle);
    }

    void setCreaseAngle(double d) {
        double d2 = Math.toRadians(d);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > Math.PI) {
            d2 = 3.1415927410125732;
        }
        this.creaseAngle = d2;
    }

    String getResourcePath() {
        return this.basePathU;
    }

    void setResourcePath(String string) {
        this.baseUrlU = null;
        this.basePathU = string;
        boolean bl = this.isUserBase = string != null && string.length() > 0;
        if (this.isUserBase) {
            URL uRL;
            string.trim();
            string = string.replace('\\', '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if ((uRL = this.getUrlForAbsolutPath(string)) == null) {
                throw new ImportException("ObjModelImporter setResourcePath : Can't create absolute URL from = " + string);
            }
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
        } else {
            this.baseUrlUser = null;
        }
    }

    URL getResourceUrl() {
        return this.baseUrlU;
    }

    void setResourceUrl(URL uRL) {
        this.basePathU = null;
        this.baseUrlU = uRL;
        boolean bl = this.isUserBase = uRL != null;
        if (this.isUserBase) {
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
            if (!this.baseUrlUser.path.endsWith("/")) {
                this.baseUrlUser.path = this.baseUrlUser.path + "/";
            }
        } else {
            this.baseUrlUser = null;
        }
    }

    EnumSet<ObjImportOption> getOptions() {
        return this.objOpts.clone();
    }

    void setOptions(ObjImportOption ... objImportOptionArray) {
        if (objImportOptionArray == null || objImportOptionArray.length < 1) {
            throw new IllegalArgumentException("options is null || options' length < 1");
        }
        if (objImportOptionArray.length > 1) {
            for (ObjImportOption objImportOption : objImportOptionArray) {
                if (objImportOption != ObjImportOption.NONE) continue;
                throw new IllegalArgumentException("options include ObjImportOption.NONE");
            }
        }
        this.objOpts.clear();
        for (ObjImportOption objImportOption : objImportOptionArray) {
            this.objOpts.add(objImportOption);
        }
        this.materials.setOptions(this.objOpts);
    }

    void setOptions(EnumSet<ObjImportOption> enumSet) {
        if (enumSet == null || enumSet.isEmpty()) {
            throw new IllegalArgumentException("options is null || options is empty");
        }
        if (enumSet.size() > 1) {
            for (ObjImportOption objImportOption : enumSet) {
                if (objImportOption != ObjImportOption.NONE) continue;
                throw new IllegalArgumentException("options include ObjImportOption.NONE");
            }
        }
        this.objOpts.clear();
        this.objOpts.addAll(enumSet);
        this.materials.setOptions(this.objOpts);
    }

    void read(File file) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (file == null) {
            throw new ImportException("ObjModelImporter read(File file) : file is null !");
        }
        if (!file.exists()) {
            throw new ImportException("ObjModelImporter read(File file) : file doesn't exist !");
        }
        if (file.isDirectory()) {
            throw new ImportException("ObjModelImporter read(File file) : file is directory !");
        }
        if (!file.canRead()) {
            throw new ImportException("ObjModelImporter read(File file) : file can't be read !");
        }
        try {
            URL uRL = file.toURI().toURL();
            this.baseUrlObj = new BaseURL();
            this.baseUrlObj.protocol = uRL.getProtocol();
            this.baseUrlObj.host = uRL.getHost();
            this.baseUrlObj.port = uRL.getPort();
            this.baseUrlObj.path = uRL.getPath();
            int n = this.baseUrlObj.path.lastIndexOf(47);
            if (n >= 0) {
                this.baseUrlObj.path = this.baseUrlObj.path.substring(0, n + 1);
            } else if (n < 0) {
                this.baseUrlObj.path = Character.toString('/');
            }
        }
        catch (MalformedURLException e) {
            throw new ImportException("ObjModelImporter read(File file) : \n" + e.getMessage(), e);
        }
        try {
            this.readWithLineReader(new InputStreamReader((InputStream)new FileInputStream(file), "ISO-8859-1"));
        }
        catch (FileNotFoundException e) {
            throw new ImportException("ObjModelImporter read(File file) : \n" + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ImportException("ObjModelImporter read(File file) : \n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ImportException("ObjModelImporter read(File file) : \n" + e.getMessage(), e);
        }
    }

    void read(String string) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (string == null || string.length() < 1) {
            throw new ImportException("ObjModelImporter read(String fileName) : fileName is null !");
        }
        URL uRL = null;
        try {
            String string2;
            string = string.replace('\\', '/');
            uRL = this.getUrlForAbsolutPath(string);
            if (uRL == null && (string2 = System.getProperty("user.dir")).length() > 0) {
                if ((string2 = string2.replace('\\', '/')).charAt(0) != '/') {
                    string2 = '/' + string2;
                }
                if (string2.charAt(string2.length() - 1) != '/') {
                    string2 = string2 + '/';
                }
                uRL = new URL("file", null, this.normalizePath(string2, string));
            }
            if (uRL == null) {
                throw new ImportException("ObjModelImporter read(String fileName) : Can' create URL f0r = \n" + string);
            }
            this.baseUrlObj = new BaseURL();
            this.baseUrlObj.protocol = uRL.getProtocol();
            this.baseUrlObj.host = uRL.getHost();
            this.baseUrlObj.port = uRL.getPort();
            this.baseUrlObj.path = uRL.getPath();
            int n = this.baseUrlObj.path.lastIndexOf(47);
            if (n >= 0) {
                this.baseUrlObj.path = this.baseUrlObj.path.substring(0, n + 1);
            } else if (n < 0) {
                this.baseUrlObj.path = Character.toString('/');
            }
        }
        catch (SecurityException e) {
            throw new ImportException("ObjModelImporter read(String fileName) : \n" + e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            throw new ImportException("ObjModelImporter read(String fileName) : \n" + e.getMessage(), e);
        }
        try {
            this.readWithLineReader(new InputStreamReader(uRL.openStream(), "ISO-8859-1"));
        }
        catch (FileNotFoundException e) {
            throw new ImportException("ObjModelImporter read(String fileName) : \n" + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ImportException("ObjModelImporter read(String fileName) : \n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ImportException("ObjModelImporter read(String fileName) : \n" + e.getMessage(), e);
        }
    }

    void read(URL uRL) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (uRL == null) {
            throw new ImportException("ObjModelImporter read(URL url) : url is null !");
        }
        this.baseUrlObj = new BaseURL();
        this.baseUrlObj.protocol = uRL.getProtocol();
        this.baseUrlObj.host = uRL.getHost();
        this.baseUrlObj.port = uRL.getPort();
        this.baseUrlObj.path = uRL.getPath();
        int n = this.baseUrlObj.path.lastIndexOf(47);
        this.baseUrlObj.path = n >= 0 ? this.baseUrlObj.path.substring(0, n + 1) : Character.toString('/');
        try {
            this.readWithLineReader(new InputStreamReader(uRL.openStream(), "ISO-8859-1"));
        }
        catch (FileNotFoundException e) {
            throw new ImportException("ObjModelImporter read(URL url) : \n" + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ImportException("ObjModelImporter read(URL url) : \n" + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ImportException("ObjModelImporter read(URL url) : \n" + e.getMessage(), e);
        }
    }

    MeshView[] getImport() {
        MeshView[] meshViewArray = null;
        int n = 0;
        if (this.importedMeshViews != null && (n = this.importedMeshViews.length) > 0) {
            meshViewArray = new MeshView[n];
            for (int i = 0; i < n; ++i) {
                meshViewArray[i] = this.importedMeshViews[i];
            }
        }
        return meshViewArray;
    }

    Map<String, MeshView> getNamedMeshViews() {
        HashMap<String, MeshView> hashMap = null;
        int n = 0;
        n = this.namedMeshViews.size();
        if (n > 0) {
            hashMap = new HashMap<String, MeshView>(n, 1.0f);
            Set<Map.Entry<String, MeshView>> set = this.namedMeshViews.entrySet();
            Iterator<Map.Entry<String, MeshView>> iterator = set.iterator();
            Map.Entry<String, MeshView> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    Map<String, PhongMaterial> getNamedMaterials() {
        HashMap<String, PhongMaterial> hashMap = null;
        int n = 0;
        HashMap<String, PhongMaterial> hashMap2 = this.materials.getAllUsedMaterials();
        if (hashMap2 != null && (n = hashMap2.size()) > 0) {
            hashMap = new HashMap<String, PhongMaterial>(n, 1.0f);
            Set<Map.Entry<String, PhongMaterial>> set = hashMap2.entrySet();
            Iterator<Map.Entry<String, PhongMaterial>> iterator = set.iterator();
            Map.Entry<String, PhongMaterial> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        IdentityHashMap<Image, FilePath> identityHashMap = this.materials.getImagePaths();
        int n = identityHashMap.size();
        if (n > 0) {
            IdentityHashMap<Image, FilePath> identityHashMap2 = new IdentityHashMap<Image, FilePath>(n);
            Set<Map.Entry<Image, FilePath>> set = identityHashMap.entrySet();
            Iterator<Map.Entry<Image, FilePath>> iterator = set.iterator();
            Map.Entry<Image, FilePath> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                identityHashMap2.put(entry.getKey(), entry.getValue());
            }
            return identityHashMap2;
        }
        return null;
    }

    void clear() {
        this.objShapes.clear();
        this.namedMeshViews.clear();
        this.importedMeshViews = null;
        this.materials.clear();
        this.currVertex = null;
        this.globalNormalState = VS_N.NULL;
        if (this.smGrs != null) {
            Collection<SmGr> collection = this.smGrs.values();
            Iterator<SmGr> iterator = collection.iterator();
            while (iterator.hasNext()) {
                iterator.next().clear();
            }
            this.smGrs.clear();
            this.smGrs = null;
        }
        this.objGroupsFace.clear();
        this.coordsList = null;
        this.normalsList = null;
        this.texsList = null;
        this.currSmGr = null;
        this.isSmGrChanged = true;
        this.currSmGrId = -2;
        this.isVeryFirstFace = true;
        this.isGrpMatVertChangeFace = true;
        this.currGroupName = "Group";
        this.currMaterialName = "";
        this.indCtsListFace = null;
        this.indCtsListInfoFace = null;
        this.startIndicesFace = null;
        this.smGrpIdPerFace = null;
        this.vertIndsListInfoFace = null;
        this.coordIndsListFace = null;
        this.normalIndsListFace = null;
        this.texIndsListFace = null;
        this.currObjShapeFace = null;
    }

    void close() {
        this.isClosed = true;
        this.clear();
        this.vertsDone = null;
        this.resetInds = null;
        this.smoother.close();
        this.materials.close();
    }

    URL getUrlForRelativePath(BaseURL baseURL, String string) {
        string = string.replace('\\', '/');
        URL uRL = null;
        try {
            uRL = new URL(baseURL.protocol, baseURL.host, baseURL.port, this.normalizePath(baseURL.path, string));
        }
        catch (MalformedURLException e) {
            throw new ImportException("\nObjModelImporter Can't build URL for resource relative to file.\nprotocol = " + baseURL.protocol + ", host = " + baseURL.host + ", port = " + baseURL.port + "\npath = " + baseURL.path + "\nrelativeP path = " + string, e);
        }
        return uRL;
    }

    URL getUrlForAbsolutPath(String string) {
        URL uRL = null;
        int n = string.indexOf(":");
        try {
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string2.toLowerCase(Locale.ENGLISH);
                if (string3.startsWith("jar") || string3.startsWith("http") || string3.startsWith("file") || string3.startsWith("ftp")) {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                } else if (string.charAt(0) != '/') {
                    uRL = new URL("file", null, "/" + string);
                } else {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                }
            } else if (string.charAt(0) == '/') {
                uRL = new URL("file", null, string);
            }
        }
        catch (URISyntaxException e) {
            throw new ImportException("ObjModelImporter Can't create URI !\nPath = " + string + "<!", e);
        }
        catch (MalformedURLException e) {
            throw new ImportException("ObjModelImporter Can't create URL !\nPath = " + string + "<!", e);
        }
        return uRL;
    }

    private String normalizePath(String string, String string2) {
        if (string2.indexOf("./") == 0) {
            string2 = string2.substring(2);
            return new String(string + string2);
        }
        int n = -1;
        int n2 = string2.lastIndexOf("../");
        int n3 = 0;
        if (n2 >= 0) {
            n3 = n2 / 3 + 1;
        }
        if (n3 > 0) {
            int n4 = string.length() - 2;
            n = string.lastIndexOf(47, n4);
            if (n < 0) {
                throw new ImportException("ObjModelImporter normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
            }
            --n3;
            while (n3 > 0) {
                if ((n = string.lastIndexOf(47, n - 1)) < 0) {
                    throw new ImportException("ObjModelImporter normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
                }
                --n3;
            }
            return new String(string.substring(0, n + 1) + string2.substring(n2 + 3));
        }
        return new String(string + string2);
    }

    private boolean checkIsClosed() {
        if (this.isClosed) {
            throw new ImportException("ObjModelImporter is closed! Can't be used anymore!");
        }
        return this.isClosed;
    }

    private void setupForNextImport() throws ImportException {
        this.clear();
        this.coordsLength = 9999;
        this.coordsSize = 0;
        this.coordsList = new float[this.coordsLength];
        this.normalsLength = 3;
        this.normalsSize = 0;
        this.normalsList = new float[this.normalsLength];
        this.texsLength = 2;
        this.texsSize = 0;
        this.texsList = new float[this.texsLength];
        this.smGrs = new HashMap();
        this.indCtsListInfoFace = new ListInfo(3333, 0);
        this.indCtsListFace = new int[3333];
        this.vertIndsListInfoFace = new ListInfo(9999, 0);
        this.coordIndsListFace = new int[9999];
    }

    private void readWithLineReader(Reader reader) throws IOException {
        this.setupForNextImport();
        boolean bl = false;
        try {
            this.lReader = new LineReader(reader);
            this.readFile();
            this.lReader.close();
            bl = true;
            this.lReader = null;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (!bl) {
                this.lReader.close();
                this.lReader = null;
            }
        }
        this.linkFacesAndLinesToIndices();
        this.createShape3Ds();
        this.importer.onFileImported();
    }

    private void linkFacesAndLinesToIndices() {
        if (!this.isVeryFirstFace && this.indCtsListInfoFace != null && this.indCtsListInfoFace.size > 0) {
            int n = this.indCtsListInfoFace.size;
            this.startIndicesFace = new int[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                this.startIndicesFace[i] = n2;
                n2 += this.indCtsListFace[i];
            }
            if (this.smGrs != null && this.smGrs.size() > 0) {
                Collection<SmGr> collection = this.smGrs.values();
                Iterator<SmGr> iterator = collection.iterator();
                SmGr smGr = null;
                ArrayList arrayList = null;
                this.smGrpIdPerFace = new int[this.indCtsListFace.length];
                while (iterator.hasNext()) {
                    smGr = iterator.next();
                    arrayList = smGr.faceIndsRanges;
                    for (Range range : arrayList) {
                        for (int i = range.start; i < range.end; ++i) {
                            this.smGrpIdPerFace[i] = smGr.id;
                        }
                    }
                }
            }
        }
    }

    private void readFile() throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        while ((string = string2) != null || (string = this.lReader.readLine()) != null) {
            string2 = null;
            string3 = this.firstWordOf(string);
            if (string3.equals("v")) {
                string2 = this.readCoords(string);
                continue;
            }
            if (string3.equals("vt")) {
                string2 = this.readTexCoords(string);
                continue;
            }
            if (string3.equals("vn")) {
                string2 = this.readNormals(string);
                continue;
            }
            if (string3.equals("f") || string3.equals("fo")) {
                string2 = this.readFace(string);
                continue;
            }
            if (string3.equals("l")) {
                string2 = this.readLLines(string);
                continue;
            }
            if (string3.equals("p")) {
                string2 = this.readPoints(string);
                continue;
            }
            if (string3.equals("g") || string3.equals("o")) {
                String string4;
                String string5 = "";
                if (string.length() > 1 && (string4 = this.firstWordOf(string.substring(1))).length() > 0) {
                    string5 = string4;
                }
                if (string5 == null || string5.length() < 1) {
                    if (string3.equals("g")) {
                        throw new ImportException("Group name is missing in g-statement, line = >" + string + "<");
                    }
                    throw new ImportException("Object name is missing in o-statement, line = >" + string + "<");
                }
                this.currGroupName = string5;
                this.isGrpMatVertChangeFace = true;
                continue;
            }
            if (string3.equals("s")) {
                if (this.objOpts.contains((Object)ObjImportOption.GENERATE_NORMALS)) continue;
                int n = this.currSmGrId;
                String string6 = "";
                if (string.length() > 1) {
                    string6 = string.substring(2);
                }
                try {
                    n = string6 == null || string6.length() < 1 || string6.equals("off") ? 0 : Integer.parseInt(string6);
                }
                catch (NumberFormatException e) {
                    n = 0;
                }
                if (n == this.currSmGrId) continue;
                this.currSmGrId = n;
                if (!this.smGrs.containsKey(this.currSmGrId)) {
                    this.smGrs.put(this.currSmGrId, new SmGr(this.currSmGrId));
                }
                this.isSmGrChanged = true;
                continue;
            }
            if (string3.equals("usemtl")) {
                String string7;
                String string8 = "";
                if (string.length() > string.indexOf(108) + 1 && (string7 = this.firstWordOf(string.substring(string.indexOf(108) + 1))).length() > 0) {
                    string8 = string7;
                }
                if (string8 == null || string8.length() < 1) {
                    throw new ImportException("Material name is missing in usemtl-statement, line = >" + string + "<");
                }
                this.currMaterialName = string8;
                this.isGrpMatVertChangeFace = true;
                continue;
            }
            if (string3.equals("mtllib")) {
                String string9 = null;
                int n = string.indexOf(98) + 1;
                int n2 = string.indexOf(".mtl", n);
                while (n > 0 && n < n2) {
                    string9 = this.trimString(string.substring(n, n2 += 4));
                    if (string9 == null || !string9.endsWith(".mtl")) continue;
                    URL uRL = null;
                    BaseURL baseURL = null;
                    try {
                        string9 = string9.replace('\\', '/');
                        uRL = this.getUrlForAbsolutPath(string9);
                        if (uRL == null) {
                            uRL = this.isUserBase ? this.getUrlForRelativePath(this.baseUrlUser, string9) : this.getUrlForRelativePath(this.baseUrlObj, string9);
                        }
                        if (uRL == null) {
                            throw new ImportException("ObjModelImporter Can' create URL for .mtl = \n" + string9);
                        }
                        baseURL = new BaseURL();
                        baseURL.protocol = uRL.getProtocol();
                        baseURL.host = uRL.getHost();
                        baseURL.port = uRL.getPort();
                        baseURL.path = uRL.getPath();
                        int n3 = baseURL.path.lastIndexOf(47);
                        if (n3 >= 0) {
                            baseURL.path = baseURL.path.substring(0, n3 + 1);
                        } else if (n3 < 0) {
                            baseURL.path = Character.toString('/');
                        }
                    }
                    catch (SecurityException e) {
                        throw new ImportException("ObjModelImporter readFile", e);
                    }
                    this.materials.readMaterialFile(uRL, baseURL, this.objOpts);
                    n = n2;
                    n2 = string.indexOf(".mtl", n);
                }
                continue;
            }
            if (string3.length() <= 0 || string.startsWith("#")) continue;
            System.out.println("OShapeImporter : Unsupported line = " + string);
        }
        if (this.currSmGr != null) {
            this.currSmGr.currRange.end = this.indCtsListInfoFace.size;
        }
        if (this.currObjShapeFace != null) {
            this.currObjShapeFace.currRange.end = this.indCtsListInfoFace.size;
        }
    }

    /*
     * Unable to fully structure code
     */
    private String readCoords(String var1_1) throws IOException {
        var2_2 = var1_1;
        var3_3 = 32;
        var4_4 = 0;
        var5_5 = -1;
        var6_6 = 0;
        var7_7 = 32;
        var8_8 = 2;
        var9_9 = var2_2.length();
        do {
            var4_4 = 0;
            var5_5 = -1;
            var6_6 = 0;
            var8_8 = 2;
            var9_9 = var2_2.length();
lbl15:
            // 2 sources

            try {
                block3: while (var8_8 < var9_9 && var6_6 < 3) {
                    block7: {
                        var7_7 = var2_2.charAt(var8_8);
                        if (var7_7 <= var3_3) break block7;
                        var4_4 = var8_8++;
                        while (var8_8 < var9_9) {
                            var7_7 = var2_2.charAt(var8_8);
                            if (var7_7 <= var3_3) {
                                var5_5 = var8_8;
                                if (this.coordsSize > this.coordsLength - 6) {
                                    var10_10 = this.coordsList;
                                    this.coordsLength = (int)((double)this.coordsSize * 1.5);
                                    this.coordsList = new float[this.coordsLength];
                                    System.arraycopy(var10_10, 0, this.coordsList, 0, this.coordsSize);
                                }
                                this.coordsList[this.coordsSize++] = Float.parseFloat(var2_2.substring(var4_4, var5_5));
                                ++var6_6;
                                ++var8_8;
                                continue block3;
                            }
                            ++var8_8;
                        }
                        ** GOTO lbl15
                    }
                    ++var8_8;
                }
                if (var4_4 <= var5_5) continue;
                this.coordsList[this.coordsSize++] = Float.parseFloat(var2_2.substring(var4_4));
            }
            catch (NumberFormatException e) {
                throw new ImportException("ObjModelImporter readCoords", e);
            }
        } while ((var2_2 = this.lReader.readLine()) != null && this.firstWordOf(var2_2).equals("v"));
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    private String readTexCoords(String var1_1) throws IOException {
        var2_2 = var1_1;
        var3_3 = 32;
        var4_4 = 0;
        var5_5 = -1;
        var6_6 = 0;
        var7_7 = 32;
        var8_8 = 3;
        var9_9 = var2_2.length();
        do {
            var4_4 = 0;
            var5_5 = -1;
            var6_6 = 0;
            var8_8 = 3;
            var9_9 = var2_2.length();
lbl15:
            // 2 sources

            try {
                block3: while (var8_8 < var9_9 && var6_6 < 2) {
                    block7: {
                        var7_7 = var2_2.charAt(var8_8);
                        if (var7_7 <= var3_3) break block7;
                        var4_4 = var8_8++;
                        while (var8_8 < var9_9) {
                            var7_7 = var2_2.charAt(var8_8);
                            if (var7_7 <= var3_3) {
                                var5_5 = var8_8;
                                if (this.texsSize > this.texsLength - 4) {
                                    var10_10 = this.texsList;
                                    this.texsLength = Math.max((int)((double)this.texsSize * 1.5), (int)((double)this.coordsLength * 2.0 / 3.0));
                                    this.texsList = new float[this.texsLength];
                                    System.arraycopy(var10_10, 0, this.texsList, 0, this.texsSize);
                                }
                                this.texsList[this.texsSize++] = Float.parseFloat(var2_2.substring(var4_4, var5_5));
                                ++var6_6;
                                ++var8_8;
                                continue block3;
                            }
                            ++var8_8;
                        }
                        ** GOTO lbl15
                    }
                    ++var8_8;
                }
                if (var4_4 <= var5_5) continue;
                this.texsList[this.texsSize++] = Float.parseFloat(var2_2.substring(var4_4));
            }
            catch (NumberFormatException e) {
                throw new ImportException("ObjModelImporter readTexCoords", e);
            }
        } while ((var2_2 = this.lReader.readLine()) != null && this.firstWordOf(var2_2).equals("vt"));
        return var2_2;
    }

    /*
     * Unable to fully structure code
     */
    private String readNormals(String var1_1) throws IOException {
        var2_2 = var1_1;
        var3_3 = 32;
        var4_4 = 0;
        var5_5 = -1;
        var6_6 = 0;
        var7_7 = 32;
        var8_8 = 3;
        var9_9 = var2_2.length();
        do {
            var4_4 = 0;
            var5_5 = -1;
            var6_6 = 0;
            var8_8 = 3;
            var9_9 = var2_2.length();
lbl15:
            // 2 sources

            try {
                block3: while (var8_8 < var9_9 && var6_6 < 3) {
                    block7: {
                        var7_7 = var2_2.charAt(var8_8);
                        if (var7_7 <= var3_3) break block7;
                        var4_4 = var8_8++;
                        while (var8_8 < var9_9) {
                            var7_7 = var2_2.charAt(var8_8);
                            if (var7_7 <= var3_3) {
                                var5_5 = var8_8;
                                if (this.normalsSize > this.normalsLength - 6) {
                                    var10_10 = this.normalsList;
                                    this.normalsLength = Math.max((int)((double)this.normalsSize * 1.5), this.coordsLength);
                                    this.normalsList = new float[this.normalsLength];
                                    System.arraycopy(var10_10, 0, this.normalsList, 0, this.normalsSize);
                                }
                                this.normalsList[this.normalsSize++] = Float.parseFloat(var2_2.substring(var4_4, var5_5));
                                ++var6_6;
                                ++var8_8;
                                continue block3;
                            }
                            ++var8_8;
                        }
                        ** GOTO lbl15
                    }
                    ++var8_8;
                }
                if (var4_4 <= var5_5) continue;
                this.normalsList[this.normalsSize++] = Float.parseFloat(var2_2.substring(var4_4));
            }
            catch (NumberFormatException e) {
                throw new ImportException("ObjModelImporter readNormals", e);
            }
        } while ((var2_2 = this.lReader.readLine()) != null && this.firstWordOf(var2_2).equals("vn"));
        return var2_2;
    }

    private Vertex determineVertex(String string) {
        int n;
        int n2 = -1;
        int n3 = -1;
        int n4 = 32;
        int n5 = 47;
        int n6 = 32;
        int n7 = string.length();
        for (n = 3; n < n7; ++n) {
            n6 = string.charAt(n);
            if (n6 <= n4 || n6 != n5) continue;
            n2 = n++;
            break;
        }
        while (n < n7 && (n6 = (int)string.charAt(n)) > n4) {
            if (n6 == n5) {
                n3 = n;
                break;
            }
            ++n;
        }
        if (n2 > 0) {
            if (n3 < 0) {
                return Vertex.CT;
            }
            if (n3 == n2 + 1) {
                return Vertex.CN;
            }
            if (n3 > n2 + 1) {
                return Vertex.CTN;
            }
            throw new ImportException("ObjModelImporter : Can't determine vertex type for line >" + string + "<");
        }
        return Vertex.C;
    }

    private String multiTosingleLine(String string) throws IOException {
        String string2 = null;
        int n = -1;
        int n2 = 0;
        int n3 = 32;
        int n4 = 92;
        int n5 = 32;
        do {
            n = -1;
            for (n2 = string.length() - 1; n2 >= 0; --n2) {
                n5 = string.charAt(n2);
                if (n5 <= n3) continue;
                if (n5 != n4) break;
                n = n2;
                break;
            }
            if (n <= 0) continue;
            string2 = this.lReader.readLine();
            string = string2 != null && string2.length() > 0 ? string.substring(0, n) + ' ' + string2 : string.substring(0, n);
        } while (n > 0);
        return string;
    }

    private String readFace(String string) throws IOException {
        String string2 = string;
        Vertex vertex = this.determineVertex(string2);
        if (this.currVertex != vertex) {
            this.currVertex = vertex;
            this.isGrpMatVertChangeFace = true;
        }
        if (this.isGrpMatVertChangeFace) {
            if (this.isVeryFirstFace) {
                this.isVeryFirstFace = false;
                if (this.currSmGrId == -2) {
                    this.smGrs.put(-2, new SmGr(-2));
                }
            }
            if (this.currVertex.isN && this.normalIndsListFace == null) {
                this.normalIndsListFace = new int[this.vertIndsListInfoFace.length];
            }
            if (this.currVertex.isT && this.texIndsListFace == null) {
                this.texIndsListFace = new int[this.vertIndsListInfoFace.length];
            }
            if (this.currObjShapeFace != null) {
                this.currObjShapeFace.currRange.end = this.indCtsListInfoFace.size;
            }
            this.currObjShapeFace = null;
            ObjGroup objGroup = this.objGroupsFace.get(this.currGroupName);
            if (objGroup == null) {
                objGroup = new ObjGroup(this.currGroupName);
                this.objGroupsFace.put(this.currGroupName, objGroup);
            } else {
                ObjShape objShape = objGroup.getObjShapeFor(this.currMaterialName, this.currVertex);
                if (objShape != null) {
                    this.currObjShapeFace = (ObjShapeFace)objShape;
                }
            }
            if (this.currObjShapeFace == null) {
                this.currObjShapeFace = new ObjShapeFace(objGroup);
                this.currObjShapeFace.materialName = this.currMaterialName;
                this.currObjShapeFace.vertex = this.currVertex;
                this.currObjShapeFace.setupShape(this.currVertex.isN, this.currVertex.isT);
                objGroup.addShape(this.currMaterialName, this.currVertex, this.currObjShapeFace);
                this.objShapes.add(this.currObjShapeFace);
            }
            this.currObjShapeFace.currRange = new Range();
            this.currObjShapeFace.currRange.start = this.indCtsListInfoFace.size;
            this.currObjShapeFace.faceIndsRanges.add(this.currObjShapeFace.currRange);
        }
        if (this.isSmGrChanged) {
            this.smoothGroupChanged();
        }
        return this.readFaces(string2);
    }

    private void smoothGroupChanged() {
        VS_N vS_N;
        this.isSmGrChanged = false;
        if (this.currSmGr != null) {
            this.currSmGr.currRange.end = this.indCtsListInfoFace.size;
        }
        this.currSmGr = this.smGrs.get(this.currSmGrId);
        this.currSmGr.currRange = new Range();
        this.currSmGr.currRange.start = this.indCtsListInfoFace.size;
        this.currSmGr.faceIndsRanges.add(this.currSmGr.currRange);
        if (this.currSmGr.sgNormal == VS_N.NULL) {
            if (this.currObjShapeFace.isNormals) {
                this.currSmGr.sgNormal = VS_N.IS_NORMAL;
            } else {
                this.currSmGr.sgNormal = VS_N.NO_NORMAL;
            }
        } else {
            vS_N = this.currSmGr.sgNormal;
            if (vS_N != VS_N.MIX_NORMAL) {
                if (this.currObjShapeFace.isNormals) {
                    if (vS_N == VS_N.NO_NORMAL) {
                        this.currSmGr.sgNormal = VS_N.MIX_NORMAL;
                    }
                } else if (vS_N == VS_N.IS_NORMAL) {
                    this.currSmGr.sgNormal = VS_N.MIX_NORMAL;
                }
            }
        }
        if (this.globalNormalState == VS_N.NULL) {
            this.globalNormalState = this.currSmGr.sgNormal;
        } else {
            vS_N = this.globalNormalState;
            if (vS_N != VS_N.MIX_NORMAL) {
                if (this.currSmGr.sgNormal == VS_N.IS_NORMAL) {
                    if (vS_N == VS_N.NO_NORMAL) {
                        this.globalNormalState = VS_N.MIX_NORMAL;
                    }
                } else if (vS_N == VS_N.IS_NORMAL) {
                    this.globalNormalState = VS_N.MIX_NORMAL;
                }
            }
        }
    }

    private String readFaces(String string) throws IOException {
        String string2 = string;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        char c = ' ';
        char c2 = '/';
        char c3 = ' ';
        int n7 = 0;
        int n8 = 2;
        int n9 = 0;
        boolean bl = false;
        Vertex vertex = null;
        do {
            string2 = this.multiTosingleLine(string2);
            n9 = string2.length();
            n7 = 0;
            n8 = 2;
            try {
                if (this.currVertex == Vertex.CTN) {
                    while (n8 < n9) {
                        c3 = string2.charAt(n8);
                        if (c3 > c) {
                            n3 = 0;
                            if (c3 == '-') {
                                n = -1;
                                ++n8;
                            }
                            while (true) {
                                char c4 = string2.charAt(n8);
                                c3 = c4;
                                if (c4 <= c2) break;
                                n2 = c3 - 48;
                                n3 *= 10;
                                n3 += n2;
                                ++n8;
                            }
                            if (n == -1) {
                                n3 *= n;
                                n = 1;
                            }
                            if ((n4 = n3 - 1) < 0) {
                                n4 += this.coordsSize / 3 + 1;
                            }
                            if (this.vertIndsListInfoFace.size > this.vertIndsListInfoFace.length - 6) {
                                this.increaseFaceVertexInds();
                            }
                            this.coordIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = n4;
                            c3 = string2.charAt(++n8);
                            n3 = 0;
                            if (c3 == '-') {
                                n = -1;
                                ++n8;
                            }
                            while (true) {
                                char c5 = string2.charAt(n8);
                                c3 = c5;
                                if (c5 <= c2) break;
                                n2 = c3 - 48;
                                n3 *= 10;
                                n3 += n2;
                                ++n8;
                            }
                            if (n == -1) {
                                n3 *= n;
                                n = 1;
                            }
                            if ((n5 = n3 - 1) < 0) {
                                n5 += this.texsSize / 2 + 1;
                            }
                            this.texIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = n5;
                            c3 = string2.charAt(++n8);
                            n3 = 0;
                            if (c3 == '-') {
                                n = -1;
                                ++n8;
                            }
                            while (n8 < n9) {
                                char c6 = string2.charAt(n8);
                                c3 = c6;
                                if (c6 <= c) break;
                                n2 = c3 - 48;
                                n3 *= 10;
                                n3 += n2;
                                ++n8;
                            }
                            if (n == -1) {
                                n3 *= n;
                                n = 1;
                            }
                            if ((n6 = n3 - 1) < 0) {
                                n6 += this.normalsSize / 3 + 1;
                            }
                            this.normalIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = n6;
                            this.vertIndsListInfoFace.size++;
                            ++n7;
                            continue;
                        }
                        ++n8;
                    }
                } else if (this.currVertex == Vertex.CN) {
                    while (n8 < n9) {
                        c3 = string2.charAt(n8);
                        if (c3 > c) {
                            n3 = 0;
                            if (c3 == '-') {
                                n = -1;
                                ++n8;
                            }
                            while (true) {
                                char c7 = string2.charAt(n8);
                                c3 = c7;
                                if (c7 <= c2) break;
                                n2 = c3 - 48;
                                n3 *= 10;
                                n3 += n2;
                                ++n8;
                            }
                            if (n == -1) {
                                n3 *= n;
                                n = 1;
                            }
                            if ((n4 = n3 - 1) < 0) {
                                n4 += this.coordsSize / 3 + 1;
                            }
                            if (this.vertIndsListInfoFace.size > this.vertIndsListInfoFace.length - 6) {
                                this.increaseFaceVertexInds();
                            }
                            this.coordIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = n4;
                            ++n8;
                            c3 = string2.charAt(++n8);
                            n3 = 0;
                            if (c3 == '-') {
                                n = -1;
                                ++n8;
                            }
                            while (n8 < n9) {
                                char c8 = string2.charAt(n8);
                                c3 = c8;
                                if (c8 <= c) break;
                                n2 = c3 - 48;
                                n3 *= 10;
                                n3 += n2;
                                ++n8;
                            }
                            if (n == -1) {
                                n3 *= n;
                                n = 1;
                            }
                            if ((n6 = n3 - 1) < 0) {
                                n6 += this.normalsSize / 3 + 1;
                            }
                            this.normalIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = n6;
                            this.vertIndsListInfoFace.size++;
                            ++n7;
                            continue;
                        }
                        ++n8;
                    }
                } else if (this.currVertex == Vertex.CT) {
                    while (n8 < n9) {
                        c3 = string2.charAt(n8);
                        if (c3 > c) {
                            n3 = 0;
                            if (c3 == '-') {
                                n = -1;
                                ++n8;
                            }
                            while (true) {
                                char c9 = string2.charAt(n8);
                                c3 = c9;
                                if (c9 <= c2) break;
                                n2 = c3 - 48;
                                n3 *= 10;
                                n3 += n2;
                                ++n8;
                            }
                            if (n == -1) {
                                n3 *= n;
                                n = 1;
                            }
                            if ((n4 = n3 - 1) < 0) {
                                n4 += this.coordsSize / 3 + 1;
                            }
                            if (this.vertIndsListInfoFace.size > this.vertIndsListInfoFace.length - 6) {
                                this.increaseFaceVertexInds();
                            }
                            this.coordIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = n4;
                            c3 = string2.charAt(++n8);
                            n3 = 0;
                            if (c3 == '-') {
                                n = -1;
                                ++n8;
                            }
                            while (n8 < n9) {
                                char c10 = string2.charAt(n8);
                                c3 = c10;
                                if (c10 <= c) break;
                                n2 = c3 - 48;
                                n3 *= 10;
                                n3 += n2;
                                ++n8;
                            }
                            if (n == -1) {
                                n3 *= n;
                                n = 1;
                            }
                            if ((n5 = n3 - 1) < 0) {
                                n5 += this.texsSize / 2 + 1;
                            }
                            this.texIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = n5;
                            this.vertIndsListInfoFace.size++;
                            ++n7;
                            continue;
                        }
                        ++n8;
                    }
                } else {
                    while (n8 < n9) {
                        c3 = string2.charAt(n8);
                        if (c3 > c) {
                            n3 = 0;
                            if (c3 == '-') {
                                n = -1;
                                ++n8;
                            }
                            while (n8 < n9) {
                                char c11 = string2.charAt(n8);
                                c3 = c11;
                                if (c11 <= c) break;
                                n2 = c3 - 48;
                                n3 *= 10;
                                n3 += n2;
                                ++n8;
                            }
                            if (n == -1) {
                                n3 *= n;
                                n = 1;
                            }
                            if ((n4 = n3 - 1) < 0) {
                                n4 += this.coordsSize / 3 + 1;
                            }
                            if (this.vertIndsListInfoFace.size > this.vertIndsListInfoFace.length - 6) {
                                this.increaseFaceVertexInds();
                            }
                            this.coordIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = n4;
                            this.vertIndsListInfoFace.size++;
                            ++n7;
                            continue;
                        }
                        ++n8;
                    }
                }
                if (n7 < 3) {
                    for (n8 = 0; n8 < n7; ++n8) {
                        this.vertIndsListInfoFace.size--;
                        this.coordIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = -1;
                        if (this.currVertex.isN) {
                            this.normalIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = -1;
                        }
                        if (!this.currVertex.isT) continue;
                        this.texIndsListFace[((ListInfo)this.vertIndsListInfoFace).size] = -1;
                    }
                } else {
                    if (this.indCtsListInfoFace.size == this.indCtsListInfoFace.length) {
                        int[] nArray = this.indCtsListFace;
                        this.indCtsListInfoFace.length = (int)((double)this.indCtsListInfoFace.size * 1.5);
                        this.indCtsListFace = new int[this.indCtsListInfoFace.length];
                        System.arraycopy(nArray, 0, this.indCtsListFace, 0, this.indCtsListInfoFace.size);
                    }
                    this.indCtsListFace[((ListInfo)this.indCtsListInfoFace).size++] = n7;
                }
            }
            catch (NumberFormatException e) {
                throw new ImportException("ObjModelImporter readFaces", e);
            }
            string2 = this.lReader.readLine();
            boolean bl2 = bl = string2 != null && this.firstWordOf(string2).equals("f");
            if (!bl || (vertex = this.determineVertex(string2)) == this.currVertex) continue;
            this.isGrpMatVertChangeFace = true;
            bl = false;
        } while (bl);
        return string2;
    }

    private void increaseFaceVertexInds() {
        int n = this.vertIndsListInfoFace.size;
        int n2 = (int)((double)this.vertIndsListInfoFace.size * 1.5);
        this.vertIndsListInfoFace.length = n2;
        int[] nArray = this.coordIndsListFace;
        this.coordIndsListFace = new int[n2];
        System.arraycopy(nArray, 0, this.coordIndsListFace, 0, n);
        if (this.normalIndsListFace != null) {
            nArray = this.normalIndsListFace;
            this.normalIndsListFace = new int[n2];
            System.arraycopy(nArray, 0, this.normalIndsListFace, 0, n);
        }
        if (this.texIndsListFace != null) {
            nArray = this.texIndsListFace;
            this.texIndsListFace = new int[n2];
            System.arraycopy(nArray, 0, this.texIndsListFace, 0, n);
        }
    }

    private String readLLines(String string) throws IOException {
        String string2 = string;
        while ((string2 = this.lReader.readLine()) != null && this.firstWordOf(string2).equals("l")) {
        }
        return string2;
    }

    private String readPoints(String string) throws IOException {
        String string2 = string;
        while ((string2 = this.lReader.readLine()) != null && this.firstWordOf(string2).equals("p")) {
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String firstWordOf(String string) {
        String string2 = "";
        if (string == null) return string2;
        if (string.length() < 1) {
            return string2;
        }
        int n = 32;
        int n2 = 32;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = string.length();
        boolean bl = true;
        try {
            block2: while (true) {
                if (bl && n5 < n6) {
                    n2 = string.charAt(n5);
                    if (n2 <= n) {
                        ++n5;
                        continue;
                    }
                } else {
                    if (n3 <= n4) return string2;
                    return string.substring(n3);
                }
                n3 = n5++;
                while (true) {
                    if (n5 >= n6) continue block2;
                    n2 = string.charAt(n5);
                    if (n2 <= n) {
                        n4 = n5;
                        string2 = string.substring(n3, n4);
                        bl = false;
                        continue block2;
                    }
                    ++n5;
                }
                break;
            }
        }
        catch (NumberFormatException e) {
            throw new ImportException("ObjModelImporter firstWordOf", e);
        }
    }

    String trimString(String string) {
        String string2 = "";
        if (string == null || string.length() < 1) {
            return string2;
        }
        int n = 32;
        int n2 = 32;
        int n3 = 0;
        int n4 = -1;
        int n5 = string.length();
        try {
            int n6;
            for (n6 = 0; n6 < n5; ++n6) {
                n2 = string.charAt(n6);
                if (n2 <= n) continue;
                n3 = n6;
                break;
            }
            for (n6 = n5 - 1; n6 >= 0; --n6) {
                n2 = string.charAt(n6);
                if (n2 <= n) continue;
                n4 = n6 + 1;
                break;
            }
        }
        catch (NumberFormatException e) {
            throw new ImportException("ObjModelImporter trimString", e);
        }
        if (n4 > n3) {
            string2 = string.substring(n3, n4);
        }
        return string2;
    }

    private void createShape3Ds() {
        int n = Math.max(Math.max(this.coordsSize, this.normalsSize), this.texsSize);
        int n2 = n / 3;
        if (this.vertsDone == null || this.vertsDone.length < n2) {
            this.vertsDone = new int[n2];
        }
        Arrays.fill(this.vertsDone, -2);
        this.resetInds = null;
        this.importedMeshViews = new MeshView[this.objShapes.size()];
        int n3 = 0;
        MeshView meshView = null;
        for (ObjShape objShape : this.objShapes) {
            meshView = objShape.getMeshView();
            this.importedMeshViews[n3++] = meshView;
            this.namedMeshViews.put(meshView.getId(), meshView);
        }
    }

    private float[] createRFTriplesAndInds(float[] fArray, int n, int[] nArray) {
        Integer n2;
        T3f t3f;
        int n3;
        if (this.resetInds != null) {
            n3 = this.resetInds.length;
            for (int i = 0; i < n3; ++i) {
                this.vertsDone[this.resetInds[i]] = -2;
            }
        }
        this.resetInds = (int[])nArray.clone();
        HashMap<T3f, Integer> hashMap = new HashMap<T3f, Integer>();
        n3 = n / 3;
        if (this.vertsDone == null || this.vertsDone.length < n3) {
            this.vertsDone = new int[n3];
            Arrays.fill(this.vertsDone, -2);
        }
        int n4 = 0;
        int n52 = 0;
        int n6 = 0;
        for (int n52 : nArray) {
            if (this.vertsDone[n52] == -2) {
                n6 = n52 * 3;
                t3f = new T3f(fArray[n6], fArray[n6 + 1], fArray[n6 + 2]);
                n2 = (Integer)hashMap.get(t3f);
                if (n2 == null) {
                    hashMap.put(t3f, n4);
                    this.vertsDone[n52] = n4;
                    nArray[var11_10] = n4++;
                    continue;
                }
                this.vertsDone[n52] = n2;
                nArray[var11_10] = n2;
                continue;
            }
            nArray[var11_10] = this.vertsDone[n52];
        }
        float[] fArray2 = new float[n4 * 3];
        Set set = hashMap.entrySet();
        for (Map.Entry entry : set) {
            t3f = (T3f)entry.getKey();
            n2 = (Integer)entry.getValue() * 3;
            fArray2[n2.intValue()] = t3f.x;
            fArray2[n2.intValue() + 1] = t3f.y;
            fArray2[n2.intValue() + 2] = t3f.z;
        }
        return fArray2;
    }

    private float[] createRFTuplesAndInds(float[] fArray, int n, int[] nArray) {
        Integer n2;
        Normalizer.Tuplef tuplef;
        int n3;
        if (this.resetInds != null) {
            n3 = this.resetInds.length;
            for (int i = 0; i < n3; ++i) {
                this.vertsDone[this.resetInds[i]] = -2;
            }
        }
        this.resetInds = (int[])nArray.clone();
        HashMap<Normalizer.Tuplef, Integer> hashMap = new HashMap<Normalizer.Tuplef, Integer>();
        n3 = n / 2;
        if (this.vertsDone == null || this.vertsDone.length < n3) {
            this.vertsDone = new int[n3];
            Arrays.fill(this.vertsDone, -2);
        }
        int n4 = 0;
        int n52 = 0;
        for (int n52 : nArray) {
            if (this.vertsDone[n52] == -2) {
                tuplef = new Normalizer.Tuplef(fArray[n52 * 2], fArray[n52 * 2 + 1]);
                n2 = (Integer)hashMap.get(tuplef);
                if (n2 == null) {
                    hashMap.put(tuplef, n4);
                    this.vertsDone[n52] = n4;
                    nArray[var10_9] = n4++;
                    continue;
                }
                this.vertsDone[n52] = n2;
                nArray[var10_9] = n2;
                continue;
            }
            nArray[var10_9] = this.vertsDone[n52];
        }
        float[] fArray2 = new float[n4 * 2];
        Set set = hashMap.entrySet();
        for (Map.Entry entry : set) {
            tuplef = (Normalizer.Tuplef)entry.getKey();
            n2 = (Integer)entry.getValue() * 2;
            fArray2[n2.intValue()] = tuplef.x;
            fArray2[n2.intValue() + 1] = tuplef.y;
        }
        return fArray2;
    }

    private static final class T3f {
        private final float x;
        private final float y;
        private final float z;

        private T3f(float f, float f2, float f3) {
            this.x = f == 0.0f ? 0.0f : f;
            this.y = f2 == 0.0f ? 0.0f : f2;
            this.z = f3 == 0.0f ? 0.0f : f3;
        }

        public boolean equals(Object object) {
            T3f t3f = (T3f)object;
            return this.x == t3f.x && this.y == t3f.y && this.z == t3f.z;
        }

        public int hashCode() {
            long l = 1L;
            l = 31L * l + (long)Float.floatToRawIntBits(this.x);
            l = 31L * l + (long)Float.floatToRawIntBits(this.y);
            l = 31L * l + (long)Float.floatToRawIntBits(this.z);
            return (int)(l ^ l >> 32);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }

    private final class ObjShapeFace
    extends ObjShape {
        private boolean isSmGrps;
        int[] smGrps;
        int maxSmGrpId;
        private boolean isTriangles;
        private boolean isDoIndexing;
        private boolean isDoGenNormals;
        private int triaCt;
        private ArrayList<Range> faceIndsRanges;

        private ObjShapeFace(ObjGroup objGroup) {
            super(objGroup);
            this.isSmGrps = false;
            this.smGrps = null;
            this.maxSmGrpId = 0;
            this.isTriangles = true;
            this.isDoIndexing = false;
            this.isDoGenNormals = false;
            this.triaCt = 0;
            this.faceIndsRanges = null;
            this.isFace = true;
            this.faceIndsRanges = new ArrayList();
        }

        @Override
        void clear() {
            super.clear();
            if (this.faceIndsRanges != null) {
                this.faceIndsRanges.clear();
                this.faceIndsRanges = null;
            }
        }

        @Override
        Mesh getMesh() {
            this.prepareArrays();
            this.isDoIndexing = true;
            this.isSmGrps = ObjModelImporterImpl.this.currSmGrId != -2;
            this.isDoGenNormals = ObjModelImporterImpl.this.objOpts.contains((Object)ObjImportOption.GENERATE_NORMALS) || !this.isSmGrps && !this.isNormals;
            this.smGrps = new int[this.triaCt];
            this.prepare();
            if (ObjModelImporterImpl.this.objOpts.contains((Object)ObjImportOption.REVERSE)) {
                this.reverseFaces();
            }
            this.convertCoords();
            int n = this.texCoords.length;
            for (int i = 1; i < n; i += 2) {
                this.texCoords[i] = 1.0f - this.texCoords[i];
            }
            TriangleMesh triangleMesh = new TriangleMesh();
            triangleMesh.getPoints().addAll(this.coords);
            triangleMesh.getTexCoords().addAll(this.texCoords);
            int[] nArray = new int[this.indexCount * 2];
            int n2 = 0;
            if (this.isTexCoords) {
                for (int i = 0; i < this.indexCount; ++i) {
                    nArray[n2++] = this.coordInds[i];
                    nArray[n2++] = this.texCoordInds[i];
                }
            } else {
                for (int i = 0; i < this.indexCount; ++i) {
                    nArray[n2++] = this.coordInds[i];
                    nArray[n2++] = 0;
                }
            }
            triangleMesh.getFaces().addAll(nArray);
            triangleMesh.getFaceSmoothingGroups().addAll(this.smGrps);
            return triangleMesh;
        }

        private void prepareArrays() {
            int n = 0;
            for (Range range : this.faceIndsRanges) {
                for (int i = range.start; i < range.end; ++i) {
                    n = ObjModelImporterImpl.this.indCtsListFace[i];
                    this.triaCt += n - 2;
                    this.isTriangles = this.isTriangles && n == 3;
                }
            }
            this.indexCount = this.triaCt * 3;
        }

        private void prepare() {
            int n;
            Object object;
            int n2;
            int n3;
            int n4;
            int n5;
            if (this.isDoIndexing) {
                this.coordInds = new int[this.indexCount];
                if (this.isNormals || this.isDoGenNormals) {
                    this.normalInds = new int[this.indexCount];
                }
                if (this.isTexCoords) {
                    this.texCoordInds = new int[this.indexCount];
                }
            }
            float[] fArray = null;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            if (this.isDoIndexing || this.isDoGenNormals) {
                if (this.isSmGrps) {
                    if (this.isTriangles) {
                        for (Range object22 : this.faceIndsRanges) {
                            int n9 = ObjModelImporterImpl.this.startIndicesFace[object22.start];
                            for (n5 = object22.start; n5 < object22.end; ++n5) {
                                this.smGrps[n8++] = ObjModelImporterImpl.this.smGrpIdPerFace[n5];
                                this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n9++];
                                this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n9++];
                                this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n9++];
                            }
                        }
                    } else {
                        int n10 = -1;
                        for (Range range : this.faceIndsRanges) {
                            n5 = ObjModelImporterImpl.this.startIndicesFace[range.start];
                            for (n4 = range.start; n4 < range.end; ++n4) {
                                n7 = ObjModelImporterImpl.this.indCtsListFace[n4];
                                n10 = ObjModelImporterImpl.this.smGrpIdPerFace[n4];
                                n3 = ObjModelImporterImpl.this.coordIndsListFace[n5++];
                                this.smGrps[n8++] = n10;
                                this.coordInds[n6++] = n3;
                                this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n5++];
                                this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n5++];
                                for (n2 = 3; n2 < n7; ++n2) {
                                    this.smGrps[n8++] = n10;
                                    this.coordInds[n6++] = n3;
                                    this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n5 - 1];
                                    this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n5++];
                                }
                            }
                        }
                    }
                } else if (this.isTriangles) {
                    for (Range range : this.faceIndsRanges) {
                        int n10 = ObjModelImporterImpl.this.startIndicesFace[range.start];
                        for (n5 = range.start; n5 < range.end; ++n5) {
                            this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n10++];
                            this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n10++];
                            this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n10++];
                        }
                    }
                } else {
                    for (Range range : this.faceIndsRanges) {
                        int n11 = ObjModelImporterImpl.this.startIndicesFace[range.start];
                        for (n5 = range.start; n5 < range.end; ++n5) {
                            n7 = ObjModelImporterImpl.this.indCtsListFace[n5];
                            n4 = ObjModelImporterImpl.this.coordIndsListFace[n11++];
                            this.coordInds[n6++] = n4;
                            this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n11++];
                            this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n11++];
                            for (n3 = 3; n3 < n7; ++n3) {
                                this.coordInds[n6++] = n4;
                                this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n11 - 1];
                                this.coordInds[n6++] = ObjModelImporterImpl.this.coordIndsListFace[n11++];
                            }
                        }
                    }
                }
                this.coords = ObjModelImporterImpl.this.createRFTriplesAndInds(ObjModelImporterImpl.this.coordsList, ObjModelImporterImpl.this.coordsSize, this.coordInds);
                if (this.isDoGenNormals) {
                    fArray = this.coords;
                }
            }
            n6 = 0;
            if (this.isDoGenNormals) {
                object = this.coordInds;
                int[] nArray = new int[fArray.length / 3];
                float[] fArray2 = ObjModelImporterImpl.this.normalizer.calcTriangleNormals(fArray, (int[])object, nArray);
                int[][] nArray2 = ObjModelImporterImpl.this.normalizer.vertexIndices((int[])object, nArray);
                n4 = this.isDoIndexing ? 1 : 0;
                Normalizer.Triplef[] triplefArray = ObjModelImporterImpl.this.normalizer.calcIndexedVertexNormals(ObjModelImporterImpl.this.creaseAngle, n4 != 0, fArray2, (int[])object, nArray2, this.normalInds);
                n2 = triplefArray.length;
                Normalizer.Triplef triplef = null;
                int n12 = 0;
                if (this.isDoIndexing) {
                    this.normals = new float[n2 * 3];
                    for (int i = 0; i < n2; ++i) {
                        triplef = triplefArray[i];
                        this.normals[n12++] = triplef.x;
                        this.normals[n12++] = triplef.y;
                        this.normals[n12++] = triplef.z;
                    }
                }
            } else if (this.isNormals && this.isDoIndexing) {
                int n13;
                if (this.isTriangles) {
                    for (Range range : this.faceIndsRanges) {
                        n13 = ObjModelImporterImpl.this.startIndicesFace[range.start];
                        for (n5 = range.start; n5 < range.end; ++n5) {
                            this.normalInds[n6++] = ObjModelImporterImpl.this.normalIndsListFace[n13++];
                            this.normalInds[n6++] = ObjModelImporterImpl.this.normalIndsListFace[n13++];
                            this.normalInds[n6++] = ObjModelImporterImpl.this.normalIndsListFace[n13++];
                        }
                    }
                } else {
                    for (Range range : this.faceIndsRanges) {
                        n13 = ObjModelImporterImpl.this.startIndicesFace[range.start];
                        for (n5 = range.start; n5 < range.end; ++n5) {
                            n7 = ObjModelImporterImpl.this.indCtsListFace[n5];
                            n4 = ObjModelImporterImpl.this.normalIndsListFace[n13++];
                            this.normalInds[n6++] = n4;
                            this.normalInds[n6++] = ObjModelImporterImpl.this.normalIndsListFace[n13++];
                            this.normalInds[n6++] = ObjModelImporterImpl.this.normalIndsListFace[n13++];
                            for (n3 = 3; n3 < n7; ++n3) {
                                this.normalInds[n6++] = n4;
                                this.normalInds[n6++] = ObjModelImporterImpl.this.normalIndsListFace[n13 - 1];
                                this.normalInds[n6++] = ObjModelImporterImpl.this.normalIndsListFace[n13++];
                            }
                        }
                    }
                }
                this.normals = ObjModelImporterImpl.this.createRFTriplesAndInds(ObjModelImporterImpl.this.normalsList, ObjModelImporterImpl.this.normalsSize, this.normalInds);
            }
            if (this.isSmGrps && !this.isDoGenNormals) {
                int n15 = this.smGrps.length;
                boolean[] blArray = new boolean[n15];
                n = 0;
                int n14 = 0;
                n4 = 0;
                for (int i = 0; i < n15; ++i) {
                    if (blArray[i]) continue;
                    blArray[i] = true;
                    n4 = this.smGrps[i];
                    if (n4 == 0) continue;
                    n = 1 << n14;
                    ++n14;
                    this.smGrps[i] = n;
                    for (n2 = i + 1; n2 < n15; ++n2) {
                        if (blArray[n2] || this.smGrps[n2] != n4) continue;
                        blArray[n2] = true;
                        this.smGrps[n2] = n;
                    }
                }
                this.maxSmGrpId = n14;
            } else {
                this.maxSmGrpId = 0;
                object = ObjModelImporterImpl.this.smoother.create(this.coordInds, this.coords.length / 3, this.normalInds);
                Object var6_25 = null;
                n = 0;
                Iterator iterator = ((ArrayList)object).iterator();
                while (iterator.hasNext()) {
                    MeshSmoother.SmoothMesh smoothMesh = (MeshSmoother.SmoothMesh)iterator.next();
                    ArrayList<Integer> arrayList = smoothMesh.getIndices();
                    n = smoothMesh.getSmGrId();
                    n2 = arrayList.size();
                    for (int i = 0; i < n2; i += 3) {
                        this.smGrps[arrayList.get((int)i).intValue() / 3] = n;
                    }
                    smoothMesh.close();
                    if (n <= this.maxSmGrpId) continue;
                    this.maxSmGrpId = n;
                }
                ((ArrayList)object).clear();
                ObjModelImporterImpl.this.smoother.clear();
            }
            if (this.isTexCoords) {
                n6 = 0;
                if (this.isDoIndexing) {
                    if (this.isTriangles) {
                        for (Range range : this.faceIndsRanges) {
                            n = ObjModelImporterImpl.this.startIndicesFace[range.start];
                            for (int i = range.start; i < range.end; ++i) {
                                this.texCoordInds[n6++] = ObjModelImporterImpl.this.texIndsListFace[n++];
                                this.texCoordInds[n6++] = ObjModelImporterImpl.this.texIndsListFace[n++];
                                this.texCoordInds[n6++] = ObjModelImporterImpl.this.texIndsListFace[n++];
                            }
                        }
                    } else {
                        for (Range range : this.faceIndsRanges) {
                            n = ObjModelImporterImpl.this.startIndicesFace[range.start];
                            for (int i = range.start; i < range.end; ++i) {
                                n7 = ObjModelImporterImpl.this.indCtsListFace[i];
                                int n15 = ObjModelImporterImpl.this.texIndsListFace[n++];
                                this.texCoordInds[n6++] = n15;
                                this.texCoordInds[n6++] = ObjModelImporterImpl.this.texIndsListFace[n++];
                                this.texCoordInds[n6++] = ObjModelImporterImpl.this.texIndsListFace[n++];
                                for (int j = 3; j < n7; ++j) {
                                    this.texCoordInds[n6++] = n15;
                                    this.texCoordInds[n6++] = ObjModelImporterImpl.this.texIndsListFace[n - 1];
                                    this.texCoordInds[n6++] = ObjModelImporterImpl.this.texIndsListFace[n++];
                                }
                            }
                        }
                    }
                    this.texCoords = ObjModelImporterImpl.this.createRFTuplesAndInds(ObjModelImporterImpl.this.texsList, ObjModelImporterImpl.this.texsSize, this.texCoordInds);
                }
            } else {
                this.texCoords = new float[2];
                this.texCoords[0] = 0.0f;
                this.texCoords[1] = 0.0f;
            }
        }

        private void reverseFaces() {
            int n = 3;
            if (this.isDoIndexing) {
                int n2;
                int n3 = this.coordInds.length;
                int n4 = -1;
                int n5 = n - 1;
                for (n2 = 0; n2 < n3; n2 += n) {
                    n4 = this.coordInds[n2 + n5];
                    this.coordInds[n2 + n5] = this.coordInds[n2 + 1];
                    this.coordInds[n2 + 1] = n4;
                }
                if (this.isTexCoords) {
                    for (n2 = 0; n2 < n3; n2 += n) {
                        n4 = this.texCoordInds[n2 + n5];
                        this.texCoordInds[n2 + n5] = this.texCoordInds[n2 + 1];
                        this.texCoordInds[n2 + 1] = n4;
                    }
                }
            }
        }
    }

    private abstract class ObjShape {
        private final ObjGroup objGroup;
        boolean isFace = false;
        String materialName = null;
        boolean isNormals = false;
        boolean isTexCoords = false;
        Vertex vertex = Vertex.C;
        int indexCount = 0;
        Range currRange = null;
        float[] coords = null;
        float[] normals = null;
        float[] texCoords = null;
        int[] coordInds = null;
        int[] normalInds = null;
        int[] texCoordInds = null;

        ObjShape(ObjGroup objGroup) {
            this.objGroup = objGroup;
        }

        final void setupShape(boolean bl, boolean bl2) {
            this.isNormals = bl;
            this.isTexCoords = bl2;
            if (this.isNormals) {
                // empty if block
            }
            if (this.isTexCoords) {
                // empty if block
            }
        }

        final MeshView getMeshView() {
            MeshView meshView;
            Mesh mesh = this.getMesh();
            PhongMaterial phongMaterial = ObjModelImporterImpl.this.materials.getMaterial(this.materialName, this.isFace, true);
            if (!(this.vertex.isT || phongMaterial == null || phongMaterial.getBumpMap() == null && phongMaterial.getDiffuseMap() == null && phongMaterial.getSpecularMap() == null)) {
                meshView = (PhongMaterial)ObjModelImporterImpl.this.matNoTexMatMap.get(phongMaterial);
                if (meshView == null) {
                    String string = this.materialName + "_noMap";
                    meshView = ObjModelImporterImpl.this.materials.createNoTexMatFrom(phongMaterial, string);
                    ObjModelImporterImpl.this.matNoTexMatMap.put(phongMaterial, meshView);
                }
                phongMaterial = meshView;
            }
            meshView = new MeshView(mesh);
            if (phongMaterial != null) {
                meshView.setMaterial((Material)phongMaterial);
            }
            meshView.setId(this.objGroup.getShapeNameFor(this));
            return meshView;
        }

        abstract Mesh getMesh();

        void convertCoords() {
            int n = 0;
            int n2 = this.coords.length / 3;
            for (int i = 0; i < n2; ++i) {
                if (this.coords[++n] != 0.0f) {
                    this.coords[n] = -this.coords[n];
                }
                if (this.coords[++n] != 0.0f) {
                    this.coords[n] = -this.coords[n];
                }
                ++n;
            }
        }

        void clear() {
            this.coords = null;
            this.normals = null;
            this.texCoords = null;
            this.coordInds = null;
            this.normalInds = null;
            this.texCoordInds = null;
        }
    }

    private static final class ObjGroup {
        private final String groupName;
        private final HashMap<String, EnumMap<Vertex, ObjShape>> matVertShapeMap = new HashMap();

        private ObjGroup(String string) {
            this.groupName = string;
        }

        private void addShape(String string, Vertex vertex, ObjShape objShape) {
            EnumMap<Vertex, ObjShape> enumMap = this.matVertShapeMap.get(string);
            if (enumMap == null) {
                enumMap = new EnumMap(Vertex.class);
                this.matVertShapeMap.put(string, enumMap);
            }
            enumMap.put(vertex, objShape);
        }

        private ObjShape getObjShapeFor(String string, Vertex vertex) {
            ObjShape objShape = null;
            EnumMap<Vertex, ObjShape> enumMap = this.matVertShapeMap.get(string);
            if (enumMap != null) {
                objShape = enumMap.get((Object)vertex);
            }
            return objShape;
        }

        private String getShapeNameFor(ObjShape objShape) {
            String string = this.groupName;
            String string2 = objShape.materialName;
            if (this.matVertShapeMap.size() > 1) {
                string = string + "_" + string2;
            }
            if (this.matVertShapeMap.get(string2).size() > 1) {
                string = string + "_" + objShape.vertex.ext;
            }
            return string;
        }
    }

    static final class BaseURL {
        String protocol = null;
        String host = null;
        int port = -1;
        String path = null;

        private BaseURL() {
        }

        public String toString() {
            return "protocol = " + this.protocol + ", host = " + this.host + ", port = " + this.port + ", path = " + this.path;
        }
    }

    private static final class SmGr {
        private int id = Integer.MIN_VALUE;
        private ArrayList<Range> faceIndsRanges = null;
        private Range currRange = null;
        private VS_N sgNormal = VS_N.NULL;

        private SmGr(int n) {
            this.id = n;
            this.faceIndsRanges = new ArrayList();
        }

        private void clear() {
            if (this.faceIndsRanges != null) {
                this.faceIndsRanges.clear();
                this.faceIndsRanges = null;
            }
        }
    }

    private static enum Vertex {
        C(false, false, "c"),
        CT(false, true, "ct"),
        CN(true, false, "cn"),
        CTN(true, true, "ctn");

        private boolean isN = false;
        private boolean isT = false;
        private String ext = "";

        private Vertex(boolean bl, boolean bl2, String string2) {
            this.isN = bl;
            this.isT = bl2;
            this.ext = string2;
        }
    }

    private static enum VS_N {
        NULL,
        IS_NORMAL,
        NO_NORMAL,
        MIX_NORMAL;

    }

    private static final class Range {
        private int start = 0;
        private int end = 0;

        private Range() {
        }
    }

    private static final class ListInfo {
        private int length = 0;
        private int size = 0;

        private ListInfo(int n, int n2) {
            this.length = n;
            this.size = n2;
        }
    }

    private static final class LineReader
    extends BufferedReader {
        private LineReader(Reader reader) {
            super(reader, SIZE);
        }
    }
}

