/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.COLLADA;
import com.interactivemesh.jfx.importer.col.CVersion;
import com.interactivemesh.jfx.importer.col.ColladaFileParser;
import com.interactivemesh.jfx.importer.col.LibCameras;
import com.interactivemesh.jfx.importer.col.LibCamerasParser;
import com.interactivemesh.jfx.importer.col.LibControllers;
import com.interactivemesh.jfx.importer.col.LibControllersParser;
import com.interactivemesh.jfx.importer.col.LibEffects;
import com.interactivemesh.jfx.importer.col.LibEffectsParser;
import com.interactivemesh.jfx.importer.col.LibGeometries;
import com.interactivemesh.jfx.importer.col.LibGeometriesParser;
import com.interactivemesh.jfx.importer.col.LibImages;
import com.interactivemesh.jfx.importer.col.LibImagesParser;
import com.interactivemesh.jfx.importer.col.LibLights;
import com.interactivemesh.jfx.importer.col.LibLightsParser;
import com.interactivemesh.jfx.importer.col.LibMaterials;
import com.interactivemesh.jfx.importer.col.LibMaterialsParser;
import com.interactivemesh.jfx.importer.col.LibNodes;
import com.interactivemesh.jfx.importer.col.LibNodesParser;
import com.interactivemesh.jfx.importer.col.LibVisualScenes;
import com.interactivemesh.jfx.importer.col.LibVisualScenesParser;
import com.interactivemesh.jfx.importer.col.Scene;

final class COLLADAParser
extends AbstractElementParser {
    private LibCamerasParser libCamerasParser = null;
    private LibControllersParser libControllersParser = null;
    private LibEffectsParser libEffectsParser = null;
    private LibGeometriesParser libGeomsParser = null;
    private LibImagesParser libImagesParser = null;
    private LibLightsParser libLightsParser = null;
    private LibMaterialsParser libMaterialsParser = null;
    private LibNodesParser libNodesParser = null;
    private LibVisualScenesParser libVisSceneParser = null;
    private COLLADA collada = null;
    private boolean isScene = false;

    COLLADAParser(ColladaFileParser colladaFileParser) {
        super(colladaFileParser);
    }

    void setup(COLLADA cOLLADA) {
        this.collada = cOLLADA;
    }

    @Override
    void doClose() {
        this.collada = null;
        if (this.libCamerasParser != null) {
            this.libCamerasParser.close();
            this.libCamerasParser = null;
        }
        if (this.libControllersParser != null) {
            this.libControllersParser.close();
            this.libControllersParser = null;
        }
        if (this.libEffectsParser != null) {
            this.libEffectsParser.close();
            this.libEffectsParser = null;
        }
        if (this.libGeomsParser != null) {
            this.libGeomsParser.close();
            this.libGeomsParser = null;
        }
        if (this.libImagesParser != null) {
            this.libImagesParser.close();
            this.libImagesParser = null;
        }
        if (this.libLightsParser != null) {
            this.libLightsParser.close();
            this.libLightsParser = null;
        }
        if (this.libMaterialsParser != null) {
            this.libMaterialsParser.close();
            this.libMaterialsParser = null;
        }
        if (this.libNodesParser != null) {
            this.libNodesParser.close();
            this.libNodesParser = null;
        }
        if (this.libVisSceneParser != null) {
            this.libVisSceneParser.close();
            this.libVisSceneParser = null;
        }
    }

    private boolean parseAppearanceLibs(String string) {
        boolean bl = true;
        if (string.equals("library_effects")) {
            LibEffects libEffects = new LibEffects();
            libEffects.id = this.cfp.xR.getAttributeValue(null, "id");
            libEffects.name = this.cfp.xR.getAttributeValue(null, "name");
            this.collada.add(libEffects);
            if (this.libEffectsParser == null) {
                this.libEffectsParser = new LibEffectsParser(this, libEffects);
            } else {
                this.libEffectsParser.setup(libEffects);
            }
            this.cfp.setParser(this.libEffectsParser);
        } else if (string.equals("library_materials")) {
            LibMaterials libMaterials = new LibMaterials(this.cfp.scope);
            libMaterials.id = this.cfp.xR.getAttributeValue(null, "id");
            libMaterials.name = this.cfp.xR.getAttributeValue(null, "name");
            this.collada.add(libMaterials);
            if (this.libMaterialsParser == null) {
                this.libMaterialsParser = new LibMaterialsParser(this, libMaterials);
            } else {
                this.libMaterialsParser.setup(libMaterials);
            }
            this.cfp.setParser(this.libMaterialsParser);
        } else if (string.equals("library_images")) {
            LibImages libImages = new LibImages();
            libImages.id = this.cfp.xR.getAttributeValue(null, "id");
            libImages.name = this.cfp.xR.getAttributeValue(null, "name");
            this.collada.add(libImages);
            if (this.libImagesParser == null) {
                this.libImagesParser = new LibImagesParser(this, libImages);
            } else {
                this.libImagesParser.setup(libImages);
            }
            this.cfp.setParser(this.libImagesParser);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean parseGeometryLib(String string) {
        boolean bl = true;
        if (string.equals("library_geometries")) {
            LibGeometries libGeometries = new LibGeometries(this.cfp.scope);
            libGeometries.id = this.cfp.xR.getAttributeValue(null, "id");
            libGeometries.name = this.cfp.xR.getAttributeValue(null, "name");
            this.collada.add(libGeometries);
            if (this.libGeomsParser == null) {
                this.libGeomsParser = new LibGeometriesParser(this, libGeometries);
            } else {
                this.libGeomsParser.setup(libGeometries);
            }
            this.cfp.setParser(this.libGeomsParser);
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        if (this.isScene) {
            if (string.equals("instance_visual_scene")) {
                this.collada.scene.instVSsid = this.cfp.xR.getAttributeValue(null, "sid");
                this.collada.scene.instVSname = this.cfp.xR.getAttributeValue(null, "name");
                this.collada.scene.instVSurl = this.cfp.xR.getAttributeValue(null, "url");
                return;
            } else if (string.equals("instance_physics_scene")) {
                this.cfp.setNullParser(this, string);
                return;
            } else if (string.equals("instance_kinematics_scene")) {
                this.cfp.setNullParser(this, string);
                return;
            } else {
                if (!string.equals("extra")) return;
                this.cfp.setNullParser(this, string);
            }
            return;
        } else if (string.charAt(0) == 'l') {
            if (this.cfp.scope.isShape3D) {
                if (this.parseAppearanceLibs(string)) {
                    return;
                }
                if (this.parseGeometryLib(string)) {
                    return;
                }
                if (string.equals("library_nodes")) {
                    LibNodes libNodes = new LibNodes();
                    libNodes.id = this.cfp.xR.getAttributeValue(null, "id");
                    libNodes.name = this.cfp.xR.getAttributeValue(null, "name");
                    this.collada.add(libNodes);
                    if (this.libNodesParser == null) {
                        this.libNodesParser = new LibNodesParser(this, libNodes);
                    } else {
                        this.libNodesParser.setup(libNodes);
                    }
                    this.cfp.setParser(this.libNodesParser);
                    return;
                } else if (this.cfp.scope.isModel) {
                    if (string.equals("library_visual_scenes")) {
                        LibVisualScenes libVisualScenes = new LibVisualScenes();
                        libVisualScenes.id = this.cfp.xR.getAttributeValue(null, "id");
                        libVisualScenes.name = this.cfp.xR.getAttributeValue(null, "name");
                        this.collada.add(libVisualScenes);
                        if (this.libVisSceneParser == null) {
                            this.libVisSceneParser = new LibVisualScenesParser(this, libVisualScenes);
                        } else {
                            this.libVisSceneParser.setup(libVisualScenes);
                        }
                        this.cfp.setParser(this.libVisSceneParser);
                        return;
                    } else if (string.equals("library_cameras")) {
                        LibCameras libCameras = new LibCameras();
                        libCameras.id = this.cfp.xR.getAttributeValue(null, "id");
                        libCameras.name = this.cfp.xR.getAttributeValue(null, "name");
                        this.collada.add(libCameras);
                        if (this.libCamerasParser == null) {
                            this.libCamerasParser = new LibCamerasParser(this, libCameras);
                        } else {
                            this.libCamerasParser.setup(libCameras);
                        }
                        this.cfp.setParser(this.libCamerasParser);
                        return;
                    } else if (string.equals("library_controllers")) {
                        LibControllers libControllers = new LibControllers();
                        libControllers.id = this.cfp.xR.getAttributeValue(null, "id");
                        libControllers.name = this.cfp.xR.getAttributeValue(null, "name");
                        this.collada.add(libControllers);
                        if (this.libControllersParser == null) {
                            this.libControllersParser = new LibControllersParser(this, libControllers);
                        } else {
                            this.libControllersParser.setup(libControllers);
                        }
                        this.cfp.setParser(this.libControllersParser);
                        return;
                    } else if (string.equals("library_lights") && this.cfp.scope.isLight) {
                        LibLights libLights = new LibLights();
                        libLights.id = this.cfp.xR.getAttributeValue(null, "id");
                        libLights.name = this.cfp.xR.getAttributeValue(null, "name");
                        this.collada.add(libLights);
                        if (this.libLightsParser == null) {
                            this.libLightsParser = new LibLightsParser(this, libLights);
                        } else {
                            this.libLightsParser.setup(libLights);
                        }
                        this.cfp.setParser(this.libLightsParser);
                        return;
                    } else if (this.cfp.scope.isScene) {
                        if (string.equals("library_force_fields")) {
                            this.cfp.setNullParser(this, string);
                            return;
                        } else if (string.equals("library_physics_materials")) {
                            this.cfp.setNullParser(this, string);
                            return;
                        } else if (string.equals("library_physics_models")) {
                            this.cfp.setNullParser(this, string);
                            return;
                        } else if (string.equals("library_physics_scenes")) {
                            this.cfp.setNullParser(this, string);
                            return;
                        } else {
                            this.cfp.setNullParser(this, string);
                        }
                        return;
                    } else {
                        this.cfp.setNullParser(this, string);
                    }
                    return;
                } else {
                    this.cfp.setNullParser(this, string);
                }
                return;
            } else if (this.cfp.scope.isAppearance) {
                if (this.parseAppearanceLibs(string)) {
                    return;
                }
                this.cfp.setNullParser(this, string);
                return;
            } else if (this.cfp.scope.isGeometry) {
                if (this.parseGeometryLib(string)) {
                    return;
                }
                this.cfp.setNullParser(this, string);
                return;
            } else {
                System.out.println("COLLADAParser should not go here: undefined scope !!");
            }
            return;
        } else if (string.equals("COLLADA")) {
            this.collada.version = this.cfp.xR.getAttributeValue(null, "version");
            this.collada.xmlns = this.cfp.xR.getAttributeValue(null, "xmlns");
            this.collada.xmlBase = this.cfp.xR.getAttributeValue(null, "base");
            if (this.collada.version == null) {
                throw new ImportException("COLLADA version is not set !!");
            }
            if (this.collada.version.contains("1.4")) {
                if (this.cfp.cVersion != CVersion.ALL && this.cfp.cVersion != CVersion.ONE_FOUR_ONE) {
                    throw new ImportException("COLLADA model importer doesn't support version : >" + this.collada.version + "<");
                }
                this.cfp.currFileVersion = CVersion.ONE_FOUR_ONE;
                return;
            } else {
                if (!this.collada.version.contains("1.5")) throw new ImportException("COLLADA  model importer doesn't support version : >" + this.collada.version + "<");
                if (this.cfp.cVersion != CVersion.ALL && this.cfp.cVersion != CVersion.ONE_FIVE_ZERO) {
                    throw new ImportException("COLLADA model importer doesn't support version : >" + this.collada.version + "<");
                }
                this.cfp.currFileVersion = CVersion.ONE_FIVE_ZERO;
            }
            return;
        } else if (string.equals("asset")) {
            Asset asset;
            this.collada.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
            return;
        } else if (string.equals("scene")) {
            this.collada.scene = new Scene();
            this.isScene = true;
            return;
        } else {
            if (!string.equals("extra")) return;
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("scene")) {
            this.isScene = false;
        }
    }
}

