/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.Shape3DParser;
import javafx.scene.Node;
import javafx.scene.shape.Box;
import javafx.scene.shape.Shape3D;

final class BoxParser
extends Shape3DParser {
    private AbstractElementParser parentParser;
    private Box currBox = null;
    private String depth = null;
    private String height = null;
    private String width = null;

    BoxParser(FxFileParser fxFileParser) {
        super(fxFileParser);
        this.charArray = new char[200];
    }

    void setup(AbstractElementParser abstractElementParser, Box box) {
        this.parentParser = abstractElementParser;
        this.currBox = box;
        this.depth = null;
        this.height = null;
        this.width = null;
        this.setupShape3D();
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = this.fxfp.xR.getAttributeValue(i);
            if (string != null && string.length() > 0) {
                String string2 = this.fxfp.xR.getAttributeLocalName(i);
                if (string2.equals("depth")) {
                    this.depth = string;
                    continue;
                }
                if (string2.equals("height")) {
                    this.height = string;
                    continue;
                }
                if (string2.equals("width")) {
                    this.width = string;
                    continue;
                }
                this.processShape3DAttributes(string2, string, i);
                continue;
            }
            throw new ImportException("BoxParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
        }
    }

    @Override
    String getIdDefault() {
        return "Box";
    }

    @Override
    void close() {
        super.close();
    }

    @Override
    void startElement(String string) {
        if (string.equals("material")) {
            super.setMaterialParser(this, (Shape3D)this.currBox);
        } else if (string.equals("transforms")) {
            this.fxfp.setTransformsParser(this, (Node)this.currBox);
        } else {
            this.isCharacter = false;
            this.isPrimitive = false;
            if (!this.processShape3DStartElement(string)) {
                if (string.equals("depth")) {
                    this.isCharacter = true;
                } else if (string.equals("height")) {
                    this.isCharacter = true;
                } else if (string.equals("width")) {
                    this.isCharacter = true;
                } else if (this.processPrimitiveStartElement(string)) {
                    this.isPrimitive = true;
                } else {
                    this.fxfp.setNullParser(this, string);
                }
            }
            if (this.isCharacter) {
                this.arrPos = 0;
            }
        }
    }

    @Override
    void endElement(String string) {
        if (!string.equals(this.primTagName)) {
            if (this.isCharacter || this.isPrimitive) {
                String string2 = this.getCharOrPrimString();
                if (string2 != null) {
                    if (string.equals("depth") && this.depth == null) {
                        this.depth = string2;
                    } else if (string.equals("height") && this.height == null) {
                        this.height = string2;
                    } else if (string.equals("width") && this.width == null) {
                        this.width = string2;
                    } else {
                        this.processShape3DEndElement(string, string2);
                    }
                }
            } else if (string.equals("Box")) {
                this.setShape3DProperties((Shape3D)this.currBox);
                if (this.depth != null) {
                    this.currBox.setDepth(Double.valueOf(this.depth).doubleValue());
                }
                if (this.height != null) {
                    this.currBox.setHeight(Double.valueOf(this.height).doubleValue());
                }
                if (this.width != null) {
                    this.currBox.setWidth(Double.valueOf(this.width).doubleValue());
                }
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
                this.currBox = null;
            }
        }
    }
}

