/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParserChar;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import javafx.scene.paint.Color;

final class ColorParser
extends AbstractElementParserChar {
    private static final String R = "red";
    private static final String G = "green";
    private static final String B = "blue";
    private static final String O = "opacity";
    private AbstractElementParser parentParser = null;
    private String fxIdStrg = null;
    private String colR = null;
    private String colG = null;
    private String colB = null;
    private String colO = null;

    ColorParser(FxFileParser fxFileParser) {
        super(fxFileParser);
        this.charArray = new char[200];
    }

    Color getColor() {
        if (this.colR == null) {
            this.colR = "0";
        }
        if (this.colG == null) {
            this.colG = "0";
        }
        if (this.colB == null) {
            this.colB = "0";
        }
        if (this.colO == null) {
            this.colO = "1";
        }
        Color color = Color.color((double)Double.parseDouble(this.colR), (double)Double.parseDouble(this.colG), (double)Double.parseDouble(this.colB), (double)Double.parseDouble(this.colO));
        if (this.fxIdStrg != null && this.fxIdStrg.length() > 0) {
            this.fxfp.currCache.putColor(this.fxIdStrg, color);
        }
        return color;
    }

    void setup(AbstractElementParser abstractElementParser) {
        this.parentParser = abstractElementParser;
        this.setupChar();
        this.colR = null;
        this.colG = null;
        this.colB = null;
        this.colO = null;
        this.fxIdStrg = null;
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = this.fxfp.xR.getAttributeValue(i);
            if (string != null && string.length() > 0) {
                String string2 = this.fxfp.xR.getAttributeLocalName(i);
                if (string2.equals(R)) {
                    this.colR = string;
                    continue;
                }
                if (string2.equals(G)) {
                    this.colG = string;
                    continue;
                }
                if (string2.equals(B)) {
                    this.colB = string;
                    continue;
                }
                if (string2.equals(O)) {
                    this.colO = string;
                    continue;
                }
                if (!string2.equals("id") || !this.fxfp.xR.getAttributePrefix(i).equals("fx")) continue;
                this.fxIdStrg = string;
                continue;
            }
            throw new ImportException("ColorParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
        }
    }

    @Override
    void close() {
        this.charArray = null;
    }

    @Override
    void startElement(String string) {
        this.isCharacter = false;
        this.isPrimitive = false;
        if (string.equals(R)) {
            this.isCharacter = true;
        } else if (string.equals(G)) {
            this.isCharacter = true;
        } else if (string.equals(B)) {
            this.isCharacter = true;
        } else if (string.equals(O)) {
            this.isCharacter = true;
        } else if (this.processPrimitiveStartElement(string)) {
            this.isPrimitive = true;
        } else {
            this.fxfp.setNullParser(this, string);
        }
        if (this.isCharacter) {
            this.arrPos = 0;
        }
    }

    @Override
    void endElement(String string) {
        if (!string.equals(this.primTagName)) {
            if (this.isCharacter || this.isPrimitive) {
                String string2 = this.getCharOrPrimString();
                if (string2 != null) {
                    if (string.equals(R)) {
                        this.colR = string2;
                    } else if (string.equals(G)) {
                        this.colG = string2;
                    } else if (string.equals(B)) {
                        this.colB = string2;
                    } else if (string.equals(O)) {
                        this.colO = string2;
                    }
                }
            } else if (string.equals("Color")) {
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
            }
        }
    }
}

