/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.FxImporterImpl;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;

final class FxUtils {
    private float[] floatValues = new float[200000];
    private int[] intValues = new int[1200000];

    FxUtils() {
    }

    void close() {
        this.floatValues = null;
        this.intValues = null;
    }

    private void adjustFloatValues(int n, int n2) {
        if (n2 > this.floatValues.length) {
            int n3 = Math.max(n2, (int)((float)this.floatValues.length * 1.5f));
            if (n > 0) {
                float[] fArray = this.floatValues;
                this.floatValues = new float[n3];
                System.arraycopy(fArray, 0, this.floatValues, 0, n);
            } else {
                this.floatValues = new float[n3];
            }
        }
    }

    private void adjustIntValues(int n, int n2) {
        if (n2 > this.intValues.length) {
            int n3 = Math.max(n2, (int)((float)this.intValues.length * 1.5f));
            if (n > 0) {
                int[] nArray = this.intValues;
                this.intValues = new int[n3];
                System.arraycopy(nArray, 0, this.intValues, 0, n);
            } else {
                this.intValues = new int[n3];
            }
        }
    }

    float[] getFloatValues() {
        return this.floatValues;
    }

    int[] getIntValues() {
        return this.intValues;
    }

    int splitFloatsC(char[] cArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        char c = '\u0000';
        this.adjustFloatValues(0, (int)((float)n / 8.0f));
        try {
            do {
                if ((c = cArray[n3]) <= ' ' || c == ',') continue;
                n2 = n3;
                while (++n3 < n && (c = cArray[n3]) > ' ' && c != ',') {
                }
                if (n4 >= this.floatValues.length) {
                    this.adjustFloatValues(n4, n4 + 1 + (n - n3) / 7);
                }
                this.floatValues[n4++] = Float.parseFloat(new String(cArray, n2, n3 - n2));
            } while (++n3 < n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("split float : " + numberFormatException.getMessage(), numberFormatException);
        }
        return n4;
    }

    int splitFloatsD(char[] cArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        char c = '\u0000';
        this.adjustFloatValues(0, (int)((float)n / 8.0f));
        try {
            do {
                if ((c = cArray[n3]) <= ' ' || c == ',') continue;
                n2 = n3;
                while (++n3 < n && (c = cArray[n3]) > ' ' && c != ',') {
                }
                if (n4 >= this.floatValues.length) {
                    this.adjustFloatValues(n4, n4 + 1 + (n - n3) / 7);
                }
                this.floatValues[n4++] = Float.parseFloat(new String(cArray, n2, n3 - n2));
            } while (++n3 < n);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ImportException("split float : " + numberFormatException.getMessage(), numberFormatException);
        }
        return n4;
    }

    int splitIntegers(char[] cArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        char c = '\u0000';
        this.adjustIntValues(0, (int)((float)n / 5.0f));
        do {
            if ((c = cArray[n4]) <= ' ' || c == ',') continue;
            n3 = 0;
            do {
                n2 = c - 48;
                n3 *= 10;
                n3 += n2;
            } while (++n4 < n && (c = cArray[n4]) > ' ' && c != ',');
            if (n5 >= this.intValues.length) {
                this.adjustIntValues(n5, n5 + 1 + (int)((float)(n - n4) / 5.0f));
            }
            this.intValues[n5++] = n3;
        } while (++n4 < n);
        return n5;
    }

    String trimString(char[] cArray, int n) {
        int n2;
        if (n < 1) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = cArray.length;
        for (n2 = 0; n2 < n5; ++n2) {
            if (cArray[n2] <= ' ') continue;
            n3 = n2;
            break;
        }
        for (n2 = n - 1; n2 >= 0; --n2) {
            if (cArray[n2] <= ' ') continue;
            n4 = n2 + 1 - n3;
            break;
        }
        return new String(cArray, n3, n4);
    }

    URL getUrlForAbsolutPath(String string) {
        URL uRL = null;
        int n = string.indexOf(":");
        try {
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string2.toLowerCase(Locale.ENGLISH);
                if (string3.startsWith("jar") || string3.startsWith("http") || string3.startsWith("file") || string3.startsWith("ftp")) {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                } else if (string.charAt(0) != '/') {
                    uRL = new URL("file", null, "/" + string);
                } else {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                }
            } else if (string.charAt(0) == '/') {
                uRL = new URL("file", null, string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ImportException("Can't create URI !\nPath = " + string + "<!");
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("Can't create URL !\nPath = " + string + "<!");
        }
        return uRL;
    }

    URL getUrlForRelativePath(FxImporterImpl.BaseURL baseURL, String string) {
        string = string.replace('\\', '/');
        URL uRL = null;
        try {
            uRL = new URL(baseURL.protocol, baseURL.host, baseURL.port, this.normalizePath(baseURL.path, string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("\nCan't build URL for resource relative to file.\nprotocol = " + baseURL.protocol + ", host = " + baseURL.host + ", port = " + baseURL.port + "\npath = " + baseURL.path + "\nrelativeP path = " + string);
        }
        return uRL;
    }

    String normalizePath(String string, String string2) {
        if (string2.indexOf("./") == 0) {
            return new String(string + string2.substring(2));
        }
        int n = -1;
        int n2 = string2.lastIndexOf("../");
        int n3 = 0;
        if (n2 >= 0) {
            n3 = n2 / 3 + 1;
        }
        if (n3 > 0) {
            int n4 = string.length() - 2;
            n = string.lastIndexOf(47, n4);
            if (n < 0) {
                throw new ImportException("normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
            }
            --n3;
            while (n3 > 0) {
                if ((n = string.lastIndexOf(47, n - 1)) < 0) {
                    throw new ImportException("normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
                }
                --n3;
            }
            return new String(string.substring(0, n + 1) + string2.substring(n2 + 3));
        }
        return new String(string + string2);
    }
}

