/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.tds;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.tds.Indexer;
import com.interactivemesh.jfx.importer.tds.MMaterial;
import com.interactivemesh.jfx.importer.tds.MeshSmoother;
import com.interactivemesh.jfx.importer.tds.Normalizer;
import com.interactivemesh.jfx.importer.tds.TdsImportOption;
import com.interactivemesh.jfx.importer.tds.TdsModelImporter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.geometry.Point3D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;
import javafx.scene.transform.MatrixType;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;

final class TdsModelImporterImpl {
    private Rotate maxToFX = null;
    private Affine rotX180 = null;
    private final EnumSet<TdsImportOption> tdsOpts = EnumSet.of(TdsImportOption.NONE);
    private double creaseAngle = Math.toRadians(45.0);
    private URL baseUrlU = null;
    private String basePathU = null;
    private boolean isUserBase = false;
    private BaseURL baseUrlUser = null;
    private BaseURL baseUrlTds = null;
    private LinkedHashMap<String, Obj> objMap = null;
    private HashMap<String, PhongMaterial> appearMap = null;
    private int keyFrameObjId = 0;
    private int coordsLength = 0;
    private int coordsSize = 0;
    private float[] coordsList = null;
    private int texsLength = 0;
    private int texsSize = 0;
    private float[] texsList = null;
    private int indsLength = 0;
    private int indsSize = 0;
    private int[] coordIndsList = null;
    private int[] normalIndsList = null;
    private int smoothIdsLength = 0;
    private int smoothIdsSize = 0;
    private int[] smoothIdsList = null;
    private ArrayList<Node> importedNodes = null;
    private HashMap<String, Node> namedNodes = null;
    private HashMap<String, PhongMaterial> namedMaterials = null;
    private MMaterial appearancer = null;
    private Indexer indexer = null;
    private Normalizer normalizer = null;
    private final MeshSmoother smoother;
    private boolean isClosed = false;
    private static int appearCloneId = 0;
    private TdsModelImporter importer = null;

    TdsModelImporterImpl(TdsModelImporter tdsModelImporter) {
        this.importer = tdsModelImporter;
        this.appearancer = new MMaterial(this);
        this.indexer = new Indexer();
        this.normalizer = new Normalizer();
        this.smoother = new MeshSmoother();
        this.maxToFX = new Rotate(-90.0, Rotate.X_AXIS);
        this.rotX180 = new Affine();
        this.rotX180.setMyy(-1.0);
        this.rotX180.setMzz(-1.0);
    }

    double getCreaseAngle() {
        return Math.toDegrees(this.creaseAngle);
    }

    void setCreaseAngle(double d) {
        double d2 = Math.toRadians(d);
        if (d2 < 0.0) {
            d2 = 0.0;
        } else if (d2 > Math.PI) {
            d2 = 3.1415927410125732;
        }
        this.creaseAngle = d2;
    }

    String getResourcePath() {
        return this.basePathU;
    }

    void setResourcePath(String string) {
        this.baseUrlU = null;
        this.basePathU = string;
        boolean bl = this.isUserBase = string != null && string.length() > 0;
        if (this.isUserBase) {
            URL uRL;
            string.trim();
            string = string.replace('\\', '/');
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if ((uRL = this.getUrlForAbsolutPath(string)) == null) {
                throw new ImportException("TdsModelImporter setResourcePath : Can't create absolute URL from = " + string);
            }
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
        } else {
            this.baseUrlUser = null;
        }
    }

    URL getResourceUrl() {
        return this.baseUrlU;
    }

    void setResourceUrl(URL uRL) {
        this.basePathU = null;
        this.baseUrlU = uRL;
        boolean bl = this.isUserBase = uRL != null;
        if (this.isUserBase) {
            this.baseUrlUser = new BaseURL();
            this.baseUrlUser.protocol = uRL.getProtocol();
            this.baseUrlUser.host = uRL.getHost();
            this.baseUrlUser.port = uRL.getPort();
            this.baseUrlUser.path = uRL.getPath();
            if (!this.baseUrlUser.path.endsWith("/")) {
                this.baseUrlUser.path = this.baseUrlUser.path + "/";
            }
        } else {
            this.baseUrlUser = null;
        }
    }

    EnumSet<TdsImportOption> getOptions() {
        return this.tdsOpts.clone();
    }

    void setOptions(TdsImportOption ... tdsImportOptionArray) {
        if (tdsImportOptionArray == null || tdsImportOptionArray.length < 1) {
            throw new IllegalArgumentException("options is null || options' length < 1");
        }
        if (tdsImportOptionArray.length > 1) {
            for (TdsImportOption tdsImportOption : tdsImportOptionArray) {
                if (tdsImportOption != TdsImportOption.NONE) continue;
                throw new IllegalArgumentException("options include TdsImportOption.NONE");
            }
        }
        this.tdsOpts.clear();
        for (TdsImportOption tdsImportOption : tdsImportOptionArray) {
            this.tdsOpts.add(tdsImportOption);
        }
        this.appearancer.setOptions(this.tdsOpts);
    }

    void setOptions(EnumSet<TdsImportOption> enumSet) {
        if (enumSet == null || enumSet.isEmpty()) {
            throw new IllegalArgumentException("options is null || options is empty");
        }
        if (enumSet.size() > 1) {
            for (TdsImportOption tdsImportOption : enumSet) {
                if (tdsImportOption != TdsImportOption.NONE) continue;
                throw new IllegalArgumentException("options include TdsImportOption.NONE");
            }
        }
        this.tdsOpts.clear();
        this.tdsOpts.addAll(enumSet);
        this.appearancer.setOptions(this.tdsOpts);
    }

    void read(File file) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (file == null) {
            throw new ImportException("TdsModelImporter read(File file) : file is null !");
        }
        if (!file.exists()) {
            throw new ImportException("TdsModelImporter read(File file) : file doesn't exist !");
        }
        if (file.isDirectory()) {
            throw new ImportException("TdsModelImporter read(File file) : file is directory !");
        }
        if (!file.canRead()) {
            throw new ImportException("TdsModelImporter read(File file) : file can't be read !");
        }
        try {
            URL uRL = file.toURI().toURL();
            this.baseUrlTds = new BaseURL();
            this.baseUrlTds.protocol = uRL.getProtocol();
            this.baseUrlTds.host = uRL.getHost();
            this.baseUrlTds.port = uRL.getPort();
            this.baseUrlTds.path = uRL.getPath();
            int n = this.baseUrlTds.path.lastIndexOf(47);
            if (n >= 0) {
                this.baseUrlTds.path = this.baseUrlTds.path.substring(0, n + 1);
            } else if (n < 0) {
                this.baseUrlTds.path = Character.toString('/');
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("TdsModelImporter read(File file)", malformedURLException);
        }
        try {
            this.importFile(new FileInputStream(file).getChannel());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("TdsModelImporter read(File file) : \n" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ImportException("TdsModelImporter read(File file) : \n" + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ImportException("TdsModelImporter read(File file) : \n" + iOException.getMessage(), iOException);
        }
    }

    void read(String string) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (string == null || string.length() < 1) {
            throw new ImportException("TdsModelImporter read(String fileName) : fileName is null !");
        }
        URL uRL = null;
        try {
            String string2;
            string = string.replace('\\', '/');
            uRL = this.getUrlForAbsolutPath(string);
            if (uRL == null && (string2 = System.getProperty("user.dir")).length() > 0) {
                if ((string2 = string2.replace('\\', '/')).charAt(0) != '/') {
                    string2 = '/' + string2;
                }
                if (string2.charAt(string2.length() - 1) != '/') {
                    string2 = string2 + '/';
                }
                uRL = new URL("file", null, this.normalizePath(string2, string));
            }
            if (uRL == null) {
                throw new ImportException("TdsModelImporter read(String fileName) : Can' create URL f0r = \n" + string);
            }
            this.baseUrlTds = new BaseURL();
            this.baseUrlTds.protocol = uRL.getProtocol();
            this.baseUrlTds.host = uRL.getHost();
            this.baseUrlTds.port = uRL.getPort();
            this.baseUrlTds.path = uRL.getPath();
            int n = this.baseUrlTds.path.lastIndexOf(47);
            if (n >= 0) {
                this.baseUrlTds.path = this.baseUrlTds.path.substring(0, n + 1);
            } else if (n < 0) {
                this.baseUrlTds.path = Character.toString('/');
            }
        }
        catch (SecurityException securityException) {
            throw new ImportException("TdsModelImporter read(String fileName) : \n" + securityException.getMessage(), securityException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("TdsModelImporter read(String fileName) : \n" + malformedURLException.getMessage(), malformedURLException);
        }
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.importFile(Channels.newChannel(uRLConnection.getInputStream()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("TdsModelImporter read(String fileName) : \n" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ImportException("TdsModelImporter read(String fileName) : \n" + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ImportException("TdsModelImporter read(String fileName) : \n" + iOException.getMessage(), iOException);
        }
    }

    void read(URL uRL) throws ImportException {
        if (this.checkIsClosed()) {
            return;
        }
        if (uRL == null) {
            throw new ImportException("TdsModelImporter read(URL url) : url is null !");
        }
        this.baseUrlTds = new BaseURL();
        this.baseUrlTds.protocol = uRL.getProtocol();
        this.baseUrlTds.host = uRL.getHost();
        this.baseUrlTds.port = uRL.getPort();
        this.baseUrlTds.path = uRL.getPath();
        int n = this.baseUrlTds.path.lastIndexOf(47);
        this.baseUrlTds.path = n >= 0 ? this.baseUrlTds.path.substring(0, n + 1) : Character.toString('/');
        try {
            URLConnection uRLConnection = uRL.openConnection();
            this.importFile(Channels.newChannel(uRLConnection.getInputStream()));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImportException("TdsModelImporter read(URL url) : \n" + fileNotFoundException.getMessage(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ImportException("TdsModelImporter read(URL url) : \n" + unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new ImportException("TdsModelImporter read(URL url) : \n" + iOException.getMessage(), iOException);
        }
    }

    Node[] getImport() {
        Node[] nodeArray = null;
        int n = 0;
        if (this.importedNodes != null && (n = this.importedNodes.size()) > 0) {
            nodeArray = new Node[n];
            for (int i = 0; i < n; ++i) {
                nodeArray[i] = this.importedNodes.get(i);
            }
        }
        return nodeArray;
    }

    Map<String, Node> getNamedNodes() {
        HashMap<String, Node> hashMap = null;
        int n = 0;
        if (this.namedNodes != null && (n = this.namedNodes.size()) > 0) {
            hashMap = new HashMap<String, Node>(n, 1.0f);
            Set<Map.Entry<String, Node>> set = this.namedNodes.entrySet();
            Iterator<Map.Entry<String, Node>> iterator = set.iterator();
            Map.Entry<String, Node> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    Map<String, PhongMaterial> getNamedMaterials() {
        HashMap<String, PhongMaterial> hashMap = null;
        int n = 0;
        if (this.namedMaterials != null && (n = this.namedMaterials.size()) > 0) {
            hashMap = new HashMap<String, PhongMaterial>(n, 1.0f);
            Set<Map.Entry<String, PhongMaterial>> set = this.namedMaterials.entrySet();
            Iterator<Map.Entry<String, PhongMaterial>> iterator = set.iterator();
            Map.Entry<String, PhongMaterial> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    IdentityHashMap<Image, FilePath> getImagePaths() {
        IdentityHashMap<Image, FilePath> identityHashMap = this.appearancer.getImagePaths();
        int n = identityHashMap.size();
        if (n > 0) {
            IdentityHashMap<Image, FilePath> identityHashMap2 = new IdentityHashMap<Image, FilePath>(n);
            Set<Map.Entry<Image, FilePath>> set = identityHashMap.entrySet();
            Iterator<Map.Entry<Image, FilePath>> iterator = set.iterator();
            Map.Entry<Image, FilePath> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                identityHashMap2.put(entry.getKey(), entry.getValue());
            }
            return identityHashMap2;
        }
        return null;
    }

    void clear() {
        if (this.objMap != null && !this.objMap.isEmpty()) {
            this.objMap.clear();
        }
        this.objMap = null;
        if (this.appearMap != null && !this.appearMap.isEmpty()) {
            this.appearMap.clear();
        }
        this.appearMap = null;
        if (this.namedNodes != null && !this.namedNodes.isEmpty()) {
            this.namedNodes.clear();
        }
        this.namedNodes = null;
        if (this.namedMaterials != null && !this.namedMaterials.isEmpty()) {
            this.namedMaterials.clear();
        }
        this.namedMaterials = null;
        if (this.importedNodes != null && !this.importedNodes.isEmpty()) {
            this.importedNodes.clear();
        }
        this.importedNodes = null;
        this.appearancer.clear();
    }

    public void close() {
        this.isClosed = true;
        this.clear();
        this.appearancer.close();
        this.indexer.close();
        this.smoother.close();
        this.coordsList = null;
        this.texsList = null;
        this.coordIndsList = null;
        this.normalIndsList = null;
        this.smoothIdsList = null;
        this.importer = null;
    }

    URL getUrlForRelativePath(BaseURL baseURL, String string) {
        string = string.replace('\\', '/');
        URL uRL = null;
        try {
            uRL = new URL(baseURL.protocol, baseURL.host, baseURL.port, this.normalizePath(baseURL.path, string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("\nTdsModelImporter Can't build URL for resource relative to file.\nprotocol = " + baseURL.protocol + ", host = " + baseURL.host + ", port = " + baseURL.port + "\npath = " + baseURL.path + "\nrelativeP path = " + string, malformedURLException);
        }
        return uRL;
    }

    URL getUrlForAbsolutPath(String string) {
        URL uRL = null;
        int n = string.indexOf(":");
        try {
            if (n > 0) {
                String string2 = string.substring(0, n);
                String string3 = string2.toLowerCase(Locale.ENGLISH);
                if (string3.startsWith("jar") || string3.startsWith("http") || string3.startsWith("file") || string3.startsWith("ftp")) {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                } else if (string.charAt(0) != '/') {
                    uRL = new URL("file", null, "/" + string);
                } else {
                    URI uRI = new URI(string);
                    uRL = uRI.toURL();
                }
            } else if (string.charAt(0) == '/') {
                uRL = new URL("file", null, string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ImportException("TdsModelImporter Can't create URI !\nPath = " + string + "<!", uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ImportException("TdsModelImporter Can't create URL !\nPath = " + string + "<!", malformedURLException);
        }
        return uRL;
    }

    private String normalizePath(String string, String string2) {
        if (string2.indexOf("./") == 0) {
            string2 = string2.substring(2);
            return new String(string + string2);
        }
        int n = -1;
        int n2 = string2.lastIndexOf("../");
        int n3 = 0;
        if (n2 >= 0) {
            n3 = n2 / 3 + 1;
        }
        if (n3 > 0) {
            int n4 = string.length() - 2;
            n = string.lastIndexOf(47, n4);
            if (n < 0) {
                throw new ImportException("TdsModelImporter normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
            }
            --n3;
            while (n3 > 0) {
                if ((n = string.lastIndexOf(47, n - 1)) < 0) {
                    throw new ImportException("TdsModelImporter normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
                }
                --n3;
            }
            return new String(string.substring(0, n + 1) + string2.substring(n2 + 3));
        }
        return new String(string + string2);
    }

    private boolean checkIsClosed() {
        if (this.isClosed) {
            throw new ImportException("TdsModelImporter is closed! Can't be used anymore!");
        }
        return this.isClosed;
    }

    private void importFile(ReadableByteChannel readableByteChannel) throws IOException {
        this.setupForNextImport();
        this.readChannel(readableByteChannel);
        this.importer.onFileImported();
    }

    private void setupForNextImport() {
        this.clear();
        this.objMap = new LinkedHashMap();
        this.appearMap = new HashMap();
        this.importedNodes = new ArrayList();
        this.namedNodes = new HashMap();
        this.namedMaterials = new HashMap();
        this.appearancer.setMaps(this.namedMaterials, this.appearMap);
        if (this.isUserBase) {
            this.appearancer.setBaseUrl(this.baseUrlUser);
        } else {
            this.appearancer.setBaseUrl(this.baseUrlTds);
        }
    }

    private void readChannel(ReadableByteChannel readableByteChannel) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(6);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.clear();
        readableByteChannel.read(byteBuffer);
        byteBuffer.position(0);
        int n = byteBuffer.getShort() & 0xFFFF;
        int n2 = byteBuffer.getInt();
        String string = Integer.toHexString(n & 0xFFFF);
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n2);
        byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer2.clear();
        byteBuffer2.position(6);
        readableByteChannel.read(byteBuffer2);
        readableByteChannel.close();
        byteBuffer2.position(6);
        while (byteBuffer2.position() < byteBuffer2.limit()) {
            n = byteBuffer2.getShort() & 0xFFFF;
            n2 = byteBuffer2.getInt();
            string = Integer.toHexString(n & 0xFFFF);
            int n3 = byteBuffer2.position() + n2 - 6;
            if (n == 15677) {
                while (byteBuffer2.position() < n3) {
                    n = byteBuffer2.getShort() & 0xFFFF;
                    n2 = byteBuffer2.getInt();
                    string = Integer.toHexString(n & 0xFFFF);
                    int n4 = byteBuffer2.position() + n2 - 6;
                    if (string.equalsIgnoreCase("afff")) {
                        this.appearancer.createAppearance(byteBuffer2, n4);
                    } else if (n == 16384) {
                        String object = this.getString(byteBuffer2);
                        while (byteBuffer2.position() < n4) {
                            n = byteBuffer2.getShort() & 0xFFFF;
                            n2 = byteBuffer2.getInt();
                            string = Integer.toHexString(n & 0xFFFF);
                            int n5 = byteBuffer2.position() + n2 - 6;
                            if (n == 16640) {
                                this.createObj(byteBuffer2, object, n5);
                            }
                            byteBuffer2.position(n5);
                        }
                    }
                    byteBuffer2.position(n4);
                }
            } else if (string.equalsIgnoreCase("b000")) {
                this.createKeyframer(byteBuffer2, n3);
            }
            byteBuffer2.position(n3);
        }
        byteBuffer2.clear();
        if (this.objMap != null && !this.objMap.isEmpty()) {
            Collection<Obj> collection = this.objMap.values();
            for (Obj obj : collection) {
                Group group;
                if (!obj.isRoot() || (group = obj.getObjGroup()) == null) continue;
                this.importedNodes.add((Node)group);
            }
            for (Obj obj : collection) {
                if (!obj.isRoot()) continue;
                obj.clearTopDown();
            }
        }
    }

    private void createKeyframer(ByteBuffer byteBuffer, int n) {
        Object object;
        ArrayList<Obj> arrayList = new ArrayList<Obj>();
        HashMap<Integer, Obj> hashMap = new HashMap<Integer, Obj>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        while (byteBuffer.position() < n) {
            String string;
            int n2 = byteBuffer.getShort() & 0xFFFF;
            int n3 = byteBuffer.getInt();
            object = Integer.toHexString(n2 & 0xFFFF);
            int n4 = byteBuffer.position() + n3 - 6;
            if (((String)object).equalsIgnoreCase("b00a")) {
                int n5 = byteBuffer.getShort() & 0xFFFF;
                string = this.getString(byteBuffer);
                int n6 = byteBuffer.getShort() & 0xFFFF;
            } else if (((String)object).equalsIgnoreCase("b008")) {
                int n7 = byteBuffer.getInt();
                int n8 = byteBuffer.getInt();
            } else if (((String)object).equalsIgnoreCase("b009")) {
                int n9 = byteBuffer.getInt();
            } else if (((String)object).equalsIgnoreCase("b002")) {
                int n10;
                String string2;
                Obj obj = null;
                string = null;
                Point3D point3D = null;
                double d = 0.0;
                Point3D point3D2 = null;
                Point3D point3D3 = null;
                Point3D point3D4 = null;
                Point3D point3D5 = null;
                Point3D point3D6 = null;
                int n11 = -1;
                int n12 = -1;
                String string3 = null;
                boolean bl = false;
                boolean bl2 = false;
                while (byteBuffer.position() < n4) {
                    float f;
                    float f2;
                    float f3;
                    float f4;
                    int n13;
                    int n14;
                    int n15;
                    n2 = byteBuffer.getShort() & 0xFFFF;
                    n3 = byteBuffer.getInt();
                    object = Integer.toHexString(n2 & 0xFFFF);
                    int n16 = byteBuffer.position() + n3 - 6;
                    if (((String)object).equalsIgnoreCase("b010")) {
                        string2 = this.getString(byteBuffer);
                        n10 = byteBuffer.getShort();
                        n15 = byteBuffer.getShort();
                        n11 = byteBuffer.getShort();
                        obj = this.objMap.get(string2);
                        if (obj != null) {
                            if (arrayList2.contains(string2)) {
                                bl = true;
                            } else {
                                arrayList2.add(string2);
                            }
                        } else {
                            bl2 = true;
                        }
                    } else if (((String)object).equalsIgnoreCase("b011")) {
                        string3 = this.getString(byteBuffer);
                    } else if (((String)object).equalsIgnoreCase("b013")) {
                        float f5 = byteBuffer.getFloat();
                        float f6 = byteBuffer.getFloat();
                        float f7 = byteBuffer.getFloat();
                        if (f5 < -1.0E-4f || f5 > 1.0E-4f || f6 < -1.0E-4f || f6 > 1.0E-4f || f7 < -1.0E-4f || f7 > 1.0E-4f) {
                            string = new Point3D((double)f5, (double)f6, (double)f7);
                        }
                    } else if (((String)object).equalsIgnoreCase("b014")) {
                        float f8 = byteBuffer.getFloat();
                        float f9 = byteBuffer.getFloat();
                        float f10 = byteBuffer.getFloat();
                        float f11 = byteBuffer.getFloat();
                        float f12 = byteBuffer.getFloat();
                        float f13 = byteBuffer.getFloat();
                        point3D4 = new Point3D((double)f8, (double)f9, (double)f10);
                        point3D5 = new Point3D((double)f11, (double)f12, (double)f13);
                        point3D6 = new Point3D((double)(f11 - f8), (double)(f12 - f9), (double)(f13 - f10));
                    } else if (((String)object).equalsIgnoreCase("b020")) {
                        short s = byteBuffer.getShort();
                        n10 = byteBuffer.getShort();
                        n15 = byteBuffer.getShort();
                        short s2 = byteBuffer.getShort();
                        short s3 = byteBuffer.getShort();
                        int n17 = byteBuffer.getShort() & 0xFFFF;
                        n14 = byteBuffer.getShort();
                        n13 = byteBuffer.getShort() & 0xFFFF;
                        int n18 = byteBuffer.getInt();
                        f4 = byteBuffer.getFloat();
                        f3 = byteBuffer.getFloat();
                        f2 = byteBuffer.getFloat();
                        point3D = new Point3D((double)f4, (double)f3, (double)f2);
                    } else if (((String)object).equalsIgnoreCase("b021")) {
                        short s = byteBuffer.getShort();
                        n10 = byteBuffer.getShort();
                        n15 = byteBuffer.getShort();
                        short s4 = byteBuffer.getShort();
                        short s5 = byteBuffer.getShort();
                        int n19 = byteBuffer.getShort() & 0xFFFF;
                        n14 = byteBuffer.getShort();
                        n13 = byteBuffer.getShort() & 0xFFFF;
                        int n20 = byteBuffer.getInt();
                        f4 = byteBuffer.getFloat();
                        f3 = byteBuffer.getFloat();
                        f2 = byteBuffer.getFloat();
                        f = byteBuffer.getFloat();
                        d = f4;
                        point3D2 = new Point3D((double)f3, (double)f2, (double)f);
                    } else if (((String)object).equalsIgnoreCase("b022")) {
                        int n21 = byteBuffer.getShort() & 0xFFFF;
                        n10 = byteBuffer.getShort() & 0xFFFF;
                        n15 = byteBuffer.getShort() & 0xFFFF;
                        int n22 = byteBuffer.getShort() & 0xFFFF;
                        int n23 = byteBuffer.getShort() & 0xFFFF;
                        int n24 = byteBuffer.getShort() & 0xFFFF;
                        n14 = byteBuffer.getShort() & 0xFFFF;
                        n13 = byteBuffer.getShort() & 0xFFFF;
                        long l = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                        f3 = byteBuffer.getFloat();
                        f2 = byteBuffer.getFloat();
                        f = byteBuffer.getFloat();
                        point3D3 = new Point3D((double)f3, (double)f2, (double)f);
                    } else if (((String)object).equalsIgnoreCase("b030")) {
                        n12 = byteBuffer.getShort();
                    }
                    byteBuffer.position(n16);
                }
                if (obj != null || bl2) {
                    if (bl2) {
                        String string4 = null;
                        if (string3 != null) {
                            string4 = "DUMMY_" + string3;
                        } else {
                            string4 = "DUMMY_" + this.keyFrameObjId;
                            ++this.keyFrameObjId;
                        }
                        obj = new Obj(string4);
                        this.objMap.put(obj.objName, obj);
                    } else if (bl) {
                        obj = obj.createInstance(string3);
                        this.objMap.put(obj.objName, obj);
                    }
                    obj.hierarchyPosition = n12;
                    obj.setHierarchyParent(n11);
                    arrayList.add(obj);
                    hashMap.put(n12, obj);
                    Point3D point3D7 = new Point3D(point3D2.getX(), -point3D2.getY(), -point3D2.getZ());
                    string2 = this.getFrameRotScale(-d, point3D7, point3D3);
                    int n25 = n10 = string2.determinant() < 0.0 ? 1 : 0;
                    if (point3D != null) {
                        string2.setTx(point3D.getX());
                        string2.setTy(-point3D.getY());
                        string2.setTz(-point3D.getZ());
                    }
                    obj.framePosRotScT3D = (Affine)string2;
                    obj.isFrameDetFlip = n10 != 0;
                    if (string != null && !bl2) {
                        obj.isFramePivot = true;
                        obj.framePivoInvT3D = new Affine();
                        obj.framePivoInvT3D.setTx(-string.getX());
                        obj.framePivoInvT3D.setTy(string.getY());
                        obj.framePivoInvT3D.setTz(string.getZ());
                    }
                    obj.isFrameTransform = true;
                }
            }
            byteBuffer.position(n4);
        }
        if (!arrayList.isEmpty()) {
            for (Obj obj : arrayList) {
                if (obj.getHierarchyParent() <= -1) continue;
                object = (Obj)hashMap.get(obj.getHierarchyParent());
                if (object != null) {
                    ((Obj)object).addchild(obj);
                    continue;
                }
                obj.setHierarchyParent(-1);
            }
        }
    }

    private Affine getFrameRotScale(double d, Point3D point3D, Point3D point3D2) {
        Rotate rotate = null;
        Scale scale = null;
        if (point3D != null && d != 0.0 && (point3D.getX() != 0.0 || point3D.getY() != 0.0 || point3D.getZ() != 0.0)) {
            rotate = new Rotate(Math.toDegrees(d), point3D);
        }
        if (!(point3D2 == null || point3D2.getX() == 1.0 && point3D2.getY() == 1.0 && point3D2.getZ() == 1.0 || point3D2.getX() == 0.0 && point3D2.getY() == 0.0 && point3D2.getZ() == 0.0)) {
            scale = new Scale(point3D2.getX(), point3D2.getY(), point3D2.getZ());
        }
        Affine affine = null;
        if (rotate != null) {
            affine = new Affine(rotate);
        }
        if (scale != null) {
            if (affine != null) {
                affine.append(scale);
            } else {
                affine = new Affine(scale);
            }
        }
        if (affine == null) {
            affine = new Affine();
        }
        return affine;
    }

    private void createObj(ByteBuffer byteBuffer, String string, int n) {
        boolean bl = false;
        Obj obj = new Obj(string);
        this.objMap.put(string, obj);
        this.indsSize = 0;
        this.coordsSize = 0;
        this.smoothIdsSize = 0;
        while (byteBuffer.position() < n) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6 = byteBuffer.getShort() & 0xFFFF;
            int n7 = byteBuffer.getInt();
            String string2 = Integer.toHexString(n6 & 0xFFFF);
            int n8 = byteBuffer.position() + n7 - 6;
            if (n6 == 16672) {
                Object object;
                int n9;
                int n10;
                n5 = byteBuffer.getShort() & 0xFFFF;
                n4 = n5 * 3;
                n3 = n5 * 8;
                this.indsSize = n4;
                if (this.coordIndsList == null || this.indsLength < n4) {
                    this.indsLength = n4;
                    this.coordIndsList = new int[this.indsLength];
                }
                n2 = 0;
                int n11 = n4 / 3;
                for (n10 = 0; n10 < n11; ++n10) {
                    this.coordIndsList[n2++] = byteBuffer.getShort() & 0xFFFF;
                    this.coordIndsList[n2++] = byteBuffer.getShort() & 0xFFFF;
                    this.coordIndsList[n2++] = byteBuffer.getShort() & 0xFFFF;
                    byteBuffer.getShort();
                }
                n10 = 0;
                boolean bl2 = true;
                String string3 = null;
                int n12 = 0;
                while (byteBuffer.position() < n8) {
                    int n13;
                    n6 = byteBuffer.getShort() & 0xFFFF;
                    n7 = byteBuffer.getInt();
                    string2 = Integer.toHexString(n6 & 0xFFFF);
                    n9 = byteBuffer.position() + n7 - 6;
                    if (n6 == 16688) {
                        string3 = this.getString(byteBuffer);
                        n13 = byteBuffer.getShort() & 0xFFFF;
                        if (n13 > 0) {
                            object = new int[n13];
                            n12 += n13;
                            for (int i = 0; i < n13; ++i) {
                                object[i] = byteBuffer.getShort() & 0xFFFF;
                            }
                            ObjShape objShape = new ObjShape(obj, string + "_" + string3, string3);
                            ObjShape.access$1602(objShape, (int[])object);
                            obj.objShapes.add(objShape);
                            ++n10;
                            bl2 = false;
                        }
                    } else if (n6 == 16720) {
                        this.smoothIdsSize = n5;
                        if (this.smoothIdsList == null || this.smoothIdsLength < n5) {
                            this.smoothIdsLength = n5;
                            this.smoothIdsList = new int[this.smoothIdsLength];
                        }
                        n13 = 0;
                        int n14 = 0;
                        int n15 = 0;
                        long l = 1L;
                        for (int i = 0; i < n5; ++i) {
                            n13 = 0;
                            long l2 = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                            n14 = 0;
                            n15 = 0;
                            for (int j = 0; j < 32; ++j) {
                                if (n15 == 3) {
                                    // empty if block
                                }
                                if ((l2 & (l = 1L << j)) == 0L) continue;
                                n14 = (int)((long)n14 | l);
                                ++n15;
                            }
                            this.smoothIdsList[i] = n14;
                            bl |= Integer.bitCount(n14) > 1;
                        }
                    }
                    byteBuffer.position(n9);
                }
                if (bl2) {
                    n9 = this.indsSize / 3;
                    int[] nArray = new int[n9];
                    for (int i = 0; i < n9; ++i) {
                        nArray[i] = i;
                    }
                    object = "NoMaterial";
                    if (string3 != null) {
                        object = string3;
                    }
                    ObjShape objShape = new ObjShape(obj, string + "_" + (String)object, (String)object);
                    ObjShape.access$1602(objShape, nArray);
                    obj.objShapes.add(objShape);
                }
            } else if (n6 == 16656) {
                n5 = byteBuffer.getShort() & 0xFFFF;
                this.coordsSize = n4 = n5 * 3;
                if (this.coordsList == null || this.coordsLength < n4) {
                    this.coordsLength = n4;
                    this.coordsList = new float[n4];
                }
                n3 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    this.coordsList[n3++] = byteBuffer.getFloat();
                    this.coordsList[n3++] = byteBuffer.getFloat();
                    this.coordsList[n3++] = byteBuffer.getFloat();
                }
            } else if (n6 == 16704) {
                obj.is4140TexCoords = true;
                n5 = byteBuffer.getShort() & 0xFFFF;
                this.texsSize = n4 = n5 * 2;
                if (this.texsList == null || this.texsLength < n4) {
                    this.texsLength = n4;
                    this.texsList = new float[n4];
                }
                n3 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    this.texsList[n3++] = byteBuffer.getFloat();
                    this.texsList[n3++] = byteBuffer.getFloat();
                }
            } else if (n6 == 16736) {
                obj.isObjTransform = true;
                float[] fArray = new float[12];
                for (n4 = 0; n4 < 12; ++n4) {
                    fArray[n4] = byteBuffer.getFloat();
                }
                n4 = 0;
                double[] dArray = new double[16];
                double[] dArray2 = new double[3];
                dArray[0] = fArray[0];
                dArray[1] = fArray[3];
                dArray[2] = fArray[6];
                dArray2[0] = fArray[9];
                dArray[4] = fArray[1];
                dArray[5] = fArray[4];
                dArray[6] = fArray[7];
                dArray2[1] = fArray[10];
                dArray[8] = fArray[2];
                dArray[9] = fArray[5];
                dArray[10] = fArray[8];
                dArray2[2] = fArray[11];
                dArray[12] = 0.0;
                dArray[13] = 0.0;
                dArray[14] = 0.0;
                dArray[15] = 1.0;
                Affine affine = new Affine(dArray, MatrixType.MT_3D_4x4, 0);
                affine.append((Transform)this.rotX180);
                affine.prepend((Transform)this.rotX180);
                affine.setTx(dArray2[0]);
                affine.setTy(-dArray2[1]);
                affine.setTz(-dArray2[2]);
                obj.objPosRotScInvT3D = affine;
                float f = (float)obj.objPosRotScInvT3D.determinant();
                try {
                    obj.objPosRotScInvT3D.invert();
                }
                catch (NonInvertibleTransformException nonInvertibleTransformException) {
                    nonInvertibleTransformException.printStackTrace();
                }
                if (f < 0.0f) {
                    obj.isObjDetFlip = true;
                    Affine affine2 = new Affine();
                    affine2.appendScale(-1.0, 1.0, 1.0);
                    affine2.append((Transform)obj.objPosRotScInvT3D);
                    obj.objPosRotScInvT3D = affine2;
                }
            }
            byteBuffer.position(n8);
        }
        if (this.coordsSize > 0 && this.indsSize > 0) {
            obj.prepareShape3Ds();
        }
    }

    String getString(ByteBuffer byteBuffer) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = (char)byteBuffer.get();
        while (c != '\u0000') {
            stringBuffer.append(c);
            c = (char)byteBuffer.get();
        }
        return stringBuffer.toString();
    }

    private final class ObjShape {
        private Obj obj = null;
        private String shapeName = null;
        private String appearName = null;
        private PhongMaterial appear = null;
        boolean isDoubleSided = false;
        boolean isLineDrawMode = false;
        private int[] faceInds = null;
        private int indexCount = 0;
        private int vertexCount = 0;
        private boolean isTexCoords = false;
        private boolean isDoIndexing = false;
        private boolean isDoGenNormals = false;
        private float[] coords = null;
        private float[] normals = null;
        private float[] texCoords = null;
        private int[] coordInds = null;
        private int[] normalInds = null;
        private int[] texCoordInds = null;
        private float[] coordsOrig = null;
        private float[] normalsOrig = null;
        private float[] texCoordsOrig = null;
        private int[] coordIndsOrig = null;
        private int[] normalIndsOrig = null;
        private int[] texCoordIndsOrig = null;
        private int[] smoothIdsOrig = null;

        private ObjShape(Obj obj, String string, String string2) {
            this.obj = obj;
            this.shapeName = string;
            this.appearName = string2;
        }

        private void prepareShape3D() {
            int n;
            this.appear = (PhongMaterial)TdsModelImporterImpl.this.appearMap.get(this.appearName);
            if (this.appear == null) {
                this.appear = new PhongMaterial();
                String string = "PhongMaterial_" + appearCloneId;
                appearCloneId++;
                TdsModelImporterImpl.this.namedMaterials.put(string, this.appear);
            } else {
                this.isDoubleSided = TdsModelImporterImpl.this.appearancer.isDoubleSidedMaterial(this.appearName);
                this.isLineDrawMode = TdsModelImporterImpl.this.appearancer.isLineDrawMode(this.appearName);
            }
            this.isTexCoords = this.obj.is4140TexCoords;
            this.isDoIndexing = true;
            this.isDoGenNormals = TdsModelImporterImpl.this.tdsOpts.contains((Object)TdsImportOption.GENERATE_NORMALS) || TdsModelImporterImpl.this.smoothIdsSize == 0;
            this.prepare();
            int n2 = 0;
            int n3 = this.coordsOrig.length / 3;
            for (n = 0; n < n3; ++n) {
                if (this.coordsOrig[++n2] != 0.0f) {
                    this.coordsOrig[n2] = -this.coordsOrig[n2];
                }
                if (this.coordsOrig[++n2] != 0.0f) {
                    this.coordsOrig[n2] = -this.coordsOrig[n2];
                }
                ++n2;
            }
            if (this.isTexCoords) {
                n3 = this.texCoordsOrig.length;
                for (n = 1; n < n3; n += 2) {
                    this.texCoordsOrig[n] = 1.0f - this.texCoordsOrig[n];
                }
            }
        }

        private MeshView createShape3D(String string, boolean bl) {
            String string2 = this.shapeName;
            if (string != null) {
                string2 = this.shapeName + string;
            }
            MeshView meshView = new MeshView();
            meshView.setId(string2);
            TdsModelImporterImpl.this.namedNodes.put(string2, meshView);
            if (this.isDoubleSided) {
                meshView.setCullFace(CullFace.NONE);
            }
            if (this.isLineDrawMode) {
                meshView.setDrawMode(DrawMode.LINE);
            }
            meshView.setMaterial((Material)this.appear);
            meshView.setMesh((Mesh)this.createGeometry(bl, false));
            this.clearTempArrays();
            return meshView;
        }

        private TriangleMesh createGeometry(boolean bl, boolean bl2) {
            if (this.coordIndsOrig != null) {
                this.coordInds = (int[])this.coordIndsOrig.clone();
            }
            if (this.texCoordIndsOrig != null) {
                this.texCoordInds = (int[])this.texCoordIndsOrig.clone();
            }
            if (this.coordsOrig != null) {
                this.coords = (float[])this.coordsOrig.clone();
            }
            if (this.texCoordsOrig != null) {
                this.texCoords = (float[])this.texCoordsOrig.clone();
            }
            if (bl) {
                this.reverseFaces(false);
            }
            if (bl2 && !TdsModelImporterImpl.this.tdsOpts.contains((Object)TdsImportOption.REVERSE_GEOMETRY) || !bl2 && TdsModelImporterImpl.this.tdsOpts.contains((Object)TdsImportOption.REVERSE_GEOMETRY)) {
                this.reverseFaces(true);
            }
            TriangleMesh triangleMesh = new TriangleMesh();
            triangleMesh.getPoints().addAll(this.coords);
            triangleMesh.getTexCoords().addAll(this.texCoords);
            int[] nArray = new int[this.indexCount * 2];
            int n = 0;
            if (this.isTexCoords) {
                for (int i = 0; i < this.indexCount; ++i) {
                    nArray[n++] = this.coordInds[i];
                    nArray[n++] = this.texCoordInds[i];
                }
            } else {
                for (int i = 0; i < this.indexCount; ++i) {
                    nArray[n++] = this.coordInds[i];
                    nArray[n++] = 0;
                }
            }
            triangleMesh.getFaces().addAll(nArray);
            triangleMesh.getFaceSmoothingGroups().addAll(this.smoothIdsOrig);
            return triangleMesh;
        }

        private void prepare() {
            int n;
            Normalizer.Triplef[] triplefArray;
            Object object;
            Object object2;
            int n2;
            int n3 = this.faceInds.length;
            this.indexCount = n3 * 3;
            if (this.isDoIndexing) {
                this.coordIndsOrig = new int[this.indexCount];
                if (this.isDoGenNormals) {
                    this.normalIndsOrig = new int[this.indexCount];
                }
                if (this.isTexCoords) {
                    this.texCoordIndsOrig = new int[this.indexCount];
                }
            }
            float[] fArray = null;
            int n4 = 0;
            int n5 = 0;
            if (this.isDoIndexing || this.isDoGenNormals) {
                for (n2 = 0; n2 < n3; ++n2) {
                    n5 = this.faceInds[n2] * 3;
                    this.coordIndsOrig[n4++] = TdsModelImporterImpl.this.coordIndsList[n5];
                    this.coordIndsOrig[n4++] = TdsModelImporterImpl.this.coordIndsList[n5 + 1];
                    this.coordIndsOrig[n4++] = TdsModelImporterImpl.this.coordIndsList[n5 + 2];
                }
                this.coordsOrig = TdsModelImporterImpl.this.indexer.createRFTriplesAndInds(TdsModelImporterImpl.this.coordsList, TdsModelImporterImpl.this.coordsSize, this.coordIndsOrig);
                if (this.isDoIndexing) {
                    this.vertexCount = this.coordsOrig.length / 3;
                }
                if (this.isDoGenNormals) {
                    fArray = this.coordsOrig;
                }
            }
            n4 = 0;
            if (this.isDoGenNormals) {
                int[] nArray = this.coordIndsOrig;
                object2 = new int[fArray.length / 3];
                object = TdsModelImporterImpl.this.normalizer.calcTriangleNormals(fArray, nArray, (int[])object2);
                int[][] nArray2 = TdsModelImporterImpl.this.normalizer.vertexIndices(nArray, (int[])object2);
                boolean bl = this.isDoIndexing;
                triplefArray = TdsModelImporterImpl.this.normalizer.calcIndexedVertexNormals(TdsModelImporterImpl.this.creaseAngle, bl, (float[])object, nArray, nArray2, this.normalIndsOrig);
                n = triplefArray.length;
                Normalizer.Triplef triplef = null;
                int n6 = 0;
                if (this.isDoIndexing) {
                    this.normalsOrig = new float[n * 3];
                    this.vertexCount = Math.max(this.vertexCount, this.normalsOrig.length / 3);
                    for (int i = 0; i < n; ++i) {
                        triplef = triplefArray[i];
                        this.normalsOrig[n6++] = triplef.x;
                        this.normalsOrig[n6++] = triplef.y;
                        this.normalsOrig[n6++] = triplef.z;
                    }
                }
            }
            this.smoothIdsOrig = new int[n3];
            n2 = -1;
            if (!this.isDoGenNormals) {
                int n7 = 0;
                for (int i = 0; i < n3; ++i) {
                    this.smoothIdsOrig[n7++] = TdsModelImporterImpl.this.smoothIdsList[this.faceInds[i]];
                }
            } else {
                object2 = TdsModelImporterImpl.this.smoother.create(this.coordIndsOrig, this.coordsOrig.length / 3, this.normalIndsOrig);
                object = null;
                int n8 = 0;
                Iterator iterator = ((ArrayList)object2).iterator();
                while (iterator.hasNext()) {
                    triplefArray = (Normalizer.Triplef[])iterator.next();
                    object = triplefArray.getIndices();
                    n8 = triplefArray.getSmGrId();
                    int n9 = ((ArrayList)object).size();
                    for (n = 0; n < n9; n += 3) {
                        this.smoothIdsOrig[((Integer)((ArrayList)object).get((int)n)).intValue() / 3] = n8;
                    }
                    triplefArray.close();
                    if (n8 <= n2) continue;
                    n2 = n8;
                }
                ((ArrayList)object2).clear();
                TdsModelImporterImpl.this.smoother.clear();
            }
            if (this.isTexCoords) {
                n4 = 0;
                if (this.isDoIndexing) {
                    for (int i = 0; i < n3; ++i) {
                        n5 = this.faceInds[i] * 3;
                        this.texCoordIndsOrig[n4++] = TdsModelImporterImpl.this.coordIndsList[n5];
                        this.texCoordIndsOrig[n4++] = TdsModelImporterImpl.this.coordIndsList[n5 + 1];
                        this.texCoordIndsOrig[n4++] = TdsModelImporterImpl.this.coordIndsList[n5 + 2];
                    }
                    this.texCoordsOrig = TdsModelImporterImpl.this.indexer.createRFTuplesAndInds(TdsModelImporterImpl.this.texsList, TdsModelImporterImpl.this.texsSize, this.texCoordIndsOrig);
                    this.vertexCount = Math.max(this.vertexCount, this.texCoordsOrig.length / 2);
                }
            } else {
                this.texCoordsOrig = new float[2];
                this.texCoordsOrig[0] = 0.0f;
                this.texCoordsOrig[1] = 0.0f;
            }
        }

        private void reverseFaces(boolean bl) {
            int n = 3;
            if (this.isDoIndexing) {
                int n2;
                int n3 = this.coordInds.length;
                int n4 = -1;
                int n5 = n - 1;
                for (n2 = 0; n2 < n3; n2 += n) {
                    n4 = this.coordInds[n2 + n5];
                    this.coordInds[n2 + n5] = this.coordInds[n2 + 1];
                    this.coordInds[n2 + 1] = n4;
                }
                if (this.isTexCoords) {
                    for (n2 = 0; n2 < n3; n2 += n) {
                        n4 = this.texCoordInds[n2 + n5];
                        this.texCoordInds[n2 + n5] = this.texCoordInds[n2 + 1];
                        this.texCoordInds[n2 + 1] = n4;
                    }
                }
            }
        }

        private void clearTempArrays() {
            this.coords = null;
            this.normals = null;
            this.texCoords = null;
            this.coordInds = null;
            this.normalInds = null;
            this.texCoordInds = null;
        }

        private void clear() {
            this.faceInds = null;
            this.appear = null;
            this.coords = null;
            this.normals = null;
            this.texCoords = null;
            this.coordsOrig = null;
            this.normalsOrig = null;
            this.texCoordsOrig = null;
            this.coordInds = null;
            this.normalInds = null;
            this.texCoordInds = null;
            this.coordIndsOrig = null;
            this.normalIndsOrig = null;
            this.texCoordIndsOrig = null;
        }

        static /* synthetic */ int[] access$1602(ObjShape objShape, int[] nArray) {
            objShape.faceInds = nArray;
            return nArray;
        }
    }

    private final class Obj {
        private String objName = null;
        private Obj parentObj = null;
        private Obj instMasterObj = null;
        private boolean isInstanceMaster = false;
        private boolean isInstance = false;
        private int nextInstanceId = 1;
        private int hierarchyPosition = -1;
        private int hierarchyParent = -1;
        private boolean isObjTransform = false;
        private Affine objPosRotScInvT3D = null;
        private boolean isObjDetFlip = false;
        private boolean isFrameTransform = false;
        private Affine framePosRotScT3D = null;
        private boolean isFramePivot = false;
        private Affine framePivoInvT3D = null;
        private boolean isFrameDetFlip = false;
        private boolean isRoot = true;
        private ArrayList<Obj> children = null;
        private boolean is4140TexCoords = false;
        private ArrayList<ObjShape> objShapes = new ArrayList();
        private MeshView[] masterMeshViews = null;

        private Obj(String string) {
            this.objName = string;
        }

        private Obj createInstance(String string) {
            int n = this.nextInstanceId++;
            if (string == null) {
                string = this.objName + "_I" + n;
            }
            Obj obj = new Obj(string);
            obj.isInstance = true;
            obj.instMasterObj = this;
            obj.isObjTransform = this.isObjTransform;
            if (obj.isObjTransform) {
                obj.objPosRotScInvT3D = new Affine((Transform)this.objPosRotScInvT3D);
            }
            obj.isObjDetFlip = this.isObjDetFlip;
            this.isInstanceMaster = true;
            this.isInstance = true;
            return obj;
        }

        private boolean isRoot() {
            return this.isRoot;
        }

        private int getHierarchyParent() {
            return this.hierarchyParent;
        }

        private void setHierarchyParent(int n) {
            this.isRoot = n <= -1;
            this.hierarchyParent = n;
        }

        private void prepareShape3Ds() {
            if (this.objShapes.isEmpty()) {
                return;
            }
            for (ObjShape objShape : this.objShapes) {
                objShape.prepareShape3D();
            }
        }

        private Group getObjGroup() {
            String string;
            boolean bl;
            boolean bl2 = this.children != null && !this.children.isEmpty();
            boolean bl3 = !this.objShapes.isEmpty();
            boolean bl4 = bl = !bl2 && (bl3 || this.isInstance);
            if (!(bl2 || bl3 || this.isInstance)) {
                return null;
            }
            Group group = new Group();
            Affine affine = new Affine();
            if (this.isRoot()) {
                affine = new Affine((Transform)TdsModelImporterImpl.this.maxToFX);
            }
            if (this.isFrameTransform) {
                affine.append((Transform)this.framePosRotScT3D);
            }
            Affine affine2 = new Affine();
            if (this.isObjTransform && this.isFrameTransform) {
                if (this.isFramePivot) {
                    affine2.append((Transform)this.framePivoInvT3D);
                    affine2.append((Transform)this.objPosRotScInvT3D);
                } else {
                    affine2 = this.objPosRotScInvT3D;
                }
            }
            Group group2 = null;
            if (bl) {
                group2 = group;
                if (!affine2.isIdentity()) {
                    affine.append((Transform)affine2);
                }
            } else if (!bl2 || bl3 || this.isInstance) {
                string = this.objName + "_Transform";
                group2 = new Group();
                group2.setId(string);
                group2.getTransforms().add((Object)affine2);
                TdsModelImporterImpl.this.namedNodes.put(string, group2);
                group.getChildren().add((Object)group2);
            }
            if (bl2) {
                for (int i = 0; i < this.children.size(); ++i) {
                    Group group3 = this.children.get(i).getObjGroup();
                    if (group3 == null) continue;
                    group.getChildren().add((Object)group3);
                }
            }
            if (bl3 || this.isInstance) {
                int n = 1;
                if (this.isFrameDetFlip) {
                    n = -1;
                }
                int n2 = this.compoundFlipDet(n);
                if (this.isInstance) {
                    int n3;
                    int n4;
                    int n5 = -1;
                    if (this.isInstanceMaster) {
                        if (!this.objShapes.isEmpty()) {
                            n4 = this.objShapes.size();
                            this.masterMeshViews = new MeshView[n4];
                            for (n3 = 0; n3 < n4; ++n3) {
                                ObjShape objShape = this.objShapes.get(n3);
                                this.masterMeshViews[n3] = objShape.createShape3D(null, false);
                            }
                        }
                        this.nextInstanceId = 0;
                        n5 = this.nextInstanceId++;
                    } else {
                        n5 = this.instMasterObj.nextInstanceId++;
                    }
                    if (n2 < 0) {
                        ArrayList<ObjShape> arrayList = null;
                        arrayList = this.isInstanceMaster ? this.objShapes : this.instMasterObj.objShapes;
                        for (ObjShape objShape : arrayList) {
                            group2.getChildren().add((Object)objShape.createShape3D(new String("_I" + n5), true));
                        }
                    } else if (this.isInstanceMaster) {
                        int n6 = n4 = this.masterMeshViews != null ? this.masterMeshViews.length : 0;
                        if (n4 > 0) {
                            group2.getChildren().addAll((Object[])this.masterMeshViews);
                        }
                    } else {
                        MeshView[] meshViewArray = this.instMasterObj.masterMeshViews;
                        n3 = meshViewArray != null ? meshViewArray.length : 0;
                        for (int i = 0; i < n3; ++i) {
                            MeshView meshView = new MeshView();
                            MeshView meshView2 = meshViewArray[i];
                            meshView.setMaterial(meshView2.getMaterial());
                            meshView.setMesh(meshView2.getMesh());
                            group2.getChildren().add((Object)meshView);
                        }
                    }
                } else if (bl3) {
                    for (ObjShape objShape : this.objShapes) {
                        group2.getChildren().add((Object)objShape.createShape3D(null, n2 < 0));
                    }
                }
            }
            if (group.getChildren().size() < 1) {
                return null;
            }
            string = null;
            string = this.isRoot() ? this.objName + "_Root" : (bl ? this.objName + "_Transform" : this.objName + "_Branch");
            group.setId(string);
            group.getTransforms().add((Object)affine);
            TdsModelImporterImpl.this.namedNodes.put(string, group);
            return group;
        }

        private void addchild(Obj obj) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            obj.parentObj = this;
            this.children.add(obj);
        }

        private int compoundFlipDet(int n) {
            int n2 = n;
            Obj obj = this.parentObj;
            while (obj != null) {
                n2 = obj.isFrameDetFlip ? (n2 *= -1) : (n2 *= 1);
                obj = obj.parentObj;
            }
            return n2;
        }

        private void clearTopDown() {
            if (!this.objShapes.isEmpty()) {
                for (ObjShape object : this.objShapes) {
                    object.clear();
                }
                this.objShapes.clear();
            }
            this.objShapes = null;
            if (this.children != null && !this.children.isEmpty()) {
                for (Obj obj : this.children) {
                    obj.clearTopDown();
                }
                this.children.clear();
            }
            this.children = null;
            this.parentObj = null;
            this.instMasterObj = null;
            this.masterMeshViews = null;
        }
    }

    static final class BaseURL {
        String protocol = null;
        String host = null;
        int port = -1;
        String path = null;

        BaseURL() {
        }

        public String toString() {
            return "protocol = " + this.protocol + ", host = " + this.host + ", port = " + this.port + ", path = " + this.path;
        }
    }
}

