/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.image;

import com.sun.media.jai.codec.SeekableStream;
import java.io.IOException;

final class TifArrayStream
extends SeekableStream {
    private byte[] buffer = null;
    private int limit = -1;
    private long streamPos = 0L;

    TifArrayStream() {
    }

    void setup(byte[] byArray, int n) {
        this.buffer = byArray;
        this.limit = n;
        this.streamPos = 0L;
        this.markPos = 0L;
    }

    void clear() {
        this.buffer = null;
    }

    public final void close() throws IOException {
        this.clear();
        super.close();
    }

    public int available() throws IOException {
        int n = this.limit - (int)this.streamPos;
        return n;
    }

    public boolean canSeekBackwards() {
        return true;
    }

    public boolean markSupported() {
        return true;
    }

    public long getFilePointer() throws IOException {
        return this.streamPos;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IOException("pos < 0");
        }
        if (l >= (long)this.limit) {
            throw new IOException("(pos >= buffer.limit())");
        }
        this.streamPos = l;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return l;
        }
        long l2 = (long)this.limit - this.streamPos;
        if (l > l2) {
            l = l2;
        }
        this.streamPos += l;
        return l;
    }

    public int skipBytes(int n) throws IOException {
        return (int)this.skip(n);
    }

    public int read() throws IOException {
        if (this.streamPos < (long)this.limit) {
            return this.buffer[(int)this.streamPos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b == null");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("((off < 0) || (len < 0) || (off + len > b.length)) b.length/off/len=)" + byArray.length + "/" + n + "/" + n2);
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.streamPos >= (long)this.limit) {
            return -1;
        }
        int n3 = (int)this.streamPos;
        if (n2 > this.limit - n3) {
            n2 = this.limit - n3;
        }
        int n4 = n + n2;
        for (int i = n; i < n4; ++i) {
            byArray[i] = this.buffer[n3++];
        }
        this.streamPos = n3;
        return n2;
    }
}

