/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.AssetParser;
import com.interactivemesh.jfx.importer.col.BindMaterialParser;
import com.interactivemesh.jfx.importer.col.COLLADA;
import com.interactivemesh.jfx.importer.col.COLLADAParser;
import com.interactivemesh.jfx.importer.col.CVersion;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ImageC;
import com.interactivemesh.jfx.importer.col.ImageCParser;
import com.interactivemesh.jfx.importer.col.InstanceBindMaterial;
import com.interactivemesh.jfx.importer.col.NewSetParamParser;
import com.interactivemesh.jfx.importer.col.NullParser;
import com.interactivemesh.jfx.importer.col.ParamFX;
import com.interactivemesh.jfx.importer.col.Sampler;
import com.interactivemesh.jfx.importer.col.SamplerParser;
import com.interactivemesh.jfx.importer.col.Scope;
import com.interactivemesh.jfx.importer.col.Source;
import com.interactivemesh.jfx.importer.col.SourceParser;
import com.interactivemesh.jfx.importer.col.Surface;
import com.interactivemesh.jfx.importer.col.SurfaceParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class ColladaFileParser {
    XMLStreamReader xR = null;
    final CVersion cVersion;
    final ElementBase base;
    final Scope scope;
    CVersion currFileVersion = CVersion.ONE_FOUR_ONE;
    private AbstractElementParser currElementParser = null;
    private final COLLADAParser colladaParser;
    private final AssetParser assetParser;
    private final BindMaterialParser bindMaterialParser;
    private final ImageCParser imageCParser;
    private final NewSetParamParser nsparamParser;
    private final SamplerParser samplerParser;
    private final SourceParser sourceParser;
    private final SurfaceParser surfaceParser;
    private final NullParser nullParser;
    private final XMLInputFactory xmlif;

    ColladaFileParser(ElementBase elementBase, Scope scope, CVersion cVersion) {
        this.cVersion = cVersion;
        this.base = elementBase;
        this.scope = scope;
        this.colladaParser = new COLLADAParser(this);
        this.assetParser = new AssetParser(this);
        this.bindMaterialParser = new BindMaterialParser(this);
        this.imageCParser = new ImageCParser(this);
        this.nsparamParser = new NewSetParamParser(this);
        this.samplerParser = new SamplerParser(this);
        this.sourceParser = new SourceParser(this);
        this.surfaceParser = new SurfaceParser(this);
        this.nullParser = new NullParser(this);
        try {
            this.xmlif = XMLInputFactory.newInstance();
            this.xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
            this.xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            this.xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            throw new ImportException("TODO", factoryConfigurationError);
        }
    }

    void clear() {
        this.xR = null;
        this.currFileVersion = CVersion.ONE_FOUR_ONE;
    }

    void close() {
        this.clear();
        this.colladaParser.close();
        this.assetParser.close();
        this.imageCParser.close();
        this.nsparamParser.close();
        this.bindMaterialParser.close();
        this.samplerParser.close();
        this.sourceParser.close();
        this.surfaceParser.close();
        this.nullParser.close();
    }

    COLLADA parse(InputStream inputStream) {
        this.clear();
        boolean bl = false;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
        try {
            this.xR = this.xmlif.createXMLStreamReader(inputStreamReader);
            COLLADA cOLLADA = new COLLADA();
            this.colladaParser.setup(cOLLADA);
            this.currElementParser = this.colladaParser;
            int n = -1;
            while (this.xR.hasNext()) {
                n = this.xR.next();
                if (n == 1) {
                    this.currElementParser.startElement(this.xR.getLocalName());
                    continue;
                }
                if (n == 4) {
                    this.currElementParser.characters();
                    continue;
                }
                if (n == 2) {
                    this.currElementParser.endElement(this.xR.getLocalName());
                    continue;
                }
                if (n != 8) continue;
                this.xR.close();
            }
            inputStreamReader.close();
            bl = true;
            COLLADA cOLLADA2 = cOLLADA;
            return cOLLADA2;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ImportException("Reading COLLADA file failed : \n" + xMLStreamException.getMessage(), xMLStreamException);
        }
        catch (ImportException importException) {
            throw importException;
        }
        catch (Exception exception) {
            throw new ImportException("Reading COLLADA file failed : \n" + exception.getMessage(), exception);
        }
        finally {
            if (!bl) {
                try {
                    this.xR.close();
                    inputStreamReader.close();
                }
                catch (Exception exception) {
                    throw new ImportException("Can't close COLLADA reader !");
                }
            }
        }
    }

    void setParser(AbstractElementParser abstractElementParser) {
        this.currElementParser = abstractElementParser;
    }

    void setAssetParser(AbstractElementParser abstractElementParser, Asset asset) {
        this.assetParser.setup(abstractElementParser, asset);
        this.currElementParser = this.assetParser;
    }

    void setBindMaterialParser(AbstractElementParser abstractElementParser, InstanceBindMaterial instanceBindMaterial) {
        this.bindMaterialParser.setup(abstractElementParser, instanceBindMaterial);
        this.currElementParser = this.bindMaterialParser;
    }

    void setImageParser(AbstractElementParser abstractElementParser, ImageC imageC) {
        this.imageCParser.setup(abstractElementParser, imageC);
        this.currElementParser = this.imageCParser;
    }

    void setNSParamParser(AbstractElementParser abstractElementParser, ParamFX paramFX) {
        this.nsparamParser.setup(abstractElementParser, paramFX);
        this.currElementParser = this.nsparamParser;
    }

    void setSamplerParser(AbstractElementParser abstractElementParser, Sampler sampler) {
        this.samplerParser.setup(abstractElementParser, sampler);
        this.currElementParser = this.samplerParser;
    }

    void setSourceParser(AbstractElementParser abstractElementParser, Source source) {
        this.sourceParser.setup(abstractElementParser, source);
        this.currElementParser = this.sourceParser;
    }

    void setSurfaceParser(AbstractElementParser abstractElementParser, Surface surface) {
        this.surfaceParser.setup(abstractElementParser, surface);
        this.currElementParser = this.surfaceParser;
    }

    void setNullParser(AbstractElementParser abstractElementParser, String string) {
        this.nullParser.setup(abstractElementParser, string);
        this.currElementParser = this.nullParser;
    }
}

