/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.image.ImageFactory;
import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.col.CIndexer;
import com.interactivemesh.jfx.importer.col.CMeshSmoother;
import com.interactivemesh.jfx.importer.col.CNormalizer;
import com.interactivemesh.jfx.importer.col.CUtils;
import com.interactivemesh.jfx.importer.col.ColAsset;
import com.interactivemesh.jfx.importer.col.ZaeCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.scene.Camera;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.paint.PhongMaterial;

final class ElementBase {
    ColAsset.UpAxis upAxis = ColAsset.UpAxis.Y_UP;
    boolean isGenerateNormals = false;
    boolean isReverse = false;
    boolean isReverseTransparence = false;
    boolean isWritableImage = false;
    boolean isIgnoreCameras = false;
    ZaeCache zaeCache = null;
    double creaseAngle = (float)Math.toRadians(45.0);
    final CUtils cUtils;
    final CIndexer indexer;
    final CNormalizer normalizer;
    final CMeshSmoother smoother;
    final ImageFactory imgFactory;
    private final HashMap<String, Node> namedNodes = new HashMap();
    private final HashMap<String, PhongMaterial> namedMaterials = new HashMap();
    private final ArrayList<Viewpoint> viewpointList = new ArrayList();
    private final ArrayList<Node> camLightList = new ArrayList();
    private long nameExt = 1L;
    private final HashSet<String> uniqueNames = new HashSet(100);

    ElementBase(CUtils cUtils) {
        this.cUtils = cUtils;
        this.indexer = new CIndexer();
        this.normalizer = new CNormalizer();
        this.smoother = new CMeshSmoother();
        this.imgFactory = new ImageFactory();
    }

    String createUniqueName(String string) {
        if (string == null || string.length() < 1) {
            return null;
        }
        boolean bl = this.uniqueNames.contains(string);
        if (bl) {
            String string2 = null;
            while (bl) {
                string2 = string + "_" + this.nameExt;
                ++this.nameExt;
                bl = this.uniqueNames.contains(string2);
            }
            this.uniqueNames.add(string2);
            return string2;
        }
        this.uniqueNames.add(string);
        return string;
    }

    void putNamedNode(String string, Node node) {
        if (string == null || node == null) {
            System.out.println("ElementBase name / node = " + string + " / " + node);
        } else {
            this.namedNodes.put(string, node);
        }
    }

    Map<String, Node> getNamedNodes() {
        HashMap<String, Node> hashMap = null;
        int n = 0;
        if (this.namedNodes != null && (n = this.namedNodes.size()) > 0) {
            hashMap = new HashMap<String, Node>(n, 1.0f);
            Set<Map.Entry<String, Node>> set = this.namedNodes.entrySet();
            Iterator<Map.Entry<String, Node>> iterator = set.iterator();
            Map.Entry<String, Node> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    void putNamedMaterial(String string, PhongMaterial phongMaterial) {
        if (string == null || phongMaterial == null) {
            System.out.println("ElementCache name / material = " + string + " / " + phongMaterial);
        } else {
            this.namedMaterials.put(string, phongMaterial);
        }
    }

    Map<String, PhongMaterial> getNamedMaterials() {
        HashMap<String, PhongMaterial> hashMap = null;
        int n = 0;
        if (this.namedMaterials != null && (n = this.namedMaterials.size()) > 0) {
            hashMap = new HashMap<String, PhongMaterial>(n, 1.0f);
            Set<Map.Entry<String, PhongMaterial>> set = this.namedMaterials.entrySet();
            Iterator<Map.Entry<String, PhongMaterial>> iterator = set.iterator();
            Map.Entry<String, PhongMaterial> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                hashMap.put(entry.getKey(), entry.getValue());
            }
        }
        return hashMap;
    }

    void addViewpoint(Viewpoint viewpoint) {
        this.viewpointList.add(viewpoint);
    }

    Viewpoint[] getViewpoints() {
        Viewpoint[] viewpointArray = null;
        if (!this.viewpointList.isEmpty()) {
            viewpointArray = new Viewpoint[this.viewpointList.size()];
            int n = 0;
            for (Viewpoint viewpoint : this.viewpointList) {
                viewpointArray[n++] = viewpoint;
            }
        }
        return viewpointArray;
    }

    void addCamera(Camera camera) {
        this.camLightList.add((Node)camera);
    }

    void addLight(LightBase lightBase) {
        this.camLightList.add((Node)lightBase);
    }

    Node[] getCamLights() {
        Node[] nodeArray = null;
        if (!this.camLightList.isEmpty()) {
            nodeArray = new Node[this.camLightList.size()];
            this.camLightList.toArray(nodeArray);
        }
        return nodeArray;
    }

    void clear() {
        this.upAxis = ColAsset.UpAxis.Y_UP;
        this.isGenerateNormals = false;
        this.isReverse = false;
        this.isReverseTransparence = false;
        this.isWritableImage = false;
        this.isIgnoreCameras = false;
        if (this.zaeCache != null) {
            this.zaeCache.clearClose();
            this.zaeCache = null;
        }
        this.creaseAngle = (float)Math.toRadians(44.0);
        this.namedNodes.clear();
        this.namedMaterials.clear();
        this.viewpointList.clear();
        this.camLightList.clear();
        this.nameExt = 1L;
        this.uniqueNames.clear();
    }

    void close() {
        if (this.imgFactory != null) {
            this.imgFactory.close();
        }
    }
}

