/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractIdElement;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.ElementBase;
import com.interactivemesh.jfx.importer.col.ElementCache;
import com.interactivemesh.jfx.importer.col.Mesh;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.scene.shape.TriangleMesh;

final class Geometry
extends AbstractIdElement {
    String name = null;
    private GeomType geomType = null;
    private int instanceGeomNameExt = 0;
    Asset asset = null;
    Mesh mesh = null;

    Geometry() {
    }

    @Override
    void initialize(ElementBase elementBase, ElementCache elementCache) {
        super.initialize(elementBase, elementCache);
        if (this.id != null) {
            elementCache.putGeometry(this.id, this);
        }
        if (this.name == null || this.name.length() < 1) {
            this.name = this.id != null && this.id.length() > 0 ? this.id : "Geometry";
        }
        this.name = elementBase.createUniqueName(this.name);
        if (this.asset != null) {
            this.asset.initialize(elementBase, elementCache);
        }
        if (this.mesh != null) {
            this.geomType = GeomType.MESH;
            this.mesh.initialize(elementBase, elementCache);
            this.mesh.geomName = this.name;
        } else {
            System.out.println("Geometry : No geometry data !");
        }
    }

    @Override
    void clear() {
        if (this.mesh == null) {
            this.mesh.clear();
            this.mesh = null;
        }
        super.clear();
    }

    GeomType getGeomType() {
        return this.geomType;
    }

    String getGeomName() {
        return this.name;
    }

    String getGeomInstanceName() {
        String string = this.name;
        if (this.instanceGeomNameExt > 0) {
            string = this.name + "-" + this.instanceGeomNameExt;
        }
        ++this.instanceGeomNameExt;
        return string;
    }

    Object[] getMorpGeometry(HashMap<String, int[]> hashMap) {
        if (this.mesh != null) {
            return this.mesh.getMorpGeometry(hashMap);
        }
        System.out.println("Geometry getMorpGeometry  No mesh !!");
        return null;
    }

    HashMap<String, ArrayList<TriangleMesh>> getQuadTriaGeometries(String string, HashMap<String, int[]> hashMap) {
        if (this.mesh != null) {
            return this.mesh.getQuadTriaGeometries(string, hashMap);
        }
        return null;
    }

    static enum GeomType {
        BREP,
        CONVEXMESH,
        MESH,
        SPLINE;

    }
}

