/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.col.AbstractElementParser;
import com.interactivemesh.jfx.importer.col.Asset;
import com.interactivemesh.jfx.importer.col.COLLADAParser;
import com.interactivemesh.jfx.importer.col.LibVisualScenes;
import com.interactivemesh.jfx.importer.col.NodeC;
import com.interactivemesh.jfx.importer.col.NodeCParser;
import com.interactivemesh.jfx.importer.col.VisualScene;

final class LibVisualScenesParser
extends AbstractElementParser {
    private COLLADAParser colladaParser = null;
    private LibVisualScenes libVisScenes = null;
    private VisualScene currVisScene = null;
    private boolean isVisualScene = false;
    private NodeCParser nodeParser = null;

    LibVisualScenesParser(COLLADAParser cOLLADAParser, LibVisualScenes libVisualScenes) {
        super(cOLLADAParser.cfp);
        this.colladaParser = cOLLADAParser;
        this.libVisScenes = libVisualScenes;
        this.nodeParser = new NodeCParser(this, false);
    }

    void setup(LibVisualScenes libVisualScenes) {
        this.libVisScenes = libVisualScenes;
    }

    @Override
    void doClose() {
        this.colladaParser = null;
        this.nodeParser.close();
        this.nodeParser = null;
    }

    @Override
    void startElement(String string) {
        if (this.isVisualScene) {
            if (string.equals("node")) {
                NodeC nodeC = new NodeC(false, false);
                nodeC.id = this.cfp.xR.getAttributeValue(null, "id");
                nodeC.name = this.cfp.xR.getAttributeValue(null, "name");
                nodeC.sid = this.cfp.xR.getAttributeValue(null, "sid");
                String string2 = this.cfp.xR.getAttributeValue(null, "type");
                if (string2 != null) {
                    nodeC.type = string2;
                }
                if ((string2 = this.cfp.xR.getAttributeValue(null, "layer")) != null) {
                    nodeC.layerList = this.cUtils().splitString(string2);
                }
                this.currVisScene.addNode(nodeC);
                this.nodeParser.setupForTopNode(nodeC);
                this.cfp.setParser(this.nodeParser);
            } else if (string.equals("evaluate_scene")) {
                this.cfp.setNullParser(this, string);
            } else if (string.equals("asset")) {
                Asset asset;
                this.libVisScenes.asset = asset = new Asset();
                this.cfp.setAssetParser(this, asset);
            } else if (string.equals("extra")) {
                this.cfp.setNullParser(this, string);
            }
        } else if (string.equals("visual_scene")) {
            this.currVisScene = new VisualScene();
            this.currVisScene.id = this.cfp.xR.getAttributeValue(null, "id");
            this.currVisScene.name = this.cfp.xR.getAttributeValue(null, "name");
            this.libVisScenes.addVisualScene(this.currVisScene);
            this.isVisualScene = true;
        } else if (string.equals("asset")) {
            Asset asset;
            this.libVisScenes.asset = asset = new Asset();
            this.cfp.setAssetParser(this, asset);
        } else if (string.equals("extra")) {
            this.cfp.setNullParser(this, string);
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("visual_scene")) {
            this.currVisScene = null;
            this.isVisualScene = false;
        } else if (string.equals("library_visual_scenes")) {
            this.cfp.setParser(this.colladaParser);
            this.libVisScenes = null;
        }
    }
}

