/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.col.SID;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

final class TransformC
implements SID {
    private static final Affine ROTX180 = new Affine();
    private final Type type;
    private final String sid;
    private double[] values = null;

    TransformC(Type type, String string) {
        this.type = type;
        this.sid = string;
    }

    @Override
    public String getSID() {
        return this.sid;
    }

    int valueLength() {
        return this.type.length;
    }

    void setValues(float[] fArray) {
        if (fArray != null && fArray.length == this.type.length) {
            this.values = new double[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                this.values[i] = fArray[i];
            }
        }
    }

    Transform getTransform(boolean bl) {
        Affine affine = null;
        switch (this.type) {
            case LOOKAT: {
                if (this.values == null) break;
                Point3D point3D = new Point3D(this.values[3] - this.values[0], this.values[4] - this.values[1], this.values[5] - this.values[2]).normalize();
                Point3D point3D2 = new Point3D(this.values[6], this.values[7], this.values[8]).normalize();
                Point3D point3D3 = point3D.crossProduct(point3D2).normalize();
                point3D2 = point3D3.crossProduct(point3D).normalize();
                Affine affine2 = new Affine();
                affine2.setMxx(point3D3.getX());
                affine2.setMxy(point3D3.getY());
                affine2.setMxz(point3D3.getZ());
                affine2.setMyx(point3D2.getX());
                affine2.setMyy(point3D2.getY());
                affine2.setMyz(point3D2.getZ());
                affine2.setMzx(-point3D.getX());
                affine2.setMzy(-point3D.getY());
                affine2.setMzz(-point3D.getZ());
                affine2.setTx(0.0);
                affine2.setTy(0.0);
                affine2.setTz(0.0);
                affine2.append((Transform)ROTX180);
                affine2.prepend((Transform)ROTX180);
                Translate translate = new Translate(-this.values[0], this.values[1], this.values[2]);
                affine2.append((Transform)translate);
                if (bl) {
                    try {
                        affine2 = affine2.createInverse();
                    }
                    catch (NonInvertibleTransformException nonInvertibleTransformException) {
                        throw new ImportException("Inverse of LOOKAT failed !", nonInvertibleTransformException);
                    }
                }
                affine = affine2;
                break;
            }
            case MATRIX: {
                if (this.values == null) break;
                Affine affine3 = new Affine();
                affine3.setMxx(this.values[0]);
                affine3.setMxy(this.values[1]);
                affine3.setMxz(this.values[2]);
                affine3.setMyx(this.values[4]);
                affine3.setMyy(this.values[5]);
                affine3.setMyz(this.values[6]);
                affine3.setMzx(this.values[8]);
                affine3.setMzy(this.values[9]);
                affine3.setMzz(this.values[10]);
                affine3.setTx(0.0);
                affine3.setTy(0.0);
                affine3.setTz(0.0);
                affine3.append((Transform)ROTX180);
                affine3.prepend((Transform)ROTX180);
                affine3.setTx(this.values[3]);
                affine3.setTy(-this.values[7]);
                affine3.setTz(-this.values[11]);
                affine = affine3;
                break;
            }
            case ROTATE: {
                if (this.values == null) break;
                if (this.values[3] != 0.0) {
                    if (this.values[1] != 0.0) {
                        this.values[1] = -this.values[1];
                    }
                    if (this.values[2] != 0.0) {
                        this.values[2] = -this.values[2];
                    }
                } else {
                    if (this.values[1] != 0.0) {
                        this.values[1] = -this.values[1];
                    }
                    if (this.values[2] != 0.0) {
                        this.values[2] = -this.values[2];
                    }
                }
                affine = new Rotate(this.values[3], 0.0, 0.0, 0.0, new Point3D(this.values[0], this.values[1], this.values[2]));
                break;
            }
            case SCALE: {
                if (this.values == null) break;
                affine = new Scale(this.values[0], this.values[1], this.values[2], 0.0, 0.0, 0.0);
                break;
            }
            case SKEW: {
                if (this.values == null) break;
                affine = new Affine();
                break;
            }
            case TRANSLATE: {
                if (this.values == null) break;
                if (this.values[1] != 0.0) {
                    this.values[1] = -this.values[1];
                }
                if (this.values[2] != 0.0) {
                    this.values[2] = -this.values[2];
                }
                affine = new Translate(this.values[0], this.values[1], this.values[2]);
            }
        }
        return affine;
    }

    static {
        ROTX180.setMyy(-1.0);
        ROTX180.setMzz(-1.0);
    }

    static enum Type {
        LOOKAT(9),
        MATRIX(16),
        ROTATE(4),
        SCALE(3),
        SKEW(7),
        TRANSLATE(3);

        private int length = 0;

        private Type(int n2) {
            this.length = n2;
        }
    }
}

