/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.col;

import com.interactivemesh.jfx.importer.ImportException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class ZaeCache {
    private ZipFile zaeFile = null;
    private String rootDaeEntryName = null;
    private HashMap<String, ZipEntry> namedZaeEntries = null;
    private HashMap<String, byte[]> namedZaeEntryArrays = null;
    private final boolean isInJar;
    private BufferedReader bManifestReader = null;

    ZaeCache(boolean bl) {
        this.isInJar = bl;
    }

    void clearClose() {
        this.zaeFile = null;
        if (this.namedZaeEntries != null) {
            this.namedZaeEntries.clear();
            this.namedZaeEntries = null;
        }
        if (this.namedZaeEntryArrays != null) {
            this.namedZaeEntryArrays.clear();
            this.namedZaeEntryArrays = null;
        }
    }

    void setZaeFile(ZipFile zipFile) {
        this.zaeFile = zipFile;
    }

    void setRoot(String string) {
        this.rootDaeEntryName = string;
    }

    String getRootEntryBase() {
        int n = this.rootDaeEntryName.lastIndexOf(47);
        if (n > 0) {
            return this.rootDaeEntryName.substring(0, n + 1);
        }
        return null;
    }

    URL getRootUrl() {
        try {
            return new URL("file", null, -1, this.rootDaeEntryName);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    URL getUrlFor(String string) {
        try {
            return new URL("file", null, -1, string);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return null;
        }
    }

    String getEntryBaseFor(String string) {
        int n = string.lastIndexOf(47);
        if (n > 0) {
            return string.substring(0, n + 1);
        }
        return null;
    }

    HashMap<String, ZipEntry> getZaeEntryMap() {
        if (this.namedZaeEntries == null) {
            this.namedZaeEntries = new HashMap();
        }
        return this.namedZaeEntries;
    }

    HashMap<String, byte[]> getZaeEntryArrayMap() {
        if (this.namedZaeEntryArrays == null) {
            this.namedZaeEntryArrays = new HashMap();
        }
        return this.namedZaeEntryArrays;
    }

    InputStream getInputStreamForEntry(String string) {
        if (this.isInJar) {
            byte[] byArray = this.namedZaeEntryArrays.get(string);
            if (byArray != null) {
                return new ByteArrayInputStream(byArray);
            }
            throw new ImportException("ZaeCache entry array is null for >" + string + "<");
        }
        ZipEntry zipEntry = this.namedZaeEntries.get(string);
        if (zipEntry != null) {
            try {
                return this.zaeFile.getInputStream(zipEntry);
            }
            catch (IOException iOException) {
                throw new ImportException("ZaeCache InputStream failed for entry >" + string + "<", iOException);
            }
        }
        throw new ImportException("ZaeCache entry is null for >" + string + "<");
    }

    String getZaeRoot(InputStream inputStream) throws IOException {
        String string = null;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
        this.bManifestReader = new BufferedReader(inputStreamReader);
        boolean bl = true;
        while (bl) {
            String string2 = this.bManifestReader.readLine();
            if (string2 != null && string2.length() > 0) {
                int n = -1;
                n = string2.indexOf("<dae_root>");
                if (n < 0) continue;
                n += 10;
                int n2 = 0;
                n2 = string2.indexOf("</dae_root>");
                if (n2 < 0) continue;
                string = string2.substring(n, n2);
                int n3 = string.indexOf("./");
                if (n3 >= 0) {
                    string = string.substring(n3 + 2);
                }
                if ((n3 = string.indexOf(35)) > 0) {
                    string = string.substring(0, n3);
                }
                bl = false;
                continue;
            }
            bl = false;
        }
        return string;
    }

    String normalizeZaeEntry(String string, String string2) {
        int n = string2.indexOf("./");
        if (string == null) {
            if (n == 0) {
                return string2.substring(2);
            }
            return string2;
        }
        if (n == 0) {
            return new String(string + string2.substring(2));
        }
        int n2 = -1;
        int n3 = string2.lastIndexOf("../");
        int n4 = 0;
        if (n3 >= 0) {
            n4 = n3 / 3 + 1;
        }
        if (n4 == 0) {
            return new String(string + string2);
        }
        int n5 = string.length() - 2;
        n2 = string.lastIndexOf(47, n5);
        if (n2 < 0) {
            throw new ImportException("normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
        }
        --n4;
        while (n4 > 0) {
            if ((n2 = string.lastIndexOf(47, n2 - 1)) < 0) {
                throw new ImportException("normalizePath : lastBaseIndex < 0 ! \nbase = " + string + " child = " + string2);
            }
            --n4;
        }
        return new String(string.substring(0, n2 + 1) + string2.substring(n3 + 3));
    }

    void closeZaeRootReader() {
        if (this.bManifestReader != null) {
            try {
                this.bManifestReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.bManifestReader = null;
        }
    }
}

