/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.Shape3DParser;
import java.util.ArrayList;
import java.util.Collection;
import javafx.scene.Group;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Shape3D;
import javafx.scene.transform.Transform;

final class CylinderParser
extends Shape3DParser {
    private String divisions = null;
    private String height = null;
    private String radius = null;
    private Group parent = null;

    CylinderParser(FxFileParser fxFileParser) {
        super(fxFileParser);
    }

    Cylinder createCylinder() {
        double d = 2.0;
        if (this.height != null && this.height.length() > 0) {
            d = Double.parseDouble(this.height);
        }
        double d2 = 1.0;
        if (this.radius != null && this.radius.length() > 0) {
            d2 = Double.parseDouble(this.radius);
        }
        Cylinder cylinder = null;
        cylinder = this.divisions == null || this.divisions.length() < 1 ? new Cylinder(d2, d) : new Cylinder(d2, d, Integer.parseInt(this.divisions));
        this.setShape3DProperties((Shape3D)cylinder);
        if (!this.transformList.isEmpty()) {
            cylinder.getTransforms().addAll((Collection)this.transformList);
        }
        return cylinder;
    }

    void setup(AbstractElementParser abstractElementParser, Group group) {
        this.parentParser = abstractElementParser;
        this.parent = group;
        this.divisions = null;
        this.height = null;
        this.radius = null;
        this.setupShape3D();
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string = this.fxfp.xR.getAttributeValue(i);
            if (string != null && string.length() > 0) {
                String string2 = this.fxfp.xR.getAttributeLocalName(i);
                if (string2.equals("divisions")) {
                    this.divisions = string;
                    continue;
                }
                if (string2.equals("height")) {
                    this.height = string;
                    continue;
                }
                if (string2.equals("radius")) {
                    this.radius = string;
                    continue;
                }
                this.processShape3DAttributes(string2, string, i);
                continue;
            }
            throw new ImportException("CylinderParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
        }
    }

    @Override
    String getIdDefault() {
        return "Cylinder";
    }

    @Override
    void close() {
        super.close();
    }

    @Override
    void startElement(String string) {
        if (string.equals("material")) {
            super.setMaterialParser(this, null);
        } else if (string.equals("transforms")) {
            this.transformsParser = this.fxfp.setTransformsParser(this, null);
        } else {
            this.isCharacter = false;
            this.isPrimitive = false;
            if (!super.processShape3DStartElement(string)) {
                if (string.equals("divisions")) {
                    this.isCharacter = true;
                } else if (string.equals("height")) {
                    this.isCharacter = true;
                } else if (string.equals("radius")) {
                    this.isCharacter = true;
                } else if (this.processPrimitiveStartElement(string)) {
                    this.isPrimitive = true;
                } else {
                    this.fxfp.setNullParser(this, string);
                }
            }
            if (this.isCharacter) {
                this.arrPos = 0;
            }
        }
    }

    @Override
    void endElement(String string) {
        if (!string.equals(this.primTagName)) {
            if (this.isCharacter || this.isPrimitive) {
                String string2 = this.getCharOrPrimString();
                if (string2 != null) {
                    if (string.equals("divisions") && this.divisions == null) {
                        this.divisions = string2;
                    } else if (string.equals("height") && this.height == null) {
                        this.height = string2;
                    } else if (string.equals("radius") && this.radius == null) {
                        this.radius = string2;
                    } else {
                        this.processShape3DEndElement(string, string2);
                    }
                }
            } else if (string.equals("Cylinder")) {
                ArrayList<Transform> arrayList;
                if (this.transformsParser != null && !(arrayList = this.transformsParser.getTransforms()).isEmpty()) {
                    this.transformList.addAll(arrayList);
                    this.transformsParser.clearTransforms();
                    this.transformsParser = null;
                }
                if (this.parent != null) {
                    this.parent.getChildren().add((Object)this.createCylinder());
                    this.parent = null;
                }
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
            }
        }
    }
}

