/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.fxml.FxImporterImpl;
import java.util.HashMap;
import javafx.geometry.Point3D;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Transform;

final class ElementCache {
    private final HashMap<String, Color> colorMap = new HashMap(2);
    private final HashMap<String, Image> imageMap = new HashMap(4);
    private final HashMap<String, Point3D> point3DMap = new HashMap(2);
    private final HashMap<String, String> primitiveMap = new HashMap();
    private final HashMap<String, PhongMaterial> phongMaterialMap = new HashMap();
    private final HashMap<String, Transform> transformMap = new HashMap();
    private final HashMap<String, TriangleMesh> triangleMeshMap = new HashMap();
    private final FxImporterImpl.BaseURL baseUrlFxml;

    ElementCache(FxImporterImpl.BaseURL baseURL) {
        this.baseUrlFxml = baseURL;
    }

    FxImporterImpl.BaseURL getBaseURL() {
        return this.baseUrlFxml;
    }

    void clear() {
        this.colorMap.clear();
        this.imageMap.clear();
        this.phongMaterialMap.clear();
        this.transformMap.clear();
        this.triangleMeshMap.clear();
    }

    void putColor(String string, Color color) {
        this.colorMap.put(string, color);
    }

    Color getColor(String string) {
        return this.colorMap.get(string);
    }

    void putPoint3D(String string, Point3D point3D) {
        this.point3DMap.put(string, point3D);
    }

    Point3D getPoint3D(String string) {
        return this.point3DMap.get(string);
    }

    void putImage(String string, Image image) {
        this.imageMap.put(string, image);
    }

    Image getImage(String string) {
        return this.imageMap.get(string);
    }

    void putPrimitive(String string, String string2) {
        this.primitiveMap.put(string, string2);
    }

    String getPrimitive(String string) {
        return this.primitiveMap.get(string);
    }

    void putPhongMaterial(String string, PhongMaterial phongMaterial) {
        this.phongMaterialMap.put(string, phongMaterial);
    }

    PhongMaterial getPhongMaterial(String string) {
        return this.phongMaterialMap.get(string);
    }

    void putTransform(String string, Transform transform) {
        this.transformMap.put(string, transform);
    }

    Transform getTransform(String string) {
        return this.transformMap.get(string);
    }

    void putTriangleMesh(String string, TriangleMesh triangleMesh) {
        this.triangleMeshMap.put(string, triangleMesh);
    }

    TriangleMesh getTriangleMesh(String string) {
        return this.triangleMeshMap.get(string);
    }
}

