/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.fxml;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.fxml.AbstractElementParser;
import com.interactivemesh.jfx.importer.fxml.ColorParser;
import com.interactivemesh.jfx.importer.fxml.FxFileParser;
import com.interactivemesh.jfx.importer.fxml.NodeParser;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.paint.Color;

final class LightParser
extends NodeParser {
    private ColorParser colorParser = null;
    private Color colorRef = null;
    private LightBase currLight = null;
    private String tagName = null;
    private String lightOn = null;
    private String lightColor = null;
    private boolean isColor = false;

    LightParser(FxFileParser fxFileParser) {
        super(fxFileParser);
    }

    void setup(AbstractElementParser abstractElementParser, LightBase lightBase, String string) {
        this.parentParser = abstractElementParser;
        this.currLight = lightBase;
        this.tagName = string;
        this.isColor = false;
        this.lightOn = null;
        this.lightColor = null;
        this.setupNode();
        int n = this.fxfp.xR.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.fxfp.xR.getAttributeValue(i);
            if (string2 != null && string2.length() > 0) {
                String string3 = this.fxfp.xR.getAttributeLocalName(i);
                if (string3.equals("color")) {
                    this.lightColor = string2;
                    continue;
                }
                if (string3.equals("lightOn")) {
                    this.lightOn = string2;
                    continue;
                }
                this.processNodeAttributes(string3, string2, i);
                continue;
            }
            throw new ImportException("LightParser : no value for attribute = " + this.fxfp.xR.getAttributeName(i));
        }
    }

    @Override
    String getIdDefault() {
        return this.tagName;
    }

    @Override
    void close() {
        super.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        this.isCharacter = false;
        this.isPrimitive = false;
        if (this.isColor) {
            if (string.equals("Color")) {
                this.colorParser = this.fxfp.setColorParser(this);
                return;
            } else {
                if (string.equals("reference")) {
                    if (!this.fxfp.xR.getPrefix().equals("fx")) throw new ImportException("LightParser : color reference element doesn't have prefix 'fx:' !");
                    String string2 = this.fxfp.xR.getAttributeValue(null, "source");
                    if (string2 == null) throw new ImportException("LightParser : source attribute in color referernce element is null !");
                    this.colorRef = this.fxfp.currCache.getColor(string2);
                    if (this.colorRef != null) return;
                    throw new ImportException("LightParser : no color referernce found for source = >" + string2 + "< !");
                }
                this.fxfp.setNullParser(this, string);
            }
            return;
        } else if (string.equals("transforms")) {
            this.fxfp.setTransformsParser(this, (Node)this.currLight);
            return;
        } else if (string.equals("color")) {
            this.isColor = true;
            this.isCharacter = true;
            return;
        } else {
            if (!this.processNodeStartElement(string)) {
                if (string.equals("lightOn")) {
                    this.isCharacter = true;
                } else if (this.processPrimitiveStartElement(string)) {
                    this.isPrimitive = true;
                } else {
                    this.fxfp.setNullParser(this, string);
                }
            }
            if (!this.isCharacter) return;
            this.arrPos = 0;
        }
    }

    @Override
    void endElement(String string) {
        if (!string.equals(this.primTagName)) {
            if (string.equals("color")) {
                this.isColor = false;
                if (this.lightColor == null) {
                    if (this.isCharacter) {
                        String string2 = this.fxfp.base.fxUtils.trimString(this.charArray, this.arrPos);
                        if (string2 != null && string2.length() > 0) {
                            this.lightColor = string2;
                        }
                    } else if (this.colorParser != null) {
                        this.currLight.setColor(this.colorParser.getColor());
                        this.colorParser = null;
                    } else if (this.colorRef != null) {
                        this.currLight.setColor(this.colorRef);
                        this.colorRef = null;
                    }
                }
            } else if (this.isCharacter || this.isPrimitive) {
                String string3 = this.getCharOrPrimString();
                if (string3 != null) {
                    if (string.equals("lightOn") && this.lightOn == null) {
                        this.lightOn = string3;
                    } else {
                        this.processNodeEndElement(string, string3);
                    }
                }
            } else if (string.equals(this.tagName)) {
                this.setNodeProperties((Node)this.currLight);
                if (this.lightColor != null) {
                    this.currLight.setColor(Color.valueOf((String)this.lightColor));
                }
                if (this.lightOn != null) {
                    this.currLight.setLightOn(Boolean.parseBoolean(this.lightOn));
                }
                this.fxfp.setParser(this.parentParser);
                this.parentParser = null;
                this.currLight = null;
                this.tagName = null;
            }
        }
    }
}

