/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.AbstractElementParser;
import com.interactivemesh.jfx.importer.x3d.CadNode;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import com.interactivemesh.jfx.importer.x3d.GroupingNode;
import com.interactivemesh.jfx.importer.x3d.InlineNode;
import com.interactivemesh.jfx.importer.x3d.LightNode;
import com.interactivemesh.jfx.importer.x3d.SceneX;
import com.interactivemesh.jfx.importer.x3d.ShapeNode;
import com.interactivemesh.jfx.importer.x3d.TransformNode;
import com.interactivemesh.jfx.importer.x3d.ViewpointNode;
import com.interactivemesh.jfx.importer.x3d.X3D;
import com.interactivemesh.jfx.importer.x3d.X3DParser;
import com.interactivemesh.jfx.importer.x3d.XFileParser;
import com.interactivemesh.jfx.importer.x3d.XImporterImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.IdentityHashMap;

final class GroupingNodeParser
extends AbstractElementParser {
    private final X3DParser parentParser;
    private SceneX sceneX = null;
    private final IdentityHashMap<GroupingNode, GroupingNode> nodeParentMap = new IdentityHashMap();
    private GroupingNode currGrpNode = null;

    GroupingNodeParser(X3DParser x3DParser) {
        super(x3DParser.xfp);
        this.parentParser = x3DParser;
    }

    void setupForTopNode(GroupingNode groupingNode, SceneX sceneX) {
        this.currGrpNode = groupingNode;
        this.sceneX = sceneX;
        this.nodeParentMap.clear();
        this.nodeParentMap.put(groupingNode, null);
    }

    void setupForChildNode(GroupingNode groupingNode) {
        this.nodeParentMap.put(groupingNode, this.currGrpNode);
        this.currGrpNode = groupingNode;
    }

    @Override
    void close() {
        this.sceneX = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        String string2 = this.xfp.xR.getAttributeValue(null, "DEF");
        String string3 = this.xfp.xR.getAttributeValue(null, "USE");
        if (string.equals("Transform")) {
            TransformNode transformNode = null;
            if (string3 != null) {
                transformNode = this.currGrpNode.cache.getTransformNode(string3);
                if (transformNode == null) throw new ImportException("GroupNodeParser : shared Transform node not found for USE = " + string3);
                transformNode.setUSE(string3);
            } else {
                transformNode = new TransformNode(this.currGrpNode.base, this.currGrpNode.cache);
                transformNode.setDEF(string2);
                transformNode.center = this.xfp.xR.getAttributeValue(null, "center");
                transformNode.rotation = this.xfp.xR.getAttributeValue(null, "rotation");
                transformNode.scale = this.xfp.xR.getAttributeValue(null, "scale");
                transformNode.scaleOrientation = this.xfp.xR.getAttributeValue(null, "scaleOrientation");
                transformNode.translation = this.xfp.xR.getAttributeValue(null, "translation");
            }
            this.currGrpNode.addChild(transformNode);
            this.setupForChildNode(transformNode);
            return;
        } else if (string.equals("Shape")) {
            ShapeNode shapeNode = null;
            if (string3 != null) {
                shapeNode = this.currGrpNode.cache.getShapeNode(string3);
                if (shapeNode == null) throw new ImportException("GroupNodeParser : shared Shape node not found for USE = " + string3);
                shapeNode.setUSE(string3);
            } else {
                shapeNode = new ShapeNode(this.currGrpNode.base, this.currGrpNode.cache);
                shapeNode.setDEF(string2);
                this.xfp.setShapeParser(shapeNode, this);
            }
            this.currGrpNode.addChild(shapeNode);
            return;
        } else if (string.equals("Inline")) {
            if (string3 != null) {
                InlineNode inlineNode = this.currGrpNode.cache.getInlineNode(string3);
                if (inlineNode == null) throw new ImportException("GroupNodeParser : shared Inline node not found for USE = " + string3);
                inlineNode.setUSE(string3);
                this.currGrpNode.addChild(inlineNode);
                return;
            } else {
                String string4 = this.xfp.xR.getAttributeValue(null, "load");
                if (string4 == null || string4.equalsIgnoreCase("TRUE")) {
                    String string5 = this.xfp.xR.getAttributeValue(null, "url");
                    if (string5 == null) throw new ImportException("GroupingNodeParser Inline : No url attribute or url is empty !");
                    if (string5.length() < 1) {
                        throw new ImportException("GroupingNodeParser Inline : No url attribute or url is empty !");
                    }
                    XImporterImpl.BaseURL baseURL = this.currGrpNode.cache.baseUrlX3d;
                    boolean bl = true;
                    ArrayList<String> arrayList = this.currGrpNode.base.xUtils.getMFStrings(string5, false);
                    if (arrayList == null) throw new ImportException("GroupingNodeParser Inline : No readable string for url >" + string5 + "<");
                    if (arrayList.isEmpty()) {
                        throw new ImportException("GroupingNodeParser Inline : No readable string for url >" + string5 + "<");
                    }
                    for (String string6 : arrayList) {
                        URL uRL = this.currGrpNode.base.xUtils.getResourceUrlFor(string6, baseURL, "Inline", string2);
                        XImporterImpl.BaseURL baseURL2 = new XImporterImpl.BaseURL();
                        baseURL2.protocol = uRL.getProtocol();
                        baseURL2.host = uRL.getHost();
                        baseURL2.port = uRL.getPort();
                        baseURL2.path = uRL.getPath();
                        int n = baseURL2.path.lastIndexOf(47);
                        if (n >= 0) {
                            baseURL2.path = baseURL2.path.substring(0, n + 1);
                        } else if (n < 0) {
                            baseURL2.path = Character.toString('/');
                        }
                        try {
                            URLConnection uRLConnection = uRL.openConnection();
                            InputStream inputStream = uRLConnection.getInputStream();
                            ElementCache elementCache = new ElementCache(baseURL2);
                            XFileParser xFileParser = this.xfp.importerImpl.getInlineParser();
                            X3D x3D = xFileParser.parse(inputStream, elementCache);
                            InlineNode inlineNode = new InlineNode(this.currGrpNode.base, this.currGrpNode.cache, x3D, string6, uRL);
                            inlineNode.setDEF(string2);
                            this.currGrpNode.addChild(inlineNode);
                            this.xfp.importerImpl.cacheInlineParser(xFileParser);
                            return;
                        }
                        catch (IOException iOException) {
                            System.out.println("Inline failed for url = >" + uRL.toExternalForm() + "<");
                        }
                    }
                    if (!bl) return;
                    System.out.println("Inline failed for all urls = >" + string5 + "<");
                    return;
                } else {
                    this.xfp.setNullParser(this, string);
                }
            }
            return;
        } else if (string.equals("Group") || string.equals("Switch") || string.equals("LOD") || string.equals("StaticGroup") || string.equals("Collision") || string.equals("Billboard") || string.equals("PickableGroup") || string.equals("Layer") || string.equals("Viewport")) {
            GroupingNode groupingNode = null;
            if (string3 != null) {
                groupingNode = this.currGrpNode.cache.getGroupingNode(string3);
                if (groupingNode == null) throw new ImportException("GroupNodeParser : shared " + string + " node not found for USE = " + string3);
                groupingNode.setUSE(string3);
            } else {
                groupingNode = new GroupingNode(this.currGrpNode.base, this.currGrpNode.cache);
                groupingNode.setDEF(string2);
                if (string.equals("Switch")) {
                    String string7 = this.xfp.xR.getAttributeValue(null, "whichChoice");
                    groupingNode.whichChoice = string7 != null ? Integer.parseInt(string7) : -1;
                } else if (string.equals("LOD")) {
                    groupingNode.whichChoice = 0;
                }
            }
            this.currGrpNode.addChild(groupingNode);
            this.setupForChildNode(groupingNode);
            return;
        } else if (string.endsWith("Light")) {
            if (this.xfp.base.isIgnoreLights) {
                this.xfp.setNullParser(this, string);
                return;
            } else {
                LightNode lightNode = null;
                if (string3 != null) {
                    lightNode = this.currGrpNode.cache.getLightNode(string3);
                    if (lightNode == null) throw new ImportException("GroupNodeParser : shared " + string + " node not found for USE = " + string3);
                    lightNode.setUSE(string3);
                } else {
                    lightNode = new LightNode(this.currGrpNode.base, this.currGrpNode.cache);
                    lightNode.setDEF(string2);
                    this.xfp.setLightParser(lightNode, this, string);
                }
                this.currGrpNode.addChild(lightNode);
            }
            return;
        } else if (string.equals("Viewpoint") || string.equals("OrthoViewpoint")) {
            ViewpointNode viewpointNode = null;
            if (string3 != null) {
                viewpointNode = this.currGrpNode.cache.getViewpointNode(string3);
                if (viewpointNode == null) throw new ImportException("GroupNodeParser : shared Viewpoint node not found for USE = " + string3);
                viewpointNode.setUSE(string3);
            } else {
                viewpointNode = new ViewpointNode(this.currGrpNode.base, this.currGrpNode.cache);
                viewpointNode.setDEF(string2);
                this.xfp.setViewpointParser(viewpointNode, this, string);
            }
            this.currGrpNode.addChild(viewpointNode);
            return;
        } else {
            if (string.equals("ViewpointGroup")) return;
            if (string.startsWith("CAD")) {
                CadNode cadNode = null;
                if (string3 != null) {
                    cadNode = (CadNode)this.currGrpNode.cache.getGroupingNode(string3);
                    if (cadNode == null) throw new ImportException("GroupNodeParser : shared " + string + " node not found for USE = " + string3);
                    cadNode.setUSE(string3);
                } else {
                    String string8;
                    cadNode = new CadNode(this.currGrpNode.base, this.currGrpNode.cache);
                    cadNode.setDEF(string2);
                    cadNode.defautltIDName = string;
                    cadNode.name = this.xfp.xR.getAttributeValue(null, "name");
                    if (string.endsWith("Part")) {
                        cadNode.center = this.xfp.xR.getAttributeValue(null, "center");
                        cadNode.rotation = this.xfp.xR.getAttributeValue(null, "rotation");
                        cadNode.scale = this.xfp.xR.getAttributeValue(null, "scale");
                        cadNode.scaleOrientation = this.xfp.xR.getAttributeValue(null, "scaleOrientation");
                        cadNode.translation = this.xfp.xR.getAttributeValue(null, "translation");
                    } else if (string.endsWith("Layer") && (string8 = this.xfp.xR.getAttributeValue(null, "visible")) != null) {
                        ArrayList<String> arrayList = this.xfp.base.xUtils.getMFStrings(string8, false);
                        int n = 0;
                        if (arrayList != null && (n = arrayList.size()) > 0) {
                            boolean[] blArray = new boolean[n];
                            for (int i = 0; i < n; ++i) {
                                blArray[i] = Boolean.parseBoolean(arrayList.get(i));
                            }
                            cadNode.visible = blArray;
                        }
                    }
                }
                this.currGrpNode.addChild(cadNode);
                this.setupForChildNode(cadNode);
                return;
            } else if (string.equals("LayerSet")) {
                String string9 = this.xfp.xR.getAttributeValue(null, "order");
                if (string9 != null) {
                    int[] nArray = this.currGrpNode.base.xUtils.getIntArray(string9);
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] > 0) {
                            int n = i;
                            nArray[n] = nArray[n] - 1;
                            continue;
                        }
                        System.out.println("GroupNodeParser LayerSet order includes value less than 1 : order[" + i + "] = " + nArray[i]);
                    }
                    this.sceneX.layerOrder = nArray;
                }
                this.setupForChildNode(this.currGrpNode);
                return;
            } else if (string.startsWith("Metadata")) {
                this.currGrpNode.setMetaData(this.xfp.setMetaParser(this, string, string2, string3, this.currGrpNode.cache));
                return;
            } else {
                this.xfp.setNullParser(this, string);
            }
        }
    }

    @Override
    void endElement(String string) {
        if (this.isGrouping(string)) {
            GroupingNode groupingNode = this.nodeParentMap.remove(this.currGrpNode);
            if (groupingNode != null) {
                this.currGrpNode = groupingNode;
            } else {
                this.xfp.setParser(this.parentParser);
                this.currGrpNode = null;
            }
        } else if (string.equals("ViewpointGroup") || string.equals("ViewpointGroup")) {
            // empty if block
        }
    }

    private boolean isGrouping(String string) {
        boolean bl = false;
        if (string.equals("Transform")) {
            bl = true;
        } else if (string.equals("Group")) {
            bl = true;
        } else if (string.startsWith("CAD")) {
            bl = true;
        } else if (string.equals("StaticGroup")) {
            bl = true;
        } else if (string.equals("Switch")) {
            bl = true;
        } else if (string.equals("Billboard")) {
            bl = true;
        } else if (string.equals("Collision")) {
            bl = true;
        } else if (string.equals("LOD")) {
            bl = true;
        } else if (string.equals("PickableGroup")) {
            bl = true;
        } else if (string.equals("Layer")) {
            bl = true;
        } else if (string.equals("Viewport")) {
            bl = true;
        }
        return bl;
    }
}

