/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.AbstractSceneElement;
import com.interactivemesh.jfx.importer.x3d.ElementBase;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;

final class ImageTextureNode
extends AbstractSceneElement {
    String urlsString = null;
    private Image image = null;

    ImageTextureNode(ElementBase elementBase, ElementCache elementCache) {
        super(elementBase, elementCache);
    }

    @Override
    void setDEF(String string) {
        if (string != null) {
            this.def = string;
            this.cache.putImageTexNode(string, this);
        }
    }

    @Override
    void initialize() {
        this.image = this.createImage(this.urlsString);
    }

    @Override
    void clear() {
        this.image = null;
        super.clear();
    }

    Image getImage() {
        return this.image;
    }

    private Image createImage(String string) {
        ArrayList<String> arrayList = this.base.xUtils.getMFStrings(string, false);
        if (arrayList == null || arrayList.isEmpty()) {
            throw new ImportException("ImageTextureNode Image : No readable string for url >" + string + "<");
        }
        for (String string2 : arrayList) {
            URL uRL = this.base.xUtils.getResourceUrlFor(string2, this.cache.baseUrlX3d, "Image", this.def);
            String string3 = uRL.toExternalForm();
            int n = string3.lastIndexOf(46) + 1;
            String string4 = string3.substring(n);
            try {
                WritableImage writableImage = null;
                if (string4.equalsIgnoreCase("tga")) {
                    writableImage = this.base.imgFactory.readImage(string4, uRL);
                } else if (string4.equalsIgnoreCase("tif") || string4.equalsIgnoreCase("tiff")) {
                    writableImage = this.base.imgFactory.readImage(string4, uRL);
                } else {
                    if (this.base.isWritableImage) {
                        writableImage = this.base.imgFactory.readImage(string4, uRL);
                    }
                    if (writableImage == null) {
                        writableImage = new Image(string3);
                    }
                }
                this.base.putImagePath((Image)writableImage, new FilePath(string2, uRL));
                return writableImage;
            }
            catch (IOException iOException) {
            }
        }
        throw new ImportException("Can't create texture image for url = \n" + string);
    }
}

