/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.x3d.AbstractNodeElement;
import com.interactivemesh.jfx.importer.x3d.AppearanceNode;
import com.interactivemesh.jfx.importer.x3d.ElementBase;
import com.interactivemesh.jfx.importer.x3d.ElementCache;
import com.interactivemesh.jfx.importer.x3d.GeometryNode;
import com.interactivemesh.jfx.importer.x3d.PrimitiveNode;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.shape.CullFace;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Shape3D;

final class ShapeNode
extends AbstractNodeElement {
    AppearanceNode appearNode = null;
    GeometryNode geomNode = null;
    PrimitiveNode primNode = null;
    private Shape3D sharedShape3D = null;

    ShapeNode(ElementBase elementBase, ElementCache elementCache) {
        super(elementBase, elementCache);
    }

    @Override
    void setDEF(String string) {
        if (string != null) {
            this.def = string;
            this.cache.putShapeNode(string, this);
        }
    }

    @Override
    void initialize() {
        if (this.appearNode != null) {
            this.appearNode.initialize();
        }
        if (this.geomNode != null) {
            this.geomNode.initialize();
        }
        if (this.primNode != null) {
            this.primNode.initialize();
        }
    }

    @Override
    void clear() {
        this.sharedShape3D = null;
        super.clear();
    }

    @Override
    Node getNode(Group group) {
        if (this.sharedShape3D != null && this.use != null) {
            return this.base.cloneShape3D(this.sharedShape3D);
        }
        MeshView meshView = null;
        if (this.primNode != null) {
            meshView = this.primNode.getShape3D(this.def);
        } else {
            meshView = new MeshView();
            String string = this.base.createUniqueName(this.def);
            if (string == null) {
                string = this.base.createUniqueName("MeshView");
            }
            meshView.setId(string);
            if (this.geomNode != null) {
                if (this.appearNode != null) {
                    this.geomNode.isImageTexture = this.appearNode.hasImageTexture();
                }
                meshView.setMesh(this.geomNode.getMesh());
                if (!this.geomNode.solid) {
                    meshView.setCullFace(CullFace.NONE);
                }
            }
        }
        if (this.appearNode != null) {
            meshView.setMaterial(this.appearNode.getMaterial());
        }
        if (this.use != null) {
            this.sharedShape3D = meshView;
        }
        this.base.putNamedNode(meshView.getId(), (Node)meshView);
        return meshView;
    }
}

