/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.x3d.AbstractElementParser;
import com.interactivemesh.jfx.importer.x3d.AppearanceNode;
import com.interactivemesh.jfx.importer.x3d.GeometryNode;
import com.interactivemesh.jfx.importer.x3d.IndFaceSetNode;
import com.interactivemesh.jfx.importer.x3d.PrimitiveNode;
import com.interactivemesh.jfx.importer.x3d.ShapeNode;
import com.interactivemesh.jfx.importer.x3d.TriaQuadSetNode;
import com.interactivemesh.jfx.importer.x3d.XFileParser;

final class ShapeNodeParser
extends AbstractElementParser {
    private final PrimitiveNodeParser primParser;
    private AbstractElementParser parentParser = null;
    private ShapeNode currShape = null;

    ShapeNodeParser(XFileParser xFileParser) {
        super(xFileParser);
        this.primParser = new PrimitiveNodeParser(xFileParser);
    }

    void setup(ShapeNode shapeNode, AbstractElementParser abstractElementParser) {
        this.currShape = shapeNode;
        this.parentParser = abstractElementParser;
    }

    @Override
    void close() {
        this.primParser.close();
    }

    private void setBoolAttr(GeometryNode geometryNode) {
        String string = this.xfp.xR.getAttributeValue(null, "ccw");
        String string2 = this.xfp.xR.getAttributeValue(null, "colorPerVertex");
        String string3 = this.xfp.xR.getAttributeValue(null, "normalPerVertex");
        String string4 = this.xfp.xR.getAttributeValue(null, "solid");
        if (string != null) {
            geometryNode.ccw = Boolean.parseBoolean(string);
        }
        if (string2 != null) {
            geometryNode.colorPerVertex = Boolean.parseBoolean(string2);
        }
        if (string3 != null) {
            geometryNode.normalPerVertex = Boolean.parseBoolean(string3);
        }
        if (string4 != null) {
            geometryNode.solid = Boolean.parseBoolean(string4);
        }
    }

    private boolean setUsedGeometry(String string, String string2) {
        if (string != null) {
            GeometryNode geometryNode = this.currShape.cache.getGeometryNode(string);
            if (geometryNode != null) {
                geometryNode.setUSE(string);
                this.currShape.geomNode = geometryNode;
                return true;
            }
            throw new ImportException("GroupNodeParser : shared " + string2 + " node not found for USE = " + string);
        }
        return false;
    }

    private boolean setUsedPrimitive(String string, String string2) {
        if (string != null) {
            PrimitiveNode primitiveNode = this.currShape.cache.getPrimitiveNode(string);
            if (primitiveNode != null) {
                primitiveNode.setUSE(string);
                this.currShape.primNode = primitiveNode;
                return true;
            }
            throw new ImportException("GroupNodeParser : shared " + string2 + " node not found for USE = " + string);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void startElement(String string) {
        String string2 = this.xfp.xR.getAttributeValue(null, "DEF");
        String string3 = this.xfp.xR.getAttributeValue(null, "USE");
        if (string.equals("Appearance")) {
            AppearanceNode appearanceNode = null;
            if (string3 != null) {
                appearanceNode = this.currShape.cache.getAppearanceNode(string3);
                if (appearanceNode == null) throw new ImportException("GroupNodeParser : shared " + string + " node not found for USE = " + string3);
                appearanceNode.setUSE(string3);
            } else {
                appearanceNode = new AppearanceNode(this.currShape.base, this.currShape.cache);
                appearanceNode.setDEF(string2);
                this.xfp.setAppearParser(appearanceNode, this);
            }
            this.currShape.appearNode = appearanceNode;
            return;
        } else if (string.startsWith("Metadata")) {
            this.currShape.setMetaData(this.xfp.setMetaParser(this, string, string2, string3, this.currShape.cache));
            return;
        } else {
            boolean bl = false;
            if (string.equals("IndexedFaceSet")) {
                String string4;
                if (this.setUsedGeometry(string3, string)) return;
                bl = true;
                IndFaceSetNode indFaceSetNode = new IndFaceSetNode(this.currShape.base, this.currShape.cache);
                indFaceSetNode.setDEF(string2);
                this.setBoolAttr(indFaceSetNode);
                String string5 = this.xfp.xR.getAttributeValue(null, "convex");
                if (string5 != null) {
                    indFaceSetNode.convex = Boolean.parseBoolean(string5);
                }
                if ((string4 = this.xfp.xR.getAttributeValue(null, "creaseAngle")) != null) {
                    indFaceSetNode.creaseAngle = Float.parseFloat(string4);
                }
                indFaceSetNode.coordIndex = this.xfp.xR.getAttributeValue(null, "coordIndex");
                indFaceSetNode.normalIndex = this.xfp.xR.getAttributeValue(null, "normalIndex");
                indFaceSetNode.texCoordIndex = this.xfp.xR.getAttributeValue(null, "texCoordIndex");
                this.currShape.geomNode = indFaceSetNode;
                this.xfp.setGeomParser(indFaceSetNode, this, string);
                return;
            } else if (string.indexOf("Line", 6) > 0) {
                this.xfp.setNullParser(this, string);
                return;
            } else if (string.startsWith("Indexed")) {
                if (this.setUsedGeometry(string3, string)) return;
                bl = true;
                TriaQuadSetNode triaQuadSetNode = new TriaQuadSetNode(this.currShape.base, this.currShape.cache);
                triaQuadSetNode.setDEF(string2);
                triaQuadSetNode.isIndexed = true;
                if (string.indexOf("Quad", 6) > 0) {
                    triaQuadSetNode.isQuad = true;
                } else if (string.indexOf("Strip", 14) > 0) {
                    triaQuadSetNode.isStrip = true;
                } else if (string.indexOf("Fan", 14) > 0) {
                    triaQuadSetNode.isFan = true;
                } else {
                    triaQuadSetNode.isTria = true;
                }
                this.setBoolAttr(triaQuadSetNode);
                triaQuadSetNode.index = this.xfp.xR.getAttributeValue(null, "index");
                if (triaQuadSetNode.index != null && triaQuadSetNode.index.length() > 0) {
                    this.currShape.geomNode = triaQuadSetNode;
                    this.xfp.setGeomParser(triaQuadSetNode, this, string);
                    return;
                } else {
                    System.out.println("ShapeNodeParser no index-attribute; ignored = " + string);
                }
                return;
            } else if (string.startsWith("Triangle")) {
                if (this.setUsedGeometry(string3, string)) return;
                bl = true;
                TriaQuadSetNode triaQuadSetNode = new TriaQuadSetNode(this.currShape.base, this.currShape.cache);
                triaQuadSetNode.setDEF(string2);
                if (string.indexOf("Strip", 6) > 0) {
                    triaQuadSetNode.isStrip = true;
                    triaQuadSetNode.fanStripCount = this.xfp.xR.getAttributeValue(null, "stripCount");
                } else if (string.indexOf("Fan", 6) > 0) {
                    triaQuadSetNode.isFan = true;
                    triaQuadSetNode.fanStripCount = this.xfp.xR.getAttributeValue(null, "fanCount");
                } else {
                    triaQuadSetNode.isTria = true;
                }
                this.setBoolAttr(triaQuadSetNode);
                this.currShape.geomNode = triaQuadSetNode;
                this.xfp.setGeomParser(triaQuadSetNode, this, string);
                return;
            } else if (string.equals("QuadSet")) {
                if (this.setUsedGeometry(string3, string)) return;
                bl = true;
                TriaQuadSetNode triaQuadSetNode = new TriaQuadSetNode(this.currShape.base, this.currShape.cache);
                triaQuadSetNode.setDEF(string2);
                triaQuadSetNode.isQuad = true;
                this.setBoolAttr(triaQuadSetNode);
                this.currShape.geomNode = triaQuadSetNode;
                this.xfp.setGeomParser(triaQuadSetNode, this, string);
                return;
            } else if (string.equals("Box")) {
                String string6;
                if (this.setUsedPrimitive(string3, string)) return;
                PrimitiveNode primitiveNode = new PrimitiveNode(PrimitiveNode.Primitive.BOX, this.currShape.base, this.currShape.cache);
                primitiveNode.setDEF(string2);
                String string7 = this.xfp.xR.getAttributeValue(null, "solid");
                if (string7 != null) {
                    primitiveNode.solid = Boolean.parseBoolean(string7);
                }
                if ((string6 = this.xfp.xR.getAttributeValue(null, "size")) != null) {
                    float[] fArray = this.currShape.base.xUtils.getFloatArray(string6);
                    if (fArray == null || fArray.length != 3) throw new ImportException("GroupNodeParser : " + string + " has strange 'size' = " + string6);
                    primitiveNode.width = fArray[0];
                    primitiveNode.height = fArray[1];
                    primitiveNode.depth = fArray[2];
                }
                this.currShape.primNode = primitiveNode;
                this.primParser.setup(primitiveNode, this, string);
                this.xfp.setParser(this.primParser);
                return;
            } else if (string.equals("Cone")) {
                if (this.setUsedPrimitive(string3, string)) return;
                PrimitiveNode primitiveNode = new PrimitiveNode(PrimitiveNode.Primitive.CONE, this.currShape.base, this.currShape.cache);
                primitiveNode.setDEF(string2);
                String string8 = null;
                string8 = this.xfp.xR.getAttributeValue(null, "solid");
                if (string8 != null) {
                    primitiveNode.solid = Boolean.parseBoolean(string8);
                }
                if ((string8 = this.xfp.xR.getAttributeValue(null, "height")) != null) {
                    primitiveNode.height = Float.parseFloat(string8);
                }
                if ((string8 = this.xfp.xR.getAttributeValue(null, "bottomRadius")) != null) {
                    primitiveNode.radius = Float.parseFloat(string8);
                }
                if ((string8 = this.xfp.xR.getAttributeValue(null, "bottom")) != null) {
                    primitiveNode.bottom = Boolean.parseBoolean(string8);
                }
                if ((string8 = this.xfp.xR.getAttributeValue(null, "side")) != null) {
                    primitiveNode.side = Boolean.parseBoolean(string8);
                }
                this.currShape.primNode = primitiveNode;
                this.primParser.setup(primitiveNode, this, string);
                this.xfp.setParser(this.primParser);
                return;
            } else if (string.equals("Cylinder")) {
                if (this.setUsedPrimitive(string3, string)) return;
                PrimitiveNode primitiveNode = new PrimitiveNode(PrimitiveNode.Primitive.CYLINDER, this.currShape.base, this.currShape.cache);
                primitiveNode.setDEF(string2);
                String string9 = null;
                string9 = this.xfp.xR.getAttributeValue(null, "solid");
                if (string9 != null) {
                    primitiveNode.solid = Boolean.parseBoolean(string9);
                }
                if ((string9 = this.xfp.xR.getAttributeValue(null, "height")) != null) {
                    primitiveNode.height = Float.parseFloat(string9);
                }
                if ((string9 = this.xfp.xR.getAttributeValue(null, "radius")) != null) {
                    primitiveNode.radius = Float.parseFloat(string9);
                }
                if ((string9 = this.xfp.xR.getAttributeValue(null, "bottom")) != null) {
                    primitiveNode.bottom = Boolean.parseBoolean(string9);
                }
                if ((string9 = this.xfp.xR.getAttributeValue(null, "side")) != null) {
                    primitiveNode.side = Boolean.parseBoolean(string9);
                }
                if ((string9 = this.xfp.xR.getAttributeValue(null, "top")) != null) {
                    primitiveNode.top = Boolean.parseBoolean(string9);
                }
                this.currShape.primNode = primitiveNode;
                this.primParser.setup(primitiveNode, this, string);
                this.xfp.setParser(this.primParser);
                return;
            } else if (string.equals("Sphere")) {
                String string10;
                if (this.setUsedPrimitive(string3, string)) return;
                PrimitiveNode primitiveNode = new PrimitiveNode(PrimitiveNode.Primitive.SPHERE, this.currShape.base, this.currShape.cache);
                primitiveNode.setDEF(string2);
                String string11 = this.xfp.xR.getAttributeValue(null, "solid");
                if (string11 != null) {
                    primitiveNode.solid = Boolean.parseBoolean(string11);
                }
                if ((string10 = this.xfp.xR.getAttributeValue(null, "radius")) != null) {
                    primitiveNode.radius = Float.parseFloat(string10);
                }
                this.currShape.primNode = primitiveNode;
                this.primParser.setup(primitiveNode, this, string);
                this.xfp.setParser(this.primParser);
                return;
            } else {
                this.xfp.setNullParser(this, string);
            }
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("Shape")) {
            this.xfp.setParser(this.parentParser);
            this.parentParser = null;
            this.currShape = null;
        }
    }

    private static final class PrimitiveNodeParser
    extends AbstractElementParser {
        private AbstractElementParser parentParser = null;
        private PrimitiveNode currPrimNode = null;
        private String returnTag = null;

        private PrimitiveNodeParser(XFileParser xFileParser) {
            super(xFileParser);
        }

        private void setup(PrimitiveNode primitiveNode, AbstractElementParser abstractElementParser, String string) {
            this.currPrimNode = primitiveNode;
            this.parentParser = abstractElementParser;
            this.returnTag = string;
        }

        @Override
        void close() {
        }

        @Override
        void startElement(String string) {
            if (string.startsWith("Metadata")) {
                String string2 = this.xfp.xR.getAttributeValue(null, "DEF");
                String string3 = this.xfp.xR.getAttributeValue(null, "USE");
                this.currPrimNode.setMetaData(this.xfp.setMetaParser(this, string, string2, string3, this.currPrimNode.cache));
            } else {
                this.xfp.setNullParser(this, string);
            }
        }

        @Override
        void endElement(String string) {
            if (string.equals(this.returnTag)) {
                this.xfp.setParser(this.parentParser);
                this.parentParser = null;
                this.currPrimNode = null;
                this.returnTag = null;
            }
        }
    }
}

