/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.importer.x3d;

import com.interactivemesh.jfx.importer.x3d.AbstractElementParser;
import com.interactivemesh.jfx.importer.x3d.GroupingNode;
import com.interactivemesh.jfx.importer.x3d.GroupingNodeParser;
import com.interactivemesh.jfx.importer.x3d.SceneX;
import com.interactivemesh.jfx.importer.x3d.X3D;
import com.interactivemesh.jfx.importer.x3d.X3dHead;
import com.interactivemesh.jfx.importer.x3d.XFileParser;
import java.util.ArrayList;
import java.util.EnumMap;
import javafx.util.Pair;

final class X3DParser
extends AbstractElementParser {
    private final GroupingNodeParser grpNdeParser = new GroupingNodeParser(this);
    X3D x3d = null;
    private boolean isHead = false;

    X3DParser(XFileParser xFileParser) {
        super(xFileParser);
    }

    void setup(X3D x3D) {
        this.x3d = x3D;
    }

    @Override
    void close() {
        this.grpNdeParser.close();
        this.x3d = null;
    }

    @Override
    void startElement(String string) {
        if (this.isHead) {
            if (string.equals("component")) {
                String string2 = this.xfp.xR.getAttributeValue(null, "name");
                String string3 = this.xfp.xR.getAttributeValue(null, "level");
                int n = -1;
                if (string3 != null) {
                    n = Integer.parseInt(string3);
                }
                if (this.x3d.head.components == null) {
                    this.x3d.head.components = new ArrayList<Pair<String, Integer>>(4);
                }
                this.x3d.head.components.add((Pair<String, Integer>)new Pair((Object)string2, (Object)n));
            } else if (string.equals("meta")) {
                String string4 = this.xfp.xR.getAttributeValue(null, "name");
                String string5 = this.xfp.xR.getAttributeValue(null, "content");
                if (this.x3d.head.metas == null) {
                    this.x3d.head.metas = new ArrayList<Pair<String, String>>(4);
                }
                this.x3d.head.metas.add((Pair<String, String>)new Pair((Object)string4, (Object)string5));
            } else if (string.equals("unit")) {
                String string6 = this.xfp.xR.getAttributeValue(null, "category");
                String string7 = this.xfp.xR.getAttributeValue(null, "name");
                String string8 = this.xfp.xR.getAttributeValue(null, "conversionFactor");
                X3dHead.UnitCat unitCat = X3dHead.UnitCat.get(string6);
                if (unitCat != null) {
                    if (this.x3d.head.units == null) {
                        this.x3d.head.units = new EnumMap<X3dHead.UnitCat, Pair<String, Double>>(X3dHead.UnitCat.class);
                    }
                    double d = -1.0;
                    if (string8 != null) {
                        d = Double.parseDouble(string8);
                    }
                    this.x3d.head.units.put(unitCat, (Pair<String, Double>)new Pair((Object)string7, (Object)d));
                } else {
                    System.out.println("X3DParser unknown unit category >" + (Object)((Object)unitCat) + "<");
                }
            }
        } else if (string.equals("head")) {
            this.isHead = true;
        } else if (string.equals("Scene")) {
            GroupingNode groupingNode = new GroupingNode(this.x3d.base, this.x3d.cache);
            this.x3d.scene = new SceneX(this.x3d.base, this.x3d.cache, groupingNode);
            this.grpNdeParser.setupForTopNode(groupingNode, this.x3d.scene);
            this.xfp.setParser(this.grpNdeParser);
        } else if (string.equals("X3D")) {
            this.x3d.head.version = this.xfp.xR.getAttributeValue(null, "version");
            this.x3d.head.profile = this.xfp.xR.getAttributeValue(null, "profile");
        }
    }

    @Override
    void endElement(String string) {
        if (string.equals("head")) {
            this.isHead = false;
        } else if (string.equals("Scene") || string.equals("X3D")) {
            // empty if block
        }
    }
}

