/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.modelbrowser;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.importer.Viewpoint;
import com.interactivemesh.jfx.importer.col.ColModelImporter;
import com.interactivemesh.jfx.importer.fxml.FxmlModelImporter;
import com.interactivemesh.jfx.importer.obj.ObjModelImporter;
import com.interactivemesh.jfx.importer.stl.StlMeshImporter;
import com.interactivemesh.jfx.importer.tds.TdsModelImporter;
import com.interactivemesh.jfx.importer.x3d.X3dModelImporter;
import com.interactivemesh.jfx.modelbrowser.FxmlModelExporter;
import com.interactivemesh.jfx.modelbrowser.ImporterType;
import com.interactivemesh.jfx.modelbrowser.ModelBrowserFileChooser;
import com.interactivemesh.jfx.modelbrowser.ModelBrowserSceneTree;
import com.interactivemesh.jfx.modelbrowser.ModelBrowserSubScene;
import com.interactivemesh.jfx.modelbrowser.ModelBrowserVP;
import com.interactivemesh.jfx.modelbrowser.SystemProperties;
import com.interactivemesh.jfx.modelbrowser.VP;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import javafx.animation.AnimationTimer;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point3D;
import javafx.geometry.Pos;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.InputEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.text.FontSmoothingType;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Callback;
import javafx.util.Duration;

final class ModelBrowserFrame {
    private FPSTimer fpsTimer = null;
    private AnimationTimer readDurUpdateTimer = null;
    private long readStartTime = 0L;
    private Label readLabel = null;
    private Label durLabel = null;
    private NumberFormat secFormat = null;
    private boolean isReadDurUpdateTimer = true;
    private long liveStartTime = 0L;
    FileSystem defaultFileSystem = null;
    private final FileChooser fileChooser;
    private String initChooserDir = null;
    private FileChooser fileSaverFXML = null;
    private ColModelImporter colImporter = null;
    private FxmlModelImporter fxmlImporter = null;
    private ObjModelImporter objImporter = null;
    private StlMeshImporter stlImporter = null;
    private TdsModelImporter tdsImporter = null;
    private X3dModelImporter x3dImporter = null;
    private boolean isColImporterUsed = false;
    private boolean isFxmlImporterUsed = false;
    private boolean isObjImporterUsed = false;
    private boolean isStlImporterUsed = false;
    private boolean isTdsImporterUsed = false;
    private boolean isX3dImporterUsed = false;
    private final PhongMaterial stlMaterial;
    private final ArrayList<Control> toolButtons = new ArrayList();
    private Button reloadButton = null;
    private double maxWidth = 0.0;
    static double buttonHeight = 0.0;
    static double cellHeight = 0.0;
    private GridPane menuGridLeft = null;
    private GridPane menuGridRight = null;
    private ComboBox<ComboItem> menuCombo = null;
    private boolean isMenuButtonBrowser = true;
    private HBox readBox = null;
    private GridPane viewpointPane = null;
    private ComboBox<ComboItem> vpCombo = null;
    private PromptItem vpPromptItem = null;
    private VPItem vpRotCenterItem = null;
    private VPItem vpIsoItem = null;
    private ComboItem saveItemFXML = null;
    private Text importText = null;
    private ModelBrowserFileChooser fileBrowser = null;
    private ModelBrowserSceneTree sceneTree = null;
    private ModelBrowserSubScene subScene3D = null;
    private Region glassPane = null;
    private final Stage stage;
    private final String cssUrlString;
    private Timeline initAnim = null;
    private SplitPane frameSplitPane = null;

    ModelBrowserFrame(Stage stage, StackPane stackPane, String string) {
        this.stage = stage;
        this.cssUrlString = string;
        this.defaultFileSystem = FileSystems.getDefault();
        this.fileChooser = new FileChooser();
        this.fileChooser.setTitle("Load 3D file");
        this.fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All 3D model importers", new String[]{"*.3ds", " *.dae", " *.zae", " *.fxml", " *.obj", " *.stl", " *.x3d", " *.x3dz"}), new FileChooser.ExtensionFilter("3dsModelImporterJFX", new String[]{"*.3ds"}), new FileChooser.ExtensionFilter("ColModelImporterJFX", new String[]{"*.dae", " *.zae"}), new FileChooser.ExtensionFilter("FxmlModelImporterJFX", new String[]{"*.fxml"}), new FileChooser.ExtensionFilter("ObjModelImporterJFX ", new String[]{"*.obj"}), new FileChooser.ExtensionFilter("StlMeshImporterJFX", new String[]{"*.stl"}), new FileChooser.ExtensionFilter("X3dModelImporterJFX", new String[]{"*.x3d", " *.x3dz"})});
        this.stlMaterial = new PhongMaterial();
        this.stlMaterial.setDiffuseColor(Color.YELLOWGREEN);
        this.stlMaterial.setSpecularColor(Color.YELLOW);
        this.stlMaterial.setSpecularPower(32.0);
        this.createFrame(stackPane);
        try {
            URL uRL = this.getClass().getResource("resources/jimModelImporter.fxml");
            FXMLLoader fXMLLoader = new FXMLLoader(uRL);
            Object object = fXMLLoader.load();
            if (object != null) {
                this.subScene3D.setImporterType(ImporterType.FXML_LOADER);
                this.subScene3D.importNodes(new Node[]{(Group)object}, uRL, "jimModelImporter.fxml", null, this.importText, true);
                ModelBrowserVP[] modelBrowserVPArray = new ModelBrowserVP[2];
                modelBrowserVPArray[0] = new ModelBrowserVP("jim");
                modelBrowserVPArray[0].setFieldOfView(44.0);
                modelBrowserVPArray[0].setIsVertical(false);
                modelBrowserVPArray[0].setTransform(new Affine(0.91, 0.0, -0.416, 193.5, 0.0, 0.992, 0.0, -20.9, 0.416, 0.0, 0.91, -250.5));
                modelBrowserVPArray[1] = new ModelBrowserVP("ModelImporter");
                modelBrowserVPArray[1].setFieldOfView(44.0);
                modelBrowserVPArray[1].setIsVertical(false);
                modelBrowserVPArray[1].setTransform(new Affine(1.0, 0.0, 0.0, 94.78, 0.0, 1.0, 0.0, 6.684, 0.0, 0.0, 1.0, -176.8));
                this.subScene3D.setViewpoints(modelBrowserVPArray);
                this.sceneTree.setup(this.subScene3D.getSceneTreeRoot());
                this.setViewpointMenuButton(modelBrowserVPArray);
            } else {
                Cylinder cylinder = new Cylinder();
                cylinder.setMaterial((Material)new PhongMaterial(Color.MISTYROSE));
                this.subScene3D.importNodes(new Node[]{cylinder}, null, null, null, null, false);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void initScene() {
        Object object2;
        this.viewpointPane.requestLayout();
        buttonHeight = this.reloadButton.getBoundsInLocal().getHeight();
        cellHeight = (int)(buttonHeight * 0.9);
        this.fileBrowser.initScene();
        this.subScene3D.initScene();
        this.maxWidth = (int)(this.reloadButton.getBoundsInLocal().getWidth() * 1.6);
        for (Object object2 : this.toolButtons) {
            object2.setMinWidth(this.maxWidth);
            object2.setPrefWidth(this.maxWidth);
        }
        this.frameSplitPane.requestLayout();
        this.frameSplitPane.layout();
        this.initAnim = new Timeline();
        this.initAnim.setAutoReverse(false);
        this.initAnim.setCycleCount(1);
        this.initAnim.setDelay(Duration.millis((double)40.0));
        SplitPane.Divider divider = (SplitPane.Divider)this.frameSplitPane.getDividers().get(0);
        object2 = this.frameSplitPane.getDividerPositions();
        double d = 1.0 / this.frameSplitPane.getWidth();
        KeyValue keyValue = new KeyValue((WritableValue)divider.positionProperty(), (Object)((double)object2[0]), Interpolator.DISCRETE);
        KeyValue keyValue2 = new KeyValue((WritableValue)divider.positionProperty(), (Object)((double)(object2[0] + d)), Interpolator.DISCRETE);
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)0.0), new KeyValue[]{keyValue});
        KeyFrame keyFrame2 = new KeyFrame(Duration.millis((double)50.0), new KeyValue[]{keyValue2});
        this.initAnim.getKeyFrames().setAll((Object[])new KeyFrame[]{keyFrame, keyFrame2});
        this.initAnim.play();
    }

    void startStopFPS(boolean bl) {
    }

    void selectNodeInSceneTree(Node node) {
        this.sceneTree.selectNode(node);
    }

    private void createFrame(StackPane stackPane) {
        this.glassPane = new Region();
        this.glassPane.addEventFilter(InputEvent.ANY, (EventHandler)new EventHandler<InputEvent>(){

            public void handle(InputEvent inputEvent) {
                inputEvent.consume();
            }
        });
        this.glassPane.setDisable(true);
        this.readDurUpdateTimer = new AnimationTimer(){

            public void handle(long l) {
                double d = (double)(System.nanoTime() - ModelBrowserFrame.this.readStartTime) / 1.0E9;
                ModelBrowserFrame.this.readLabel.setText(ModelBrowserFrame.this.secFormat.format(d));
            }

            public void start() {
                ModelBrowserFrame.this.readStartTime = System.nanoTime();
                double d = buttonHeight * 2.0;
                ProgressIndicator progressIndicator = new ProgressIndicator();
                progressIndicator.setPrefSize(d, d);
                ModelBrowserFrame.this.readBox.getChildren().add((Object)new StackPane(new Node[]{progressIndicator, ModelBrowserFrame.this.readLabel}));
                super.start();
            }

            public void stop() {
                ModelBrowserFrame.this.liveStartTime = System.nanoTime();
                double d = (double)(ModelBrowserFrame.this.liveStartTime - ModelBrowserFrame.this.readStartTime) / 1.0E9;
                ModelBrowserFrame.this.readBox.getChildren().clear();
                ModelBrowserFrame.this.readLabel.setText("0.000");
                ModelBrowserFrame.this.durLabel.setText(ModelBrowserFrame.this.secFormat.format(d));
                super.stop();
            }
        };
        this.secFormat = NumberFormat.getInstance();
        this.secFormat.setMaximumFractionDigits(3);
        this.secFormat.setMinimumFractionDigits(3);
        this.secFormat.setGroupingUsed(false);
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        borderPane.setMinSize(0.0, 0.0);
        if (this.cssUrlString != null) {
            borderPane.getStylesheets().add((Object)this.cssUrlString);
            borderPane.getStyleClass().add((Object)"subroot");
        }
        this.fileBrowser = new ModelBrowserFileChooser(this);
        this.sceneTree = new ModelBrowserSceneTree(this.cssUrlString);
        ComboItem comboItem = new ComboItem("Load...", null){

            @Override
            void handle() {
                File file;
                if (ModelBrowserFrame.this.initChooserDir != null) {
                    ModelBrowserFrame.this.fileChooser.setInitialDirectory(new File(ModelBrowserFrame.this.initChooserDir));
                }
                if ((file = ModelBrowserFrame.this.fileChooser.showOpenDialog((Window)ModelBrowserFrame.this.stage)) != null) {
                    ModelBrowserFrame.this.initChooserDir = file.getParent();
                    try {
                        ModelBrowserFrame.this.loadFile(file.toURI().toURL(), ImporterType.FXML_IMPORTER);
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            }
        };
        this.saveItemFXML = new ComboItem("Export as fxml...", null){

            @Override
            void handle() {
                String string;
                if (ModelBrowserFrame.this.fileSaverFXML == null) {
                    ModelBrowserFrame.this.fileSaverFXML = new FileChooser();
                    ModelBrowserFrame.this.fileSaverFXML.setTitle("Save 3D file");
                    ModelBrowserFrame.this.fileSaverFXML.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("FXML", new String[]{"*.fxml"}), new FileChooser.ExtensionFilter("All files", new String[]{"*.*"})});
                }
                if ((string = ModelBrowserFrame.this.subScene3D.getCurrFileName()) != null) {
                    int n = string.lastIndexOf(46);
                    String string2 = string.substring(0, n) + ".fxml";
                    ModelBrowserFrame.this.fileSaverFXML.setInitialFileName(string2);
                    ModelBrowserFrame.this.fileSaverFXML.setInitialDirectory(ModelBrowserFrame.this.subScene3D.getCurrDirPath().toFile());
                    File file = ModelBrowserFrame.this.fileSaverFXML.showSaveDialog((Window)ModelBrowserFrame.this.stage);
                    if (file != null) {
                        Node[] nodeArray = ModelBrowserFrame.this.subScene3D.getRootForFxmlExport();
                        if (nodeArray == null || nodeArray.length < 1) {
                            return;
                        }
                        boolean bl = false;
                        String string3 = file.getAbsolutePath();
                        String string4 = string3.substring(string3.lastIndexOf(46) + 1);
                        if (string4 == null || string4.length() < 1 || !string4.equalsIgnoreCase("fxml")) {
                            string3 = string3 + ".fxml";
                            bl = true;
                        }
                        Path path = Paths.get(string3, new String[0]);
                        Path path2 = Paths.get(file.getParent(), new String[0]);
                        try {
                            ChildrenVisitor childrenVisitor = new ChildrenVisitor();
                            Files.walkFileTree(path2, EnumSet.noneOf(FileVisitOption.class), 1, childrenVisitor);
                            ModelBrowserFrame.this.consumeInputEvents(true);
                            Map<Image, FilePath> map = ModelBrowserFrame.this.subScene3D.getImagePathMap();
                            if (childrenVisitor.contains(path)) {
                                String string5 = string3 + ".tmp";
                                while (childrenVisitor.contains(Paths.get(string5, new String[0]))) {
                                    string5 = string5 + ".tmp";
                                }
                                Path path3 = Paths.get(string5, new String[0]);
                                Path path4 = Paths.get(string3, new String[0]);
                                try {
                                    FxmlModelExporter fxmlModelExporter = new FxmlModelExporter(path3.toFile());
                                    fxmlModelExporter.export(nodeArray, map);
                                    Files.delete(path);
                                    Files.move(path3, path4.resolveSibling(path), StandardCopyOption.REPLACE_EXISTING);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            } else {
                                try {
                                    FxmlModelExporter fxmlModelExporter = new FxmlModelExporter(path.toFile());
                                    fxmlModelExporter.export(nodeArray, map);
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                            ModelBrowserFrame.this.consumeInputEvents(false);
                            ModelBrowserFrame.this.fileBrowser.refreshTreeAndTable(false);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                }
            }
        };
        this.saveItemFXML.setDisable(true);
        ComboItem comboItem2 = new ComboItem("Clear importers & run GC", null){

            @Override
            void handle() {
                ModelBrowserFrame.this.clearImporter();
            }
        };
        ComboItem comboItem3 = new ComboItem("Close importers & run GC", null){

            @Override
            void handle() {
                ModelBrowserFrame.this.closeImporter();
            }
        };
        ComboItem comboItem4 = new ComboItem("About...", null){

            @Override
            void handle() {
                ModelBrowserFrame.this.showAboutDialog();
            }
        };
        ComboItem comboItem5 = new ComboItem("Help...", null){

            @Override
            void handle() {
                ModelBrowserFrame.this.showHelpDialog();
            }
        };
        ComboItem comboItem6 = new ComboItem("System...", null){

            @Override
            void handle() {
                ModelBrowserFrame.this.showSystemInfoDialog();
            }
        };
        ComboItem comboItem7 = new ComboItem("Exit", null){

            @Override
            void handle() {
                ModelBrowserFrame.this.exit();
            }
        };
        final PromptItem promptItem = new PromptItem("Menu");
        this.menuCombo = new ComboBox();
        this.menuCombo.getStyleClass().add((Object)"combo-box-mb");
        this.menuCombo.setTooltip(new Tooltip("Application menu"));
        this.menuCombo.setVisibleRowCount(13);
        this.menuCombo.getItems().setAll((Object[])new ComboItem[]{promptItem, comboItem, this.saveItemFXML, new SeparatorItem(), comboItem2, comboItem3, new SeparatorItem(), comboItem4, comboItem5, comboItem6, new SeparatorItem(), comboItem7});
        this.menuCombo.setValue((Object)promptItem);
        this.menuCombo.valueProperty().addListener((ChangeListener)new ChangeListener<ComboItem>(){

            public void changed(ObservableValue<? extends ComboItem> observableValue, ComboItem comboItem, ComboItem comboItem2) {
                if (comboItem2 != null && comboItem2 != promptItem) {
                    comboItem2.handle();
                    ModelBrowserFrame.this.menuCombo.setValue((Object)promptItem);
                }
            }
        });
        this.menuCombo.setCellFactory((Callback)new Callback<ListView<ComboItem>, ListCell<ComboItem>>(){

            public ListCell<ComboItem> call(ListView<ComboItem> listView) {
                return new ListCell<ComboItem>(){

                    protected void updateItem(ComboItem comboItem, boolean bl) {
                        super.updateItem((Object)comboItem, bl);
                        if (comboItem == null || bl) {
                            this.setText(null);
                            this.setGraphic(null);
                        } else {
                            this.setText(comboItem.getText());
                            this.setGraphic(comboItem.getGraphic());
                            this.setDisable(comboItem.isDisable());
                            this.setOpacity(comboItem.getOpacity());
                            this.setPrefHeight(comboItem.getPrefHeight());
                        }
                    }
                };
            }
        });
        this.toolButtons.add((Control)this.menuCombo);
        final Button button = new Button("Refresh");
        button.getStyleClass().add((Object)"button-mb");
        button.setTooltip(new Tooltip("Refresh file system tree and table"));
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                ModelBrowserFrame.this.fileBrowser.refreshTreeAndTable(false);
            }
        });
        this.toolButtons.add((Control)button);
        Button button2 = new Button("ddd");
        button2.getStyleClass().add((Object)"button-mb");
        button2.setVisible(false);
        Button button3 = new Button("ddd");
        button3.getStyleClass().add((Object)"button-mb");
        button3.setVisible(false);
        this.menuGridLeft = new GridPane();
        this.menuGridLeft.setHgap(10.0);
        this.menuGridLeft.setVgap(5.0);
        this.menuGridLeft.setGridLinesVisible(false);
        this.menuGridLeft.add(this.menuCombo, 0, 0);
        this.menuGridLeft.add((Node)button, 0, 1);
        this.menuGridLeft.add((Node)button2, 1, 0);
        this.menuGridLeft.add((Node)button3, 1, 1);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHalignment(HPos.CENTER);
        this.menuGridLeft.getColumnConstraints().add((Object)columnConstraints);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_LEFT);
        hBox.setSpacing(10.0);
        hBox.getChildren().add((Object)this.menuGridLeft);
        Button button4 = new Button("<");
        button4.getStyleClass().add((Object)"button-mb");
        button4.setTooltip(new Tooltip("Hide browser pane"));
        button4.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                ((SplitPane.Divider)ModelBrowserFrame.this.frameSplitPane.getDividers().get(0)).setPosition(0.0);
            }
        });
        Button button5 = new Button("ddd");
        button5.getStyleClass().add((Object)"button-mb");
        button5.setVisible(false);
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(5.0);
        gridPane.setGridLinesVisible(false);
        gridPane.add((Node)button4, 0, 0);
        gridPane.add((Node)button5, 0, 1);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHalignment(HPos.RIGHT);
        gridPane.getColumnConstraints().add((Object)columnConstraints2);
        HBox hBox2 = new HBox();
        hBox2.setAlignment(Pos.CENTER_RIGHT);
        hBox2.setSpacing(10.0);
        hBox2.getChildren().addAll((Object[])new Node[]{gridPane});
        BorderPane borderPane2 = new BorderPane();
        borderPane2.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        borderPane2.setMinSize(0.0, 0.0);
        borderPane2.setLeft((Node)hBox);
        borderPane2.setRight((Node)hBox2);
        borderPane.setTop((Node)borderPane2);
        Pane pane = this.fileBrowser.getFileSystemPane();
        pane.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        BorderPane borderPane3 = new BorderPane();
        borderPane3.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        borderPane3.setMinSize(0.0, 0.0);
        borderPane3.setCenter(this.sceneTree.getTreePane());
        Tab tab = new Tab("File Browser");
        tab.setTooltip(new Tooltip("File system tree and table"));
        tab.setContent((Node)pane);
        Tab tab2 = new Tab("Scene Graph");
        tab2.setTooltip(new Tooltip("Scene graph of loaded 3D file"));
        tab2.setContent((Node)borderPane3);
        Tab tab3 = new Tab("Map Images");
        tab3.setTooltip(new Tooltip("Texture images of loaded 3D file"));
        HBox hBox3 = new HBox(new Node[]{new Label("Under development !")});
        hBox3.setAlignment(Pos.CENTER);
        tab3.setContent((Node)hBox3);
        TabPane tabPane = new TabPane();
        tabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        tabPane.getTabs().addAll((Object[])new Tab[]{tab, tab2, tab3});
        tabPane.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                int n = number2.intValue();
                button.setDisable(n != 0);
            }
        });
        borderPane.setCenter((Node)tabPane);
        Label label = new Label("Under development !");
        label.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        HBox hBox4 = new HBox(new Node[]{label});
        hBox4.setAlignment(Pos.CENTER);
        this.importText = new Text();
        this.importText.setText("Loaded file : -\n   MinX 0  MinY 0  MinZ 0\n   MaxX 0  MaxY 0  MaxZ 0\n   Nodes = 0, therefrom Groups = 0, Shape3Ds = 0\n   Faces = 0");
        HBox hBox5 = new HBox(new Node[]{this.importText});
        hBox5.setAlignment(Pos.CENTER_LEFT);
        this.durLabel = new Label("0.000");
        this.durLabel.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        HBox hBox6 = new HBox();
        hBox6.setAlignment(Pos.CENTER_LEFT);
        hBox6.setSpacing(5.0);
        hBox6.getChildren().addAll((Object[])new Node[]{new Label("Read duration (sec) = "), this.durLabel});
        BorderPane borderPane4 = new BorderPane();
        borderPane4.setPadding(new Insets(5.0, 10.0, 5.0, 10.0));
        borderPane4.setTop((Node)hBox4);
        borderPane4.setCenter((Node)hBox5);
        borderPane4.setBottom((Node)hBox6);
        Tab tab4 = new Tab("Import");
        tab4.setTooltip(new Tooltip("Imported data"));
        tab4.setContent((Node)borderPane4);
        Tab tab5 = new Tab("Options");
        tab5.setTooltip(new Tooltip("Options of the 3D model importers"));
        HBox hBox7 = new HBox(new Node[]{new Label("Under development !")});
        hBox7.setAlignment(Pos.CENTER);
        tab5.setContent((Node)hBox7);
        Tab tab6 = new Tab("Scene");
        tab6.setTooltip(new Tooltip("Scene information"));
        HBox hBox8 = new HBox(new Node[]{new Label("Under development !")});
        hBox8.setAlignment(Pos.CENTER);
        tab6.setContent((Node)hBox8);
        TabPane tabPane2 = new TabPane();
        tabPane2.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        tabPane2.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        tabPane2.getTabs().addAll((Object[])new Tab[]{tab4, tab5, tab6});
        borderPane.setBottom((Node)tabPane2);
        Button button6 = new Button("Load...");
        button6.getStyleClass().add((Object)"button-mb");
        button6.setTooltip(new Tooltip("File chooser for loading a 3D model file"));
        button6.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                File file;
                if (ModelBrowserFrame.this.initChooserDir != null) {
                    ModelBrowserFrame.this.fileChooser.setInitialDirectory(new File(ModelBrowserFrame.this.initChooserDir));
                }
                if ((file = ModelBrowserFrame.this.fileChooser.showOpenDialog((Window)ModelBrowserFrame.this.stage)) != null) {
                    ModelBrowserFrame.this.initChooserDir = file.getParent();
                    try {
                        ModelBrowserFrame.this.loadFile(file.toURI().toURL(), ImporterType.FXML_LOADER);
                    }
                    catch (MalformedURLException malformedURLException) {
                        malformedURLException.printStackTrace();
                    }
                }
            }
        });
        this.toolButtons.add((Control)button6);
        this.reloadButton = new Button("  Reload  ");
        this.reloadButton.getStyleClass().add((Object)"button-mb");
        this.reloadButton.setTooltip(new Tooltip("Reloads the current 3D model file"));
        this.reloadButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                URL uRL = ModelBrowserFrame.this.subScene3D.getCurrFile();
                ImporterType importerType = ModelBrowserFrame.this.subScene3D.getImporterType();
                if (uRL != null) {
                    ModelBrowserFrame.this.loadFile(uRL, importerType);
                }
            }
        });
        this.toolButtons.add((Control)this.reloadButton);
        GridPane gridPane2 = new GridPane();
        gridPane2.setHgap(0.0);
        gridPane2.setVgap(5.0);
        gridPane2.setGridLinesVisible(false);
        gridPane2.add((Node)button6, 0, 0);
        gridPane2.add((Node)this.reloadButton, 0, 1);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setHalignment(HPos.CENTER);
        gridPane2.getColumnConstraints().add((Object)columnConstraints3);
        this.vpIsoItem = new VPItem(new ModelBrowserVP("Isometric view")){

            @Override
            void handle() {
                ModelBrowserFrame.this.subScene3D.setViewpoint(VP.ISO);
            }
        };
        this.vpRotCenterItem = new VPItem(new ModelBrowserVP("From rotation center to +Z")){

            @Override
            void handle() {
                ModelBrowserFrame.this.subScene3D.setViewpoint(VP.CENTER);
            }
        };
        this.vpPromptItem = new PromptItem("Viewpoints");
        this.vpCombo = new ComboBox();
        this.vpCombo.getStyleClass().add((Object)"combo-box-mb");
        this.vpCombo.setTooltip(new Tooltip("Viewpoints from the 3D file and common viewpoints"));
        this.vpCombo.setMaxWidth(Double.MAX_VALUE);
        this.vpCombo.getItems().addAll((Object[])new ComboItem[]{this.vpPromptItem, this.vpIsoItem, this.vpRotCenterItem});
        this.vpCombo.setValue((Object)this.vpPromptItem);
        this.vpCombo.valueProperty().addListener((ChangeListener)new ChangeListener<ComboItem>(){

            public void changed(ObservableValue<? extends ComboItem> observableValue, ComboItem comboItem, ComboItem comboItem2) {
                if (comboItem2 != null && comboItem2 != ModelBrowserFrame.this.vpPromptItem) {
                    comboItem2.handle();
                    ModelBrowserFrame.this.vpCombo.setValue((Object)ModelBrowserFrame.this.vpPromptItem);
                }
            }
        });
        this.vpCombo.setCellFactory((Callback)new Callback<ListView<ComboItem>, ListCell<ComboItem>>(){

            public ListCell<ComboItem> call(ListView<ComboItem> listView) {
                return new ListCell<ComboItem>(){

                    protected void updateItem(ComboItem comboItem, boolean bl) {
                        super.updateItem((Object)comboItem, bl);
                        if (comboItem == null || bl) {
                            this.setText("");
                            this.setGraphic(null);
                        } else {
                            this.setText(comboItem.getText());
                            this.setGraphic(comboItem.getGraphic());
                            this.setDisable(comboItem.isDisable());
                            this.setPrefHeight(comboItem.getPrefHeight());
                        }
                    }
                };
            }
        });
        this.toolButtons.add((Control)this.vpCombo);
        EventHandler<ActionEvent> eventHandler = new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                VpButton vpButton = (VpButton)((Object)actionEvent.getSource());
                ModelBrowserFrame.this.subScene3D.setViewpoint(vpButton.vp);
            }
        };
        this.viewpointPane = new GridPane();
        this.viewpointPane.setHgap(5.0);
        this.viewpointPane.setVgap(0.0);
        this.viewpointPane.setGridLinesVisible(false);
        VpButton vpButton = new VpButton(VP.RIGHT, (EventHandler)eventHandler, null);
        this.viewpointPane.add((Node)new VpButton(VP.FRONT, (EventHandler)eventHandler, vpButton), 0, 0);
        this.viewpointPane.add((Node)new VpButton(VP.BACK, (EventHandler)eventHandler, vpButton), 1, 0);
        this.viewpointPane.add((Node)vpButton, 2, 0);
        this.viewpointPane.add((Node)new VpButton(VP.LEFT, (EventHandler)eventHandler, vpButton), 3, 0);
        this.viewpointPane.add((Node)new VpButton(VP.TOP, (EventHandler)eventHandler, vpButton), 4, 0);
        this.viewpointPane.add((Node)new VpButton(VP.BOTTOM, (EventHandler)eventHandler, vpButton), 5, 0);
        ColumnConstraints columnConstraints4 = new ColumnConstraints();
        columnConstraints4.setHalignment(HPos.CENTER);
        this.viewpointPane.getColumnConstraints().add((Object)columnConstraints4);
        GridPane gridPane3 = new GridPane();
        gridPane3.setHgap(0.0);
        gridPane3.setVgap(5.0);
        gridPane3.setGridLinesVisible(false);
        gridPane3.add(this.vpCombo, 0, 0);
        gridPane3.add((Node)this.viewpointPane, 0, 1);
        ColumnConstraints columnConstraints5 = new ColumnConstraints();
        columnConstraints5.setHalignment(HPos.CENTER);
        gridPane3.getColumnConstraints().add((Object)columnConstraints5);
        ToggleGroup toggleGroup = new ToggleGroup();
        final RadioButton radioButton = new RadioButton("");
        radioButton.setToggleGroup(toggleGroup);
        radioButton.getStyleClass().add((Object)"check-box-mb");
        radioButton.setMouseTransparent(true);
        final RadioButton radioButton2 = new RadioButton("");
        radioButton2.setToggleGroup(toggleGroup);
        radioButton2.getStyleClass().add((Object)"check-box-mb");
        radioButton2.setMouseTransparent(true);
        final RadioButton radioButton3 = new RadioButton("");
        radioButton3.setToggleGroup(toggleGroup);
        radioButton3.getStyleClass().add((Object)"check-box-mb");
        radioButton3.setMouseTransparent(true);
        radioButton3.setSelected(true);
        ComboItem comboItem8 = new ComboItem("Off", (Node)radioButton){

            @Override
            void handle() {
                radioButton.setSelected(true);
                ModelBrowserFrame.this.subScene3D.setPicking(false, true);
            }
        };
        ComboItem comboItem9 = new ComboItem("Bounds", (Node)radioButton2){

            @Override
            void handle() {
                radioButton2.setSelected(true);
                ModelBrowserFrame.this.subScene3D.setPicking(true, true);
            }
        };
        ComboItem comboItem10 = new ComboItem("Geometry", (Node)radioButton3){

            @Override
            void handle() {
                radioButton3.setSelected(true);
                ModelBrowserFrame.this.subScene3D.setPicking(true, false);
            }
        };
        final PromptItem promptItem2 = new PromptItem("Picking");
        final ComboBox comboBox = new ComboBox();
        comboBox.getStyleClass().add((Object)"combo-box-mb");
        comboBox.setTooltip(new Tooltip("Shape3D picking modes"));
        comboBox.getItems().addAll((Object[])new ComboItem[]{promptItem2, comboItem9, comboItem10, new SeparatorItem(), comboItem8});
        comboBox.setValue((Object)promptItem2);
        comboBox.valueProperty().addListener((ChangeListener)new ChangeListener<ComboItem>(){

            public void changed(ObservableValue<? extends ComboItem> observableValue, ComboItem comboItem, ComboItem comboItem2) {
                if (comboItem2 != null && comboItem2 != promptItem2) {
                    comboItem2.handle();
                    comboBox.setValue((Object)promptItem2);
                }
            }
        });
        comboBox.setCellFactory((Callback)new Callback<ListView<ComboItem>, ListCell<ComboItem>>(){

            public ListCell<ComboItem> call(ListView<ComboItem> listView) {
                return new ListCell<ComboItem>(){

                    protected void updateItem(ComboItem comboItem, boolean bl) {
                        super.updateItem((Object)comboItem, bl);
                        if (comboItem == null || bl) {
                            this.setText("");
                            this.setGraphic(null);
                        } else {
                            this.setText(comboItem.getText());
                            this.setGraphic(comboItem.getGraphic());
                            this.setDisable(comboItem.isDisable());
                            this.setPrefHeight(comboItem.getPrefHeight());
                        }
                    }
                };
            }
        });
        this.toolButtons.add((Control)comboBox);
        RadioButton radioButton4 = new RadioButton("");
        radioButton4.setOpacity(0.0);
        radioButton4.getStyleClass().add((Object)"check-box-mb");
        radioButton4.setMouseTransparent(true);
        ComboItem comboItem11 = new ComboItem("Origin (0,0,0)", (Node)radioButton4){

            @Override
            void handle() {
                ModelBrowserFrame.this.subScene3D.setRotationCenter(new Point3D(0.0, 0.0, 0.0));
            }
        };
        RadioButton radioButton5 = new RadioButton("");
        radioButton5.setOpacity(0.0);
        radioButton5.getStyleClass().add((Object)"check-box-mb");
        radioButton5.setMouseTransparent(true);
        ComboItem comboItem12 = new ComboItem("Scene center", (Node)radioButton5){

            @Override
            void handle() {
                ModelBrowserFrame.this.subScene3D.setRotationCenter(ModelBrowserFrame.this.subScene3D.getSceneCenter());
            }
        };
        ToggleGroup toggleGroup2 = new ToggleGroup();
        final RadioButton radioButton6 = new RadioButton("");
        radioButton6.setToggleGroup(toggleGroup2);
        radioButton6.getStyleClass().add((Object)"check-box-mb");
        radioButton6.setMouseTransparent(true);
        final RadioButton radioButton7 = new RadioButton("");
        radioButton7.setToggleGroup(toggleGroup2);
        radioButton7.getStyleClass().add((Object)"check-box-mb");
        radioButton7.setMouseTransparent(true);
        final RadioButton radioButton8 = new RadioButton("");
        radioButton8.setToggleGroup(toggleGroup2);
        radioButton8.getStyleClass().add((Object)"check-box-mb");
        radioButton8.setMouseTransparent(true);
        radioButton6.setSelected(true);
        ComboItem comboItem13 = new ComboItem("Picked Shape3D center", (Node)radioButton6){

            @Override
            void handle() {
                radioButton6.setSelected(true);
                ModelBrowserFrame.this.subScene3D.setPickShape3DRotCenter(ModelBrowserSubScene.RotCenter.PICKEAD_SHAPE_CENTER);
            }
        };
        ComboItem comboItem14 = new ComboItem("Picked Shape3D point", (Node)radioButton7){

            @Override
            void handle() {
                radioButton7.setSelected(true);
                ModelBrowserFrame.this.subScene3D.setPickShape3DRotCenter(ModelBrowserSubScene.RotCenter.PICKEAD_SHAPE_POINT);
            }
        };
        ComboItem comboItem15 = new ComboItem("Picked Shape3D vertex", (Node)radioButton8){

            @Override
            void handle() {
                radioButton8.setSelected(true);
                ModelBrowserFrame.this.subScene3D.setPickShape3DRotCenter(ModelBrowserSubScene.RotCenter.PICKEAD_SHAPE_VERTEX);
            }
        };
        final CheckBox checkBox = new CheckBox();
        checkBox.setSelected(true);
        checkBox.getStyleClass().add((Object)"check-box-mb");
        ComboItem comboItem16 = new ComboItem("Look at center of rotation", (Node)checkBox){

            @Override
            void handle() {
                boolean bl = !checkBox.isSelected();
                checkBox.setSelected(bl);
                ModelBrowserFrame.this.subScene3D.setLookAtCenter(bl);
            }
        };
        checkBox.setMouseTransparent(true);
        final PromptItem promptItem3 = new PromptItem("Rotation");
        final ComboBox comboBox2 = new ComboBox();
        comboBox2.getStyleClass().add((Object)"combo-box-mb");
        comboBox2.setTooltip(new Tooltip("Center of rotation selection"));
        comboBox2.getItems().addAll((Object[])new ComboItem[]{promptItem3, comboItem11, comboItem12, new SeparatorItem(), comboItem13, comboItem14, comboItem15, new SeparatorItem(), comboItem16});
        comboBox2.setValue((Object)promptItem3);
        comboBox2.valueProperty().addListener((ChangeListener)new ChangeListener<ComboItem>(){

            public void changed(ObservableValue<? extends ComboItem> observableValue, ComboItem comboItem, ComboItem comboItem2) {
                if (comboItem2 != null && comboItem2 != promptItem3) {
                    comboItem2.handle();
                    comboBox2.setValue((Object)promptItem3);
                }
            }
        });
        comboBox2.setCellFactory((Callback)new Callback<ListView<ComboItem>, ListCell<ComboItem>>(){

            public ListCell<ComboItem> call(ListView<ComboItem> listView) {
                return new ListCell<ComboItem>(){

                    protected void updateItem(ComboItem comboItem, boolean bl) {
                        super.updateItem((Object)comboItem, bl);
                        if (comboItem == null || bl) {
                            this.setText("");
                            this.setGraphic(null);
                        } else {
                            this.setText(comboItem.getText());
                            this.setGraphic(comboItem.getGraphic());
                            this.setDisable(comboItem.isDisable());
                            this.setPrefHeight(comboItem.getPrefHeight());
                        }
                    }
                };
            }
        });
        this.toolButtons.add((Control)comboBox2);
        final CheckBox checkBox2 = new CheckBox();
        checkBox2.setSelected(true);
        checkBox2.getStyleClass().add((Object)"check-box-mb");
        ComboItem comboItem17 = new ComboItem("Scene axes", (Node)checkBox2){

            @Override
            void handle() {
                boolean bl = !checkBox2.isSelected();
                checkBox2.setSelected(bl);
                ModelBrowserFrame.this.subScene3D.setSceneAxesVisible(bl);
            }
        };
        final CheckBox checkBox3 = new CheckBox();
        checkBox3.setSelected(true);
        checkBox3.getStyleClass().add((Object)"check-box-mb");
        ComboItem comboItem18 = new ComboItem("Viewing axes", (Node)checkBox3){

            @Override
            void handle() {
                boolean bl = !checkBox3.isSelected();
                checkBox3.setSelected(bl);
                ModelBrowserFrame.this.subScene3D.setNavAxesVisible(bl);
            }
        };
        checkBox2.setMouseTransparent(true);
        checkBox3.setMouseTransparent(true);
        final PromptItem promptItem4 = new PromptItem("Axes");
        final ComboBox comboBox3 = new ComboBox();
        comboBox3.getStyleClass().add((Object)"combo-box-mb");
        comboBox3.setTooltip(new Tooltip("Visibility of the 3D space axes"));
        comboBox3.getItems().addAll((Object[])new ComboItem[]{promptItem4, comboItem17, comboItem18});
        comboBox3.setValue((Object)promptItem4);
        comboBox3.valueProperty().addListener((ChangeListener)new ChangeListener<ComboItem>(){

            public void changed(ObservableValue<? extends ComboItem> observableValue, ComboItem comboItem, ComboItem comboItem2) {
                if (comboItem2 != null && comboItem2 != promptItem4) {
                    comboItem2.handle();
                    comboBox3.setValue((Object)promptItem4);
                }
            }
        });
        comboBox3.setCellFactory((Callback)new Callback<ListView<ComboItem>, ListCell<ComboItem>>(){

            public ListCell<ComboItem> call(ListView<ComboItem> listView) {
                return new ListCell<ComboItem>(){

                    protected void updateItem(ComboItem comboItem, boolean bl) {
                        super.updateItem((Object)comboItem, bl);
                        if (comboItem == null || bl) {
                            this.setText("");
                            this.setGraphic(null);
                        } else {
                            this.setText(comboItem.getText());
                            this.setGraphic(comboItem.getGraphic());
                            this.setPrefHeight(comboItem.getPrefHeight());
                        }
                    }
                };
            }
        });
        this.toolButtons.add((Control)comboBox3);
        final CheckBox checkBox4 = new CheckBox();
        checkBox4.getStyleClass().add((Object)"check-box-mb");
        ComboItem comboItem19 = new ComboItem("Ambient light", (Node)checkBox4){

            @Override
            void handle() {
                boolean bl = !checkBox4.isSelected();
                checkBox4.setSelected(bl);
                ModelBrowserFrame.this.subScene3D.enableAmbientLght(bl);
            }
        };
        final CheckBox checkBox5 = new CheckBox();
        checkBox5.getStyleClass().add((Object)"check-box-mb");
        checkBox5.setSelected(true);
        ComboItem comboItem20 = new ComboItem("Headlight", (Node)checkBox5){

            @Override
            void handle() {
                boolean bl = !checkBox5.isSelected();
                checkBox5.setSelected(bl);
                ModelBrowserFrame.this.subScene3D.enableHeadLight(bl);
            }
        };
        checkBox4.setMouseTransparent(true);
        checkBox5.setMouseTransparent(true);
        final PromptItem promptItem5 = new PromptItem("Lights");
        final ComboBox comboBox4 = new ComboBox();
        comboBox4.getStyleClass().add((Object)"combo-box-mb");
        comboBox4.setTooltip(new Tooltip("Scene lights selection"));
        comboBox4.getItems().addAll((Object[])new ComboItem[]{promptItem5, comboItem19, comboItem20});
        comboBox4.setValue((Object)promptItem5);
        comboBox4.valueProperty().addListener((ChangeListener)new ChangeListener<ComboItem>(){

            public void changed(ObservableValue<? extends ComboItem> observableValue, ComboItem comboItem, ComboItem comboItem2) {
                if (comboItem2 != null && comboItem2 != promptItem5) {
                    comboItem2.handle();
                    comboBox4.setValue((Object)promptItem5);
                }
            }
        });
        comboBox4.setCellFactory((Callback)new Callback<ListView<ComboItem>, ListCell<ComboItem>>(){

            public ListCell<ComboItem> call(ListView<ComboItem> listView) {
                return new ListCell<ComboItem>(){

                    protected void updateItem(ComboItem comboItem, boolean bl) {
                        super.updateItem((Object)comboItem, bl);
                        if (comboItem == null || bl) {
                            this.setText("");
                            this.setGraphic(null);
                        } else {
                            this.setText(comboItem.getText());
                            this.setGraphic(comboItem.getGraphic());
                            this.setPrefHeight(comboItem.getPrefHeight());
                        }
                    }
                };
            }
        });
        this.toolButtons.add((Control)comboBox4);
        ToggleGroup toggleGroup3 = new ToggleGroup();
        final RadioButton radioButton9 = new RadioButton("");
        radioButton9.setToggleGroup(toggleGroup3);
        radioButton9.getStyleClass().add((Object)"check-box-mb");
        radioButton9.setMouseTransparent(true);
        final RadioButton radioButton10 = new RadioButton("");
        radioButton10.setToggleGroup(toggleGroup3);
        radioButton10.getStyleClass().add((Object)"check-box-mb");
        radioButton10.setMouseTransparent(true);
        radioButton9.setSelected(true);
        ComboItem comboItem21 = new ComboItem("BALANCED", (Node)radioButton9){

            @Override
            void handle() {
                radioButton9.setSelected(true);
                ModelBrowserFrame.this.subScene3D.setSceneAntialiasing(SceneAntialiasing.BALANCED);
            }
        };
        ComboItem comboItem22 = new ComboItem("DISABLED", (Node)radioButton10){

            @Override
            void handle() {
                radioButton10.setSelected(true);
                ModelBrowserFrame.this.subScene3D.setSceneAntialiasing(SceneAntialiasing.DISABLED);
            }
        };
        final PromptItem promptItem6 = new PromptItem("Antialiasing");
        final ComboBox comboBox5 = new ComboBox();
        comboBox5.getStyleClass().add((Object)"combo-box-mb");
        comboBox5.setTooltip(new Tooltip("Scene anti-aliasing modes"));
        comboBox5.getItems().addAll((Object[])new ComboItem[]{promptItem6, comboItem21, comboItem22});
        comboBox5.setValue((Object)promptItem6);
        comboBox5.valueProperty().addListener((ChangeListener)new ChangeListener<ComboItem>(){

            public void changed(ObservableValue<? extends ComboItem> observableValue, ComboItem comboItem, ComboItem comboItem2) {
                if (comboItem2 != null && comboItem2 != promptItem6) {
                    comboItem2.handle();
                    comboBox5.setValue((Object)promptItem6);
                }
            }
        });
        comboBox5.setCellFactory((Callback)new Callback<ListView<ComboItem>, ListCell<ComboItem>>(){

            public ListCell<ComboItem> call(ListView<ComboItem> listView) {
                return new ListCell<ComboItem>(){

                    protected void updateItem(ComboItem comboItem, boolean bl) {
                        super.updateItem((Object)comboItem, bl);
                        if (comboItem == null || bl) {
                            this.setText("");
                            this.setGraphic(null);
                        } else {
                            this.setText(comboItem.getText());
                            this.setGraphic(comboItem.getGraphic());
                            this.setPrefHeight(comboItem.getPrefHeight());
                        }
                    }
                };
            }
        });
        this.toolButtons.add((Control)comboBox5);
        GridPane gridPane4 = new GridPane();
        gridPane4.setHgap(10.0);
        gridPane4.setVgap(5.0);
        gridPane4.setGridLinesVisible(false);
        gridPane4.add((Node)comboBox, 0, 0);
        gridPane4.add((Node)comboBox2, 0, 1);
        gridPane4.add((Node)comboBox3, 1, 0);
        gridPane4.add((Node)comboBox5, 1, 1);
        gridPane4.add((Node)comboBox4, 2, 1);
        ColumnConstraints columnConstraints6 = new ColumnConstraints();
        columnConstraints6.setHalignment(HPos.CENTER);
        gridPane4.getColumnConstraints().add((Object)columnConstraints6);
        this.readLabel = new Label(this.secFormat.format(0.0));
        this.readLabel.setStyle("-fx-font-weight: bold; ");
        this.readLabel.setTextFill((Paint)Color.RED);
        this.readLabel.setTextAlignment(TextAlignment.LEFT);
        this.readBox = new HBox();
        this.readBox.setSpacing(5.0);
        this.readBox.setAlignment(Pos.CENTER_LEFT);
        this.readBox.setPadding(new Insets(0.0, 0.0, 0.0, 10.0));
        HBox hBox9 = new HBox();
        hBox9.setAlignment(Pos.CENTER_LEFT);
        hBox9.setSpacing(10.0);
        hBox9.getChildren().addAll((Object[])new Node[]{gridPane2, gridPane3, gridPane4, this.readBox});
        Button button7 = new Button("ddd");
        button7.getStyleClass().add((Object)"button-mb");
        button7.setVisible(false);
        this.menuGridRight = new GridPane();
        this.menuGridRight.setHgap(0.0);
        this.menuGridRight.setVgap(5.0);
        this.menuGridRight.setGridLinesVisible(false);
        this.menuGridRight.add((Node)button7, 0, 1);
        ColumnConstraints columnConstraints7 = new ColumnConstraints();
        columnConstraints7.setHalignment(HPos.CENTER);
        this.menuGridRight.getColumnConstraints().add((Object)columnConstraints7);
        HBox hBox10 = new HBox();
        hBox10.setAlignment(Pos.CENTER_RIGHT);
        hBox10.getChildren().add((Object)this.menuGridRight);
        BorderPane borderPane5 = new BorderPane();
        borderPane5.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        borderPane5.setLeft((Node)hBox9);
        borderPane5.setRight((Node)hBox10);
        if (this.cssUrlString != null) {
            borderPane5.getStylesheets().add((Object)this.cssUrlString);
            borderPane5.getStyleClass().add((Object)"subroot");
        }
        this.subScene3D = new ModelBrowserSubScene(this, SceneAntialiasing.BALANCED);
        this.sceneTree.setup(this.subScene3D);
        BorderPane borderPane6 = new BorderPane();
        borderPane6.setTop((Node)borderPane5);
        borderPane6.setCenter((Node)this.subScene3D.getSubScenePane());
        borderPane6.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        borderPane6.setPickOnBounds(false);
        this.frameSplitPane = new SplitPane();
        this.frameSplitPane.getItems().addAll((Object[])new Node[]{borderPane, borderPane6});
        this.frameSplitPane.setDividerPosition(0, 0.3);
        SplitPane.setResizableWithParent((Node)borderPane, (Boolean)false);
        this.frameSplitPane.setPickOnBounds(false);
        ((SplitPane.Divider)this.frameSplitPane.getDividers().get(0)).positionProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                double d = (ModelBrowserFrame.this.menuCombo.getWidth() + 10.0) / ModelBrowserFrame.this.frameSplitPane.getWidth();
                if (number2.doubleValue() < d) {
                    if (ModelBrowserFrame.this.isMenuButtonBrowser) {
                        ModelBrowserFrame.this.isMenuButtonBrowser = false;
                        ModelBrowserFrame.this.menuGridRight.add((Node)ModelBrowserFrame.this.menuCombo, 0, 0);
                    }
                } else if (!ModelBrowserFrame.this.isMenuButtonBrowser) {
                    ModelBrowserFrame.this.isMenuButtonBrowser = true;
                    ModelBrowserFrame.this.menuGridLeft.add((Node)ModelBrowserFrame.this.menuCombo, 0, 0);
                }
            }
        });
        stackPane.getChildren().addAll((Object[])new Node[]{this.frameSplitPane, this.glassPane});
    }

    private void consumeInputEvents(boolean bl) {
        this.glassPane.setDisable(!bl);
    }

    void loadFile(URL uRL, ImporterType importerType) {
        this.consumeInputEvents(true);
        if (this.isReadDurUpdateTimer) {
            this.readDurUpdateTimer.start();
        }
        new Loader(uRL, importerType).start();
    }

    private void setViewpointMenuButton(ModelBrowserVP[] modelBrowserVPArray) {
        this.vpCombo.getItems().clear();
        this.vpCombo.getItems().add((Object)this.vpPromptItem);
        if (modelBrowserVPArray != null && modelBrowserVPArray.length > 0) {
            for (ModelBrowserVP modelBrowserVP : modelBrowserVPArray) {
                VPItem vPItem = new VPItem(modelBrowserVP){

                    @Override
                    void handle() {
                        ModelBrowserFrame.this.subScene3D.setViewpoint(this.getVP());
                    }
                };
                this.vpCombo.getItems().add((Object)vPItem);
            }
            this.vpCombo.getItems().add((Object)new SeparatorItem());
        }
        this.vpCombo.getItems().addAll((Object[])new ComboItem[]{this.vpIsoItem, this.vpRotCenterItem});
        this.vpCombo.setValue((Object)this.vpPromptItem);
    }

    private void clearImporter() {
        if (this.isColImporterUsed && this.colImporter != null) {
            this.colImporter.clear();
            this.isColImporterUsed = false;
        }
        if (this.isFxmlImporterUsed && this.fxmlImporter != null) {
            this.fxmlImporter.clear();
            this.isFxmlImporterUsed = false;
        }
        if (this.isObjImporterUsed && this.objImporter != null) {
            this.objImporter.clear();
            this.isObjImporterUsed = false;
        }
        if (this.isStlImporterUsed && this.stlImporter != null) {
            this.stlImporter.clear();
            this.isStlImporterUsed = false;
        }
        if (this.isTdsImporterUsed && this.tdsImporter != null) {
            this.tdsImporter.clear();
            this.isTdsImporterUsed = false;
        }
        if (this.isX3dImporterUsed && this.x3dImporter != null) {
            this.x3dImporter.clear();
            this.isX3dImporterUsed = false;
        }
        System.gc();
    }

    private void closeImporter() {
        if (this.colImporter != null) {
            this.colImporter.close();
            this.colImporter = null;
            this.isColImporterUsed = false;
        }
        if (this.fxmlImporter != null) {
            this.fxmlImporter.close();
            this.fxmlImporter = null;
            this.isFxmlImporterUsed = false;
        }
        if (this.objImporter != null) {
            this.objImporter.close();
            this.objImporter = null;
            this.isObjImporterUsed = false;
        }
        if (this.stlImporter != null) {
            this.stlImporter.close();
            this.stlImporter = null;
            this.isStlImporterUsed = false;
        }
        if (this.tdsImporter != null) {
            this.tdsImporter.close();
            this.tdsImporter = null;
            this.isTdsImporterUsed = false;
        }
        if (this.x3dImporter != null) {
            this.x3dImporter.close();
            this.x3dImporter = null;
            this.isX3dImporterUsed = false;
        }
        System.gc();
    }

    void exit() {
        if (this.colImporter != null) {
            this.colImporter.close();
        }
        if (this.fxmlImporter != null) {
            this.fxmlImporter.close();
        }
        if (this.objImporter != null) {
            this.objImporter.close();
        }
        if (this.stlImporter != null) {
            this.stlImporter.close();
        }
        if (this.tdsImporter != null) {
            this.tdsImporter.close();
        }
        if (this.x3dImporter != null) {
            this.x3dImporter.close();
        }
        System.exit(0);
    }

    private void showException(final Exception exception, final URL uRL) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ModelBrowserFrame.this.isReadDurUpdateTimer) {
                    ModelBrowserFrame.this.readDurUpdateTimer.stop();
                }
                ModelBrowserFrame.this.showExceptionDialog(exception, uRL.toExternalForm());
                ModelBrowserFrame.this.consumeInputEvents(false);
            }
        });
    }

    private void extractCamLights(Group group, ArrayList<Node> arrayList) {
        ObservableList observableList = group.getChildren();
        for (Node node : observableList) {
            if (node instanceof Group) {
                this.extractCamLights((Group)node, arrayList);
                continue;
            }
            if (node instanceof LightBase) {
                arrayList.add(node);
                continue;
            }
            if (!(node instanceof Camera)) continue;
            arrayList.add(node);
        }
    }

    private void showExceptionDialog(Exception exception, String string) {
        String string2;
        StackTraceElement stackTraceElement2;
        final Stage stage = new Stage(StageStyle.UTILITY);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setTitle("Exception");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Import failed for file :\n");
        stringBuilder.append("          \n");
        stringBuilder.append(string + '\n');
        stringBuilder.append("          \n");
        stringBuilder.append(exception.getMessage() + '\n');
        stringBuilder.append("          \n");
        int n = 0;
        int n2 = 6;
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        if (stackTraceElementArray != null) {
            for (StackTraceElement stackTraceElement2 : stackTraceElementArray) {
                string2 = stackTraceElement2.toString();
                int borderPane = string2.length();
                if (borderPane > n) {
                    n = borderPane;
                }
                ++n2;
                stringBuilder.append(string2 + '\n');
            }
        }
        final String string3 = stringBuilder.toString();
        Text text = new Text();
        text.setText(string3);
        Button button = new Button("  Copy  ");
        button.setTooltip(new Tooltip("Copy exception to system clipboard"));
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.putString(string3);
                clipboard.setContent((Map)clipboardContent);
            }
        });
        stackTraceElement2 = new Button("  Close  ");
        stackTraceElement2.setTooltip(new Tooltip("Close this dialog"));
        stackTraceElement2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                stage.close();
            }
        });
        string2 = new HBox();
        string2.setSpacing(20.0);
        string2.setAlignment(Pos.CENTER);
        string2.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        string2.getChildren().addAll((Object[])new Node[]{button, stackTraceElement2});
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        ScrollPane scrollPane = new ScrollPane((Node)text);
        scrollPane.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        borderPane.setCenter((Node)scrollPane);
        borderPane.setBottom((Node)string2);
        Bounds bounds = text.getBoundsInLocal();
        borderPane.setPrefSize(bounds.getWidth() + 60.0, bounds.getHeight() + 80.0);
        stage.setScene(new Scene((Parent)borderPane));
        stage.sizeToScene();
        stage.show();
    }

    private void showSystemInfoDialog() {
        final Stage stage = new Stage(StageStyle.UTILITY);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setTitle("System");
        SystemProperties systemProperties = new SystemProperties();
        StringBuilder stringBuilder = systemProperties.getSystemProps();
        final String string = stringBuilder.toString();
        Text text = new Text();
        text.setText(string);
        Button button = new Button("  Copy  ");
        button.setTooltip(new Tooltip("Copy information to system clipboard"));
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.putString(string);
                clipboard.setContent((Map)clipboardContent);
            }
        });
        Button button2 = new Button("  Close  ");
        button2.setTooltip(new Tooltip("Close this dialog"));
        button2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                stage.close();
            }
        });
        HBox hBox = new HBox();
        hBox.setSpacing(20.0);
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        hBox.getChildren().addAll((Object[])new Node[]{button, button2});
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        ScrollPane scrollPane = new ScrollPane((Node)text);
        scrollPane.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        borderPane.setCenter((Node)scrollPane);
        borderPane.setBottom((Node)hBox);
        Bounds bounds = text.getBoundsInLocal();
        borderPane.setPrefSize(bounds.getWidth() + 120.0, 800.0);
        stage.setScene(new Scene((Parent)borderPane));
        stage.sizeToScene();
        stage.show();
    }

    private void showHelpDialog() {
        WebView webView = new WebView();
        WebEngine webEngine = webView.getEngine();
        URL uRL = this.getClass().getResource("resources/modelBrowserHelp.html");
        webEngine.load(uRL.toExternalForm());
        final Stage stage = new Stage(StageStyle.UTILITY);
        stage.initModality(Modality.NONE);
        stage.setResizable(true);
        stage.setTitle("Help");
        Button button = new Button("  Close  ");
        button.setTooltip(new Tooltip("Close this dialog"));
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                stage.close();
            }
        });
        HBox hBox = new HBox();
        hBox.setSpacing(0.0);
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        hBox.getChildren().add((Object)button);
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(15.0, 10.0, 10.0, 10.0));
        borderPane.setCenter((Node)webView);
        borderPane.setBottom((Node)hBox);
        borderPane.setPrefSize(900.0, 800.0);
        stage.setScene(new Scene((Parent)borderPane));
        stage.sizeToScene();
        stage.show();
        button.requestFocus();
    }

    private void showAboutDialog() {
        final Stage stage = new Stage(StageStyle.UTILITY);
        stage.initModality(Modality.APPLICATION_MODAL);
        stage.setResizable(true);
        stage.setTitle("About");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ModelBrowserJFX 0.4.1\n\n");
        stringBuilder.append("3dsModelImporterJFX 0.7\n");
        stringBuilder.append("ColModelImporterJFX 0.6\n");
        stringBuilder.append("FxmlModelImporterJFX 0.5\n");
        stringBuilder.append("ObjModelImporterJFX 0.8\n");
        stringBuilder.append("StlMeshImporterJFX 0.7\n");
        stringBuilder.append("X3dModelImporterJFX 0.4\n\n");
        stringBuilder.append("Copyright (c) 2013-2014 August Lammersdorf, InteractiveMesh e.K.. All rights reserved.\n\nInteractiveMesh e.K.\nAugust Lammersdorf \nHauptstrasse 28d \n85737 Ismaning \nGermany / Munich Area\nDistrict court Munich HRA 89887\n\nwww.InteractiveMesh.com - www.InteractiveMesh.org\n\n");
        stringBuilder.append("License Agreement\n");
        String string = stringBuilder.toString();
        Text text = new Text();
        text.setText(string);
        text.setFill((Paint)Color.DARKCYAN);
        text.setFontSmoothingType(FontSmoothingType.LCD);
        stringBuilder = new StringBuilder();
        stringBuilder.append("By installing, copying, or otherwise using the Program, you agree to be bound by\nthe terms of this Agreement. If you do not agree to the terms of this Agreement,\ndo not install or use the Program.\n\nThe copyright holder grants to you a non-exclusive, perpetual, irrevocable, and\nworldwide right to use the Program. It is provided to you free of charge for\nacademic, commercial, and personal use.\n\nYou may not remove any copyright, license, or other proprietary notice from the\nProgram.\n\nNo parts of the Program may be reproduced in part or in whole. You may not\nreverse engineer, decompile, or disassemble the Program or prepare derivative\nworks of it.\n\nTHIS PROGRAM IS PROVIDED \"AS IS\", WITHOUT WARRANTIES OR CONDITIONS OF\nANY KIND, EIHTER EXPRESS OR IMPLIED, INCLUDING, WITHOUT LIMITATION, ANY\nWARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY,\nOR FITNESS FOR A PARTICULAR PURPOSE. YOU ARE SOLELY RESPONSIBLE FOR\nDETERMINING THE APPROPRIATENESS OF USING THE PROGRAM AND ASSUME ANY\nRISKS ASSOCIATED WITH YOUR EXERCISE OF PERMISSIONS UNDER THIS LICENSE.\n\nIN NO EVENT AND UNDER NO LEGAL THEORY, WHETHER IN TORT, CONTRACT, OR\nOTHERWISE, UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING,\nSHALL THE COPYRIGHT HOLDER BE LIABLE TO YOU FOR DAMAGES, INCLUDING ANY\nDIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES OF ANY\nCHARACTER ARISING AS A RESULT OF THIS LICENSE OR OUT THE USE OR INABILITY\nTO USE THE PROGRAM, EVEN IF THE COPYRIGHT HOLDER HAS BEEN ADVISED OF\nTHE POSSIBILITY OF SUCH DAMAGES.");
        string = stringBuilder.toString();
        Text text2 = new Text();
        text2.setText(string);
        text2.setFontSmoothingType(FontSmoothingType.LCD);
        Button button = new Button("  Close  ");
        button.setTooltip(new Tooltip("Close this dialog"));
        button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                stage.close();
            }
        });
        HBox hBox = new HBox();
        hBox.setSpacing(0.0);
        hBox.setAlignment(Pos.CENTER);
        hBox.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        hBox.getChildren().add((Object)button);
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(15.0, 10.0, 10.0, 10.0));
        ScrollPane scrollPane = new ScrollPane((Node)text2);
        scrollPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        borderPane.setTop((Node)text);
        borderPane.setCenter((Node)scrollPane);
        borderPane.setBottom((Node)hBox);
        Bounds bounds = text.getBoundsInLocal();
        borderPane.setPrefSize(bounds.getWidth() + 120.0, bounds.getHeight() * 2.0);
        stage.setScene(new Scene((Parent)borderPane));
        stage.sizeToScene();
        stage.show();
        button.requestFocus();
    }

    private Affine createVpTransform(Camera camera) {
        Transform transform;
        Object object;
        Affine affine = new Affine();
        Group group = (Group)camera.getParent();
        if (group != null) {
            object = new ArrayList();
            while (group != null) {
                ((ArrayList)object).add(group);
                group = (Group)group.getParent();
            }
            for (int i = ((ArrayList)object).size() - 1; i >= 0; --i) {
                transform = ((Group)((ArrayList)object).get(i)).getTransforms();
                if (transform == null || transform.size() <= 0) continue;
                for (Transform transform2 : transform) {
                    affine.append(transform2);
                }
            }
        }
        if ((object = camera.getTransforms()) != null && object.size() > 0) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                transform = (Transform)iterator.next();
                affine.append(transform);
            }
        }
        return affine;
    }

    static /* synthetic */ TdsModelImporter access$3700(ModelBrowserFrame modelBrowserFrame) {
        return modelBrowserFrame.tdsImporter;
    }

    static /* synthetic */ TdsModelImporter access$3702(ModelBrowserFrame modelBrowserFrame, TdsModelImporter tdsModelImporter) {
        modelBrowserFrame.tdsImporter = tdsModelImporter;
        return modelBrowserFrame.tdsImporter;
    }

    static /* synthetic */ void access$3800(ModelBrowserFrame modelBrowserFrame, Exception exception, URL uRL) {
        modelBrowserFrame.showException(exception, uRL);
    }

    static /* synthetic */ boolean access$3902(ModelBrowserFrame modelBrowserFrame, boolean bl) {
        modelBrowserFrame.isTdsImporterUsed = bl;
        return modelBrowserFrame.isTdsImporterUsed;
    }

    static /* synthetic */ ColModelImporter access$4000(ModelBrowserFrame modelBrowserFrame) {
        return modelBrowserFrame.colImporter;
    }

    static /* synthetic */ ColModelImporter access$4002(ModelBrowserFrame modelBrowserFrame, ColModelImporter colModelImporter) {
        modelBrowserFrame.colImporter = colModelImporter;
        return modelBrowserFrame.colImporter;
    }

    static /* synthetic */ boolean access$4102(ModelBrowserFrame modelBrowserFrame, boolean bl) {
        modelBrowserFrame.isColImporterUsed = bl;
        return modelBrowserFrame.isColImporterUsed;
    }

    static /* synthetic */ ObjModelImporter access$4200(ModelBrowserFrame modelBrowserFrame) {
        return modelBrowserFrame.objImporter;
    }

    static /* synthetic */ ObjModelImporter access$4202(ModelBrowserFrame modelBrowserFrame, ObjModelImporter objModelImporter) {
        modelBrowserFrame.objImporter = objModelImporter;
        return modelBrowserFrame.objImporter;
    }

    static /* synthetic */ boolean access$4302(ModelBrowserFrame modelBrowserFrame, boolean bl) {
        modelBrowserFrame.isObjImporterUsed = bl;
        return modelBrowserFrame.isObjImporterUsed;
    }

    static /* synthetic */ X3dModelImporter access$4400(ModelBrowserFrame modelBrowserFrame) {
        return modelBrowserFrame.x3dImporter;
    }

    static /* synthetic */ X3dModelImporter access$4402(ModelBrowserFrame modelBrowserFrame, X3dModelImporter x3dModelImporter) {
        modelBrowserFrame.x3dImporter = x3dModelImporter;
        return modelBrowserFrame.x3dImporter;
    }

    static /* synthetic */ boolean access$4502(ModelBrowserFrame modelBrowserFrame, boolean bl) {
        modelBrowserFrame.isX3dImporterUsed = bl;
        return modelBrowserFrame.isX3dImporterUsed;
    }

    static /* synthetic */ StlMeshImporter access$4600(ModelBrowserFrame modelBrowserFrame) {
        return modelBrowserFrame.stlImporter;
    }

    static /* synthetic */ StlMeshImporter access$4602(ModelBrowserFrame modelBrowserFrame, StlMeshImporter stlMeshImporter) {
        modelBrowserFrame.stlImporter = stlMeshImporter;
        return modelBrowserFrame.stlImporter;
    }

    static /* synthetic */ boolean access$4702(ModelBrowserFrame modelBrowserFrame, boolean bl) {
        modelBrowserFrame.isStlImporterUsed = bl;
        return modelBrowserFrame.isStlImporterUsed;
    }

    static /* synthetic */ FxmlModelImporter access$4800(ModelBrowserFrame modelBrowserFrame) {
        return modelBrowserFrame.fxmlImporter;
    }

    static /* synthetic */ FxmlModelImporter access$4802(ModelBrowserFrame modelBrowserFrame, FxmlModelImporter fxmlModelImporter) {
        modelBrowserFrame.fxmlImporter = fxmlModelImporter;
        return modelBrowserFrame.fxmlImporter;
    }

    static /* synthetic */ boolean access$4902(ModelBrowserFrame modelBrowserFrame, boolean bl) {
        modelBrowserFrame.isFxmlImporterUsed = bl;
        return modelBrowserFrame.isFxmlImporterUsed;
    }

    static /* synthetic */ void access$5000(ModelBrowserFrame modelBrowserFrame, Group group, ArrayList arrayList) {
        modelBrowserFrame.extractCamLights(group, arrayList);
    }

    static /* synthetic */ Affine access$5100(ModelBrowserFrame modelBrowserFrame, Camera camera) {
        return modelBrowserFrame.createVpTransform(camera);
    }

    private static final class FPSTimer
    extends AnimationTimer {
        private long lastTime = 0L;
        private int frameCounter = 0;
        private int elapsedFrames = 30;
        private boolean isFirstCall = true;
        private final Label fpsLabel;

        private FPSTimer(Label label) {
            this.fpsLabel = label;
        }

        private void startStop(boolean bl) {
            if (bl) {
                this.lastTime = System.nanoTime();
                this.frameCounter = 0;
                this.elapsedFrames = 30;
                this.isFirstCall = true;
                this.start();
            } else {
                this.stop();
            }
        }

        public void handle(long l) {
            ++this.frameCounter;
            if (this.frameCounter > this.elapsedFrames) {
                long l2 = System.nanoTime();
                double d = (double)(l2 - this.lastTime) / (double)this.frameCounter;
                this.lastTime = l2;
                int n = (int)(1.0E9 / d + 0.5);
                int n2 = (int)(d / 1000000.0 + 0.5);
                this.frameCounter = 0;
                this.elapsedFrames = (int)Math.max(1.0f, (float)n / 3.0f);
                this.elapsedFrames = Math.min(100, this.elapsedFrames);
                if (this.isFirstCall) {
                    this.isFirstCall = false;
                } else {
                    System.out.println("F P S =" + Integer.toString(n));
                }
            }
        }
    }

    private static final class ChildrenVisitor
    extends SimpleFileVisitor<Path> {
        private final ArrayList<Path> fileList = new ArrayList();

        private ChildrenVisitor() {
        }

        private ArrayList<Path> getChildren() {
            return this.fileList;
        }

        private boolean contains(Path path) {
            return this.fileList.contains(path);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
            FileVisitResult fileVisitResult = null;
            try {
                fileVisitResult = super.preVisitDirectory(path, basicFileAttributes);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return fileVisitResult;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
            FileVisitResult fileVisitResult = null;
            try {
                fileVisitResult = super.visitFile(path, basicFileAttributes);
                this.fileList.add(path);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return fileVisitResult;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException iOException) {
            FileVisitResult fileVisitResult = null;
            try {
                fileVisitResult = super.postVisitDirectory(path, iOException);
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
            return fileVisitResult;
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException iOException) {
            FileVisitResult fileVisitResult = null;
            try {
                fileVisitResult = super.visitFileFailed(path, iOException);
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
            return fileVisitResult;
        }
    }

    private final class Loader
    extends Thread {
        private final URL url;
        private final ImporterType fxmlType;

        private Loader(URL uRL, ImporterType importerType) {
            this.url = uRL;
            this.fxmlType = importerType;
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block67: {
                var1_1 = this.url.toExternalForm();
                var2_2 = var1_1.substring(var1_1.lastIndexOf(47) + 1);
                var3_3 = var2_2.substring(var2_2.lastIndexOf(46) + 1);
                var4_4 /* !! */  = null;
                var5_5 = null;
                var6_6 = null;
                var7_7 = null;
                var8_8 = null;
                if (var3_3.equalsIgnoreCase("3ds")) {
                    if (ModelBrowserFrame.access$3700(ModelBrowserFrame.this) == null) {
                        ModelBrowserFrame.access$3702(ModelBrowserFrame.this, new TdsModelImporter());
                    }
                    try {
                        ModelBrowserFrame.access$3700(ModelBrowserFrame.this).read(this.url);
                        var5_5 = ModelBrowserFrame.access$3700(ModelBrowserFrame.this).getImport();
                        var6_6 = ModelBrowserFrame.access$3700(ModelBrowserFrame.this).getImageFilePaths();
                        var4_4 /* !! */  = ImporterType.TDS;
                    }
                    catch (ImportException var9_9) {
                        ModelBrowserFrame.access$3800(ModelBrowserFrame.this, var9_9, this.url);
                        return;
                    }
                    finally {
                        ModelBrowserFrame.access$3902(ModelBrowserFrame.this, true);
                    }
                }
                if (var3_3.equalsIgnoreCase("dae") || var3_3.equalsIgnoreCase("zae")) {
                    if (ModelBrowserFrame.access$4000(ModelBrowserFrame.this) == null) {
                        ModelBrowserFrame.access$4002(ModelBrowserFrame.this, new ColModelImporter());
                    }
                    try {
                        ModelBrowserFrame.access$4000(ModelBrowserFrame.this).read(this.url);
                        var5_5 = ModelBrowserFrame.access$4000(ModelBrowserFrame.this).getImport();
                        var6_6 = ModelBrowserFrame.access$4000(ModelBrowserFrame.this).getImageFilePaths();
                        var4_4 /* !! */  = ImporterType.COL;
                        var8_8 = ModelBrowserFrame.access$4000(ModelBrowserFrame.this).getCamLights();
                        var9_10 /* !! */  = ModelBrowserFrame.access$4000(ModelBrowserFrame.this).getViewpoints();
                        if (var9_10 /* !! */  == null) ** GOTO lbl190
                        var7_7 = new ModelBrowserVP[((TriangleMesh)var9_10 /* !! */ ).length];
                        var10_17 = 0;
                        for (Node var14_41 : var9_10 /* !! */ ) {
                            var7_7[var10_17++] = new ModelBrowserVP((Viewpoint)var14_41);
                        }
                    }
                    catch (ImportException var9_11) {
                        ModelBrowserFrame.access$3800(ModelBrowserFrame.this, var9_11, this.url);
                        return;
                    }
                    finally {
                        ModelBrowserFrame.access$4102(ModelBrowserFrame.this, true);
                    }
                } else {
                    if (var3_3.equalsIgnoreCase("obj")) {
                        if (ModelBrowserFrame.access$4200(ModelBrowserFrame.this) == null) {
                            ModelBrowserFrame.access$4202(ModelBrowserFrame.this, new ObjModelImporter());
                        }
                        try {
                            ModelBrowserFrame.access$4200(ModelBrowserFrame.this).read(this.url);
                            var5_5 = ModelBrowserFrame.access$4200(ModelBrowserFrame.this).getImport();
                            var6_6 = ModelBrowserFrame.access$4200(ModelBrowserFrame.this).getImageFilePaths();
                            var4_4 /* !! */  = ImporterType.OBJ;
                        }
                        catch (ImportException var9_12) {
                            ModelBrowserFrame.access$3800(ModelBrowserFrame.this, var9_12, this.url);
                            return;
                        }
                        finally {
                            ModelBrowserFrame.access$4302(ModelBrowserFrame.this, true);
                        }
                    }
                    if (var3_3.equalsIgnoreCase("x3d") || var3_3.equalsIgnoreCase("x3dz")) {
                        if (ModelBrowserFrame.access$4400(ModelBrowserFrame.this) == null) {
                            ModelBrowserFrame.access$4402(ModelBrowserFrame.this, new X3dModelImporter());
                        }
                        try {
                            ModelBrowserFrame.access$4400(ModelBrowserFrame.this).read(this.url);
                            var5_5 = ModelBrowserFrame.access$4400(ModelBrowserFrame.this).getImport();
                            var6_6 = ModelBrowserFrame.access$4400(ModelBrowserFrame.this).getImageFilePaths();
                            var4_4 /* !! */  = ImporterType.X3D;
                            var8_8 = ModelBrowserFrame.access$4400(ModelBrowserFrame.this).getCamLights();
                            var9_10 /* !! */  = ModelBrowserFrame.access$4400(ModelBrowserFrame.this).getViewpoints();
                            if (var9_10 /* !! */  == null) ** GOTO lbl190
                            var7_7 = new ModelBrowserVP[((Node)var9_10 /* !! */ ).length];
                            var10_18 = 0;
                            for (Node var14_42 : var9_10 /* !! */ ) {
                                var7_7[var10_18++] = new ModelBrowserVP((Viewpoint)var14_42);
                            }
                        }
                        catch (ImportException var9_13) {
                            ModelBrowserFrame.access$3800(ModelBrowserFrame.this, var9_13, this.url);
                            return;
                        }
                        finally {
                            ModelBrowserFrame.access$4502(ModelBrowserFrame.this, true);
                        }
                    } else if (var3_3.equalsIgnoreCase("stl")) {
                        if (ModelBrowserFrame.access$4600(ModelBrowserFrame.this) == null) {
                            ModelBrowserFrame.access$4602(ModelBrowserFrame.this, new StlMeshImporter());
                            ModelBrowserFrame.access$4600(ModelBrowserFrame.this).setCreaseAngle(28.0);
                        }
                        try {
                            ModelBrowserFrame.access$4600(ModelBrowserFrame.this).read(this.url);
                            var9_10 /* !! */  = ModelBrowserFrame.access$4600(ModelBrowserFrame.this).getImport();
                            if (var9_10 /* !! */  == null) ** GOTO lbl190
                            var10_19 = new MeshView((Mesh)var9_10 /* !! */ );
                            var5_5 = new Node[]{var10_19};
                            var4_4 /* !! */  = ImporterType.Stl;
                        }
                        catch (ImportException var9_14) {
                            ModelBrowserFrame.access$3800(ModelBrowserFrame.this, var9_14, this.url);
                            return;
                        }
                        finally {
                            ModelBrowserFrame.access$4702(ModelBrowserFrame.this, true);
                        }
                    } else if (var3_3.equalsIgnoreCase("fxml")) {
                        try {
                            var9_10 /* !! */  = null;
                            if (this.fxmlType == ImporterType.FXML_IMPORTER) {
                                if (ModelBrowserFrame.access$4800(ModelBrowserFrame.this) == null) {
                                    ModelBrowserFrame.access$4802(ModelBrowserFrame.this, new FxmlModelImporter());
                                }
                                try {
                                    ModelBrowserFrame.access$4800(ModelBrowserFrame.this).read(this.url);
                                    var9_10 /* !! */  = ModelBrowserFrame.access$4800(ModelBrowserFrame.this).getImport();
                                    if (var9_10 /* !! */  == null) ** GOTO lbl150
                                    var6_6 = ModelBrowserFrame.access$4800(ModelBrowserFrame.this).getImageFilePaths();
                                    var8_8 = ModelBrowserFrame.access$4800(ModelBrowserFrame.this).getCamLights();
                                    var10_20 = ModelBrowserFrame.access$4800(ModelBrowserFrame.this).getViewpoints();
                                    if (var10_20 == null) ** GOTO lbl150
                                    var7_7 = new ModelBrowserVP[((Viewpoint[])var10_20).length];
                                    var11_26 = 0;
                                    for (Object var15_47 : var10_20) {
                                        var7_7[var11_26++] = new ModelBrowserVP((Viewpoint)var15_47);
                                    }
                                }
                                catch (ImportException var10_21) {
                                    ModelBrowserFrame.access$3800(ModelBrowserFrame.this, var10_21, this.url);
                                    return;
                                }
                                finally {
                                    ModelBrowserFrame.access$4902(ModelBrowserFrame.this, true);
                                }
                            } else if (this.fxmlType == ImporterType.FXML_LOADER) {
                                try {
                                    var10_20 = new FXMLLoader();
                                    var10_20.setLocation(this.url);
                                    var9_10 /* !! */  = var10_20.load();
                                }
                                catch (Exception var10_22) {
                                    throw new ImportException("FXMLLoader : load() failed due to = \n  " + var10_22.getMessage(), var10_22);
                                }
                            } else {
                                throw new ImportException("fxmlType = " + (Object)this.fxmlType);
                            }
lbl150:
                            // 4 sources

                            if (var9_10 /* !! */  != null) {
                                var4_4 /* !! */  = this.fxmlType;
                                if (var9_10 /* !! */  instanceof Group) {
                                    var5_5 = new Node[]{(Group)var9_10 /* !! */ };
                                    if (this.fxmlType == ImporterType.FXML_LOADER) {
                                        var10_20 = new ArrayList<E>();
                                        ModelBrowserFrame.access$5000(ModelBrowserFrame.this, (Group)var9_10 /* !! */ , (ArrayList)var10_20);
                                        var11_27 = new ArrayList<Camera>();
                                        if (!var10_20.isEmpty()) {
                                            var8_8 = new Node[var10_20.size()];
                                            var12_32 = 0;
                                            var13_38 = var10_20.iterator();
                                            while (var13_38.hasNext()) {
                                                var14_44 = (Node)var13_38.next();
                                                var8_8[var12_32++] = var14_44;
                                                if (!(var14_44 instanceof Camera)) continue;
                                                var11_27.add((Camera)var14_44);
                                            }
                                        }
                                        if ((var12_33 = var11_27.size()) > 0) {
                                            var7_7 = new ModelBrowserVP[var12_33];
                                            for (var13_39 = 0; var13_39 < var12_33; ++var13_39) {
                                                var14_45 = (Camera)var11_27.get(var13_39);
                                                var7_7[var13_39] = new ModelBrowserVP(var14_45, ModelBrowserFrame.access$5100(ModelBrowserFrame.this, var14_45));
                                            }
                                        }
                                    }
                                    break block67;
                                }
                                if (var9_10 /* !! */  instanceof Shape3D) {
                                    var5_5 = new Node[]{(Shape3D)var9_10 /* !! */ };
                                    break block67;
                                }
                                if (var9_10 /* !! */  instanceof Mesh) {
                                    var10_20 = new MeshView((Mesh)var9_10 /* !! */ );
                                    var5_5 = new Node[]{var10_20};
                                    break block67;
                                }
                                throw new ImportException("FXML root node isn't supported by ModelBrowserJFX = \n\n" + var9_10 /* !! */ );
                            }
                            if (this.fxmlType == ImporterType.FXML_IMPORTER) {
                                throw new ImportException("FxmlModelImorterJFX : getImport() returned null !");
                            }
                            throw new ImportException("FXMLLoader : load() returned null !");
                        }
                        catch (Exception var9_15) {
                            ModelBrowserFrame.access$3800(ModelBrowserFrame.this, var9_15, this.url);
                            return;
                        }
                    }
                }
            }
            if (var7_7 != null && var7_7.length > 0) {
                Arrays.sort(var7_7, new ModelBrowserVP.CompVP());
            }
            var9_10 /* !! */  = var4_4 /* !! */ ;
            var10_23 = var5_5;
            var11_28 = var6_6;
            var12_34 = var8_8;
            var13_40 = var7_7;
            Platform.runLater((Runnable)new Runnable((ImporterType)var9_10 /* !! */ , var11_28, var13_40, var2_2, var12_34){
                final /* synthetic */ ImporterType val$impTypef;
                final /* synthetic */ Map val$impImagePathMapf;
                final /* synthetic */ ModelBrowserVP[] val$vpsf;
                final /* synthetic */ String val$fileName;
                final /* synthetic */ Node[] val$camLihgtsf;
                {
                    this.val$impTypef = importerType;
                    this.val$impImagePathMapf = map;
                    this.val$vpsf = modelBrowserVPArray;
                    this.val$fileName = string;
                    this.val$camLihgtsf = nodeArray2;
                }

                @Override
                public void run() {
                    if (ModelBrowserFrame.this.isReadDurUpdateTimer) {
                        ModelBrowserFrame.this.readDurUpdateTimer.stop();
                    }
                    if (var10_23 != null && var10_23.length > 0) {
                        try {
                            ModelBrowserFrame.this.subScene3D.setImporterType(this.val$impTypef);
                            ModelBrowserFrame.this.subScene3D.setImagePathMap(this.val$impImagePathMapf);
                            ModelBrowserFrame.this.subScene3D.setViewpoints(this.val$vpsf);
                            ModelBrowserFrame.this.subScene3D.importNodes(var10_23, Loader.this.url, this.val$fileName, this.val$camLihgtsf, ModelBrowserFrame.this.importText, true);
                            ModelBrowserFrame.this.sceneTree.setup(ModelBrowserFrame.this.subScene3D.getSceneTreeRoot());
                            if (ModelBrowserFrame.this.saveItemFXML.isDisable() != (this.val$impTypef == ImporterType.FXML_LOADER)) {
                                ModelBrowserFrame.this.saveItemFXML.setDisable(!ModelBrowserFrame.this.saveItemFXML.isDisable());
                                ModelBrowserFrame.this.menuCombo.getItems().set(2, (Object)ModelBrowserFrame.this.saveItemFXML);
                            }
                            ModelBrowserFrame.this.setViewpointMenuButton(this.val$vpsf);
                        }
                        catch (Exception exception) {
                            ModelBrowserFrame.this.showExceptionDialog(exception, Loader.this.url.toExternalForm());
                        }
                    } else if (var10_23 == null) {
                        System.out.println("(importsf == null)");
                    } else {
                        System.out.println("importsf.length = " + var10_23.length);
                    }
                    ModelBrowserFrame.this.consumeInputEvents(false);
                }
            });
        }
    }

    private static final class VpButton
    extends Button {
        private final VP vp;

        private VpButton(VP vP, EventHandler<ActionEvent> eventHandler, VpButton vpButton) {
            super(vP.getListName());
            this.vp = vP;
            this.getStyleClass().add((Object)"button-vp");
            this.setOnAction(eventHandler);
            this.setTooltip(new Tooltip(vP.getTooltip()));
            this.setMaxWidth(Double.MAX_VALUE);
            if (vpButton != null) {
                this.prefWidthProperty().bind((ObservableValue)vpButton.widthProperty());
            }
        }
    }

    private abstract class VPItem
    extends ComboItem {
        private final ModelBrowserVP vp;

        private VPItem(ModelBrowserVP modelBrowserVP) {
            super(modelBrowserVP.getName(), null);
            this.vp = modelBrowserVP;
        }

        ModelBrowserVP getVP() {
            return this.vp;
        }
    }

    final class SeparatorItem
    extends ComboItem {
        private SeparatorItem() {
            super(null, (Node)new Separator());
            this.isDisabled = true;
        }

        @Override
        void handle() {
        }

        @Override
        double getPrefHeight() {
            return 7.0;
        }

        @Override
        double getOpacity() {
            return 1.0;
        }
    }

    final class PromptItem
    extends ComboItem {
        private PromptItem(String string) {
            super(string, null);
        }

        @Override
        void handle() {
        }

        @Override
        double getPrefHeight() {
            return 0.0;
        }
    }

    private abstract class ComboItem {
        private final String text;
        private final Node graphic;
        boolean isDisabled = false;

        ComboItem(String string, Node node) {
            this.text = string;
            this.graphic = node;
        }

        abstract void handle();

        private Node getGraphic() {
            return this.graphic;
        }

        private String getText() {
            return this.text;
        }

        double getPrefHeight() {
            return cellHeight;
        }

        private void setDisable(boolean bl) {
            this.isDisabled = bl;
        }

        private boolean isDisable() {
            return this.isDisabled;
        }

        double getOpacity() {
            if (this.isDisabled) {
                return 0.4;
            }
            return 1.0;
        }

        public String toString() {
            return this.text;
        }
    }
}

