/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.modelbrowser;

import com.interactivemesh.jfx.modelbrowser.ModelBrowserSubScene;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.Circle;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

final class ModelBrowserSceneTree {
    private static final NumberFormat numFormatFaces = NumberFormat.getIntegerInstance();
    private final TreeTableView<Node> treeTableView;
    private NodeTreeItem currRootItem = null;
    private Group currRoot = null;
    private double colIdWidth = 250.0;
    private double colTrfWidth = 78.0;
    private double colFaceWidth = 79.0;
    private double colMapWidth = 81.0;
    private final SceneTreeContextMenu stContextMenu;
    private final Background bg = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.web((String)"0xc9c9c9"), null, null)});
    private ModelBrowserSubScene currSubScene = null;
    private final String cssUrlString;

    ModelBrowserSceneTree(String string) {
        this.treeTableView = new TreeTableView();
        this.treeTableView.setShowRoot(false);
        this.createSceneTreeTable();
        this.stContextMenu = new SceneTreeContextMenu();
        this.treeTableView.setContextMenu((ContextMenu)this.stContextMenu);
        this.cssUrlString = string;
    }

    TreeTableView<Node> getTreePane() {
        return this.treeTableView;
    }

    void setup(ModelBrowserSubScene modelBrowserSubScene) {
        this.currSubScene = modelBrowserSubScene;
    }

    void setup(Group group) {
        this.currRoot = group;
        this.currRootItem = new NodeTreeItem((Node)group);
        this.currRootItem.setExpanded(true);
        this.treeTableView.setRoot((TreeItem)this.currRootItem);
        ObservableList<TreeItem<Node>> observableList = this.currRootItem.getChildren();
        if (observableList.size() == 1) {
            ((TreeItem)observableList.get(0)).setExpanded(true);
        }
        this.treeTableView.getSelectionModel().clearSelection();
    }

    private void expandRoots(boolean bl) {
        ObservableList<TreeItem<Node>> observableList = this.currRootItem.getChildren();
        for (TreeItem treeItem : observableList) {
            if (treeItem.isLeaf()) continue;
            this.expandGroup((TreeItem<Node>)treeItem, bl);
            treeItem.setExpanded(bl);
        }
    }

    private void expandSelectedGroup(boolean bl) {
        TreeItem treeItem = (TreeItem)this.treeTableView.getSelectionModel().getSelectedItem();
        if (treeItem != null && !treeItem.isLeaf() && treeItem != this.currRootItem) {
            this.expandGroup((TreeItem<Node>)treeItem, bl);
            treeItem.setExpanded(bl);
        }
    }

    private void expandGroup(TreeItem<Node> treeItem, boolean bl) {
        ObservableList observableList = treeItem.getChildren();
        for (TreeItem treeItem2 : observableList) {
            if (treeItem2.isLeaf()) continue;
            this.expandGroup((TreeItem<Node>)treeItem2, bl);
            treeItem2.setExpanded(bl);
        }
    }

    private void showHideSubGraph(TreeItem<Node> treeItem, boolean bl) {
        ObservableList observableList = treeItem.getChildren();
        for (TreeItem treeItem2 : observableList) {
            if (treeItem2.isLeaf()) {
                Node node = (Node)treeItem2.getValue();
                if (!(node instanceof Shape3D)) continue;
                node.setVisible(bl);
                continue;
            }
            this.showHideSubGraph((TreeItem<Node>)treeItem2, bl);
        }
    }

    private void fillLineSubGraph(TreeItem<Node> treeItem, DrawMode drawMode) {
        ObservableList observableList = treeItem.getChildren();
        for (TreeItem treeItem2 : observableList) {
            if (treeItem2.isLeaf()) {
                Node node = (Node)treeItem2.getValue();
                if (!(node instanceof Shape3D)) continue;
                ((Shape3D)node).setDrawMode(drawMode);
                continue;
            }
            this.fillLineSubGraph((TreeItem<Node>)treeItem2, drawMode);
        }
    }

    void selectNode(Node node) {
        Group group;
        int n;
        this.treeTableView.getSelectionModel().clearSelection();
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (Parent parent = node.getParent(); parent != null && parent != this.currRoot; parent = parent.getParent()) {
            arrayList.add((Group)parent);
        }
        NodeTreeItem nodeTreeItem = this.currRootItem;
        nodeTreeItem.setExpanded(true);
        ObservableList observableList = this.currRootItem.getChildren();
        int n2 = arrayList.size();
        if (n2 > 0) {
            for (n = n2 - 1; n >= 0; --n) {
                group = (Group)arrayList.get(n);
                for (TreeItem treeItem : observableList) {
                    if (treeItem.getValue() != group) continue;
                    nodeTreeItem = treeItem;
                    break;
                }
                nodeTreeItem.setExpanded(true);
                observableList = nodeTreeItem.getChildren();
            }
        }
        n = 0;
        group = null;
        for (TreeItem treeItem : observableList) {
            ++n;
            if (treeItem.getValue() != node) continue;
            group = treeItem;
            break;
        }
        int n3 = this.treeTableView.getRow((TreeItem)group);
        this.treeTableView.scrollTo(n3);
        this.treeTableView.getSelectionModel().select((Object)group);
        this.treeTableView.requestFocus();
    }

    private void createSceneTreeTable() {
        TreeTableColumn treeTableColumn = new TreeTableColumn("Id");
        treeTableColumn.setSortable(false);
        treeTableColumn.setPrefWidth(this.colIdWidth);
        EventHandler<MouseEvent> eventHandler = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                Object object;
                if (mouseEvent.getSource() == null || (object = ((TreeTableCell)mouseEvent.getSource()).getItem()) == null || object instanceof NodeTreeItem) {
                    // empty if block
                }
            }
        };
        treeTableColumn.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Node, NodeTreeItem>, ObservableValue<NodeTreeItem>>(){

            public ObservableValue<NodeTreeItem> call(TreeTableColumn.CellDataFeatures<Node, NodeTreeItem> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)cellDataFeatures.getValue());
            }
        });
        treeTableColumn.setCellFactory((Callback)new Callback<TreeTableColumn<Node, NodeTreeItem>, TreeTableCell<Node, NodeTreeItem>>((EventHandler)eventHandler){
            final /* synthetic */ EventHandler val$onMouseClickedNode;
            {
                this.val$onMouseClickedNode = eventHandler;
            }

            public TreeTableCell<Node, NodeTreeItem> call(TreeTableColumn<Node, NodeTreeItem> treeTableColumn) {
                return new TreeTableCell<Node, NodeTreeItem>(){

                    protected void updateItem(NodeTreeItem nodeTreeItem, boolean bl) {
                        super.updateItem((Object)nodeTreeItem, bl);
                        if (nodeTreeItem == null || bl) {
                            this.setText("   ");
                            this.setGraphic(null);
                        } else {
                            this.setText(nodeTreeItem.getId());
                            Node node = nodeTreeItem.getGraphicNode();
                            this.setGraphic(node);
                            this.setOnMouseClicked(val$onMouseClickedNode);
                        }
                    }
                };
            }
        });
        TreeTableColumn treeTableColumn2 = new TreeTableColumn("Transforms");
        treeTableColumn2.setSortable(false);
        treeTableColumn2.setPrefWidth(this.colTrfWidth);
        treeTableColumn2.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Node, NodeTreeItem>, ObservableValue<NodeTreeItem>>(){

            public ObservableValue<NodeTreeItem> call(TreeTableColumn.CellDataFeatures<Node, NodeTreeItem> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)cellDataFeatures.getValue());
            }
        });
        treeTableColumn2.setCellFactory((Callback)new Callback<TreeTableColumn<Node, NodeTreeItem>, TreeTableCell<Node, NodeTreeItem>>(){

            public TreeTableCell<Node, NodeTreeItem> call(TreeTableColumn<Node, NodeTreeItem> treeTableColumn) {
                return new TreeTableCell<Node, NodeTreeItem>(){
                    {
                        this.setAlignment(Pos.CENTER);
                    }

                    protected void updateItem(NodeTreeItem nodeTreeItem, boolean bl) {
                        super.updateItem((Object)nodeTreeItem, bl);
                        if (nodeTreeItem == null || bl) {
                            this.setText("     ");
                        } else {
                            this.setText(nodeTreeItem.getTransforms());
                        }
                    }
                };
            }
        });
        TreeTableColumn treeTableColumn3 = new TreeTableColumn("Faces");
        treeTableColumn3.setSortable(false);
        treeTableColumn3.setPrefWidth(this.colFaceWidth);
        treeTableColumn3.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Node, NodeTreeItem>, ObservableValue<NodeTreeItem>>(){

            public ObservableValue<NodeTreeItem> call(TreeTableColumn.CellDataFeatures<Node, NodeTreeItem> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)cellDataFeatures.getValue());
            }
        });
        treeTableColumn3.setCellFactory((Callback)new Callback<TreeTableColumn<Node, NodeTreeItem>, TreeTableCell<Node, NodeTreeItem>>(){

            public TreeTableCell<Node, NodeTreeItem> call(TreeTableColumn<Node, NodeTreeItem> treeTableColumn) {
                return new TreeTableCell<Node, NodeTreeItem>(){
                    {
                        this.setAlignment(Pos.CENTER_RIGHT);
                    }

                    protected void updateItem(NodeTreeItem nodeTreeItem, boolean bl) {
                        super.updateItem((Object)nodeTreeItem, bl);
                        if (nodeTreeItem == null || bl) {
                            this.setText("     ");
                        } else {
                            this.setText(nodeTreeItem.getFaces());
                        }
                    }
                };
            }
        });
        TreeTableColumn treeTableColumn4 = new TreeTableColumn("Maps");
        treeTableColumn4.setSortable(false);
        treeTableColumn4.setPrefWidth(this.colMapWidth);
        treeTableColumn4.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<Node, NodeTreeItem>, ObservableValue<NodeTreeItem>>(){

            public ObservableValue<NodeTreeItem> call(TreeTableColumn.CellDataFeatures<Node, NodeTreeItem> cellDataFeatures) {
                return new ReadOnlyObjectWrapper((Object)cellDataFeatures.getValue());
            }
        });
        treeTableColumn4.setCellFactory((Callback)new Callback<TreeTableColumn<Node, NodeTreeItem>, TreeTableCell<Node, NodeTreeItem>>(){

            public TreeTableCell<Node, NodeTreeItem> call(TreeTableColumn<Node, NodeTreeItem> treeTableColumn) {
                return new TreeTableCell<Node, NodeTreeItem>(){
                    {
                        this.setAlignment(Pos.CENTER);
                    }

                    protected void updateItem(NodeTreeItem nodeTreeItem, boolean bl) {
                        super.updateItem((Object)nodeTreeItem, bl);
                        if (nodeTreeItem == null || bl) {
                            this.setText("     ");
                        } else {
                            this.setText(nodeTreeItem.getMaps());
                        }
                    }
                };
            }
        });
        this.treeTableView.getColumns().setAll((Object[])new TreeTableColumn[]{treeTableColumn, treeTableColumn2, treeTableColumn3, treeTableColumn4});
    }

    static {
        numFormatFaces.setGroupingUsed(true);
    }

    public final class NodeTreeItem
    extends TreeItem<Node> {
        private String id;
        private String faces;
        private String maps;
        private String transforms;
        private boolean isCamera;
        private boolean isLight;
        private boolean isShape3D;
        private boolean isGroup;
        private boolean hasNoChildren;
        private boolean isChildrenFirstTime;

        public NodeTreeItem(Node node) {
            super((Object)node);
            this.id = null;
            this.faces = null;
            this.maps = null;
            this.transforms = null;
            this.isCamera = false;
            this.isLight = false;
            this.isShape3D = false;
            this.isGroup = false;
            this.hasNoChildren = false;
            this.isChildrenFirstTime = true;
            if (node instanceof Shape3D) {
                this.isShape3D = true;
            } else if (node instanceof LightBase) {
                this.isLight = true;
            } else if (node instanceof Camera) {
                this.isCamera = true;
            } else if (node instanceof Group) {
                this.isGroup = true;
            }
        }

        public String toString() {
            return ((Node)this.getValue()).toString();
        }

        public boolean isLeaf() {
            return !this.isGroup || this.hasNoChildren;
        }

        private boolean isNodeVisisble() {
            return ((Node)this.getValue()).isVisible();
        }

        private String getId() {
            if (this.id == null) {
                this.id = ((Node)this.getValue()).getId();
                if (this.id == null || this.id.length() < 1) {
                    this.id = "na";
                }
            }
            return this.id;
        }

        private Node getGraphicNode() {
            Node node = (Node)this.getValue();
            Rectangle rectangle = null;
            if (this.isGroup) {
                rectangle = new Rectangle(0.0, 0.0, 12.0, 9.0);
                if (node.isVisible()) {
                    rectangle.setFill((Paint)Color.rgb((int)255, (int)226, (int)0));
                } else {
                    rectangle.setFill(null);
                    rectangle.setStroke((Paint)Color.rgb((int)255, (int)226, (int)0));
                    rectangle.setStrokeWidth(1.0);
                }
            } else {
                Color color = null;
                if (this.isShape3D) {
                    color = Color.DODGERBLUE;
                } else if (this.isLight) {
                    color = Color.ORANGE;
                } else if (this.isCamera) {
                    color = Color.GREEN;
                }
                if (color != null) {
                    rectangle = new Circle(5.0, 6.0, 5.0);
                    if (node.isVisible()) {
                        if (this.isShape3D) {
                            if (((Shape3D)this.getValue()).getDrawMode() == DrawMode.LINE) {
                                Arc arc = new Arc(5.0, 6.0, 5.0, 5.0, 0.0, 120.0);
                                arc.setType(ArcType.ROUND);
                                arc.setFill(null);
                                arc.setStroke((Paint)color);
                                arc.setStrokeWidth(0.8);
                                Arc arc2 = new Arc(5.0, 6.0, 5.0, 5.0, 120.0, 120.0);
                                arc2.setType(ArcType.ROUND);
                                arc2.setFill(null);
                                arc2.setStroke((Paint)color);
                                arc2.setStrokeWidth(0.8);
                                Arc arc3 = new Arc(5.0, 6.0, 5.0, 5.0, 240.0, 120.0);
                                arc3.setType(ArcType.ROUND);
                                arc3.setFill(null);
                                arc3.setStroke((Paint)color);
                                arc3.setStrokeWidth(0.8);
                                rectangle = new Pane();
                                ((Pane)rectangle).getChildren().addAll((Object[])new Node[]{arc, arc2, arc3});
                            } else {
                                ((Circle)rectangle).setFill((Paint)color);
                                ((Circle)rectangle).setStroke((Paint)color);
                                ((Circle)rectangle).setStrokeWidth(0.8);
                            }
                        } else if (this.isLight) {
                            if (((LightBase)this.getValue()).isLightOn()) {
                                ((Circle)rectangle).setFill((Paint)color);
                                ((Circle)rectangle).setStroke((Paint)color);
                                ((Circle)rectangle).setStrokeWidth(0.8);
                            } else {
                                ((Circle)rectangle).setFill(null);
                                ((Circle)rectangle).setStroke((Paint)color);
                                ((Circle)rectangle).setStrokeWidth(0.8);
                            }
                        } else {
                            ((Circle)rectangle).setFill((Paint)color);
                            ((Circle)rectangle).setStroke((Paint)color);
                            ((Circle)rectangle).setStrokeWidth(0.8);
                        }
                    } else {
                        ((Circle)rectangle).setFill(null);
                        ((Circle)rectangle).setStroke((Paint)color);
                        ((Circle)rectangle).setStrokeWidth(0.8);
                    }
                } else {
                    rectangle = new Rectangle(0.0, 0.0, 12.0, 9.0);
                    rectangle.setFill((Paint)Color.TRANSPARENT);
                }
            }
            return rectangle;
        }

        private String getFaces() {
            if (this.faces == null) {
                Mesh mesh;
                Node node = (Node)this.getValue();
                if (node instanceof MeshView && (mesh = ((MeshView)node).getMesh()) != null && mesh instanceof TriangleMesh) {
                    int n = ((TriangleMesh)mesh).getFaces().size() / ((TriangleMesh)mesh).getFaceElementSize();
                    this.faces = numFormatFaces.format(n);
                }
                if (this.faces == null) {
                    this.faces = "     ";
                }
            }
            return this.faces;
        }

        private String getMaps() {
            if (this.maps == null) {
                Material material;
                Node node = (Node)this.getValue();
                if (node instanceof Shape3D && (material = ((Shape3D)node).getMaterial()) instanceof PhongMaterial) {
                    PhongMaterial phongMaterial = (PhongMaterial)material;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (phongMaterial.getBumpMap() != null) {
                        stringBuilder.append("B ");
                    }
                    if (phongMaterial.getDiffuseMap() != null) {
                        stringBuilder.append("D ");
                    }
                    if (phongMaterial.getSelfIlluminationMap() != null) {
                        stringBuilder.append("Se ");
                    }
                    if (phongMaterial.getSpecularMap() != null) {
                        stringBuilder.append("Sp ");
                    }
                    if (stringBuilder.length() > 0) {
                        this.maps = stringBuilder.substring(0, stringBuilder.length() - 1);
                    }
                }
                if (this.maps == null) {
                    this.maps = "     ";
                }
            }
            return this.maps;
        }

        private String getTransforms() {
            if (this.transforms == null) {
                ObservableList observableList = ((Node)this.getValue()).getTransforms();
                if (!observableList.isEmpty()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (Transform transform : observableList) {
                        if (transform instanceof Translate) {
                            stringBuilder.append("T ");
                            continue;
                        }
                        if (transform instanceof Rotate) {
                            stringBuilder.append("R ");
                            continue;
                        }
                        if (transform instanceof Scale) {
                            stringBuilder.append("S ");
                            continue;
                        }
                        if (!(transform instanceof Affine)) continue;
                        stringBuilder.append("A ");
                    }
                    if (stringBuilder.length() > 0) {
                        this.transforms = stringBuilder.substring(0, stringBuilder.length() - 1);
                    }
                }
                if (this.transforms == null) {
                    this.transforms = "     ";
                }
            }
            return this.transforms;
        }

        public ObservableList<TreeItem<Node>> getChildren() {
            if (this.isChildrenFirstTime) {
                this.isChildrenFirstTime = false;
                ObservableList observableList = null;
                if (this.isGroup) {
                    observableList = FXCollections.observableArrayList();
                    ObservableList observableList2 = ((Group)this.getValue()).getChildren();
                    for (Node node : observableList2) {
                        NodeTreeItem nodeTreeItem = new NodeTreeItem(node);
                        observableList.add((Object)nodeTreeItem);
                        if (!(node instanceof Group)) continue;
                        nodeTreeItem.hasNoChildren = ((Group)node).getChildren().size() < 1;
                    }
                } else {
                    observableList = FXCollections.emptyObservableList();
                }
                super.getChildren().setAll((Collection)observableList);
            }
            return super.getChildren();
        }
    }

    private final class SceneTreeContextMenu
    extends ContextMenu {
        NodeTreeItem selectedItem = null;
        final MenuItem itemExpandGroup = new MenuItem("Expand");
        final MenuItem itemCollapseGroup = new MenuItem("Collapse");
        final MenuItem itemShowGroup = new MenuItem("Show");
        final MenuItem itemHideGroup = new MenuItem("Hide");
        final MenuItem itemFillGroup = new MenuItem("Shaded surface");
        final MenuItem itemLineGroup = new MenuItem("Wireframe");
        final MenuItem itemLookAtGroup = new MenuItem("Look at");
        final MenuItem itemLookAtShape = new MenuItem("Look at");
        final MenuItem itemShowShape = new MenuItem("Show");
        final MenuItem itemHideShape = new MenuItem("Hide");
        final MenuItem itemFillShape = new MenuItem("Shaded surface");
        final MenuItem itemLineShape = new MenuItem("Wireframe");
        final MenuItem itemOnOffLight = new MenuItem("TODO");
        final MenuItem itemClear = new MenuItem("Clear selection");

        SceneTreeContextMenu() {
            this.setOnShowing((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent windowEvent) {
                    int n;
                    if (ModelBrowserSceneTree.this.cssUrlString != null) {
                        SceneTreeContextMenu.this.getScene().getStylesheets().add((Object)ModelBrowserSceneTree.this.cssUrlString);
                    }
                    if ((n = ModelBrowserSceneTree.this.treeTableView.getSelectionModel().getSelectedIndex()) >= 0) {
                        SceneTreeContextMenu.this.selectedItem = (NodeTreeItem)((Object)ModelBrowserSceneTree.this.treeTableView.getSelectionModel().getSelectedItem());
                        if (SceneTreeContextMenu.this.selectedItem.isGroup) {
                            SceneTreeContextMenu.this.getItems().add((Object)new MenuSeparator("Sub-graph"));
                            SceneTreeContextMenu.this.getItems().addAll((Object[])new MenuItem[]{SceneTreeContextMenu.this.itemExpandGroup, SceneTreeContextMenu.this.itemCollapseGroup, new SeparatorMenuItem(), SceneTreeContextMenu.this.itemLookAtGroup, new SeparatorMenuItem(), SceneTreeContextMenu.this.itemHideGroup, SceneTreeContextMenu.this.itemShowGroup, new SeparatorMenuItem(), SceneTreeContextMenu.this.itemFillGroup, SceneTreeContextMenu.this.itemLineGroup});
                        } else if (SceneTreeContextMenu.this.selectedItem.isShape3D) {
                            SceneTreeContextMenu.this.getItems().add((Object)new MenuSeparator("Shape3D"));
                            if (SceneTreeContextMenu.this.selectedItem.isNodeVisisble()) {
                                SceneTreeContextMenu.this.getItems().add((Object)SceneTreeContextMenu.this.itemLookAtShape);
                                SceneTreeContextMenu.this.getItems().add((Object)SceneTreeContextMenu.this.itemHideShape);
                                if (((Shape3D)SceneTreeContextMenu.this.selectedItem.getValue()).getDrawMode() == DrawMode.FILL) {
                                    SceneTreeContextMenu.this.getItems().add((Object)SceneTreeContextMenu.this.itemLineShape);
                                } else {
                                    SceneTreeContextMenu.this.getItems().add((Object)SceneTreeContextMenu.this.itemFillShape);
                                }
                            } else {
                                SceneTreeContextMenu.this.getItems().add((Object)SceneTreeContextMenu.this.itemShowShape);
                            }
                        } else if (SceneTreeContextMenu.this.selectedItem.isLight) {
                            SceneTreeContextMenu.this.getItems().add((Object)new MenuSeparator("Light"));
                            if (((LightBase)SceneTreeContextMenu.this.selectedItem.getValue()).isLightOn()) {
                                SceneTreeContextMenu.this.itemOnOffLight.setText("Off");
                            } else {
                                SceneTreeContextMenu.this.itemOnOffLight.setText("On");
                            }
                            SceneTreeContextMenu.this.getItems().add((Object)SceneTreeContextMenu.this.itemOnOffLight);
                        }
                        SceneTreeContextMenu.this.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), SceneTreeContextMenu.this.itemClear});
                    }
                }
            });
            this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent windowEvent) {
                    SceneTreeContextMenu.this.getItems().remove(3, SceneTreeContextMenu.this.getItems().size());
                }
            });
            MenuItem menuItem = new MenuItem("Expand");
            menuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.expandRoots(true);
                    SceneTreeContextMenu.this.clearSelection();
                }
            });
            MenuItem menuItem2 = new MenuItem("Collapse");
            menuItem2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.expandRoots(false);
                    SceneTreeContextMenu.this.clearSelection();
                }
            });
            this.itemExpandGroup.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.expandSelectedGroup(true);
                }
            });
            this.itemCollapseGroup.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.expandSelectedGroup(false);
                }
            });
            this.getItems().addAll((Object[])new MenuItem[]{new MenuSeparator("Scene graph"), menuItem, menuItem2});
            this.itemLookAtGroup.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.currSubScene.setViewpoint((Node)SceneTreeContextMenu.this.selectedItem.getValue());
                }
            });
            this.itemLookAtShape.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.currSubScene.setViewpoint((Node)SceneTreeContextMenu.this.selectedItem.getValue());
                }
            });
            this.itemFillGroup.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.fillLineSubGraph((TreeItem<Node>)SceneTreeContextMenu.this.selectedItem, DrawMode.FILL);
                    SceneTreeContextMenu.this.repaintTable();
                }
            });
            this.itemLineGroup.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.fillLineSubGraph((TreeItem<Node>)SceneTreeContextMenu.this.selectedItem, DrawMode.LINE);
                    SceneTreeContextMenu.this.repaintTable();
                }
            });
            this.itemFillShape.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ((Shape3D)SceneTreeContextMenu.this.selectedItem.getValue()).setDrawMode(DrawMode.FILL);
                    SceneTreeContextMenu.this.repaintTable();
                }
            });
            this.itemLineShape.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ((Shape3D)SceneTreeContextMenu.this.selectedItem.getValue()).setDrawMode(DrawMode.LINE);
                    SceneTreeContextMenu.this.repaintTable();
                }
            });
            this.itemShowGroup.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.showHideSubGraph((TreeItem<Node>)SceneTreeContextMenu.this.selectedItem, true);
                    SceneTreeContextMenu.this.repaintTable();
                }
            });
            this.itemHideGroup.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ModelBrowserSceneTree.this.showHideSubGraph((TreeItem<Node>)SceneTreeContextMenu.this.selectedItem, false);
                    SceneTreeContextMenu.this.repaintTable();
                }
            });
            this.itemShowShape.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ((Node)SceneTreeContextMenu.this.selectedItem.getValue()).setVisible(true);
                    SceneTreeContextMenu.this.repaintTable();
                }
            });
            this.itemHideShape.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    ((Node)SceneTreeContextMenu.this.selectedItem.getValue()).setVisible(false);
                    SceneTreeContextMenu.this.repaintTable();
                }
            });
            this.itemOnOffLight.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    LightBase lightBase;
                    lightBase.setLightOn(!(lightBase = (LightBase)SceneTreeContextMenu.this.selectedItem.getValue()).isLightOn());
                    SceneTreeContextMenu.this.repaintTable();
                }
            });
            this.itemClear.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    SceneTreeContextMenu.this.clearSelection();
                }
            });
        }

        private void clearSelection() {
            ModelBrowserSceneTree.this.treeTableView.getSelectionModel().clearSelection();
        }

        private void repaintTable() {
            ((TreeTableColumn)ModelBrowserSceneTree.this.treeTableView.getColumns().get(0)).setVisible(false);
            ((TreeTableColumn)ModelBrowserSceneTree.this.treeTableView.getColumns().get(0)).setVisible(true);
        }
    }

    private final class MenuSeparator
    extends SeparatorMenuItem {
        private MenuSeparator(String string) {
            Node node = this.getContent();
            BorderPane borderPane = new BorderPane();
            Label label = new Label("  " + string + "  ");
            label.setBackground(ModelBrowserSceneTree.this.bg);
            borderPane.setCenter((Node)label);
            borderPane.setLeft((Node)new Label("    "));
            borderPane.setRight((Node)new Label("    "));
            StackPane stackPane = new StackPane();
            stackPane.getChildren().addAll((Object[])new Node[]{node, borderPane});
            this.setContent((Node)stackPane);
        }
    }
}

