/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.modelbrowser;

import com.interactivemesh.jfx.importer.FilePath;
import com.interactivemesh.jfx.importer.ImportException;
import com.interactivemesh.jfx.modelbrowser.ImporterType;
import com.interactivemesh.jfx.modelbrowser.ModelBrowserFrame;
import com.interactivemesh.jfx.modelbrowser.ModelBrowserVP;
import com.interactivemesh.jfx.modelbrowser.VP;
import com.interactivemesh.jfx.modelbrowser.ViewingAxes;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableFloatArray;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point3D;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.ImageCursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.canvas.Canvas;
import javafx.scene.image.Image;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.PickResult;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Material;
import javafx.scene.paint.Paint;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.ObservableFaceArray;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.text.Text;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;

final class ModelBrowserSubScene {
    private static final NumberFormat numFormatFaces = NumberFormat.getIntegerInstance();
    private static final double FOV = 44.0;
    private static final double MAX_CLIP_RATIO = 3000.0;
    private static final double ROT = 0.1;
    private static final double TRANS = 0.001;
    private static final double ZOOM = 0.00125;
    private double rotScale = 0.1;
    private double transScale = 0.001;
    private double zoomScale = 0.00125;
    private SubScene subScene = null;
    private Pane layeredPane = null;
    private final Group sceneTopGroup = new Group();
    private BoundingBox scene3DBinL = null;
    private double sceneDiameter = 0.0;
    private Point3D sceneCenter = null;
    private EventHandler<MouseEvent> rotPicker = null;
    private ImporterType currImpType = null;
    private URL currLoadedPath = null;
    private String currLoadedFileName = null;
    private Map<Image, FilePath> currImagePathMap = null;
    private final Group viewingGroup = new Group();
    private final Affine viewingRotate = new Affine();
    private final Translate viewingCenterTranslate = new Translate();
    private final Translate viewingCenterRevTranslate = new Translate();
    private final Translate viewingTranslate = new Translate();
    private double startX = 0.0;
    private double startY = 0.0;
    private double axisRadiusInit = 0.0;
    private double camDistInit = 0.0;
    private boolean isFirstClip = true;
    private PerspectiveCamera perspectiveCamera = null;
    private Transform concatViewTransform = null;
    private AmbientLight ambSceneLight = null;
    private PointLight headLight = null;
    private MouseButton currDraggingButton = null;
    private final Group axesGroup = new Group();
    private final Cylinder xAxis = new Cylinder(0.5, 1.0, 36);
    private final Cylinder yAxis = new Cylinder(0.5, 1.0, 36);
    private final Cylinder zAxis = new Cylinder(0.5, 1.0, 36);
    private Cursor rotCursor = null;
    private Cursor transCursor = null;
    private Cursor zoomCursor = null;
    private final ViewingAxes viewAxesController;
    private final Canvas viewAxesCanvas;
    private int bgVerticalPos = 30;
    private int bgColorScale = 50;
    private NumberFormat numFormat = null;
    private boolean isPickingOn = true;
    private boolean isPickingBounds = false;
    private RotCenter pickedShapeRotCenter = RotCenter.PICKEAD_SHAPE_CENTER;
    private boolean isLookAtCenter = true;
    private Group currImportRoot = null;
    private Node[] currImports = null;
    private ModelBrowserVP[] currViewpoints = null;
    private int currNumNodes = 0;
    private int currNumGroups = 0;
    private int currNumShape3Ds = 0;
    private int currNumTriangles = 0;
    private final ModelBrowserFrame browserFrame;

    ModelBrowserSubScene(ModelBrowserFrame modelBrowserFrame, SceneAntialiasing sceneAntialiasing) {
        this.browserFrame = modelBrowserFrame;
        this.createAxes();
        this.createViewingGroupAndLights();
        this.createSubScene(800.0, 600.0, sceneAntialiasing);
        this.viewAxesController = new ViewingAxes(300.0);
        this.viewAxesCanvas = this.viewAxesController.getCanvas();
        this.viewAxesCanvas.setMouseTransparent(true);
        this.numFormat = NumberFormat.getInstance(Locale.US);
        this.numFormat.setMaximumFractionDigits(7);
        this.numFormat.setMinimumFractionDigits(7);
        this.numFormat.setGroupingUsed(false);
    }

    Pane getSubScenePane() {
        if (this.layeredPane == null) {
            this.layeredPane = new Pane();
            this.layeredPane.getChildren().addAll((Object[])new Node[]{this.subScene, this.viewAxesCanvas});
            this.layeredPane.setMinSize(0.0, 0.0);
            ChangeListener<Number> changeListener = new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observableValue, Number number, Number number2) {
                    ModelBrowserSubScene.this.setSize(ModelBrowserSubScene.this.layeredPane.getWidth(), ModelBrowserSubScene.this.layeredPane.getHeight());
                }
            };
            this.layeredPane.widthProperty().addListener((ChangeListener)changeListener);
            this.layeredPane.heightProperty().addListener((ChangeListener)changeListener);
            Stop[] stopArray = new Stop[]{new Stop(0.0, Color.rgb((int)0, (int)73, (int)255)), new Stop(0.7, Color.rgb((int)127, (int)164, (int)255)), new Stop(1.0, Color.rgb((int)0, (int)73, (int)255))};
            LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, stopArray);
            Background background = new Background(new BackgroundFill[]{new BackgroundFill((Paint)linearGradient, null, null)});
            this.layeredPane.setBackground(background);
        }
        return this.layeredPane;
    }

    private void setSize(double d, double d2) {
        this.subScene.setWidth(d);
        this.subScene.setHeight(d2);
        this.viewAxesController.setSize(d2 / 7.5);
        this.viewAxesCanvas.relocate(0.0, d2 - d2 / 7.5);
    }

    void requestFocus() {
        if (this.layeredPane != null) {
            this.layeredPane.layout();
            this.layeredPane.requestFocus();
        }
    }

    void setBackground(Color color) {
        float f = (float)this.bgColorScale / 100.0f;
        Color color2 = new Color((double)((float)Math.min(color.getRed() + (1.0 - color.getRed()) * (double)f, 1.0)), (double)((float)Math.min(color.getGreen() + (1.0 - color.getGreen()) * (double)f, 1.0)), (double)((float)Math.min(color.getBlue() + (1.0 - color.getBlue()) * (double)f, 1.0)), 1.0);
        Stop[] stopArray = new Stop[]{new Stop(0.0, color), new Stop(0.7, color2), new Stop(1.0, color)};
        LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 0.0, 1.0, true, CycleMethod.NO_CYCLE, stopArray);
        Background background = new Background(new BackgroundFill[]{new BackgroundFill((Paint)linearGradient, null, null)});
        this.layeredPane.setBackground(background);
    }

    void setNavAxesVisible(boolean bl) {
        this.viewAxesCanvas.setVisible(bl);
    }

    void setSceneAxesVisible(boolean bl) {
        this.xAxis.setVisible(bl);
        this.yAxis.setVisible(bl);
        this.zAxis.setVisible(bl);
    }

    void enableHeadLight(boolean bl) {
        this.headLight.setLightOn(bl);
    }

    void enableAmbientLght(boolean bl) {
        this.ambSceneLight.setLightOn(bl);
    }

    void setPicking(boolean bl, boolean bl2) {
        this.isPickingOn = bl;
        this.sceneTopGroup.setMouseTransparent(!bl);
        if (bl) {
            this.isPickingBounds = bl2;
            this.setPickingState(this.sceneTopGroup);
        }
    }

    ImporterType getImporterType() {
        return this.currImpType;
    }

    void setImporterType(ImporterType importerType) {
        this.currImpType = importerType;
    }

    Path getCurrDirPath() {
        try {
            return Paths.get(this.currLoadedPath.toURI()).getParent();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return null;
        }
    }

    URL getCurrFile() {
        return this.currLoadedPath;
    }

    String getCurrFileName() {
        return this.currLoadedFileName;
    }

    Group getSceneTreeRoot() {
        return this.currImportRoot;
    }

    Node[] getRootForFxmlExport() {
        return this.currImports;
    }

    Map<Image, FilePath> getImagePathMap() {
        return this.currImagePathMap;
    }

    void setImagePathMap(Map<Image, FilePath> map) {
        this.currImagePathMap = map;
    }

    ModelBrowserVP[] getViewpoints() {
        return this.currViewpoints;
    }

    void setViewpoints(ModelBrowserVP[] modelBrowserVPArray) {
        this.currViewpoints = modelBrowserVPArray;
    }

    void setSceneAntialiasing(SceneAntialiasing sceneAntialiasing) {
        ((Group)this.subScene.getRoot()).getChildren().clear();
        this.subScene.setCamera(null);
        this.createSubScene(this.subScene.getWidth(), this.subScene.getHeight(), sceneAntialiasing);
        this.layeredPane.getChildren().set(0, (Object)this.subScene);
    }

    void initScene() {
        Image image = new Image(this.getClass().getResource("resources/rotCursor.png").toExternalForm());
        this.rotCursor = new ImageCursor(image, image.getWidth() / 2.0, image.getHeight() / 2.0);
        image = new Image(this.getClass().getResource("resources/translCursor.png").toExternalForm());
        this.transCursor = new ImageCursor(image, image.getWidth() / 2.0, image.getHeight() / 2.0);
        image = new Image(this.getClass().getResource("resources/zoomCursor.png").toExternalForm());
        this.zoomCursor = new ImageCursor(image, image.getWidth() / 2.0, image.getHeight() / 2.0);
    }

    private void createAxes() {
        this.xAxis.setRotationAxis(Rotate.Z_AXIS);
        this.xAxis.setRotate(90.0);
        PhongMaterial phongMaterial = new PhongMaterial(Color.RED);
        phongMaterial.setSpecularColor(Color.RED);
        phongMaterial.setSpecularPower(4.0);
        this.xAxis.setMaterial((Material)phongMaterial);
        PhongMaterial phongMaterial2 = new PhongMaterial(Color.LIMEGREEN);
        phongMaterial2.setSpecularColor(Color.LIMEGREEN);
        phongMaterial2.setSpecularPower(100.0);
        this.yAxis.setMaterial((Material)phongMaterial2);
        this.zAxis.setRotationAxis(Rotate.X_AXIS);
        this.zAxis.setRotate(90.0);
        PhongMaterial phongMaterial3 = new PhongMaterial(Color.STEELBLUE);
        phongMaterial3.setSpecularColor(Color.BLUE);
        phongMaterial3.setSpecularPower(4.0);
        this.zAxis.setMaterial((Material)phongMaterial3);
        this.axesGroup.getChildren().addAll((Object[])new Node[]{this.xAxis, this.yAxis, this.zAxis});
    }

    private void createViewingGroupAndLights() {
        this.perspectiveCamera = new PerspectiveCamera(true);
        this.perspectiveCamera.setVerticalFieldOfView(false);
        this.perspectiveCamera.setFieldOfView(44.0);
        this.headLight = new PointLight(Color.WHITE);
        this.headLight.setTranslateZ(-20000.0);
        this.ambSceneLight = new AmbientLight(Color.color((double)0.2, (double)0.2, (double)0.2));
        this.ambSceneLight.setLightOn(false);
        this.viewingGroup.getChildren().setAll((Object[])new Node[]{this.perspectiveCamera, this.headLight});
        this.viewingGroup.getTransforms().setAll((Object[])new Transform[]{this.viewingCenterTranslate, this.viewingRotate, this.viewingCenterRevTranslate, this.viewingTranslate});
    }

    private void createSubScene(double d, double d2, SceneAntialiasing sceneAntialiasing) {
        Group group = new Group();
        group.getStylesheets().clear();
        this.subScene = new SubScene((Parent)group, d, d2, true, sceneAntialiasing);
        this.subScene.setFill((Paint)Color.TRANSPARENT);
        this.subScene.setCamera((Camera)this.perspectiveCamera);
        group.getChildren().addAll((Object[])new Node[]{this.viewingGroup, this.ambSceneLight, this.axesGroup, this.sceneTopGroup});
        final Rotate rotate = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.X_AXIS);
        final Rotate rotate2 = new Rotate(0.0, 0.0, 0.0, 0.0, Rotate.Y_AXIS);
        this.subScene.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (ModelBrowserSubScene.this.currDraggingButton == MouseButton.PRIMARY) {
                    rotate.setAngle((ModelBrowserSubScene.this.startY - mouseEvent.getSceneY()) * ModelBrowserSubScene.this.rotScale);
                    rotate2.setAngle((mouseEvent.getSceneX() - ModelBrowserSubScene.this.startX) * ModelBrowserSubScene.this.rotScale);
                    ModelBrowserSubScene.this.viewingRotate.append(rotate.createConcatenation((Transform)rotate2));
                    ModelBrowserSubScene.this.viewAxesController.updateAxes((Transform)ModelBrowserSubScene.this.viewingRotate);
                } else if (ModelBrowserSubScene.this.currDraggingButton == MouseButton.SECONDARY) {
                    ModelBrowserSubScene.this.viewingTranslate.setX(ModelBrowserSubScene.this.viewingTranslate.getX() + (ModelBrowserSubScene.this.startX - mouseEvent.getSceneX()) * ModelBrowserSubScene.this.transScale);
                    ModelBrowserSubScene.this.viewingTranslate.setY(ModelBrowserSubScene.this.viewingTranslate.getY() + (ModelBrowserSubScene.this.startY - mouseEvent.getSceneY()) * ModelBrowserSubScene.this.transScale);
                } else if (ModelBrowserSubScene.this.currDraggingButton == MouseButton.MIDDLE) {
                    ModelBrowserSubScene.this.viewingTranslate.setZ(ModelBrowserSubScene.this.viewingTranslate.getZ() + (mouseEvent.getSceneY() - ModelBrowserSubScene.this.startY) * ModelBrowserSubScene.this.zoomScale);
                    ModelBrowserSubScene.this.setClipping();
                }
                ModelBrowserSubScene.this.startX = mouseEvent.getSceneX();
                ModelBrowserSubScene.this.startY = mouseEvent.getSceneY();
            }
        });
        this.subScene.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent scrollEvent) {
                ModelBrowserSubScene.this.viewingTranslate.setZ(ModelBrowserSubScene.this.viewingTranslate.getZ() - scrollEvent.getDeltaY() * ModelBrowserSubScene.this.zoomScale * 0.5);
                ModelBrowserSubScene.this.setClipping();
            }
        });
        this.subScene.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ModelBrowserSubScene.this.startX = mouseEvent.getSceneX();
                ModelBrowserSubScene.this.startY = mouseEvent.getSceneY();
                if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                    ModelBrowserSubScene.this.currDraggingButton = MouseButton.PRIMARY;
                    ModelBrowserSubScene.this.subScene.setCursor(ModelBrowserSubScene.this.rotCursor);
                } else if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                    ModelBrowserSubScene.this.currDraggingButton = MouseButton.SECONDARY;
                    ModelBrowserSubScene.this.subScene.setCursor(ModelBrowserSubScene.this.transCursor);
                } else if (mouseEvent.getButton() == MouseButton.MIDDLE) {
                    ModelBrowserSubScene.this.currDraggingButton = MouseButton.MIDDLE;
                    ModelBrowserSubScene.this.subScene.setCursor(ModelBrowserSubScene.this.zoomCursor);
                } else {
                    ModelBrowserSubScene.this.currDraggingButton = null;
                }
                ModelBrowserSubScene.this.viewAxesController.redrawAxes();
            }
        });
        this.subScene.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ModelBrowserSubScene.this.currDraggingButton = null;
                ModelBrowserSubScene.this.subScene.setCursor(null);
                ModelBrowserSubScene.this.viewAxesController.redrawAxes();
            }
        });
    }

    private void setRotPicker(Node[] nodeArray) {
        this.rotPicker = new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    PickResult pickResult = mouseEvent.getPickResult();
                    if (pickResult == null) {
                        System.out.println("ModelBrowserSubScene : PickResult is null !!");
                        return;
                    }
                    Node node = pickResult.getIntersectedNode();
                    if (node == null) {
                        System.out.println("ModelBrowserSubScene : IntersectedNode is null !!");
                        return;
                    }
                    if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                        Point3D point3D;
                        Point3D point3D2 = null;
                        if (ModelBrowserSubScene.this.pickedShapeRotCenter == RotCenter.PICKEAD_SHAPE_CENTER) {
                            point3D = (BoundingBox)node.getBoundsInLocal();
                            point3D2 = new Point3D((point3D.getMaxX() + point3D.getMinX()) / 2.0, (point3D.getMaxY() + point3D.getMinY()) / 2.0, (point3D.getMaxZ() + point3D.getMinZ()) / 2.0);
                        } else {
                            point3D = pickResult.getIntersectedPoint();
                            if (point3D == null) {
                                System.out.println("ModelBrowserSubScene : IntersectedPoint is null !!");
                                return;
                            }
                            point3D2 = point3D;
                            if (ModelBrowserSubScene.this.pickedShapeRotCenter == RotCenter.PICKEAD_SHAPE_VERTEX && node instanceof MeshView && !ModelBrowserSubScene.this.isPickingBounds) {
                                int n = pickResult.getIntersectedFace();
                                if (n == -1) {
                                    System.out.println("ModelBrowserSubScene : IntersectedFace is FACE_UNDEFINED !!");
                                    return;
                                }
                                MeshView meshView = (MeshView)node;
                                TriangleMesh triangleMesh = (TriangleMesh)meshView.getMesh();
                                ObservableFaceArray observableFaceArray = triangleMesh.getFaces();
                                ObservableFloatArray observableFloatArray = triangleMesh.getPoints();
                                int n2 = n * 6;
                                int n3 = observableFaceArray.get(n2) * 3;
                                int n4 = observableFaceArray.get(n2 + 2) * 3;
                                int n5 = observableFaceArray.get(n2 + 4) * 3;
                                Point3D point3D3 = new Point3D((double)observableFloatArray.get(n3), (double)observableFloatArray.get(n3 + 1), (double)observableFloatArray.get(n3 + 2));
                                Point3D point3D4 = new Point3D((double)observableFloatArray.get(n4), (double)observableFloatArray.get(n4 + 1), (double)observableFloatArray.get(n4 + 2));
                                Point3D point3D5 = new Point3D((double)observableFloatArray.get(n5), (double)observableFloatArray.get(n5 + 1), (double)observableFloatArray.get(n5 + 2));
                                double d = point3D2.distance(point3D3);
                                double d2 = point3D2.distance(point3D4);
                                double d3 = point3D2.distance(point3D5);
                                Point3D point3D6 = point3D3;
                                if (d2 < d) {
                                    point3D6 = d3 < d2 ? point3D5 : point3D4;
                                } else if (d3 < d) {
                                    point3D6 = point3D5;
                                }
                                point3D2 = point3D6;
                            }
                        }
                        point3D = node.getLocalToSceneTransform();
                        Point3D point3D7 = point3D.transform(point3D2);
                        ModelBrowserSubScene.this.setRotationCenter(point3D7);
                    } else if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                        ModelBrowserSubScene.this.browserFrame.selectNodeInSceneTree(node);
                    }
                }
            }
        };
        this.currNumNodes = nodeArray.length;
        this.currNumGroups = 0;
        this.currNumShape3Ds = 0;
        this.currNumTriangles = 0;
        for (Node node : nodeArray) {
            Mesh mesh;
            if (node instanceof Group) {
                ++this.currNumGroups;
                this.setRotPicker((Group)node);
                continue;
            }
            if (!(node instanceof Shape3D)) continue;
            ++this.currNumShape3Ds;
            node.setOnMouseClicked(this.rotPicker);
            node.setPickOnBounds(this.isPickingBounds);
            if (!(node instanceof MeshView) || (mesh = ((MeshView)node).getMesh()) == null || !(mesh instanceof TriangleMesh)) continue;
            this.currNumTriangles += ((TriangleMesh)mesh).getFaces().size() / ((TriangleMesh)mesh).getFaceElementSize();
        }
    }

    private void setRotPicker(Group group) {
        ObservableList observableList = group.getChildren();
        this.currNumNodes += observableList.size();
        for (Node node : observableList) {
            Mesh mesh;
            if (node instanceof Group) {
                ++this.currNumGroups;
                this.setRotPicker((Group)node);
                continue;
            }
            if (!(node instanceof Shape3D)) continue;
            ++this.currNumShape3Ds;
            node.setOnMouseClicked(this.rotPicker);
            node.setPickOnBounds(this.isPickingBounds);
            if (!(node instanceof MeshView) || (mesh = ((MeshView)node).getMesh()) == null || !(mesh instanceof TriangleMesh)) continue;
            this.currNumTriangles += ((TriangleMesh)mesh).getFaces().size() / ((TriangleMesh)mesh).getFaceElementSize();
        }
    }

    private void setPickingState(Group group) {
        ObservableList observableList = group.getChildren();
        for (Node node : observableList) {
            if (node instanceof Shape3D) {
                node.setPickOnBounds(this.isPickingBounds);
                continue;
            }
            if (!(node instanceof Group)) continue;
            this.setPickingState((Group)node);
        }
    }

    void importNodes(Node[] nodeArray, URL uRL, String string, Node[] nodeArray2, Text text, boolean bl) {
        this.sceneTopGroup.getChildren().remove((Object)this.currImportRoot);
        this.setRotPicker(nodeArray);
        this.currImportRoot = new Group(nodeArray);
        this.currImports = nodeArray;
        this.currLoadedPath = uRL;
        this.currLoadedFileName = string;
        int n = 0;
        boolean bl2 = nodeArray2 != null && (n = nodeArray2.length) > 0;
        int[] nArray = null;
        Group[] groupArray = null;
        if (bl2) {
            int n2;
            nArray = new int[n];
            groupArray = new Group[n];
            for (n2 = 0; n2 < n; ++n2) {
                Group group;
                Node node = nodeArray2[n2];
                groupArray[n2] = group = (Group)node.getParent();
                nArray[n2] = group.getChildren().indexOf((Object)node);
            }
            for (n2 = 0; n2 < n; ++n2) {
                groupArray[n2].getChildren().remove((Object)nodeArray2[n2]);
            }
        }
        this.scene3DBinL = (BoundingBox)this.currImportRoot.getBoundsInLocal();
        double d = Math.max(this.scene3DBinL.getWidth(), Math.max(this.scene3DBinL.getHeight(), this.scene3DBinL.getDepth()));
        this.sceneDiameter = Math.sqrt(3.0) * d;
        this.sceneCenter = new Point3D((this.scene3DBinL.getMaxX() + this.scene3DBinL.getMinX()) / 2.0, (this.scene3DBinL.getMaxY() + this.scene3DBinL.getMinY()) / 2.0, (this.scene3DBinL.getMaxZ() + this.scene3DBinL.getMinZ()) / 2.0);
        if (bl2) {
            for (int i = 0; i < nodeArray2.length; ++i) {
                groupArray[i].getChildren().add(nArray[i], (Object)nodeArray2[i]);
            }
        }
        this.setRotationCenter(this.sceneCenter);
        this.transScale = this.sceneDiameter * 0.001;
        this.zoomScale = this.sceneDiameter * 0.00125;
        double d2 = (this.sceneCenter.magnitude() + d / 2.0) * 2.0 * 2.0;
        this.axisRadiusInit = d / 700.0;
        this.xAxis.setHeight(d2);
        this.xAxis.setRadius(this.axisRadiusInit);
        this.yAxis.setHeight(d2);
        this.yAxis.setRadius(this.axisRadiusInit);
        this.zAxis.setHeight(d2);
        this.zAxis.setRadius(this.axisRadiusInit);
        this.isFirstClip = true;
        this.setViewpoint(VP.FRONT);
        this.sceneTopGroup.getChildren().add((Object)this.currImportRoot);
        if (bl) {
            this.printBoundInLocal(this.scene3DBinL, uRL, text);
        }
    }

    void printBoundInLocal(BoundingBox boundingBox, URL uRL, Text text) {
        if (uRL == null) {
            return;
        }
        text.setText("Loaded file : " + uRL.toExternalForm() + '\n' + "   MinX " + this.numFormat.format(boundingBox.getMinX()) + "  MinY " + this.numFormat.format(boundingBox.getMinY()) + "  MinZ " + this.numFormat.format(boundingBox.getMinZ()) + '\n' + "   MaxX " + this.numFormat.format(boundingBox.getMaxX()) + "  MaxY " + this.numFormat.format(boundingBox.getMaxY()) + "  MaxZ " + this.numFormat.format(boundingBox.getMaxZ()) + '\n' + "   Nodes = " + numFormatFaces.format(this.currNumNodes) + ", therefrom Groups = " + numFormatFaces.format(this.currNumGroups) + ", Shape3Ds = " + numFormatFaces.format(this.currNumShape3Ds) + '\n' + "   Faces = " + numFormatFaces.format(this.currNumTriangles));
    }

    private Point3D getRotationCenter() {
        return new Point3D(this.viewingCenterTranslate.getX(), this.viewingCenterTranslate.getY(), this.viewingCenterTranslate.getZ());
    }

    Point3D getSceneCenter() {
        return this.sceneCenter;
    }

    void setRotationCenter(Point3D point3D) {
        if (this.isLookAtCenter) {
            Point3D point3D2 = this.getCamPos();
            double d = point3D.distance(point3D2);
            this.setCenterTranslations(point3D);
            this.viewingTranslate.setX(point3D.getX());
            this.viewingTranslate.setY(point3D.getY());
            this.viewingTranslate.setZ(point3D.getZ() - d);
        } else {
            this.updateConcatViewTransform();
            Transform transform = this.concatViewTransform;
            this.setCenterTranslations(point3D);
            Transform transform2 = this.viewingCenterTranslate.createConcatenation((Transform)this.viewingRotate);
            transform2 = transform2.createConcatenation((Transform)this.viewingCenterRevTranslate);
            try {
                Transform transform3 = transform2.createInverse();
                Transform transform4 = transform3.createConcatenation(transform);
                this.viewingTranslate.setX(transform4.getTx());
                this.viewingTranslate.setY(transform4.getTy());
                this.viewingTranslate.setZ(transform4.getTz());
            }
            catch (NonInvertibleTransformException nonInvertibleTransformException) {
                nonInvertibleTransformException.printStackTrace();
            }
        }
        this.setClipping();
    }

    RotCenter getPickShape3DRotCenter() {
        return this.pickedShapeRotCenter;
    }

    void setPickShape3DRotCenter(RotCenter rotCenter) {
        this.pickedShapeRotCenter = rotCenter;
    }

    boolean isLookAtCenter() {
        return this.isLookAtCenter;
    }

    void setLookAtCenter(boolean bl) {
        this.isLookAtCenter = bl;
    }

    private void setCenterTranslations(Point3D point3D) {
        this.viewingCenterTranslate.setX(point3D.getX());
        this.viewingCenterTranslate.setY(point3D.getY());
        this.viewingCenterTranslate.setZ(point3D.getZ());
        this.viewingCenterRevTranslate.setX(-point3D.getX());
        this.viewingCenterRevTranslate.setY(-point3D.getY());
        this.viewingCenterRevTranslate.setZ(-point3D.getZ());
    }

    void setViewpoint(VP vP) {
        Rotate rotate = null;
        this.perspectiveCamera.setVerticalFieldOfView(false);
        this.perspectiveCamera.setFieldOfView(44.0);
        double d = this.distToSceneCenter(this.sceneDiameter / 2.0);
        switch (vP) {
            case FRONT: {
                rotate = new Rotate();
                break;
            }
            case BACK: {
                rotate = new Rotate(180.0, Rotate.Y_AXIS);
                break;
            }
            case RIGHT: {
                rotate = new Rotate(-90.0, Rotate.Y_AXIS);
                break;
            }
            case LEFT: {
                rotate = new Rotate(90.0, Rotate.Y_AXIS);
                break;
            }
            case TOP: {
                rotate = new Rotate(-90.0, Rotate.X_AXIS);
                break;
            }
            case BOTTOM: {
                rotate = new Rotate(90.0, Rotate.X_AXIS);
                break;
            }
            case CENTER: {
                Point3D point3D = this.getRotationCenter();
                Affine affine = new Affine();
                affine.setToTransform((Transform)new Rotate(0.0, Rotate.Y_AXIS));
                rotate = affine;
                this.viewingTranslate.setX(point3D.getX());
                this.viewingTranslate.setY(point3D.getY());
                this.viewingTranslate.setZ(point3D.getZ());
                break;
            }
            case ISO: {
                Rotate rotate2 = new Rotate(-35.0, Rotate.X_AXIS);
                Rotate rotate3 = new Rotate(-45.0, Rotate.Y_AXIS);
                Affine affine = new Affine();
                affine.append((Transform)rotate3);
                affine.append((Transform)rotate2);
                rotate = affine;
            }
        }
        this.viewingRotate.setToTransform((Transform)rotate);
        if (vP != VP.CENTER) {
            this.setCenterTranslations(this.sceneCenter);
            this.viewingTranslate.setX(this.sceneCenter.getX());
            this.viewingTranslate.setY(this.sceneCenter.getY());
            this.viewingTranslate.setZ(this.sceneCenter.getZ() - d);
        }
        this.viewAxesController.updateAxes((Transform)this.viewingRotate);
        this.setClipping();
    }

    void setViewpoint(ModelBrowserVP modelBrowserVP) {
        try {
            Affine affine = modelBrowserVP.getTransform();
            if (modelBrowserVP.getCenterOfRotation() != null) {
                this.setCenterTranslations(modelBrowserVP.getCenterOfRotation());
            } else {
                this.setCenterTranslations(this.sceneCenter);
            }
            affine.prepend((Transform)this.viewingCenterRevTranslate);
            affine.append((Transform)this.viewingCenterTranslate);
            Point3D point3D = new Point3D(affine.getTx(), affine.getTy(), affine.getTz());
            affine.setTx(0.0);
            affine.setTy(0.0);
            affine.setTz(0.0);
            Point3D point3D2 = affine.inverseTransform(point3D);
            this.viewingRotate.setToTransform((Transform)affine);
            this.viewingTranslate.setX(point3D2.getX());
            this.viewingTranslate.setY(point3D2.getY());
            this.viewingTranslate.setZ(point3D2.getZ());
        }
        catch (NonInvertibleTransformException nonInvertibleTransformException) {
            throw new ImportException("Viewpoint setting failed ! Name = " + modelBrowserVP.getName(), nonInvertibleTransformException);
        }
        this.perspectiveCamera.setVerticalFieldOfView(modelBrowserVP.isVerticalFieldOfView());
        this.perspectiveCamera.setFieldOfView(modelBrowserVP.getFieldOfView());
        this.viewAxesController.updateAxes((Transform)this.viewingRotate);
        this.setClipping();
    }

    void setViewpoint(Node node) {
        Bounds bounds = node.getBoundsInLocal();
        Point3D point3D = new Point3D((bounds.getMaxX() + bounds.getMinX()) / 2.0, (bounds.getMaxY() + bounds.getMinY()) / 2.0, (bounds.getMaxZ() + bounds.getMinZ()) / 2.0);
        double d = Math.max(bounds.getWidth(), Math.max(bounds.getHeight(), bounds.getDepth()));
        double d2 = Math.sqrt(3.0) * d;
        this.perspectiveCamera.setVerticalFieldOfView(false);
        this.perspectiveCamera.setFieldOfView(44.0);
        double d3 = this.distToSceneCenter(d2 / 2.0);
        Transform transform = node.getLocalToSceneTransform();
        Point3D point3D2 = transform.transform(point3D);
        this.viewingRotate.setToTransform((Transform)new Rotate());
        this.setCenterTranslations(point3D2);
        this.viewingTranslate.setX(point3D2.getX());
        this.viewingTranslate.setY(point3D2.getY());
        this.viewingTranslate.setZ(point3D2.getZ() - d3);
        this.viewAxesController.updateAxes((Transform)this.viewingRotate);
        this.setClipping();
    }

    private void updateConcatViewTransform() {
        this.concatViewTransform = this.viewingCenterTranslate.createConcatenation((Transform)this.viewingRotate);
        this.concatViewTransform = this.concatViewTransform.createConcatenation((Transform)this.viewingCenterRevTranslate);
        this.concatViewTransform = this.concatViewTransform.createConcatenation((Transform)this.viewingTranslate);
    }

    private Point3D getCamPos() {
        this.updateConcatViewTransform();
        return this.concatViewTransform.transform(0.0, 0.0, 0.0);
    }

    private Point3D getInvPoint(Point3D point3D) {
        try {
            this.updateConcatViewTransform();
            return this.concatViewTransform.inverseTransform(point3D);
        }
        catch (NonInvertibleTransformException nonInvertibleTransformException) {
            nonInvertibleTransformException.printStackTrace();
            return null;
        }
    }

    private void setClipping() {
        Point3D point3D = this.getInvPoint(this.getRotationCenter());
        double d = point3D.getZ() + this.sceneDiameter * 1.0 * 1.1;
        double d2 = point3D.getZ() - this.sceneDiameter * 1.0 * 1.1;
        double d3 = Math.max(d2, d / 3000.0);
        Point3D point3D2 = this.getCamPos();
        double d4 = point3D2.magnitude();
        if (this.isFirstClip) {
            this.isFirstClip = false;
            this.camDistInit = d4;
        } else {
            double d5 = d4 / this.camDistInit;
            double d6 = this.axisRadiusInit * d5;
            this.xAxis.setRadius(d6);
            this.yAxis.setRadius(d6);
            this.zAxis.setRadius(d6);
        }
        this.perspectiveCamera.setFarClip(d);
        this.perspectiveCamera.setNearClip(d3);
    }

    private double distToSceneCenter(double d) {
        double d2 = this.perspectiveCamera.getFieldOfView();
        double d3 = this.subScene.getWidth();
        double d4 = this.subScene.getHeight();
        double d5 = 1.0;
        if (d3 > d4) {
            // empty if block
        }
        double d6 = 1.0 * d5 * d / Math.tan(Math.toRadians(d2 / 2.0));
        return d6;
    }

    static {
        numFormatFaces.setGroupingUsed(true);
    }

    static enum RotCenter {
        ORIGIN,
        PICKEAD_SHAPE_CENTER,
        PICKEAD_SHAPE_POINT,
        PICKEAD_SHAPE_VERTEX,
        SCENE_CENTER;

    }
}

