/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.jfx.modelbrowser;

import javafx.geometry.Point3D;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

final class ViewingAxes {
    private double border = 5.0;
    private Point3D ptXn = null;
    private Point3D ptXp = null;
    private Point3D ptYn = null;
    private Point3D ptYp = null;
    private Point3D ptZn = null;
    private Point3D ptZp = null;
    private Point3D ptXn1 = null;
    private Point3D ptXp1 = null;
    private Point3D ptYn1 = null;
    private Point3D ptYp1 = null;
    private Point3D ptZn1 = null;
    private Point3D ptZp1 = null;
    private Point3D centerXY = null;
    private final Canvas canvas;
    private final Affine currViewingTransform = new Affine();
    private Font font = new Font("Arial", 14.0);

    ViewingAxes(double d) {
        this.canvas = new Canvas(d, d);
        this.setSize(d);
    }

    Canvas getCanvas() {
        return this.canvas;
    }

    void setSize(double d) {
        this.canvas.setWidth(d * 1.1);
        this.canvas.setHeight(d);
        this.centerXY = new Point3D(d / 2.0, d / 2.0, 0.0);
        this.setupAxes(d);
        this.drawAxes();
    }

    void updateAxes(Transform transform) {
        Affine affine = new Affine(transform);
        try {
            affine = affine.createInverse();
        }
        catch (NonInvertibleTransformException nonInvertibleTransformException) {
            nonInvertibleTransformException.printStackTrace();
        }
        this.currViewingTransform.setToTransform((Transform)affine);
        this.drawAxes();
    }

    void redrawAxes() {
        this.drawAxes();
    }

    private void setupAxes(double d) {
        double d2 = (d / 2.0 - this.border) * 0.9;
        this.ptXn = new Point3D(-d2, 0.0, 0.0);
        this.ptXp = new Point3D(d2, 0.0, 0.0);
        this.ptYn = new Point3D(0.0, -d2, 0.0);
        this.ptYp = new Point3D(0.0, d2, 0.0);
        this.ptZn = new Point3D(0.0, 0.0, -d2);
        this.ptZp = new Point3D(0.0, 0.0, d2);
    }

    private void drawAxes() {
        this.currViewingTransform.setTx(this.centerXY.getX());
        this.currViewingTransform.setTy(this.centerXY.getY());
        this.currViewingTransform.setTz(0.0);
        this.ptXn1 = this.currViewingTransform.transform(this.ptXn);
        this.ptXp1 = this.currViewingTransform.transform(this.ptXp);
        this.ptYn1 = this.currViewingTransform.transform(this.ptYn);
        this.ptYp1 = this.currViewingTransform.transform(this.ptYp);
        this.ptZn1 = this.currViewingTransform.transform(this.ptZn);
        this.ptZp1 = this.currViewingTransform.transform(this.ptZp);
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        graphicsContext.setFont(this.font);
        graphicsContext.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        graphicsContext.setLineWidth(1.0);
        graphicsContext.setStroke((Paint)Color.RED);
        graphicsContext.strokeLine(this.ptXn1.getX(), this.ptXn1.getY(), this.centerXY.getX(), this.centerXY.getY());
        graphicsContext.strokeLine(this.centerXY.getX(), this.centerXY.getY(), this.ptXp1.getX(), this.ptXp1.getY());
        graphicsContext.strokeText(" + X", this.ptXp1.getX(), this.ptXp1.getY());
        graphicsContext.strokeText(" - X", this.ptXn1.getX(), this.ptXn1.getY());
        graphicsContext.setStroke((Paint)Color.LIMEGREEN);
        graphicsContext.strokeLine(this.ptYn1.getX(), this.ptYn1.getY(), this.centerXY.getX(), this.centerXY.getY());
        graphicsContext.strokeLine(this.centerXY.getX(), this.centerXY.getY(), this.ptYp1.getX(), this.ptYp1.getY());
        graphicsContext.strokeText(" + Y", this.ptYp1.getX(), this.ptYp1.getY());
        graphicsContext.strokeText(" - Y", this.ptYn1.getX(), this.ptYn1.getY());
        graphicsContext.setStroke((Paint)Color.DARKBLUE);
        graphicsContext.strokeLine(this.ptZn1.getX(), this.ptZn1.getY(), this.centerXY.getX(), this.centerXY.getY());
        graphicsContext.strokeLine(this.centerXY.getX(), this.centerXY.getY(), this.ptZp1.getX(), this.ptZp1.getY());
        graphicsContext.strokeText(" + Z", this.ptZp1.getX(), this.ptZp1.getY());
        graphicsContext.strokeText(" - Z", this.ptZn1.getX(), this.ptZn1.getY());
    }
}

