package com.interactivemesh.j3d.sourcecode.applet;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;

import java.io.FileNotFoundException;

import java.net.MalformedURLException;
import java.net.URL;

import java.util.Enumeration;
import java.util.Vector;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.RotationInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;

import javax.swing.JApplet;

import javax.vecmath.Vector3f;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;

import com.sun.j3d.loaders.objectfile.ObjectFile;

import com.sun.j3d.utils.applet.MainFrame;

/*
 * Beethoven.obj
 * 
# Tue Oct 27 19:18:13 1992
#
#	A Bust of Beethoven
#
# Courtesy of:
#
#	Viewpoint Animation Engineering
#	870 West Center
#	Orem, Utah 84057
#	(801)224-2222
#	1-800-DATASET
#
#	(c) Copyright 1992 Viewpoint Animation Engineering Inc.
#	Sun Microsystems has been authorized to freely distribute
#	these Datasets.  They are provided for unlimited use in
#	existing or modified form.  The actual Dataset (ie, geometry)
#	may not, however, be resold in existing or modified form.
#
*/

/**
 * @author Copyright (c) 2007 August Lammersdorf, www.InteractiveMesh.com
 * @since March 5, 2009
 * @version 1.1
 * 
 * Please create your own implementation.
 * You are allowed to copy all lines you like of this source code, 
 * but you may not modify, compile, or distribute this 'AppletObjLoader'. 
 * 
 */

public final class AppletObjLoader extends JApplet { 

	static {
		System.out.println("AppletObjLoader: Copyright (c) 2009 August Lammersdorf, www.InteractiveMesh.com.");
	}

	private boolean			isJ3D		=	false;
	private boolean			isJ3DLoader	=	false;
	
	private BoundingSphere 	globalBounds = 	null;

	private View 			view 		= 	null;
	private	Canvas3D 		canvas3D 	=	null;
	
	private VirtualUniverse	vu 			= 	null;
	private Locale 			locale 		= 	null;
	
	private BranchGroup 	sceneBranch = 	null;
	private BranchGroup 	viewBranch 	= 	null;
	private BranchGroup 	enviBranch 	= 	null;
	
	private TransformGroup 	rotTG 		= 	null;
	private TransformGroup 	sceneTG		= 	null;
	
	private Vector<Shape3D> shapesVec	=	null;
	
	private ClassLoader 	classLoader = 	null;

    //
    // Allows AppletObjLoader to be run as an application as well as an applet
    //
    public static void main(String[] args) {
    	new MainFrame(new AppletObjLoader(), 600, 600); 
    }

	public AppletObjLoader() {
	}
	
	@Override
	public void init() {
		System.out.println("AppletObjLoader : init");
		
		// Check if Java 3D and the loader package are installed
		classLoader = this.getClass().getClassLoader();		
		try {
			classLoader.loadClass("javax.media.j3d.BoundingSphere");
			isJ3D = true;
			
			classLoader.loadClass("com.sun.j3d.loaders.objectfile.ObjectFile");
			isJ3DLoader = true;
		}
		catch (ClassNotFoundException e) {
		}		
		
		if (isJ3D) {
			createUniverse();
			if (isJ3DLoader)
				createScene();
			else
				System.out.println("Loader 'com.sun.j3d.loaders.objectfile.ObjectFile' not found !!");
			setLive();
	
			this.getContentPane().add(canvas3D);
		}
	}
	@Override
	public void start() {
	}
	@Override
    public void stop() {
	}
	@Override
    public void destroy() {
		System.out.println("AppletObjLoader : destroy");
		
		view.removeAllCanvas3Ds();
		view.attachViewPlatform(null);
		
		vu.removeAllLocales();
	}
	
	private void createScene() {
		
		//
	    // Scene
    	//		
		// File located at: com.interactivemesh.j3d.sourcecode.applet.scenes.Beethoven.obj
		Scene fishScene = this.loadScene("scenes/Beethoven.obj");
		
		BranchGroup rootGroup = null;
		if (fishScene != null && (rootGroup = fishScene.getSceneGroup()) != null) {
			
			shapesVec = new Vector<Shape3D>(); 
			
			traverseForShape3D(rootGroup.getAllChildren());
			
			if (!shapesVec.isEmpty()) {
				
				Appearance appear = new Appearance();
				
				Material mat = new Material();
				mat.setDiffuseColor(0.9f, 0.0f, 0.0f);
				mat.setSpecularColor(1.0f, 0.0f, 0.0f);
				mat.setShininess(32.0f);
				
				appear.setMaterial(mat);
				
				for(Shape3D shape : shapesVec) 
					shape.setAppearance(appear);
			}
				
			sceneTG.addChild(rootGroup);
		}
		//
		// Animation
		//
		Alpha rotAlpha = new Alpha();
		rotAlpha.setMode(Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE);
		rotAlpha.setIncreasingAlphaDuration(1000);
		rotAlpha.setAlphaAtOneDuration(200);
		rotAlpha.setDecreasingAlphaDuration(2000);
		rotAlpha.setDecreasingAlphaRampDuration(200);
		rotAlpha.setAlphaAtZeroDuration(1000);
		
		RotationInterpolator rotIntp = new RotationInterpolator(rotAlpha, rotTG);
		rotIntp.setSchedulingBounds(globalBounds);
		rotIntp.setMinimumAngle(0.0f);
		rotIntp.setMaximumAngle((float)Math.PI * 2.0f);
				
		sceneTG.addChild(rotIntp);
	}
	
	// Loads *.obj files
	// relativePath: path relative to package of this class
	private Scene loadScene(String relativePath) {
		
		Scene scene = null;
		
		// Some loader could have problems to handle a url based on jar: protocol
		// The syntax of the jar: protocol is jar:<url>!/{entry}. "!/" is called the separator.
		// Examples local/web:
		// jar:file:/ ... /appletObjLoader.jar!/com/interactivemesh/j3d/sourcecode/applet/scenes/Fish.wrl
		// jar:http://www.interactivemesh.org/sourcecode/webstart/appletObjLoader.jar!/com/interactivemesh/j3d/sourcecode/applet/scenes/Fish.wrl			
		URL sceneUrl = this.getClass().getResource(relativePath);
		if (sceneUrl == null) {
			System.out.println("sceneUrl = null");
			return null;
		}
		
		String sceneUrlString = sceneUrl.toString();
		String baseUrlString = sceneUrlString.substring(0, sceneUrlString.lastIndexOf('/') + 1); // V 1.1
		
		URL baseUrl = null;
		try {
			baseUrl = new URL(baseUrlString);
		}
		catch (MalformedURLException e) {		
		}
		
		System.out.println("Scene URL = " + sceneUrlString);
		
		Loader objLoader = new ObjectFile(); // No flag: Shapes only
		
		// BaseUrl = null works as well !!
		objLoader.setBaseUrl(baseUrl);
		System.out.println("Base Url  = " + objLoader.getBaseUrl().toString());
		
		try {
			scene = objLoader.load(sceneUrl);
		}
		catch (FileNotFoundException e) {			
		}
		catch (IncorrectFormatException e) {			
		}
		catch (ParsingErrorException e) {			
		}
		
		return scene;
	}
	
	private void traverseForShape3D(Enumeration e) {
		while (e.hasMoreElements()) {
			Object nodeObject = e.nextElement();
			if (nodeObject instanceof Group) {
				Enumeration children = ((Group)nodeObject).getAllChildren();
				traverseForShape3D(children);				
			}
			else if (nodeObject instanceof Shape3D) {
				shapesVec.add((Shape3D)nodeObject);
			}
		}
	}
	
    // Set live
	private void setLive() {
		sceneBranch.compile();
		viewBranch.compile();
		enviBranch.compile();
        locale.addBranchGraph(sceneBranch);
        locale.addBranchGraph(viewBranch);
        locale.addBranchGraph(enviBranch);
	}
	
    private void createUniverse() {		
        // Bounds
    	globalBounds = new BoundingSphere();
        globalBounds.setRadius(Double.MAX_VALUE);		
        //
        // Viewing
        //
        view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        
        GraphicsConfigTemplate3D gCT = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(gCT);
        
        try {
        	canvas3D = new Canvas3D(gcfg);
        }
        catch (NullPointerException e) {
            System.out.println("AppletObjLoader: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("AppletObjLoader: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }               
        
    	view.addCanvas3D(canvas3D);
        //
        // SuperStructure
        //
        vu = new VirtualUniverse();
        locale = new Locale(vu);        
        //
        // BranchGraphs
        //		
        sceneBranch = new BranchGroup();
        viewBranch = new BranchGroup();
        enviBranch = new BranchGroup();
        
        // ViewBranch
        
        TransformGroup viewTG = new TransformGroup();
        viewTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        
        Transform3D viewTransform = new Transform3D();
        viewTransform.setTranslation(new Vector3f(0.0f, 0.0f, 16.0f));
        viewTG.setTransform(viewTransform);
                
        ViewPlatform vp = new ViewPlatform();
        view.attachViewPlatform(vp);
        
        DirectionalLight headLight = new DirectionalLight();
        headLight.setInfluencingBounds(globalBounds);

        viewTG.addChild(vp);
        viewTG.addChild(headLight);
        
        viewBranch.addChild(viewTG);
        
        // EnviBranch
        
        Background bg = new Background();
        bg.setApplicationBounds(globalBounds);
        bg.setColor(0.0f, 0.47f, 0.63f);
        
        enviBranch.addChild(bg);

        // SceneBranch
        
        rotTG = new TransformGroup();
        rotTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        
        sceneBranch.addChild(rotTG);
        
        sceneTG = new TransformGroup();        
        // Scene positioning 
        Transform3D sceneTransform = new Transform3D();
        // Rotate around Y
        sceneTransform.setTranslation(new Vector3f(0.281f, 0.4f, -0.421f));
        sceneTG.setTransform(sceneTransform);

        rotTG.addChild(sceneTG);       
    }
}

