package com.interactivemesh.j3d.sourcecode.universe;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;

import javax.media.j3d.Alpha;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Locale;
import javax.media.j3d.Material;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.ScaleInterpolator;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;

import javax.swing.JFrame;
import javax.swing.JPanel;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

/**
 * @author Copyright (c) 2007 August Lammersdorf, www.InteractiveMesh.com
 * @since March 31, 2007
 * @version 1.0
 * 
 * Please create your own implementation.
 * You are allowed to copy all lines you like of this source code, 
 * but you may not modify, compile, or distribute this 'MyFirstUniverse_I'. 
 * 
 * 
 */
public final class MyFirstUniverse_I {
	
	static {
		System.out.println("MyFirstUniverse_I: Copyright (c) 2007 August Lammersdorf, www.InteractiveMesh.com.");
	}
	
	private BoundingSphere 	globalBounds = 	null;

	private	Canvas3D 		canvas3D 	=	null;
	private Locale 			locale 		= 	null;
	
	private BranchGroup 	sceneBranch = 	null;
	private BranchGroup 	viewBranch 	= 	null;
	private BranchGroup 	enviBranch 	= 	null;
	
	private TransformGroup 	scaleTG 	= 	null;
	private TransformGroup 	characterTG	= 	null;
	
	public static void main(String[] args) {
		new MyFirstUniverse_I();
	}

	public MyFirstUniverse_I() {
		createUniverse();
		createScene();
		setLive();
		showCanvas3D();
	}
	
	private void createScene() {
		
		//
	    // Text3D geometry
    	//
        Font font = new Font("Dialog", Font.PLAIN, 1);
        Font3D font3D = new Font3D(font, 0.008, new FontExtrusion());
        
        Text3D text3D = new Text3D(font3D, "MyFirstUniverse");

		//
		// Appearance: Material
		//
		Appearance appear = new Appearance();
		
		Material mat = new Material();
		mat.setDiffuseColor(1.0f, 0.0f, 0.2f);
		mat.setSpecularColor(1.0f, 0.0f, 0.0f);
		mat.setShininess(1.25f);

		appear.setMaterial(mat);

		//
		// Shape
		//
		Shape3D textShape = new Shape3D(text3D, appear);		
		
		characterTG.addChild(textShape);
		
		//
		// Animation
		//
		Alpha scaleAlpha = new Alpha();
		scaleAlpha.setMode(Alpha.INCREASING_ENABLE | Alpha.DECREASING_ENABLE);
		scaleAlpha.setAlphaAtZeroDuration(500);
		scaleAlpha.setIncreasingAlphaDuration(2000);
		scaleAlpha.setIncreasingAlphaRampDuration(200);
		scaleAlpha.setAlphaAtOneDuration(500);
		scaleAlpha.setDecreasingAlphaDuration(500);
		
		ScaleInterpolator scaler = new ScaleInterpolator(scaleAlpha, scaleTG);
		scaler.setSchedulingBounds(globalBounds);
		scaler.setMaximumScale(1.0f);
		scaler.setMinimumScale(0.005f);
		
		characterTG.addChild(scaler);
	}
	
    // Set live
	private void setLive() {
		sceneBranch.compile();
		viewBranch.compile();
		enviBranch.compile();
        locale.addBranchGraph(sceneBranch);
        locale.addBranchGraph(viewBranch);
        locale.addBranchGraph(enviBranch);
	}
	
    private void createUniverse() {		
        // Bounds
    	globalBounds = new BoundingSphere();
        globalBounds.setRadius(Double.MAX_VALUE);		
        //
        // Viewing
        //
        View view = new View();
        view.setPhysicalBody(new PhysicalBody());
        view.setPhysicalEnvironment(new PhysicalEnvironment());
        
        GraphicsConfigTemplate3D gCT = new GraphicsConfigTemplate3D();
        GraphicsConfiguration gcfg = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(gCT);
        
        try {
        	canvas3D = new Canvas3D(gcfg);
        }
        catch (NullPointerException e) {
            System.out.println("MyFirstUniverse_I: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }
        catch (IllegalArgumentException e) {
            System.out.println("MyFirstUniverse_I: Canvas3D failed !!");
            e.printStackTrace();
            System.exit(0);
        }               
        
    	view.addCanvas3D(canvas3D);
        //
        // SuperStructure
        //
        VirtualUniverse vu = new VirtualUniverse();
        locale = new Locale(vu);        
        //
        // BranchGraphs
        //		
        sceneBranch = new BranchGroup();
        viewBranch = new BranchGroup();
        enviBranch = new BranchGroup();
        
        // ViewBranch
        
        TransformGroup viewTG = new TransformGroup();
        viewTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        
        Transform3D viewTransform = new Transform3D();
        viewTransform.setTranslation(new Vector3f(0.0f, 0.5f, 11.5f));
        viewTG.setTransform(viewTransform);
                
        ViewPlatform vp = new ViewPlatform();
        view.attachViewPlatform(vp);
        
        DirectionalLight headLight = new DirectionalLight();
        headLight.setInfluencingBounds(globalBounds);

        viewTG.addChild(vp);
        viewTG.addChild(headLight);
        
        viewBranch.addChild(viewTG);
        
        // EnviBranch
        
        Background bg = new Background();
        bg.setApplicationBounds(globalBounds);
        bg.setColor(0.0f, 0.0f, 0.6f);
        
        enviBranch.addChild(bg);

        // SceneBranch
        
        scaleTG = new TransformGroup();
        scaleTG.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        
        sceneBranch.addChild(scaleTG);
        
        characterTG = new TransformGroup();        
        // Center of character 
        Transform3D charTransform = new Transform3D();
        // Scale to a depth of 3.0f (0.2f * 15.0)
        charTransform.setScale(new Vector3d(1.0f, 1.0f, 15.0f));
        // Rotate around X
        charTransform.setRotation(new AxisAngle4f(1.0f, 0.0f, 0.0f, -0.35f));
        // Center text
        charTransform.setTranslation(new Vector3f(-3.6113281f, -0.359375f, 0.0f));
        characterTG.setTransform(charTransform);

        scaleTG.addChild(characterTG);
        
    }
    
	private void showCanvas3D() {
		
		Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenDim = toolkit.getScreenSize();
	
		JPanel jPanel = new JPanel(new BorderLayout());
		jPanel.setPreferredSize(new Dimension(screenDim.width - 20, screenDim.width / 3));
		jPanel.add(canvas3D);
		
		JFrame jFrame = new JFrame();
		jFrame.setTitle("InteractiveMesh : MyFirstUniverse_I");
		jFrame.setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		jFrame.add(jPanel);
		jFrame.pack();
		
        Dimension jframeDim = jFrame.getSize();
        jFrame.setLocation((screenDim.width - jframeDim.width)/2, (screenDim.height - jframeDim.height)/2);

		jFrame.setVisible(true);
	}	
}