/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.utils.geometry;

import com.interactivemesh.j3d.community.utils.geometry.AWTShapeExtruder;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.TriangleArray;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class String3D {
    private AWTShapeExtruder stringExtruder = null;
    private Font stringFont = null;
    private Point3f stringPosition = new Point3f();
    private float stringSpacing = 0.0f;
    private Alignment stringAlignment = Alignment.FIRST;
    private Path stringPath = Path.RIGHT;

    public String3D() {
    }

    public String3D(Font font, AWTShapeExtruder extruder) {
        this.stringFont = font;
        this.stringExtruder = extruder;
    }

    public String3D(Font font, AWTShapeExtruder extruder, Point3f position) {
        this.stringFont = font;
        this.stringExtruder = extruder;
        if (position != null) {
            this.stringPosition.set((Tuple3f)position);
        }
    }

    public String3D(Font font, AWTShapeExtruder extruder, Point3f position, Alignment alignment, Path path) {
        this.stringFont = font;
        this.stringExtruder = extruder;
        if (position != null) {
            this.stringPosition.set((Tuple3f)position);
        }
        this.setAlignment(alignment);
        this.setPath(path);
    }

    public Font getFont() {
        return this.stringFont;
    }

    public void setFont(Font font) {
        this.stringFont = font;
    }

    public AWTShapeExtruder getExtruder() {
        return this.stringExtruder;
    }

    public void setExtruder(AWTShapeExtruder extruder) {
        this.stringExtruder = extruder;
    }

    public void getPosition(Point3f position) {
        if (position == null) {
            throw new NullPointerException("position is null");
        }
        position.set((Tuple3f)this.stringPosition);
    }

    public void setPosition(Point3f position) {
        if (position == null) {
            throw new NullPointerException("position is null");
        }
        this.stringPosition.set((Tuple3f)position);
    }

    public Alignment getAlignment() {
        return this.stringAlignment;
    }

    public void setAlignment(Alignment alignment) {
        this.stringAlignment = alignment;
    }

    public Path getPath() {
        return this.stringPath;
    }

    public void setPath(Path path) {
        this.stringPath = path;
    }

    public float getCharacterSpacing() {
        return this.stringSpacing;
    }

    public void setCharacterSpacing(float characterSpacing) {
        this.stringSpacing = characterSpacing;
    }

    public void getGeometryBounds(String string, BoundingBox bounds) {
        this.checkStringAndState(string);
        if (bounds == null) {
            throw new NullPointerException("String3D : bounds is null !");
        }
        boolean isReverse = this.stringPath == Path.LEFT || this.stringPath == Path.DOWN_CENTER || this.stringPath == Path.DOWN_LEFT || this.stringPath == Path.DOWN_RIGHT;
        GlyphVector[] gvs = this.createGlyphVectors(string, isReverse);
        if (gvs == null) {
            throw new IllegalArgumentException("String3D : string is whitespace !");
        }
        this.createCharTranslations(gvs, bounds, new Point3f());
        if (this.stringExtruder.getShapeExtrusion() != null) {
            Point3d p3d = new Point3d();
            bounds.getUpper(p3d);
            p3d.z += (double)this.stringExtruder.getShapeExtrusion().getDepth();
            bounds.setUpper(p3d);
        }
    }

    public GeometryArray getStringGeometry(String string) {
        return this.createStringGeometry(string, null);
    }

    public GeometryArray getStringGeometry(String string, BoundingBox bounds) {
        return this.createStringGeometry(string, bounds);
    }

    private GeometryArray createStringGeometry(String string, BoundingBox bounds) {
        this.checkStringAndState(string);
        boolean isReverse = this.stringPath == Path.LEFT || this.stringPath == Path.DOWN_CENTER || this.stringPath == Path.DOWN_LEFT || this.stringPath == Path.DOWN_RIGHT;
        boolean isExtrusionShape = this.stringExtruder.getShapeExtrusion() != null && this.stringExtruder.getShapeExtrusion().getExtrusionShape() != null;
        GlyphVector[] gvs = this.createGlyphVectors(string, isReverse);
        if (gvs == null) {
            throw new IllegalArgumentException("String3D : string is whitespace !");
        }
        Vector3f[] charTranss = this.createCharTranslations(gvs, bounds, this.stringPosition);
        int numChars = gvs.length;
        int totalVertexCount = 0;
        GeometryArray[] geomList = new GeometryArray[numChars];
        int i = 0;
        while (i < numChars) {
            PathIterator pathIt = this.createPathIterator(gvs[i]);
            GeometryArray geomInterim = this.stringExtruder.createGeometry(pathIt, true, false);
            if (geomInterim != null) {
                totalVertexCount += geomInterim.getVertexCount();
                geomList[i] = geomInterim;
            }
            ++i;
        }
        if (totalVertexCount < 1) {
            return null;
        }
        Point3d boundsLower = new Point3d();
        Point3d boundsUpper = new Point3d();
        if (bounds != null) {
            if (this.stringExtruder.getShapeExtrusion() != null) {
                Point3d p3d = new Point3d();
                bounds.getUpper(p3d);
                p3d.z += (double)this.stringExtruder.getShapeExtrusion().getDepth();
                bounds.setUpper(p3d);
            }
            if (isExtrusionShape) {
                bounds.getLower(boundsLower);
                bounds.getUpper(boundsUpper);
            }
        }
        float[] coordsAll = new float[totalVertexCount * 3];
        float[] normalsAll = new float[totalVertexCount * 3];
        int k = 0;
        int i2 = 0;
        while (i2 < numChars) {
            GeometryArray geomInterim = geomList[i2];
            if (geomInterim != null) {
                int z;
                int j;
                float[] coords = geomInterim.getCoordRefFloat();
                float[] normals = geomInterim.getNormalRefFloat();
                Vector3f charTrans = charTranss[i2];
                if (bounds != null && isExtrusionShape) {
                    j = 0;
                    z = coords.length;
                    while (j < z) {
                        coordsAll[k] = coords[j] + charTrans.x;
                        if (boundsLower.x > (double)coordsAll[k]) {
                            boundsLower.x = coordsAll[k];
                        } else if (boundsUpper.x < (double)coordsAll[k]) {
                            boundsUpper.x = coordsAll[k];
                        }
                        normalsAll[k++] = normals[j];
                        coordsAll[k] = coords[j + 1] + charTrans.y;
                        if (boundsLower.y > (double)coordsAll[k]) {
                            boundsLower.y = coordsAll[k];
                        } else if (boundsUpper.y < (double)coordsAll[k]) {
                            boundsUpper.y = coordsAll[k];
                        }
                        normalsAll[k++] = normals[j + 1];
                        coordsAll[k] = coords[j + 2] + charTrans.z;
                        normalsAll[k++] = normals[j + 2];
                        j += 3;
                    }
                } else {
                    j = 0;
                    z = coords.length;
                    while (j < z) {
                        coordsAll[k] = coords[j] + charTrans.x;
                        normalsAll[k++] = normals[j];
                        coordsAll[k] = coords[j + 1] + charTrans.y;
                        normalsAll[k++] = normals[j + 1];
                        coordsAll[k] = coords[j + 2] + charTrans.z;
                        normalsAll[k++] = normals[j + 2];
                        j += 3;
                    }
                }
                geomInterim.setCoordRefFloat(null);
                geomInterim.setNormalRefFloat(null);
            }
            ++i2;
        }
        if (bounds != null && isExtrusionShape) {
            bounds.setLower(boundsLower);
            bounds.setUpper(boundsUpper);
        }
        TriangleArray triaArray = new TriangleArray(totalVertexCount, 3);
        this.stringExtruder.transformCoords(coordsAll);
        this.stringExtruder.transformNormals(normalsAll);
        if (bounds != null) {
            this.stringExtruder.transformBounds(bounds, coordsAll);
        }
        triaArray.setCoordinates(0, coordsAll);
        triaArray.setNormals(0, normalsAll);
        return triaArray;
    }

    public GeometryArray getStringOutlineGeometry(String string) {
        return this.createStringOutlineGeometry(string, null);
    }

    public GeometryArray getStringOutlineGeometry(String string, BoundingBox bounds) {
        return this.createStringOutlineGeometry(string, bounds);
    }

    private GeometryArray createStringOutlineGeometry(String string, BoundingBox bounds) {
        this.checkStringAndState(string);
        boolean isReverse = this.stringPath == Path.LEFT || this.stringPath == Path.DOWN_CENTER || this.stringPath == Path.DOWN_LEFT || this.stringPath == Path.DOWN_RIGHT;
        GlyphVector[] gvs = this.createGlyphVectors(string, isReverse);
        if (gvs == null) {
            throw new IllegalArgumentException("String3D : string is whitespace !");
        }
        Vector3f[] charTranss = this.createCharTranslations(gvs, bounds, this.stringPosition);
        int numChars = gvs.length;
        int totalVertexCount = 0;
        int totalStripCount = 0;
        int numStrips = 0;
        int maxNumStrips = 0;
        LineStripArray[] geomList = new LineStripArray[numChars];
        int i = 0;
        while (i < numChars) {
            PathIterator pathIt = this.createPathIterator(gvs[i]);
            LineStripArray geomInterim = this.stringExtruder.createLineStripGeometry(pathIt, false, true, false);
            if (geomInterim != null) {
                totalVertexCount += geomInterim.getVertexCount();
                numStrips = geomInterim.getNumStrips();
                totalStripCount += numStrips;
                if (maxNumStrips < numStrips) {
                    maxNumStrips = numStrips;
                }
                geomList[i] = geomInterim;
            }
            ++i;
        }
        if (totalVertexCount < 1) {
            return null;
        }
        float[] coordsAll = new float[totalVertexCount * 3];
        int[] stripVertexCtAll = new int[totalStripCount];
        int[] stripVertCtBuffer = new int[maxNumStrips];
        int k = 0;
        int l = 0;
        int i2 = 0;
        while (i2 < numChars) {
            LineStripArray geomInterim = geomList[i2];
            if (geomInterim != null) {
                float[] coords = geomInterim.getCoordRefFloat();
                geomInterim.getStripVertexCounts(stripVertCtBuffer);
                int j = 0;
                int z = coords.length;
                while (j < z) {
                    coordsAll[k++] = coords[j] + charTranss[i2].x;
                    coordsAll[k++] = coords[j + 1] + charTranss[i2].y;
                    coordsAll[k++] = coords[j + 2] + charTranss[i2].z;
                    j += 3;
                }
                j = 0;
                int num = geomInterim.getNumStrips();
                while (j < num) {
                    stripVertexCtAll[l++] = stripVertCtBuffer[j];
                    ++j;
                }
                geomInterim.setCoordRefFloat(null);
            }
            ++i2;
        }
        LineStripArray lineStripArray = new LineStripArray(totalVertexCount, 3, stripVertexCtAll);
        this.stringExtruder.transformCoords(coordsAll);
        float[] normalArr = new float[]{0.0f, 0.0f, 1.0f};
        this.stringExtruder.transformNormals(normalArr);
        if (bounds != null) {
            this.stringExtruder.transformBounds(bounds, coordsAll);
        }
        lineStripArray.setCoordinates(0, coordsAll);
        int i3 = 0;
        while (i3 < totalVertexCount) {
            lineStripArray.setNormal(i3, normalArr);
            ++i3;
        }
        return lineStripArray;
    }

    public GeometryArray[] getCharacterGeometry(String string) {
        return this.createCharacterGeometry(string, null);
    }

    public GeometryArray[] getCharacterGeometry(String string, BoundingBox bounds) {
        return this.createCharacterGeometry(string, bounds);
    }

    private GeometryArray[] createCharacterGeometry(String string, BoundingBox bounds) {
        this.checkStringAndState(string);
        boolean isReverse = this.stringPath == Path.LEFT || this.stringPath == Path.DOWN_CENTER || this.stringPath == Path.DOWN_LEFT || this.stringPath == Path.DOWN_RIGHT;
        boolean isExtrusionShape = this.stringExtruder.getShapeExtrusion() != null && this.stringExtruder.getShapeExtrusion().getExtrusionShape() != null;
        GlyphVector[] gvs = this.createGlyphVectors(string, isReverse);
        if (gvs == null) {
            throw new IllegalArgumentException("String3D : string is whitespace !");
        }
        Vector3f[] charTranss = this.createCharTranslations(gvs, bounds, this.stringPosition);
        Point3d boundsLower = new Point3d();
        Point3d boundsUpper = new Point3d();
        if (bounds != null) {
            if (this.stringExtruder.getShapeExtrusion() != null) {
                Point3d p3d = new Point3d();
                bounds.getUpper(p3d);
                p3d.z += (double)this.stringExtruder.getShapeExtrusion().getDepth();
                bounds.setUpper(p3d);
            }
            if (isExtrusionShape) {
                bounds.getLower(boundsLower);
                bounds.getUpper(boundsUpper);
            }
        }
        int numChars = gvs.length;
        ArrayList<TriangleArray> geomList = new ArrayList<TriangleArray>(numChars);
        ArrayList<float[]> coordsList = null;
        if (bounds != null) {
            coordsList = new ArrayList<float[]>(numChars);
        }
        int i = 0;
        while (i < numChars) {
            PathIterator pathIt = this.createPathIterator(gvs[i]);
            GeometryArray geomInterim = this.stringExtruder.createGeometry(pathIt, true, false);
            if (geomInterim != null) {
                int z;
                int j;
                float[] coords = geomInterim.getCoordRefFloat();
                float[] normals = geomInterim.getNormalRefFloat();
                Vector3f charTrans = charTranss[i];
                if (bounds != null && isExtrusionShape) {
                    j = 0;
                    z = coords.length;
                    while (j < z) {
                        int n = j;
                        coords[n] = coords[n] + charTrans.x;
                        if (boundsLower.x > (double)coords[j]) {
                            boundsLower.x = coords[j];
                        } else if (boundsUpper.x < (double)coords[j]) {
                            boundsUpper.x = coords[j];
                        }
                        int n2 = j + 1;
                        coords[n2] = coords[n2] + charTrans.y;
                        if (boundsLower.y > (double)coords[j + 1]) {
                            boundsLower.y = coords[j + 1];
                        } else if (boundsUpper.y < (double)coords[j + 1]) {
                            boundsUpper.y = coords[j + 1];
                        }
                        int n3 = j + 2;
                        coords[n3] = coords[n3] + charTrans.z;
                        j += 3;
                    }
                } else {
                    j = 0;
                    z = coords.length;
                    while (j < z) {
                        int n = j;
                        coords[n] = coords[n] + charTrans.x;
                        int n4 = j + 1;
                        coords[n4] = coords[n4] + charTrans.y;
                        int n5 = j + 2;
                        coords[n5] = coords[n5] + charTrans.z;
                        j += 3;
                    }
                }
                TriangleArray triaArray = new TriangleArray(geomInterim.getVertexCount(), 3);
                this.stringExtruder.transformCoords(coords);
                this.stringExtruder.transformNormals(normals);
                if (bounds != null) {
                    coordsList.add(coords);
                }
                triaArray.setCoordinates(0, coords);
                triaArray.setNormals(0, normals);
                geomList.add(triaArray);
                geomInterim.setCoordRefFloat(null);
                geomInterim.setNormalRefFloat(null);
            }
            ++i;
        }
        if (geomList.isEmpty()) {
            return null;
        }
        if (bounds != null) {
            if (isExtrusionShape) {
                bounds.setLower(boundsLower);
                bounds.setUpper(boundsUpper);
            }
            this.stringExtruder.transformBounds(bounds, coordsList);
            coordsList.clear();
        }
        GeometryArray[] geomArrays = new GeometryArray[geomList.size()];
        geomList.toArray(geomArrays);
        return geomArrays;
    }

    public GeometryArray[] getCharacterOutlineGeometry(String string) {
        return this.createCharacterOutlineGeometry(string, null);
    }

    public GeometryArray[] getCharacterOutlineGeometry(String string, BoundingBox bounds) {
        return this.createCharacterOutlineGeometry(string, bounds);
    }

    private GeometryArray[] createCharacterOutlineGeometry(String string, BoundingBox bounds) {
        this.checkStringAndState(string);
        boolean isReverse = this.stringPath == Path.LEFT || this.stringPath == Path.DOWN_CENTER || this.stringPath == Path.DOWN_LEFT || this.stringPath == Path.DOWN_RIGHT;
        GlyphVector[] gvs = this.createGlyphVectors(string, isReverse);
        if (gvs == null) {
            throw new IllegalArgumentException("String3D : string is whitespace !");
        }
        Vector3f[] charTranss = this.createCharTranslations(gvs, bounds, this.stringPosition);
        float[] normalArr = new float[]{0.0f, 0.0f, 1.0f};
        this.stringExtruder.transformNormals(normalArr);
        int numChars = gvs.length;
        ArrayList<LineStripArray> geomList = new ArrayList<LineStripArray>(numChars);
        ArrayList<float[]> coordsList = null;
        if (bounds != null) {
            coordsList = new ArrayList<float[]>(numChars);
        }
        int i = 0;
        while (i < numChars) {
            PathIterator pathIt = this.createPathIterator(gvs[i]);
            LineStripArray geomInterim = this.stringExtruder.createLineStripGeometry(pathIt, false, true, false);
            if (geomInterim != null) {
                float[] coords = geomInterim.getCoordRefFloat();
                int j = 0;
                int z = coords.length;
                while (j < z) {
                    int n = j;
                    coords[n] = coords[n] + charTranss[i].x;
                    int n2 = j + 1;
                    coords[n2] = coords[n2] + charTranss[i].y;
                    int n3 = j + 2;
                    coords[n3] = coords[n3] + charTranss[i].z;
                    j += 3;
                }
                int vertexCt = geomInterim.getVertexCount();
                int[] stripVertexCt = new int[geomInterim.getNumStrips()];
                geomInterim.getStripVertexCounts(stripVertexCt);
                LineStripArray lineStripArray = new LineStripArray(vertexCt, 3, stripVertexCt);
                this.stringExtruder.transformCoords(coords);
                if (bounds != null) {
                    coordsList.add(coords);
                }
                lineStripArray.setCoordinates(0, coords);
                int j2 = 0;
                while (j2 < vertexCt) {
                    lineStripArray.setNormal(j2, normalArr);
                    ++j2;
                }
                geomList.add(lineStripArray);
                geomInterim.setCoordRefFloat(null);
            }
            ++i;
        }
        if (geomList.isEmpty()) {
            return null;
        }
        if (bounds != null) {
            this.stringExtruder.transformBounds(bounds, coordsList);
            coordsList.clear();
        }
        LineStripArray[] geomArrays = new LineStripArray[geomList.size()];
        geomList.toArray(geomArrays);
        return geomArrays;
    }

    private void checkStringAndState(String string) {
        if (string == null || string.length() < 1) {
            throw new NullPointerException("String3D : string is null or of length < 1 !");
        }
        if (this.stringExtruder == null) {
            throw new IllegalStateException("String3D : extruder isn't set !");
        }
        if (this.stringFont == null) {
            throw new IllegalStateException("String3D : font isn't set !");
        }
    }

    private GlyphVector[] createGlyphVectors(String string3d, boolean reverse) {
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        char[] chars = new char[1];
        int length = string3d.length();
        GlyphVector[] gvs = new GlyphVector[length];
        int whitespaceCt = 0;
        if (reverse) {
            int k = 0;
            int i = length - 1;
            while (i >= 0) {
                chars[0] = string3d.charAt(i);
                gvs[k++] = this.stringFont.createGlyphVector(frc, chars);
                if (Character.isWhitespace(chars[0])) {
                    ++whitespaceCt;
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < length) {
                chars[0] = string3d.charAt(i);
                gvs[i] = this.stringFont.createGlyphVector(frc, chars);
                if (Character.isWhitespace(chars[0])) {
                    ++whitespaceCt;
                }
                ++i;
            }
        }
        if (whitespaceCt == length) {
            return null;
        }
        return gvs;
    }

    private PathIterator createPathIterator(GlyphVector glyphVector) {
        AffineTransform glyphTrans = new AffineTransform();
        glyphTrans.setToScale(1.0, -1.0);
        Shape shape = glyphVector.getOutline();
        PathIterator pathIt = shape.getPathIterator(glyphTrans, this.stringExtruder.getTessellationTolerance());
        return pathIt;
    }

    private Vector3f[] createCharTranslations(GlyphVector[] glyphVectors, BoundingBox bounds, Point3f charPosition) {
        Rectangle2D logicalBounds = null;
        Rectangle2D visualBounds = null;
        double logWidth = 0.0;
        double logHeight = 0.0;
        double visX = 0.0;
        double visY = 0.0;
        double visY_trans = 0.0;
        double visWidth = 0.0;
        double visHeight = 0.0;
        double visWidthMax = 0.0;
        double[] visWidths = null;
        double vertWS = 0.25;
        double vertS = 0.125;
        double verticalSpace = 0.0;
        Point3d lower = new Point3d();
        Point3d upper = new Point3d();
        Point3d visLower = new Point3d();
        Point3d visUpper = new Point3d();
        boolean isVisBoundsStarted = false;
        boolean isCurrCharWhitespace = false;
        Point3f position = new Point3f();
        boolean isPathUp = this.stringPath == Path.UP_CENTER || this.stringPath == Path.UP_LEFT || this.stringPath == Path.UP_RIGHT;
        boolean isPathDown = this.stringPath == Path.DOWN_CENTER || this.stringPath == Path.DOWN_LEFT || this.stringPath == Path.DOWN_RIGHT;
        int numChars = glyphVectors.length;
        Vector3f[] charTranslations = new Vector3f[numChars];
        int i = 0;
        while (i < numChars) {
            charTranslations[i] = new Vector3f();
            ++i;
        }
        logicalBounds = glyphVectors[0].getLogicalBounds();
        logWidth = logicalBounds.getWidth();
        logHeight = logicalBounds.getHeight();
        visualBounds = glyphVectors[0].getVisualBounds();
        visX = visualBounds.getX();
        visY = visualBounds.getY();
        visWidth = visualBounds.getWidth();
        visHeight = visualBounds.getHeight();
        if (visWidth < 1.0E-6 || visHeight < 1.0E-6) {
            isCurrCharWhitespace = true;
        }
        position.set((Tuple3f)charPosition);
        lower.set((Tuple3f)position);
        upper.set((Tuple3f)position);
        visLower.z = charPosition.z;
        visUpper.z = charPosition.z;
        if (this.stringPath == Path.RIGHT || this.stringPath == Path.LEFT) {
            position.x += (float)visX * -1.0f;
            upper.x = numChars == 1 ? (upper.x += visWidth) : (upper.x += logWidth - visX);
            if (!isCurrCharWhitespace) {
                isVisBoundsStarted = true;
                visLower.x = charPosition.x;
                visLower.y = (double)charPosition.y + -1.0 * (visY + visHeight);
                visUpper.x = visLower.x + visWidth;
                visUpper.y = visLower.y + visHeight;
            }
        } else if (isPathUp || isPathDown) {
            visWidths = new double[numChars];
            visWidths[0] = visWidth;
            visWidthMax = visWidth;
            verticalSpace = logHeight * vertS + (double)this.stringSpacing;
            if (isCurrCharWhitespace) {
                visHeight = logHeight * vertWS;
            }
            position.x += (float)visX * -1.0f;
            visY_trans = visualBounds.getY() + visHeight;
            position.y = (float)(upper.y + visY_trans);
            upper.y += visHeight;
            if (!isCurrCharWhitespace) {
                isVisBoundsStarted = true;
                visLower.x = charPosition.x;
                visLower.y = charPosition.y;
                visUpper.x = visLower.x + visWidth;
                visUpper.y = visLower.y + visHeight;
            }
        }
        charTranslations[0].set((Tuple3f)position);
        i = 1;
        while (i < numChars) {
            logicalBounds = glyphVectors[i].getLogicalBounds();
            logWidth = logicalBounds.getWidth();
            logHeight = logicalBounds.getHeight();
            visualBounds = glyphVectors[i].getVisualBounds();
            visX = visualBounds.getX();
            visY = visualBounds.getY();
            visWidth = visualBounds.getWidth();
            visHeight = visualBounds.getHeight();
            boolean bl = isCurrCharWhitespace = visWidth < 1.0E-6 || visHeight < 1.0E-6;
            if (this.stringPath == Path.RIGHT || this.stringPath == Path.LEFT) {
                upper.x += (double)this.stringSpacing;
                position.x = (float)upper.x;
                upper.x = i == numChars - 1 ? (isCurrCharWhitespace ? (upper.x += logWidth) : (upper.x += visX + visWidth)) : (upper.x += logWidth);
                if (!isCurrCharWhitespace) {
                    if (isVisBoundsStarted) {
                        visLower.y = Math.min(visLower.y, (double)charPosition.y + -1.0 * (visY + visHeight));
                        visUpper.x = (double)position.x + (visX + visWidth);
                        visUpper.y = Math.max(visUpper.y, (double)charPosition.y + -1.0 * visY);
                    } else {
                        isVisBoundsStarted = true;
                        visLower.x = (double)position.x + visX;
                        visLower.y = (double)charPosition.y + -1.0 * (visY + visHeight);
                        visUpper.x = visLower.x + visWidth;
                        visUpper.y = visLower.y + visHeight;
                    }
                }
            } else if (isPathUp || isPathDown) {
                if (isCurrCharWhitespace) {
                    visHeight = logHeight * vertWS;
                }
                visY_trans = visualBounds.getY() + visHeight;
                position.x = charPosition.x + (float)visX * -1.0f;
                upper.y += verticalSpace;
                position.y = (float)(upper.y + visY_trans);
                upper.y += visHeight;
                if (!isCurrCharWhitespace) {
                    if (isVisBoundsStarted) {
                        visUpper.x = Math.max(visUpper.x, visLower.x + visWidth);
                        visUpper.y = upper.y;
                    } else {
                        isVisBoundsStarted = true;
                        visLower.x = charPosition.x;
                        visLower.y = (double)charPosition.y + upper.y - visHeight;
                        visUpper.x = visLower.x + visWidth;
                        visUpper.y = visLower.y + visHeight;
                    }
                }
                visWidths[i] = visWidth;
                if (visWidthMax < visWidth) {
                    visWidthMax = visWidth;
                }
            }
            charTranslations[i].set((Tuple3f)position);
            ++i;
        }
        if (isPathUp || isPathDown) {
            int i2;
            double visdx = visUpper.x - visLower.x;
            if (this.stringPath == Path.UP_CENTER || this.stringPath == Path.DOWN_CENTER) {
                i2 = 0;
                while (i2 < numChars) {
                    charTranslations[i2].x = (float)((double)charTranslations[i2].x - visWidths[i2] / 2.0);
                    ++i2;
                }
                visLower.x -= visdx / 2.0;
                visUpper.x -= visdx / 2.0;
            } else if (this.stringPath == Path.UP_RIGHT || this.stringPath == Path.DOWN_RIGHT) {
                i2 = 0;
                while (i2 < numChars) {
                    charTranslations[i2].x = (float)((double)charTranslations[i2].x - visWidths[i2]);
                    ++i2;
                }
                visLower.x -= visdx;
                visUpper.x -= visdx;
            }
        }
        double dx = upper.x - lower.x;
        double dy = upper.y - lower.y;
        if (this.stringAlignment == Alignment.FIRST) {
            if (this.stringPath == Path.LEFT) {
                int i3 = 0;
                while (i3 < numChars) {
                    charTranslations[i3].x = (float)((double)charTranslations[i3].x - dx);
                    ++i3;
                }
                visLower.x -= dx;
                visUpper.x -= dx;
            } else if (isPathDown) {
                int i4 = 0;
                while (i4 < numChars) {
                    charTranslations[i4].y = (float)((double)charTranslations[i4].y - dy);
                    ++i4;
                }
                visLower.y -= dy;
                visUpper.y -= dy;
            }
        } else if (this.stringAlignment == Alignment.LAST) {
            if (this.stringPath == Path.RIGHT) {
                int i5 = 0;
                while (i5 < numChars) {
                    charTranslations[i5].x = (float)((double)charTranslations[i5].x - dx);
                    ++i5;
                }
                visLower.x -= dx;
                visUpper.x -= dx;
            } else if (isPathUp) {
                int i6 = 0;
                while (i6 < numChars) {
                    charTranslations[i6].y = (float)((double)charTranslations[i6].y - dy);
                    ++i6;
                }
                visLower.y -= dy;
                visUpper.y -= dy;
            }
        } else if (this.stringAlignment == Alignment.CENTER) {
            dx *= 0.5;
            dy *= 0.5;
            if (this.stringPath == Path.RIGHT || this.stringPath == Path.LEFT) {
                int i7 = 0;
                while (i7 < numChars) {
                    charTranslations[i7].x = (float)((double)charTranslations[i7].x - dx);
                    ++i7;
                }
                visLower.x -= dx;
                visUpper.x -= dx;
            } else if (isPathUp || isPathDown) {
                int i8 = 0;
                while (i8 < numChars) {
                    charTranslations[i8].y = (float)((double)charTranslations[i8].y - dy);
                    ++i8;
                }
                visLower.y -= dy;
                visUpper.y -= dy;
            }
        }
        if (bounds != null) {
            bounds.setLower(visLower);
            bounds.setUpper(visUpper);
        }
        return charTranslations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Alignment {
        CENTER,
        FIRST,
        LAST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Path {
        LEFT,
        RIGHT,
        DOWN_CENTER,
        DOWN_LEFT,
        DOWN_RIGHT,
        UP_CENTER,
        UP_LEFT,
        UP_RIGHT;

    }
}

