
package com.interactivemesh.j3d.testspace.jfx.distortstring;

import java.lang.System;

import javax.swing.JPanel;

import javafx.ext.swing.SwingComponent;
import javafx.util.Math;

// FXCanvas3D API 3.0
import com.interactivemesh.j3d.community.gui.FXCanvas3DSB; 
import com.interactivemesh.j3d.community.gui.FXCanvas3DRepainter;

/**
 * FXCancas3DComp.fx
 *
 * Version: 6.1
 * Date: 2010/09/19
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'FXCancas3DComp.fx'.
 *
 */
package class FXCanvas3DComp extends SwingComponent, FXCanvas3DRepainter {

    // Container for FXCanvas3D's parent
    var container: JPanel; 

    // FXCanvas3D instance
    var fxCanvas3D: FXCanvas3DSB;

    // Frames per second
    def updatesPerSecond = 2;
    var elapsedFrames: Integer = 50;
    var frameCounter: Integer;
    var startTimePaint: Number = System.nanoTime()/1000000;
    var endTimePaint: Number;
    package var frameDuration: Number;
    package var fpsPaint: Integer;


    // Create SwingComponent - called at construction time
    override protected function createJComponent(): JPanel{
        container = new JPanel();
    }

    // Async call from Main
    package function initFXCanvas3D(universe: DistortStringUniverse) {
        fxCanvas3D = universe.createFXCanvas3D(this, container);
    }
    
    // Interface FXCanvas3Repainter

    // Called from FXCanvas3D
    override function repaintFXCanvas3D() {
        /*
         JavaFX API :
         A deferAction represents an action that should be executed
         at a later time of the system's choosing.
         In systems based on event dispatch, such as Swing, execution of a
         deferAction generally means putting it on the event queue for later processing.
        */
        FX.deferAction(
            function(): Void {

                // Now we are in the JavaFX painting loop and on the EDT

                // Repaint FXCanvas3D

                // Call doesn't wait, paintComponent() will be called in the next loop !?
                fxCanvas3D.repaint();

                //
                // Frames per second
                //

                frameCounter++;
                
                if (frameCounter >= elapsedFrames) {
			    		
                    endTimePaint = System.nanoTime()/1000000;
                    frameDuration = (endTimePaint-startTimePaint)/frameCounter;
                    startTimePaint = endTimePaint;

                    fpsPaint = (1000 / frameDuration) as Integer;

                    // Reset
                    frameCounter = 0;
                    elapsedFrames = Math.max(1, ((fpsPaint + 0.5) / updatesPerSecond)) as Integer;
                }
            }
        );
    }
}
