/*
 * Decompiled with CFR 0.152.
 */
package com.interactivemesh.j3d.community.utils.navigation.orbit;

import com.interactivemesh.j3d.community.utils.navigation.orbit.ViewPlatformBehaviorInterim;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;

public abstract class ViewPlatformAWTBehaviorInterim
extends ViewPlatformBehaviorInterim
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected static final int POST_ID = 9998;
    protected WakeupOnElapsedFrames frameWakeup;
    protected WakeupOnBehaviorPost postWakeup;
    protected Transform3D targetTransform = new Transform3D();
    protected boolean motion = false;
    public static final int MOUSE_LISTENER = 1;
    public static final int MOUSE_MOTION_LISTENER = 2;
    public static final int MOUSE_WHEEL_LISTENER = 8;
    protected Component component = null;
    private ArrayList eventQueue = new ArrayList();
    private int listenerFlags = 0;
    private boolean firstEvent = false;

    protected ViewPlatformAWTBehaviorInterim() {
    }

    protected ViewPlatformAWTBehaviorInterim(int listenerFlags) {
        this.setListenerFlags(listenerFlags);
    }

    protected void setListenerFlags(int listenerFlags) {
        this.listenerFlags = listenerFlags;
    }

    public void initialize() {
        this.frameWakeup = new WakeupOnElapsedFrames(0);
        this.postWakeup = new WakeupOnBehaviorPost((Behavior)this, 9998);
        this.wakeupOn((WakeupCondition)this.postWakeup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration behEnum) {
        boolean hadPost = false;
        while (behEnum.hasMoreElements()) {
            WakeupCondition wakeup = (WakeupCondition)behEnum.nextElement();
            if (wakeup instanceof WakeupOnElapsedFrames) {
                AWTEvent[] events = null;
                ArrayList arrayList = this.eventQueue;
                synchronized (arrayList) {
                    events = this.eventQueue.toArray(new AWTEvent[this.eventQueue.size()]);
                    this.eventQueue.clear();
                }
                this.processAWTEvents(events);
                if (!this.motion) continue;
                this.integrateTransforms();
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            hadPost = true;
        }
        if (this.motion || hadPost) {
            this.wakeupOn((WakeupCondition)this.frameWakeup);
        } else {
            if (this.component != null) {
                this.component.requestFocusInWindow();
            }
            this.wakeupOn((WakeupCondition)this.postWakeup);
        }
    }

    public void setEnable(boolean state) {
        if (state == this.getEnable()) {
            return;
        }
        super.setEnable(state);
        if (this.component != null && this.targetTG != null) {
            this.enableListeners(state);
        }
    }

    private void enableListeners(boolean enable) {
        if (this.component == null) {
            throw new IllegalStateException("No component available !!");
        }
        if (enable) {
            this.firstEvent = true;
            if ((this.listenerFlags & 1) != 0) {
                this.component.addMouseListener(this);
            }
            if ((this.listenerFlags & 2) != 0) {
                this.component.addMouseMotionListener(this);
            }
            if ((this.listenerFlags & 8) != 0) {
                this.component.addMouseWheelListener(this);
            }
        } else {
            if ((this.listenerFlags & 1) != 0) {
                this.component.removeMouseListener(this);
            }
            if ((this.listenerFlags & 2) != 0) {
                this.component.removeMouseMotionListener(this);
            }
            if ((this.listenerFlags & 8) != 0) {
                this.component.removeMouseWheelListener(this);
            }
        }
    }

    public void setAWTComponent(Component c) {
        if (this.component != null) {
            this.enableListeners(false);
        }
        this.component = c;
        if (this.component != null && this.targetTG != null && this.getEnable()) {
            this.enableListeners(true);
        }
    }

    public void setViewingTransformGroup(TransformGroup tg) {
        if (this.component != null) {
            this.enableListeners(false);
        }
        super.setViewingTransformGroup(tg);
        if (this.component != null && this.targetTG != null && this.getEnable()) {
            this.enableListeners(true);
        }
    }

    protected abstract void processAWTEvents(AWTEvent[] var1);

    protected abstract void integrateTransforms();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueAWTEvent(AWTEvent e) {
        ArrayList arrayList = this.eventQueue;
        synchronized (arrayList) {
            this.eventQueue.add(e);
            if (this.firstEvent || this.eventQueue.size() == 1) {
                this.firstEvent = false;
                this.postId(9998);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.queueAWTEvent(e);
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        this.queueAWTEvent(e);
    }
}

