
package com.interactivemesh.j3d.testspace.jfx.canvascube;

import java.lang.Math;

/**
 * Matrix3N.fx
 *
 * Version: 4.0
 * Date: 2010/09/20
 *
 * Copyright (c) 2009-2010
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 *
 * Please create your own implementation.
 * This source code is provided "AS IS", without warranty of any kind.
 * You are allowed to copy and use all lines you like of this source code
 * without any copyright notice,
 * but you may not modify, compile, or distribute this 'Matrix3N.fx'.
 *
 */

package class Matrix3N {

    var mat: Matrix3N;

    // Identity
    var m00: Number = 1.0;
    var m01: Number = 0.0;
    var m02: Number = 0.0;
    var m10: Number = 0.0;
    var m11: Number = 1.0;
    var m12: Number = 0.0;
    var m20: Number = 0.0;
    var m21: Number = 0.0;
    var m22: Number = 1.0;
    
    var n: Number = 0.0;
    var w: Number = 0.0;
    
    package function setupPerspectiveView(fov: Number, width: Number): Void {
        n = (width/2.0) / Math.tan(fov/2.0);
        w = width;
    }

    package function setIdentity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;

        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;

        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    package function set(mat: Matrix3N) {
        this.m00 = mat.m00;
        this.m01 = mat.m01;
        this.m02 = mat.m02;

        this.m10 = mat.m10;
        this.m11 = mat.m11;
        this.m12 = mat.m12;

        this.m20 = mat.m20;
        this.m21 = mat.m21;
        this.m22 = mat.m22;
    }

    package function set(mat: Number[]) {
        this.m00 = mat[0];
        this.m01 = mat[1];
        this.m02 = mat[2];

        this.m10 = mat[3];
        this.m11 = mat[4];
        this.m12 = mat[5];

        this.m20 = mat[6];
        this.m21 = mat[7];
        this.m22 = mat[8];
    }

    // Sets the value of this matrix to a counter clockwise rotation about the x axis.
    package function rotationX(angle: Number): Void {

        def sinAngle = Math.sin(angle);
        def cosAngle = Math.cos(angle);

        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;

        this.m10 = 0.0;
        this.m11 = cosAngle;
        this.m12 = -sinAngle;

        this.m20 = 0.0;
        this.m21 = sinAngle;
        this.m22 = cosAngle;
    }

    // Sets the value of this matrix to a counter clockwise rotation about the y axis.
    package function rotationY(angle: Number): Void {

        def sinAngle = Math.sin(angle);
        def cosAngle = Math.cos(angle);

        this.m00 = cosAngle;
        this.m01 = 0.0;
        this.m02 = sinAngle;

        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;

        this.m20 = -sinAngle;
        this.m21 = 0.0;
        this.m22 = cosAngle;
    }

    package function multiply(mat1: Matrix3N, mat2: Matrix3N): Void {
        this.m00 = mat1.m00*mat2.m00 + mat1.m01*mat2.m10 + mat1.m02*mat2.m20;
        this.m01 = mat1.m00*mat2.m01 + mat1.m01*mat2.m11 + mat1.m02*mat2.m21;
        this.m02 = mat1.m00*mat2.m02 + mat1.m01*mat2.m12 + mat1.m02*mat2.m22;

        this.m10 = mat1.m10*mat2.m00 + mat1.m11*mat2.m10 + mat1.m12*mat2.m20;
        this.m11 = mat1.m10*mat2.m01 + mat1.m11*mat2.m11 + mat1.m12*mat2.m21;
        this.m12 = mat1.m10*mat2.m02 + mat1.m11*mat2.m12 + mat1.m12*mat2.m22;

        this.m20 = mat1.m20*mat2.m00 + mat1.m21*mat2.m10 + mat1.m22*mat2.m20;
        this.m21 = mat1.m20*mat2.m01 + mat1.m21*mat2.m11 + mat1.m22*mat2.m21;
        this.m22 = mat1.m20*mat2.m02 + mat1.m21*mat2.m12 + mat1.m22*mat2.m22;
    }

    package function multiplyLeft(matLeft: Matrix3N): Void {
        if (mat == null) {
            mat = Matrix3N {};
        }

        mat.multiply(matLeft, this);

        this.set(mat);
    }

    package function transform(pointIn: Tuple3N, pointOut: Tuple3N): Void {
        pointOut.x = m00*pointIn.x + m01*pointIn.y + m02*pointIn.z;
        pointOut.y = m10*pointIn.x + m11*pointIn.y + m12*pointIn.z;
        pointOut.z = m20*pointIn.x + m21*pointIn.y + m22*pointIn.z;
    }

    package function transformPersp(pointIn: Tuple3N, pointOut: Tuple3N): Void {
        pointOut.x = m00*pointIn.x + m01*pointIn.y + m02*pointIn.z;
        pointOut.y = m10*pointIn.x + m11*pointIn.y + m12*pointIn.z;
        pointOut.z = m20*pointIn.x + m21*pointIn.y + m22*pointIn.z;

        def ratio = n / (n + (w-pointOut.z));

        pointOut.x *= ratio;
        pointOut.y *= ratio;
    }
}