/*
 * Decompiled with CFR 0.152.
 */
package org.interactivemesh.pivot.wtk.j3d.nav;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOnElapsedFrames;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.ComponentMouseListener;
import org.apache.pivot.wtk.ComponentMouseWheelListener;
import org.apache.pivot.wtk.Mouse;
import org.interactivemesh.pivot.wtk.j3d.nav.OrbitEvent;
import org.interactivemesh.pivot.wtk.j3d.nav.ViewPlatformBehaviorPivot;

public abstract class ViewPlatformEventBehaviorPivot
extends ViewPlatformBehaviorPivot
implements ComponentMouseListener,
ComponentMouseButtonListener,
ComponentMouseWheelListener {
    protected static final int POST_ID = 9998;
    protected WakeupOnElapsedFrames frameWakeup;
    protected WakeupOnBehaviorPost postWakeup;
    protected Transform3D targetTransform = new Transform3D();
    protected boolean motion = false;
    public static final int MOUSE_LISTENER = 1;
    public static final int MOUSE_MOTION_LISTENER = 2;
    public static final int MOUSE_WHEEL_LISTENER = 8;
    protected Component component = null;
    private ArrayList<OrbitEvent> eventQueue = new ArrayList();
    private int listenerFlags = 0;
    private boolean firstEvent = false;

    protected ViewPlatformEventBehaviorPivot() {
    }

    protected ViewPlatformEventBehaviorPivot(int listenerFlags) {
        this.setListenerFlags(listenerFlags);
    }

    protected void setListenerFlags(int listenerFlags) {
        this.listenerFlags = listenerFlags;
    }

    public void initialize() {
        this.frameWakeup = new WakeupOnElapsedFrames(0);
        this.postWakeup = new WakeupOnBehaviorPost((Behavior)this, 9998);
        this.wakeupOn((WakeupCondition)this.postWakeup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration behEnum) {
        boolean hadPost = false;
        while (behEnum.hasMoreElements()) {
            WakeupCondition wakeup = (WakeupCondition)behEnum.nextElement();
            if (wakeup instanceof WakeupOnElapsedFrames) {
                OrbitEvent[] events = null;
                ArrayList<OrbitEvent> arrayList = this.eventQueue;
                synchronized (arrayList) {
                    events = new OrbitEvent[this.eventQueue.size()];
                    this.eventQueue.toArray(events);
                    this.eventQueue.clear();
                }
                this.processEvents(events);
                if (!this.motion) continue;
                this.integrateTransforms();
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            hadPost = true;
        }
        if (this.motion || hadPost) {
            this.wakeupOn((WakeupCondition)this.frameWakeup);
        } else {
            if (this.component != null) {
                this.component.requestFocus();
            }
            this.wakeupOn((WakeupCondition)this.postWakeup);
        }
    }

    public void setEnable(boolean state) {
        if (state == this.getEnable()) {
            return;
        }
        super.setEnable(state);
        if (this.component != null && this.targetTG != null) {
            this.enableListeners(state);
        }
    }

    private void enableListeners(boolean enable) {
        if (this.component == null) {
            throw new IllegalStateException("No component available !!");
        }
        if (enable) {
            this.firstEvent = true;
            if ((this.listenerFlags & 1) != 0) {
                this.component.getComponentMouseButtonListeners().add((Object)this);
            }
            if ((this.listenerFlags & 2) != 0) {
                this.component.getComponentMouseListeners().add((Object)this);
            }
            if ((this.listenerFlags & 8) != 0) {
                this.component.getComponentMouseWheelListeners().add((Object)this);
            }
        } else {
            if ((this.listenerFlags & 1) != 0) {
                this.component.getComponentMouseButtonListeners().remove((Object)this);
            }
            if ((this.listenerFlags & 2) != 0) {
                this.component.getComponentMouseListeners().remove((Object)this);
            }
            if ((this.listenerFlags & 8) != 0) {
                this.component.getComponentMouseWheelListeners().remove((Object)this);
            }
        }
    }

    public void setComponent(Component c) {
        if (this.component != null) {
            this.enableListeners(false);
        }
        this.component = c;
        if (this.component != null && this.targetTG != null && this.getEnable()) {
            this.enableListeners(true);
        }
    }

    @Override
    public void setViewingTransformGroup(TransformGroup tg) {
        if (this.component != null) {
            this.enableListeners(false);
        }
        super.setViewingTransformGroup(tg);
        if (this.component != null && this.targetTG != null && this.getEnable()) {
            this.enableListeners(true);
        }
    }

    protected abstract void processEvents(OrbitEvent[] var1);

    protected abstract void integrateTransforms();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueEvent(OrbitEvent e) {
        ArrayList<OrbitEvent> arrayList = this.eventQueue;
        synchronized (arrayList) {
            this.eventQueue.add(e);
            if (this.firstEvent || this.eventQueue.size() == 1) {
                this.firstEvent = false;
                this.postId(9998);
            }
        }
    }

    public boolean mouseMove(Component component, int x, int y) {
        if (Mouse.isPressed((Mouse.Button)Mouse.Button.LEFT) || Mouse.isPressed((Mouse.Button)Mouse.Button.RIGHT) || Mouse.isPressed((Mouse.Button)Mouse.Button.MIDDLE)) {
            OrbitEvent event = new OrbitEvent();
            event.type = OrbitEvent.Type.MOUSE;
            event.id = OrbitEvent.ID.MOUSE_DRAGGED;
            event.x = x;
            event.y = y;
            this.queueEvent(event);
            return true;
        }
        return false;
    }

    public void mouseOver(Component component) {
    }

    public void mouseOut(Component component) {
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        OrbitEvent event = new OrbitEvent();
        event.type = OrbitEvent.Type.MOUSE;
        event.id = OrbitEvent.ID.MOUSE_PRESSED;
        event.x = x;
        event.y = y;
        event.setNav(button);
        this.queueEvent(event);
        return true;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        OrbitEvent event = new OrbitEvent();
        event.type = OrbitEvent.Type.MOUSE;
        event.id = OrbitEvent.ID.MOUSE_RELEASED;
        event.x = x;
        event.y = y;
        this.queueEvent(event);
        return true;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        return false;
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        OrbitEvent event = new OrbitEvent();
        event.type = OrbitEvent.Type.MOUSE;
        event.id = OrbitEvent.ID.MOUSE_WHEEL_ROTATED;
        event.wheelRotation = wheelRotation;
        event.x = x;
        event.y = y;
        this.queueEvent(event);
        return true;
    }
}

