/*
 * org.interactivemesh.pivot.wtk.j3d.nav.OrbitEvent.java
 *
 * Copyright (c) 2009 InteractiveMesh e.K.. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * - Redistribution of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * Neither the name of InteractiveMesh e.K. or the names of
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * This software is provided "AS IS," without a warranty of any
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF
 * USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR
 * ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *
 * You acknowledge that this software is not designed, licensed or
 * intended for use in the design, construction, operation or
 * maintenance of any nuclear facility.
 *
 *
 * Version: 2.0
 * Date: 2011/01/15
 * 
 * Author:
 * August Lammersdorf, InteractiveMesh e.K.
 * Kolomanstrasse 2a, 85737 Ismaning
 * Germany / Munich Area
 * www.InteractiveMesh.com/org
 * 
 */
 
package org.interactivemesh.pivot.wtk.j3d.nav;

import org.apache.pivot.wtk.Mouse.Button;

final class OrbitEvent {
    
    enum Nav {
        ROTATE,
        TRANSLATE,
        ZOOM
    }
    
    enum Type {
        KEY,
        MOUSE
    }

    enum ID {      
        KEY_PRESSED,   
        KEY_RELEASED,
        
        MOUSE_ENTERED, 
        MOUSE_EXITED,
        MOUSE_PRESSED,
        MOUSE_RELEASED,
        
        MOUSE_MOVED,
        
        MOUSE_DRAGGED,
        
        MOUSE_WHEEL_ROTATED,
    }
    
    void setNav(Button button) {
        if (button == Button.LEFT)
            nav = Nav.ROTATE;
        else if (button == Button.MIDDLE)
            nav = Nav.ZOOM;
        else if (button == Button.RIGHT)
            nav = Nav.TRANSLATE;
        else
            nav = null;
    }
    
    Nav     nav     =   null;

    Type    type    =   null;
    
    ID      id      =   null;
    
    Button  button  =   null;
    
    int     x       =   0;
    int     y       =   0;
    
    int     wheelRotation = 0;

}
