/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Resources;
import org.apache.pivot.wtk.AlertListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dialog;
import org.apache.pivot.wtk.DialogCloseListener;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Window;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="body")
public class Alert
extends Dialog {
    private MessageType messageType = null;
    private String message = null;
    private Component body = null;
    private ArrayList<Object> options = new ArrayList();
    private OptionSequence optionSequence = new OptionSequence();
    private int selectedOptionIndex = -1;
    private AlertListenerList alertListeners = new AlertListenerList();
    private static Resources resources = null;

    public Alert() {
        this(null, null, null);
    }

    public Alert(MessageType messageType, String message, Sequence<?> options) {
        this(messageType, message, options, true);
    }

    public Alert(MessageType messageType, String message, Sequence<?> options, boolean modal) {
        this(messageType, message, options, null, modal);
    }

    public Alert(MessageType messageType, String message, Sequence<?> options, Component body) {
        this(messageType, message, options, body, true);
    }

    public Alert(MessageType messageType, String message, Sequence<?> options, Component body, boolean modal) {
        super(modal);
        this.setMessageType(messageType == null ? MessageType.INFO : messageType);
        this.setMessage(message);
        this.setOptions((Sequence<?>)(options == null ? new ArrayList(new Object[]{resources.get("defaultOption")}) : options));
        this.setBody(body);
        if (messageType == null) {
            this.setTitle((String)resources.get("defaultTitle"));
        } else {
            switch (messageType) {
                case ERROR: {
                    this.setTitle((String)resources.get("defaultErrorTitle"));
                    break;
                }
                case WARNING: {
                    this.setTitle((String)resources.get("defaultWarningTitle"));
                    break;
                }
                case QUESTION: {
                    this.setTitle((String)resources.get("defaultQuestionTitle"));
                    break;
                }
                case INFO: {
                    this.setTitle((String)resources.get("defaultInfoTitle"));
                    break;
                }
                default: {
                    this.setTitle((String)resources.get("defaultTitle"));
                }
            }
        }
        this.installSkin(Alert.class);
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException();
        }
        MessageType previousMessageType = this.messageType;
        if (previousMessageType != messageType) {
            this.messageType = messageType;
            this.alertListeners.messageTypeChanged(this, previousMessageType);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String previousMessage = this.message;
        if (previousMessage != message) {
            this.message = message;
            this.alertListeners.messageChanged(this, previousMessage);
        }
    }

    public Component getBody() {
        return this.body;
    }

    public void setBody(Component body) {
        Component previousBody = this.body;
        if (previousBody != body) {
            this.body = body;
            this.alertListeners.bodyChanged(this, previousBody);
        }
    }

    public OptionSequence getOptions() {
        return this.optionSequence;
    }

    public void setOptions(Sequence<?> options) {
        this.optionSequence.remove(0, this.optionSequence.getLength());
        if (options != null) {
            int n = options.getLength();
            for (int i = 0; i < n; ++i) {
                this.optionSequence.add(options.get(i));
            }
            this.setSelectedOptionIndex(0);
        }
    }

    public void setOptions(String options) {
        try {
            this.setOptions((Sequence<?>)JSONSerializer.parseList((String)options));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int getSelectedOptionIndex() {
        return this.selectedOptionIndex;
    }

    public void setSelectedOptionIndex(int selectedOption) {
        if (selectedOption < -1 || selectedOption > this.options.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int previousSelectedOption = this.selectedOptionIndex;
        if (selectedOption != previousSelectedOption) {
            this.selectedOptionIndex = selectedOption;
            this.alertListeners.selectedOptionChanged(this, previousSelectedOption);
        }
    }

    public Object getSelectedOption() {
        return this.selectedOptionIndex == -1 ? null : this.options.get(this.selectedOptionIndex);
    }

    public void setSelectedOption(Object selectedOption) {
        this.setSelectedOptionIndex(this.options.indexOf(selectedOption));
    }

    public ListenerList<AlertListener> getAlertListeners() {
        return this.alertListeners;
    }

    public static void alert(String message, Window owner) {
        Alert.alert(MessageType.INFO, message, null, null, owner, null);
    }

    public static void alert(MessageType messageType, String message, Window owner) {
        Alert.alert(messageType, message, null, null, owner, null);
    }

    public static void alert(MessageType messageType, String message, Window owner, DialogCloseListener dialogCloseListener) {
        Alert.alert(messageType, message, null, null, owner, dialogCloseListener);
    }

    public static void alert(MessageType messageType, String message, Component body, Window owner) {
        Alert.alert(messageType, message, null, body, owner, null);
    }

    public static void alert(MessageType messageType, String message, Component body, Window owner, DialogCloseListener dialogCloseListener) {
        Alert.alert(messageType, message, null, body, owner, dialogCloseListener);
    }

    public static void alert(MessageType messageType, String message, String title, Component body, Window owner, DialogCloseListener dialogCloseListener) {
        Alert alert = new Alert(messageType, message, null, body);
        if (title != null) {
            alert.setTitle(title);
        }
        alert.open(owner.getDisplay(), owner, dialogCloseListener);
    }

    static {
        try {
            resources = new Resources(Alert.class.getName());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlertListenerList
    extends ListenerList<AlertListener>
    implements AlertListener {
        private AlertListenerList() {
        }

        @Override
        public void messageTypeChanged(Alert alert, MessageType previousMessageType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AlertListener listener = (AlertListener)i$.next();
                listener.messageTypeChanged(alert, previousMessageType);
            }
        }

        @Override
        public void messageChanged(Alert alert, String previousMessage) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AlertListener listener = (AlertListener)i$.next();
                listener.messageChanged(alert, previousMessage);
            }
        }

        @Override
        public void bodyChanged(Alert alert, Component previousBody) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AlertListener listener = (AlertListener)i$.next();
                listener.bodyChanged(alert, previousBody);
            }
        }

        @Override
        public void optionInserted(Alert alert, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AlertListener listener = (AlertListener)i$.next();
                listener.optionInserted(alert, index);
            }
        }

        @Override
        public void optionsRemoved(Alert alert, int index, Sequence<?> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AlertListener listener = (AlertListener)i$.next();
                listener.optionsRemoved(alert, index, removed);
            }
        }

        @Override
        public void selectedOptionChanged(Alert alert, int previousSelectedOption) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                AlertListener listener = (AlertListener)i$.next();
                listener.selectedOptionChanged(alert, previousSelectedOption);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class OptionSequence
    implements Sequence<Object>,
    Iterable<Object> {
        private OptionSequence() {
        }

        public int add(Object option) {
            int index = this.getLength();
            this.insert(option, index);
            return index;
        }

        public void insert(Object option, int index) {
            if (option == null) {
                throw new IllegalArgumentException("option is null.");
            }
            Alert.this.options.insert(option, index);
            if (Alert.this.selectedOptionIndex >= index) {
                Alert.this.selectedOptionIndex++;
            }
            Alert.this.alertListeners.optionInserted(Alert.this, index);
        }

        public Component update(int index, Object option) {
            throw new UnsupportedOperationException();
        }

        public int remove(Object option) {
            int index = this.indexOf(option);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Object> remove(int index, int count) {
            Sequence removed = Alert.this.options.remove(index, count);
            if (removed.getLength() > 0) {
                if (Alert.this.selectedOptionIndex >= index) {
                    if (Alert.this.selectedOptionIndex < index + count) {
                        Alert.this.selectedOptionIndex = -1;
                    } else {
                        Alert.this.selectedOptionIndex -= count;
                    }
                }
                Alert.this.alertListeners.optionsRemoved(Alert.this, index, removed);
            }
            return removed;
        }

        public Object get(int index) {
            return Alert.this.options.get(index);
        }

        public int indexOf(Object option) {
            return Alert.this.options.indexOf(option);
        }

        public int getLength() {
            return Alert.this.options.getLength();
        }

        @Override
        public Iterator<Object> iterator() {
            return new ImmutableIterator((Iterator)Alert.this.options.iterator());
        }
    }
}

