/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import java.util.Locale;
import org.apache.pivot.json.JSON;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Action;
import org.apache.pivot.wtk.ActionListener;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.ButtonBindingListener;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonListener;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.ButtonStateListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Renderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Button
extends Component {
    private Object buttonData = null;
    private DataRenderer dataRenderer = null;
    private Action action = null;
    private ActionListener actionListener = new ActionListener(){

        public void enabledChanged(Action action) {
            Button.this.setEnabled(action.isEnabled());
        }
    };
    private State state = State.UNSELECTED;
    private boolean toggleButton = false;
    private boolean triState = false;
    private ButtonGroup buttonGroup = null;
    private String selectedKey = null;
    private BindType selectedBindType = BindType.BOTH;
    private SelectedBindMapping selectedBindMapping = null;
    private String stateKey = null;
    private BindType stateBindType = BindType.BOTH;
    private StateBindMapping stateBindMapping = null;
    private String buttonDataKey = null;
    private BindType buttonDataBindType = BindType.BOTH;
    private ButtonDataBindMapping buttonDataBindMapping = null;
    private ButtonListenerList buttonListeners = new ButtonListenerList();
    private ButtonStateListenerList buttonStateListeners = new ButtonStateListenerList();
    private ButtonPressListenerList buttonPressListeners = new ButtonPressListenerList();
    private ButtonBindingListenerList buttonBindingListeners = new ButtonBindingListenerList();

    public Button() {
        this(null);
    }

    public Button(Object buttonData) {
        this.buttonData = buttonData;
    }

    public Object getButtonData() {
        return this.buttonData;
    }

    public void setButtonData(Object buttonData) {
        Object previousButtonData = this.buttonData;
        if (previousButtonData != buttonData) {
            this.buttonData = buttonData;
            this.buttonListeners.buttonDataChanged(this, previousButtonData);
        }
    }

    public DataRenderer getDataRenderer() {
        return this.dataRenderer;
    }

    public void setDataRenderer(DataRenderer dataRenderer) {
        if (dataRenderer == null) {
            throw new IllegalArgumentException("dataRenderer is null.");
        }
        DataRenderer previousDataRenderer = this.dataRenderer;
        if (previousDataRenderer != dataRenderer) {
            this.dataRenderer = dataRenderer;
            this.buttonListeners.dataRendererChanged(this, previousDataRenderer);
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        Action previousAction = this.action;
        if (previousAction != action) {
            if (previousAction != null) {
                previousAction.getActionListeners().remove((Object)this.actionListener);
            }
            this.action = action;
            if (action != null) {
                action.getActionListeners().add((Object)this.actionListener);
                this.setEnabled(action.isEnabled());
            }
            this.buttonListeners.actionChanged(this, previousAction);
        }
    }

    public void setAction(String actionID) {
        if (actionID == null) {
            throw new IllegalArgumentException("actionID is null");
        }
        Action action = Action.getNamedActions().get(actionID);
        if (action == null) {
            throw new IllegalArgumentException("An action with ID " + actionID + " does not exist.");
        }
        this.setAction(action);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.action != null && enabled != this.action.isEnabled()) {
            throw new IllegalArgumentException("Button and action enabled states are not consistent.");
        }
        super.setEnabled(enabled);
    }

    public void press() {
        this.buttonPressListeners.buttonPressed(this);
        if (this.action != null) {
            this.action.perform(this);
        }
    }

    public boolean isSelected() {
        return this.getState() == State.SELECTED;
    }

    public void setSelected(boolean selected) {
        this.setState(selected ? State.SELECTED : State.UNSELECTED);
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        if (state == null) {
            throw new IllegalArgumentException("state is null.");
        }
        if (!this.toggleButton) {
            throw new IllegalStateException("Button is not in toggle mode.");
        }
        if (state == State.MIXED && !this.triState) {
            throw new IllegalArgumentException("Button is not tri-state.");
        }
        State previousState = this.state;
        if (previousState != state) {
            this.state = state;
            if (this.buttonGroup != null) {
                if (state == State.SELECTED) {
                    this.buttonGroup.setSelection(this);
                } else if (this.buttonGroup.getSelection() == this) {
                    this.buttonGroup.setSelection(null);
                }
            }
            this.buttonStateListeners.stateChanged(this, previousState);
        }
    }

    public boolean isToggleButton() {
        return this.toggleButton;
    }

    public void setToggleButton(boolean toggleButton) {
        if (this.toggleButton != toggleButton) {
            if (!toggleButton) {
                this.setSelected(false);
                this.setButtonGroup(null);
                this.setTriState(false);
            }
            this.toggleButton = toggleButton;
            this.buttonListeners.toggleButtonChanged(this);
        }
    }

    public boolean isTriState() {
        return this.triState;
    }

    public void setTriState(boolean triState) {
        if (!this.toggleButton) {
            throw new IllegalStateException("Button is not in toggle mode.");
        }
        if (triState && this.buttonGroup != null) {
            throw new IllegalStateException("Toggle button is a member of a group.");
        }
        if (this.triState != triState) {
            this.triState = triState;
            this.buttonListeners.triStateChanged(this);
        }
    }

    public ButtonGroup getButtonGroup() {
        return this.buttonGroup;
    }

    public void setButtonGroup(ButtonGroup buttonGroup) {
        if (!this.toggleButton) {
            throw new IllegalStateException("Button is not in toggle mode.");
        }
        if (buttonGroup != null && this.triState) {
            throw new IllegalStateException("Toggle button is tri-state.");
        }
        ButtonGroup previousButtonGroup = this.buttonGroup;
        if (previousButtonGroup != buttonGroup) {
            this.buttonGroup = buttonGroup;
            if (previousButtonGroup != null) {
                previousButtonGroup.remove(this);
            }
            if (buttonGroup != null) {
                buttonGroup.add(this);
            }
            this.buttonListeners.buttonGroupChanged(this, previousButtonGroup);
        }
    }

    public String getButtonDataKey() {
        return this.buttonDataKey;
    }

    public void setButtonDataKey(String buttonDataKey) {
        String previousButtonDataKey = this.buttonDataKey;
        if (previousButtonDataKey != buttonDataKey) {
            this.buttonDataKey = buttonDataKey;
            this.buttonBindingListeners.buttonDataKeyChanged(this, previousButtonDataKey);
        }
    }

    public BindType getButtonDataBindType() {
        return this.buttonDataBindType;
    }

    public void setButtonDataBindType(BindType buttonDataBindType) {
        if (buttonDataBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousButtonDataBindType = this.buttonDataBindType;
        if (previousButtonDataBindType != buttonDataBindType) {
            this.buttonDataBindType = buttonDataBindType;
            this.buttonBindingListeners.buttonDataBindTypeChanged(this, previousButtonDataBindType);
        }
    }

    public ButtonDataBindMapping getButtonDataBindMapping() {
        return this.buttonDataBindMapping;
    }

    public void setButtonDataBindMapping(ButtonDataBindMapping buttonDataBindMapping) {
        ButtonDataBindMapping previousButtonDataBindMapping = this.buttonDataBindMapping;
        if (previousButtonDataBindMapping != buttonDataBindMapping) {
            this.buttonDataBindMapping = buttonDataBindMapping;
            this.buttonBindingListeners.buttonDataBindMappingChanged(this, previousButtonDataBindMapping);
        }
    }

    public String getSelectedKey() {
        return this.selectedKey;
    }

    public void setSelectedKey(String selectedKey) {
        String previousSelectedKey = this.selectedKey;
        if (previousSelectedKey != selectedKey) {
            this.selectedKey = selectedKey;
            this.buttonBindingListeners.selectedKeyChanged(this, previousSelectedKey);
        }
    }

    public BindType getSelectedBindType() {
        return this.selectedBindType;
    }

    public void setSelectedBindType(BindType selectedBindType) {
        if (selectedBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedBindType = this.selectedBindType;
        if (previousSelectedBindType != selectedBindType) {
            this.selectedBindType = selectedBindType;
            this.buttonBindingListeners.selectedBindTypeChanged(this, previousSelectedBindType);
        }
    }

    public SelectedBindMapping getSelectedBindMapping() {
        return this.selectedBindMapping;
    }

    public void setSelectedBindMapping(SelectedBindMapping selectedBindMapping) {
        SelectedBindMapping previousSelectedBindMapping = this.selectedBindMapping;
        if (previousSelectedBindMapping != selectedBindMapping) {
            this.selectedBindMapping = selectedBindMapping;
            this.buttonBindingListeners.selectedBindMappingChanged(this, previousSelectedBindMapping);
        }
    }

    public String getStateKey() {
        return this.stateKey;
    }

    public void setStateKey(String stateKey) {
        String previousStateKey = this.stateKey;
        if (previousStateKey != stateKey) {
            this.stateKey = stateKey;
            this.buttonBindingListeners.stateKeyChanged(this, previousStateKey);
        }
    }

    public BindType getStateBindType() {
        return this.stateBindType;
    }

    public void setStateBindType(BindType stateBindType) {
        if (stateBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousStateBindType = this.stateBindType;
        if (previousStateBindType != stateBindType) {
            this.stateBindType = stateBindType;
            this.buttonBindingListeners.stateBindTypeChanged(this, previousStateBindType);
        }
    }

    public StateBindMapping getStateBindMapping() {
        return this.stateBindMapping;
    }

    public void setStateBindMapping(StateBindMapping stateBindMapping) {
        StateBindMapping previousStateBindMapping = this.stateBindMapping;
        if (previousStateBindMapping != stateBindMapping) {
            this.stateBindMapping = stateBindMapping;
            this.buttonBindingListeners.stateBindMappingChanged(this, previousStateBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        Object value;
        if (this.toggleButton) {
            if (this.triState) {
                if (this.stateKey != null && this.stateBindType != BindType.STORE && JSON.containsKey((Object)context, (String)this.stateKey)) {
                    value = JSON.get((Object)context, (String)this.stateKey);
                    State state = State.UNSELECTED;
                    if (value instanceof State) {
                        state = (State)((Object)value);
                    } else if (this.stateBindMapping == null) {
                        if (value != null) {
                            state = State.valueOf(value.toString().toUpperCase(Locale.ENGLISH));
                        }
                    } else {
                        state = this.stateBindMapping.toState(value);
                    }
                    this.setState(state);
                }
            } else if (this.selectedKey != null && this.selectedBindType != BindType.STORE && JSON.containsKey((Object)context, (String)this.selectedKey)) {
                value = JSON.get((Object)context, (String)this.selectedKey);
                boolean selected = false;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                } else if (this.selectedBindMapping == null) {
                    if (value != null) {
                        selected = Boolean.valueOf(value.toString());
                    }
                } else {
                    selected = this.selectedBindMapping.isSelected(value);
                }
                this.setSelected(selected);
            }
        }
        if (this.buttonDataKey != null && JSON.containsKey((Object)context, (String)this.buttonDataKey) && this.buttonDataBindType != BindType.STORE) {
            value = JSON.get((Object)context, (String)this.buttonDataKey);
            this.setButtonData(this.buttonDataBindMapping == null ? value : this.buttonDataBindMapping.toButtonData(value));
        }
    }

    @Override
    public void store(Object context) {
        if (this.toggleButton) {
            if (this.triState) {
                if (this.stateKey != null && this.stateBindType != BindType.LOAD) {
                    JSON.put((Object)context, (String)this.selectedKey, (Object)(this.stateBindMapping == null ? this.state : this.stateBindMapping.valueOf(this.state)));
                }
            } else if (this.selectedKey != null && this.selectedBindType != BindType.LOAD) {
                JSON.put((Object)context, (String)this.selectedKey, (Object)(this.selectedBindMapping == null ? Boolean.valueOf(this.isSelected()) : this.selectedBindMapping.valueOf(this.isSelected())));
            }
        }
        if (this.buttonDataKey != null && this.buttonDataBindType != BindType.LOAD) {
            JSON.put((Object)context, (String)this.buttonDataKey, (Object)(this.buttonDataBindMapping == null ? this.buttonData : this.buttonDataBindMapping.valueOf(this.buttonData)));
        }
    }

    @Override
    public void clear() {
        if (this.buttonDataKey != null) {
            this.setButtonData(null);
        }
        if (this.selectedKey != null || this.stateKey != null) {
            this.setSelected(false);
        }
    }

    public ListenerList<ButtonListener> getButtonListeners() {
        return this.buttonListeners;
    }

    public ListenerList<ButtonStateListener> getButtonStateListeners() {
        return this.buttonStateListeners;
    }

    public ListenerList<ButtonPressListener> getButtonPressListeners() {
        return this.buttonPressListeners;
    }

    public ListenerList<ButtonBindingListener> getButtonBindingListeners() {
        return this.buttonBindingListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ButtonBindingListenerList
    extends ListenerList<ButtonBindingListener>
    implements ButtonBindingListener {
        private ButtonBindingListenerList() {
        }

        @Override
        public void buttonDataKeyChanged(Button button, String previousButtonDataKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonBindingListener listener = (ButtonBindingListener)i$.next();
                listener.buttonDataKeyChanged(button, previousButtonDataKey);
            }
        }

        @Override
        public void buttonDataBindTypeChanged(Button button, BindType previousDataBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonBindingListener listener = (ButtonBindingListener)i$.next();
                listener.buttonDataBindTypeChanged(button, previousDataBindType);
            }
        }

        @Override
        public void buttonDataBindMappingChanged(Button button, ButtonDataBindMapping previousButtonDataBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonBindingListener listener = (ButtonBindingListener)i$.next();
                listener.buttonDataBindMappingChanged(button, previousButtonDataBindMapping);
            }
        }

        @Override
        public void selectedKeyChanged(Button button, String previousSelectedKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonBindingListener listener = (ButtonBindingListener)i$.next();
                listener.selectedKeyChanged(button, previousSelectedKey);
            }
        }

        @Override
        public void selectedBindTypeChanged(Button button, BindType previousSelectedBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonBindingListener listener = (ButtonBindingListener)i$.next();
                listener.selectedBindTypeChanged(button, previousSelectedBindType);
            }
        }

        @Override
        public void selectedBindMappingChanged(Button button, SelectedBindMapping previousSelectedBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonBindingListener listener = (ButtonBindingListener)i$.next();
                listener.selectedBindMappingChanged(button, previousSelectedBindMapping);
            }
        }

        @Override
        public void stateKeyChanged(Button button, String previousStateKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonBindingListener listener = (ButtonBindingListener)i$.next();
                listener.stateKeyChanged(button, previousStateKey);
            }
        }

        @Override
        public void stateBindTypeChanged(Button button, BindType previousStateBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonBindingListener listener = (ButtonBindingListener)i$.next();
                listener.stateBindTypeChanged(button, previousStateBindType);
            }
        }

        @Override
        public void stateBindMappingChanged(Button button, StateBindMapping previousStateBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonBindingListener listener = (ButtonBindingListener)i$.next();
                listener.stateBindMappingChanged(button, previousStateBindMapping);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ButtonPressListenerList
    extends ListenerList<ButtonPressListener>
    implements ButtonPressListener {
        private ButtonPressListenerList() {
        }

        @Override
        public void buttonPressed(Button button) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonPressListener listener = (ButtonPressListener)i$.next();
                listener.buttonPressed(button);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ButtonStateListenerList
    extends ListenerList<ButtonStateListener>
    implements ButtonStateListener {
        private ButtonStateListenerList() {
        }

        @Override
        public void stateChanged(Button button, State previousState) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonStateListener listener = (ButtonStateListener)i$.next();
                listener.stateChanged(button, previousState);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ButtonListenerList
    extends ListenerList<ButtonListener>
    implements ButtonListener {
        private ButtonListenerList() {
        }

        @Override
        public void buttonDataChanged(Button button, Object previousButtonData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonListener listener = (ButtonListener)i$.next();
                listener.buttonDataChanged(button, previousButtonData);
            }
        }

        @Override
        public void dataRendererChanged(Button button, DataRenderer previousDataRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonListener listener = (ButtonListener)i$.next();
                listener.dataRendererChanged(button, previousDataRenderer);
            }
        }

        @Override
        public void actionChanged(Button button, Action previousAction) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonListener listener = (ButtonListener)i$.next();
                listener.actionChanged(button, previousAction);
            }
        }

        @Override
        public void toggleButtonChanged(Button button) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonListener listener = (ButtonListener)i$.next();
                listener.toggleButtonChanged(button);
            }
        }

        @Override
        public void triStateChanged(Button button) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonListener listener = (ButtonListener)i$.next();
                listener.triStateChanged(button);
            }
        }

        @Override
        public void buttonGroupChanged(Button button, ButtonGroup previousButtonGroup) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ButtonListener listener = (ButtonListener)i$.next();
                listener.buttonGroupChanged(button, previousButtonGroup);
            }
        }
    }

    public static interface ButtonDataBindMapping {
        public Object toButtonData(Object var1);

        public Object valueOf(Object var1);
    }

    public static interface StateBindMapping {
        public State toState(Object var1);

        public Object valueOf(State var1);
    }

    public static interface SelectedBindMapping {
        public boolean isSelected(Object var1);

        public Object valueOf(boolean var1);
    }

    public static interface DataRenderer
    extends Renderer {
        public void render(Object var1, Button var2, boolean var3);

        public String toString(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        SELECTED,
        UNSELECTED,
        MIXED;

    }
}

