/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import java.util.Locale;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSON;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.CalendarDate;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Calendar;
import org.apache.pivot.wtk.CalendarButtonBindingListener;
import org.apache.pivot.wtk.CalendarButtonListener;
import org.apache.pivot.wtk.CalendarButtonSelectionListener;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.CalendarButtonDataRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalendarButton
extends Button {
    private int year;
    private int month;
    private CalendarDate selectedDate = null;
    private Locale locale = Locale.getDefault();
    private Filter<CalendarDate> disabledDateFilter = null;
    private String selectedDateKey = null;
    private BindType selectedDateBindType = BindType.BOTH;
    private Calendar.SelectedDateBindMapping selectedDateBindMapping = null;
    private CalendarButtonListenerList calendarButtonListeners = new CalendarButtonListenerList();
    private CalendarButtonSelectionListenerList calendarButtonSelectionListeners = new CalendarButtonSelectionListenerList();
    private CalendarButtonBindingListenerList calendarButtonBindingListeners = new CalendarButtonBindingListenerList();
    public static final String LANGUAGE_KEY = "language";
    public static final String COUNTRY_KEY = "country";
    public static final String VARIANT_KEY = "variant";
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new CalendarButtonDataRenderer();

    public CalendarButton() {
        this(new CalendarDate());
    }

    private CalendarButton(CalendarDate calendarDate) {
        this(calendarDate.year, calendarDate.month);
    }

    public CalendarButton(int year, int month) {
        this.year = year;
        this.month = month;
        this.setDataRenderer(DEFAULT_DATA_RENDERER);
        this.installSkin(CalendarButton.class);
        this.setSelectedDate(new CalendarDate());
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public Window getListPopup() {
        return ((Skin)((Object)this.getSkin())).getCalendarPopup();
    }

    @Override
    public void setToggleButton(boolean toggleButton) {
        throw new UnsupportedOperationException("Calendar buttons cannot be toggle buttons.");
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        int previousYear = this.year;
        if (previousYear != year) {
            this.year = year;
            this.calendarButtonListeners.yearChanged(this, previousYear);
        }
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        int previousMonth = this.month;
        if (previousMonth != month) {
            this.month = month;
            this.calendarButtonListeners.monthChanged(this, previousMonth);
        }
    }

    public CalendarDate getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(CalendarDate selectedDate) {
        CalendarDate previousSelectedDate = this.selectedDate;
        if (previousSelectedDate != selectedDate) {
            this.selectedDate = selectedDate;
            this.calendarButtonSelectionListeners.selectedDateChanged(this, previousSelectedDate);
        }
    }

    public final void setSelectedDate(String selectedDate) {
        if (selectedDate == null) {
            throw new IllegalArgumentException("selectedDate is null.");
        }
        this.setSelectedDate(CalendarDate.decode((String)selectedDate));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        Locale previousLocale = this.locale;
        if (previousLocale != locale) {
            this.locale = locale;
            this.calendarButtonListeners.localeChanged(this, previousLocale);
        }
    }

    public void setLocale(Dictionary<String, ?> locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        String language = (String)locale.get((Object)LANGUAGE_KEY);
        String country = (String)locale.get((Object)COUNTRY_KEY);
        String variant = (String)locale.get((Object)VARIANT_KEY);
        if (variant != null) {
            this.setLocale(new Locale(language, country, variant));
        } else if (country != null) {
            this.setLocale(new Locale(language, country));
        } else {
            this.setLocale(new Locale(language));
        }
    }

    public void setLocale(String locale) {
        if (locale == null) {
            throw new IllegalArgumentException("locale is null.");
        }
        try {
            this.setLocale((Dictionary<String, ?>)JSONSerializer.parseMap((String)locale));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public Filter<CalendarDate> getDisabledDateFilter() {
        return this.disabledDateFilter;
    }

    public void setDisabledDateFilter(Filter<CalendarDate> disabledDateFilter) {
        Filter<CalendarDate> previousDisabledDateFilter = this.disabledDateFilter;
        if (previousDisabledDateFilter != disabledDateFilter) {
            this.disabledDateFilter = disabledDateFilter;
            this.calendarButtonListeners.disabledDateFilterChanged(this, previousDisabledDateFilter);
        }
    }

    public String getSelectedDateKey() {
        return this.selectedDateKey;
    }

    public void setSelectedDateKey(String selectedDateKey) {
        String previousSelectedDateKey = this.selectedDateKey;
        if (previousSelectedDateKey != selectedDateKey) {
            this.selectedDateKey = selectedDateKey;
            this.calendarButtonBindingListeners.selectedDateKeyChanged(this, previousSelectedDateKey);
        }
    }

    public BindType getSelectedDateBindType() {
        return this.selectedDateBindType;
    }

    public void setSelectedDateBindType(BindType selectedDateBindType) {
        if (selectedDateBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedDateBindType = this.selectedDateBindType;
        if (previousSelectedDateBindType != selectedDateBindType) {
            this.selectedDateBindType = selectedDateBindType;
            this.calendarButtonBindingListeners.selectedDateBindTypeChanged(this, previousSelectedDateBindType);
        }
    }

    public Calendar.SelectedDateBindMapping getSelectedDateBindMapping() {
        return this.selectedDateBindMapping;
    }

    public void setSelectedDateBindMapping(Calendar.SelectedDateBindMapping bindMapping) {
        Calendar.SelectedDateBindMapping previousSelectedDateBindMapping = this.selectedDateBindMapping;
        if (previousSelectedDateBindMapping != bindMapping) {
            this.selectedDateBindMapping = bindMapping;
            this.calendarButtonBindingListeners.selectedDateBindMappingChanged(this, previousSelectedDateBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        if (this.selectedDateKey != null && JSON.containsKey((Object)context, (String)this.selectedDateKey) && this.selectedDateBindType != BindType.STORE) {
            Object value = JSON.get((Object)context, (String)this.selectedDateKey);
            CalendarDate selectedDate = null;
            if (value instanceof CalendarDate) {
                selectedDate = (CalendarDate)value;
            } else if (this.selectedDateBindMapping == null) {
                if (value != null) {
                    selectedDate = CalendarDate.decode((String)value.toString());
                }
            } else {
                selectedDate = this.selectedDateBindMapping.toDate(value);
            }
            this.setSelectedDate(selectedDate);
        }
    }

    @Override
    public void store(Object context) {
        if (this.selectedDateKey != null && this.selectedDateBindType != BindType.LOAD) {
            JSON.put((Object)context, (String)this.selectedDateKey, (Object)(this.selectedDateBindMapping == null ? this.selectedDate : this.selectedDateBindMapping.valueOf(this.selectedDate)));
        }
    }

    @Override
    public void clear() {
        if (this.selectedDateKey != null) {
            this.setSelectedDate((CalendarDate)null);
        }
    }

    public ListenerList<CalendarButtonListener> getCalendarButtonListeners() {
        return this.calendarButtonListeners;
    }

    public ListenerList<CalendarButtonSelectionListener> getCalendarButtonSelectionListeners() {
        return this.calendarButtonSelectionListeners;
    }

    public static interface Skin {
        public Window getCalendarPopup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalendarButtonBindingListenerList
    extends ListenerList<CalendarButtonBindingListener>
    implements CalendarButtonBindingListener {
        private CalendarButtonBindingListenerList() {
        }

        @Override
        public void selectedDateKeyChanged(CalendarButton calendarButton, String previousSelectedDateKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarButtonBindingListener listener = (CalendarButtonBindingListener)i$.next();
                listener.selectedDateKeyChanged(calendarButton, previousSelectedDateKey);
            }
        }

        @Override
        public void selectedDateBindTypeChanged(CalendarButton calendarButton, BindType previousSelectedDateBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarButtonBindingListener listener = (CalendarButtonBindingListener)i$.next();
                listener.selectedDateBindTypeChanged(calendarButton, previousSelectedDateBindType);
            }
        }

        @Override
        public void selectedDateBindMappingChanged(CalendarButton calendarButton, Calendar.SelectedDateBindMapping previousSelectedDateBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarButtonBindingListener listener = (CalendarButtonBindingListener)i$.next();
                listener.selectedDateBindMappingChanged(calendarButton, previousSelectedDateBindMapping);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalendarButtonSelectionListenerList
    extends ListenerList<CalendarButtonSelectionListener>
    implements CalendarButtonSelectionListener {
        private CalendarButtonSelectionListenerList() {
        }

        @Override
        public void selectedDateChanged(CalendarButton calendarButton, CalendarDate previousSelectedDate) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarButtonSelectionListener listener = (CalendarButtonSelectionListener)i$.next();
                listener.selectedDateChanged(calendarButton, previousSelectedDate);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CalendarButtonListenerList
    extends ListenerList<CalendarButtonListener>
    implements CalendarButtonListener {
        private CalendarButtonListenerList() {
        }

        @Override
        public void yearChanged(CalendarButton calendarButton, int previousYear) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarButtonListener listener = (CalendarButtonListener)i$.next();
                listener.yearChanged(calendarButton, previousYear);
            }
        }

        @Override
        public void monthChanged(CalendarButton calendarButton, int previousMonth) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarButtonListener listener = (CalendarButtonListener)i$.next();
                listener.monthChanged(calendarButton, previousMonth);
            }
        }

        @Override
        public void localeChanged(CalendarButton calendarButton, Locale previousLocale) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarButtonListener listener = (CalendarButtonListener)i$.next();
                listener.localeChanged(calendarButton, previousLocale);
            }
        }

        @Override
        public void disabledDateFilterChanged(CalendarButton calendarButton, Filter<CalendarDate> previousDisabledDateFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                CalendarButtonListener listener = (CalendarButtonListener)i$.next();
                listener.disabledDateFilterChanged(calendarButton, previousDisabledDateFilter);
            }
        }
    }
}

