/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import org.apache.pivot.wtk.ClipboardContentListener;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.LocalManifestAdapter;
import org.apache.pivot.wtk.Manifest;
import org.apache.pivot.wtk.RemoteManifest;

public final class Clipboard {
    private static LocalManifest content = null;
    private static ClipboardContentListener clipboardContentListener = null;

    public static Manifest getContent() {
        Manifest content = Clipboard.content;
        if (content == null) {
            try {
                java.awt.datatransfer.Clipboard awtClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                content = new RemoteManifest(awtClipboard.getContents(null));
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return content;
    }

    public static void setContent(LocalManifest content) {
        Clipboard.setContent(content, null);
    }

    public static void setContent(LocalManifest content, ClipboardContentListener clipboardContentListener) {
        if (content == null) {
            throw new IllegalArgumentException("content is null");
        }
        try {
            java.awt.datatransfer.Clipboard awtClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            LocalManifestAdapter localManifestAdapter = new LocalManifestAdapter(content);
            awtClipboard.setContents(localManifestAdapter, new ClipboardOwner(){

                public void lostOwnership(java.awt.datatransfer.Clipboard clipboard, Transferable contents) {
                    LocalManifest previousContent = content;
                    content = null;
                    if (clipboardContentListener != null) {
                        clipboardContentListener.contentChanged(previousContent);
                    }
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        Clipboard.content = content;
        Clipboard.clipboardContentListener = clipboardContentListener;
    }
}

