/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ContainerListener;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.effects.Decorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Container
extends Component
implements Sequence<Component>,
Iterable<Component> {
    private ArrayList<Component> components = new ArrayList();
    private FocusTraversalPolicy focusTraversalPolicy = null;
    private Component mouseOverComponent = null;
    private boolean mouseDown = false;
    private Component mouseDownComponent = null;
    private long mouseDownTime = 0L;
    private int mouseClickCount = 0;
    private boolean mouseClickConsumed = false;
    private ContainerListenerList containerListeners = new ContainerListenerList();
    private ContainerMouseListenerList containerMouseListeners = new ContainerMouseListenerList();

    public final int add(Component component) {
        int index = this.getLength();
        this.insert(component, index);
        return index;
    }

    public void insert(Component component, int index) {
        if (component == null) {
            throw new IllegalArgumentException("component is null.");
        }
        if (component instanceof Container && ((Container)component).isAncestor(this)) {
            throw new IllegalArgumentException("Component already exists in ancestry.");
        }
        if (component.getParent() != null) {
            throw new IllegalArgumentException("Component already has a parent.");
        }
        component.setParent(this);
        this.components.insert((Object)component, index);
        this.repaint(component.getDecoratedBounds());
        this.invalidate();
        this.containerListeners.componentInserted(this, index);
    }

    public Component update(int index, Component component) {
        throw new UnsupportedOperationException();
    }

    public final int remove(Component component) {
        int index = this.indexOf(component);
        if (index != -1) {
            this.remove(index, 1);
        }
        return index;
    }

    public Sequence<Component> remove(int index, int count) {
        Sequence removed = this.components.remove(index, count);
        int n = removed.getLength();
        for (int i = 0; i < n; ++i) {
            Component component = (Component)removed.get(i);
            if (component == this.mouseOverComponent) {
                if (this.mouseOverComponent.isMouseOver()) {
                    this.mouseOverComponent.mouseOut();
                }
                this.mouseOverComponent = null;
                Mouse.setCursor(this);
            }
            this.repaint(component.getDecoratedBounds());
            component.setParent(null);
        }
        if (removed.getLength() > 0) {
            this.invalidate();
            this.containerListeners.componentsRemoved(this, index, (Sequence<Component>)removed);
        }
        return removed;
    }

    public final Sequence<Component> removeAll() {
        return this.remove(0, this.getLength());
    }

    public void move(int from, int to) {
        if (from != to) {
            int n = this.components.getLength();
            if (from < 0 || from >= n || to < 0 || to >= n) {
                throw new IndexOutOfBoundsException();
            }
            Sequence removed = this.components.remove(from, 1);
            Component component = (Component)removed.get(0);
            this.components.insert((Object)component, to);
            this.repaint(component.getDecoratedBounds());
            this.containerListeners.componentMoved(this, from, to);
        }
    }

    public Component get(int index) {
        return (Component)this.components.get(index);
    }

    public int indexOf(Component component) {
        return this.components.indexOf((Object)component);
    }

    public int getLength() {
        return this.components.getLength();
    }

    @Override
    public Iterator<Component> iterator() {
        return new ImmutableIterator((Iterator)this.components.iterator());
    }

    @Override
    protected void setParent(Container parent) {
        if (parent == null && this.containsFocus()) {
            Container.clearFocus();
        }
        super.setParent(parent);
    }

    public Component getComponentAt(int x, int y) {
        Bounds bounds;
        int i;
        Component component = null;
        for (i = this.components.getLength() - 1; !(i < 0 || (component = (Component)this.components.get(i)).isVisible() && (bounds = component.getBounds()).contains(x, y)); --i) {
        }
        if (i < 0) {
            component = null;
        }
        return component;
    }

    public Component getDescendantAt(int x, int y) {
        Component component = this.getComponentAt(x, y);
        if (component instanceof Container) {
            Container container = (Container)component;
            component = container.getDescendantAt(x - container.getX(), y - container.getY());
        }
        if (component == null) {
            component = this;
        }
        return component;
    }

    public Component getNamedComponent(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        Component namedComponent = null;
        for (Component component : this) {
            if (!name.equals(component.getName())) continue;
            namedComponent = component;
            break;
        }
        return namedComponent;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.containsFocus()) {
            Container.clearFocus();
        }
        super.setVisible(visible);
    }

    @Override
    protected void layout() {
        super.layout();
        int n = this.components.getLength();
        for (int i = 0; i < n; ++i) {
            Component component = (Component)this.components.get(i);
            component.validate();
        }
    }

    @Override
    public void paint(Graphics2D graphics) {
        Component component;
        int i;
        int count = this.getLength();
        Bounds paintBounds = new Bounds(0, 0, this.getWidth(), this.getHeight());
        Rectangle clipBounds = graphics.getClipBounds();
        if (clipBounds != null) {
            paintBounds = paintBounds.intersect(new Bounds(clipBounds));
        }
        boolean paintContainer = true;
        for (i = 0; i < count; ++i) {
            component = this.get(i);
            if (!component.isVisible() || !component.isOpaque() || !component.getBounds().contains(paintBounds)) continue;
            paintContainer = false;
            break;
        }
        if (paintContainer) {
            Graphics2D containerGraphics = (Graphics2D)graphics.create();
            super.paint(containerGraphics);
            containerGraphics.dispose();
        }
        for (i = 0; i < count; ++i) {
            component = this.get(i);
            Bounds decoratedBounds = component.getDecoratedBounds();
            if (!component.isVisible() || !decoratedBounds.intersects(paintBounds)) continue;
            Bounds componentBounds = component.getBounds();
            Graphics2D decoratedGraphics = (Graphics2D)graphics.create();
            decoratedGraphics.translate(componentBounds.x, componentBounds.y);
            Component.DecoratorSequence decorators = component.getDecorators();
            int n = decorators.getLength();
            for (int j = n - 1; j >= 0; --j) {
                Decorator decorator = decorators.get(j);
                decoratedGraphics = decorator.prepare(component, decoratedGraphics);
            }
            Graphics2D componentGraphics = (Graphics2D)decoratedGraphics.create();
            componentGraphics.clipRect(0, 0, componentBounds.width, componentBounds.height);
            component.paint(componentGraphics);
            componentGraphics.dispose();
            for (int j = 0; j < n; ++j) {
                Decorator decorator = decorators.get(j);
                decorator.update();
            }
        }
    }

    public boolean isAncestor(Component component) {
        boolean ancestor = false;
        for (Component parent = component; parent != null; parent = parent.getParent()) {
            if (parent != this) continue;
            ancestor = true;
            break;
        }
        return ancestor;
    }

    @Override
    public boolean requestFocus() {
        boolean focused = false;
        if (this.isFocusable()) {
            focused = super.requestFocus();
        } else if (this.focusTraversalPolicy != null) {
            Component first;
            Component component = first = this.focusTraversalPolicy.getNextComponent(this, null, FocusTraversalDirection.FORWARD);
            while (component != null && !component.requestFocus() && (component = this.focusTraversalPolicy.getNextComponent(this, component, FocusTraversalDirection.FORWARD)) != first) {
            }
            focused = component != null;
        }
        return focused;
    }

    public Component transferFocus(Component component, FocusTraversalDirection direction) {
        if (this.focusTraversalPolicy == null) {
            component = this.transferFocus(direction);
        } else {
            do {
                if ((component = this.focusTraversalPolicy.getNextComponent(this, component, direction)) == null) continue;
                if (component.isFocusable()) {
                    component.requestFocus();
                    continue;
                }
                if (!(component instanceof Container)) continue;
                Container container = (Container)component;
                component = container.transferFocus(null, direction);
            } while (component != null && !component.isFocused());
            if (component == null) {
                component = this.transferFocus(direction);
            }
        }
        return component;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        return this.focusTraversalPolicy;
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
        FocusTraversalPolicy previousFocusTraversalPolicy = this.focusTraversalPolicy;
        if (previousFocusTraversalPolicy != focusTraversalPolicy) {
            this.focusTraversalPolicy = focusTraversalPolicy;
            this.containerListeners.focusTraversalPolicyChanged(this, previousFocusTraversalPolicy);
        }
    }

    public boolean containsFocus() {
        Component focusedComponent = Container.getFocusedComponent();
        return focusedComponent != null && this.isAncestor(focusedComponent);
    }

    protected void descendantAdded(Component descendant) {
        Container parent = this.getParent();
        if (parent != null) {
            parent.descendantAdded(descendant);
        }
    }

    protected void descendantRemoved(Component descendant) {
        Container parent = this.getParent();
        if (parent != null) {
            parent.descendantRemoved(descendant);
        }
    }

    protected void descendantGainedFocus(Component descendant, Component previousFocusedComponent) {
        Container parent = this.getParent();
        if (parent != null) {
            parent.descendantGainedFocus(descendant, previousFocusedComponent);
        }
    }

    protected void descendantLostFocus(Component descendant) {
        Container parent = this.getParent();
        if (parent != null) {
            parent.descendantLostFocus(descendant);
        }
    }

    @Override
    public void load(Object context) {
        for (Component component : this.components) {
            component.load(context);
        }
    }

    @Override
    public void store(Object context) {
        for (Component component : this.components) {
            component.store(context);
        }
    }

    @Override
    public void clear() {
        for (Component component : this.components) {
            component.clear();
        }
    }

    @Override
    protected boolean mouseMove(int x, int y) {
        boolean consumed = false;
        if (this.mouseOverComponent != null && !this.mouseOverComponent.isMouseOver()) {
            this.mouseOverComponent = null;
        }
        if (this.isEnabled()) {
            Component component = this.getComponentAt(x, y);
            if (this.mouseOverComponent != component) {
                if (this.mouseOverComponent != null) {
                    this.mouseOverComponent.mouseOut();
                }
                this.mouseOverComponent = null;
                Mouse.setCursor(this);
            }
            if (!(consumed = this.containerMouseListeners.mouseMove(this, x, y))) {
                if (this.mouseOverComponent != component) {
                    this.mouseOverComponent = component;
                    if (this.mouseOverComponent != null) {
                        this.mouseOverComponent.mouseOver();
                        Mouse.setCursor(this.mouseOverComponent);
                    }
                }
                if (component != null) {
                    consumed = component.mouseMove(x - component.getX(), y - component.getY());
                }
                if (!consumed) {
                    consumed = super.mouseMove(x, y);
                }
            }
        }
        return consumed;
    }

    @Override
    protected void mouseOut() {
        if (this.mouseOverComponent != null && this.mouseOverComponent.isMouseOver()) {
            this.mouseOverComponent.mouseOut();
        }
        this.mouseOverComponent = null;
        super.mouseOut();
    }

    @Override
    protected boolean mouseDown(Mouse.Button button, int x, int y) {
        boolean consumed = false;
        this.mouseDown = true;
        if (this.isEnabled() && !(consumed = this.containerMouseListeners.mouseDown(this, button, x, y))) {
            Component component = this.getComponentAt(x, y);
            long currentTime = System.currentTimeMillis();
            int multiClickInterval = Platform.getMultiClickInterval();
            if (this.mouseDownComponent == component && currentTime - this.mouseDownTime < (long)multiClickInterval) {
                ++this.mouseClickCount;
            } else {
                this.mouseDownTime = System.currentTimeMillis();
                this.mouseClickCount = 1;
            }
            this.mouseDownComponent = component;
            if (component != null) {
                if (!component.isMouseOver()) {
                    component.mouseOver();
                }
                consumed = component.mouseDown(button, x - component.getX(), y - component.getY());
            }
            if (!consumed) {
                consumed = super.mouseDown(button, x, y);
            }
        }
        return consumed;
    }

    @Override
    protected boolean mouseUp(Mouse.Button button, int x, int y) {
        boolean consumed = false;
        if (this.isEnabled() && !(consumed = this.containerMouseListeners.mouseUp(this, button, x, y))) {
            Component component = this.getComponentAt(x, y);
            if (component != null) {
                if (!component.isMouseOver()) {
                    component.mouseOver();
                }
                consumed = component.mouseUp(button, x - component.getX(), y - component.getY());
            }
            if (!consumed) {
                consumed = super.mouseUp(button, x, y);
            }
            if (this.mouseDown && component != null && component == this.mouseDownComponent && component.isEnabled() && component.isVisible()) {
                this.mouseClickConsumed = component.mouseClick(button, x - component.getX(), y - component.getY(), this.mouseClickCount);
            }
        }
        this.mouseDown = false;
        return consumed;
    }

    @Override
    protected boolean mouseClick(Mouse.Button button, int x, int y, int count) {
        if (this.isEnabled() && !this.mouseClickConsumed) {
            this.mouseClickConsumed = super.mouseClick(button, x, y, count);
        }
        return this.mouseClickConsumed;
    }

    @Override
    protected boolean mouseWheel(Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        boolean consumed = false;
        if (this.isEnabled() && !(consumed = this.containerMouseListeners.mouseWheel(this, scrollType, scrollAmount, wheelRotation, x, y))) {
            Component component = this.getComponentAt(x, y);
            if (component != null) {
                if (!component.isMouseOver()) {
                    component.mouseOver();
                }
                consumed = component.mouseWheel(scrollType, scrollAmount, wheelRotation, x - component.getX(), y - component.getY());
            }
            if (!consumed) {
                consumed = super.mouseWheel(scrollType, scrollAmount, wheelRotation, x, y);
            }
        }
        return consumed;
    }

    public ListenerList<ContainerListener> getContainerListeners() {
        return this.containerListeners;
    }

    public ListenerList<ContainerMouseListener> getContainerMouseListeners() {
        return this.containerMouseListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContainerMouseListenerList
    extends ListenerList<ContainerMouseListener>
    implements ContainerMouseListener {
        private ContainerMouseListenerList() {
        }

        @Override
        public boolean mouseMove(Container container, int x, int y) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ContainerMouseListener listener = (ContainerMouseListener)i$.next();
                consumed |= listener.mouseMove(container, x, y);
            }
            return consumed;
        }

        @Override
        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ContainerMouseListener listener = (ContainerMouseListener)i$.next();
                consumed |= listener.mouseDown(container, button, x, y);
            }
            return consumed;
        }

        @Override
        public boolean mouseUp(Container container, Mouse.Button button, int x, int y) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ContainerMouseListener listener = (ContainerMouseListener)i$.next();
                consumed |= listener.mouseUp(container, button, x, y);
            }
            return consumed;
        }

        @Override
        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            boolean consumed = false;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ContainerMouseListener listener = (ContainerMouseListener)i$.next();
                consumed |= listener.mouseWheel(container, scrollType, scrollAmount, wheelRotation, x, y);
            }
            return consumed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContainerListenerList
    extends ListenerList<ContainerListener>
    implements ContainerListener {
        private ContainerListenerList() {
        }

        @Override
        public void componentInserted(Container container, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ContainerListener listener = (ContainerListener)i$.next();
                listener.componentInserted(container, index);
            }
        }

        @Override
        public void componentsRemoved(Container container, int index, Sequence<Component> components) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ContainerListener listener = (ContainerListener)i$.next();
                listener.componentsRemoved(container, index, components);
            }
        }

        @Override
        public void componentMoved(Container container, int from, int to) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ContainerListener listener = (ContainerListener)i$.next();
                listener.componentMoved(container, from, to);
            }
        }

        @Override
        public void focusTraversalPolicyChanged(Container container, FocusTraversalPolicy previousFocusTraversalPolicy) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ContainerListener listener = (ContainerListener)i$.next();
                listener.focusTraversalPolicyChanged(container, previousFocusTraversalPolicy);
            }
        }
    }
}

