/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.Serializable;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CornerRadii
implements Serializable {
    private static final long serialVersionUID = -433469769555042467L;
    public final int topLeft;
    public final int topRight;
    public final int bottomLeft;
    public final int bottomRight;
    public static final String TOP_LEFT_KEY = "topLeft";
    public static final String TOP_RIGHT_KEY = "topRight";
    public static final String BOTTOM_LEFT_KEY = "bottomLeft";
    public static final String BOTTOM_RIGHT_KEY = "bottomRight";
    public static final CornerRadii NONE = new CornerRadii(0);

    public CornerRadii(int radius) {
        this(radius, radius, radius, radius);
    }

    public CornerRadii(CornerRadii cornerRadii) {
        if (cornerRadii == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        if (cornerRadii.topLeft < 0) {
            throw new IllegalArgumentException("cornerRadii.topLeft is negative.");
        }
        if (cornerRadii.topRight < 0) {
            throw new IllegalArgumentException("cornerRadii.topRight is negative.");
        }
        if (cornerRadii.bottomLeft < 0) {
            throw new IllegalArgumentException("cornerRadii.bottomLeft is negative.");
        }
        if (cornerRadii.bottomRight < 0) {
            throw new IllegalArgumentException("cornerRadii.bottomRight is negative.");
        }
        this.topLeft = cornerRadii.topLeft;
        this.topRight = cornerRadii.topRight;
        this.bottomLeft = cornerRadii.bottomLeft;
        this.bottomRight = cornerRadii.bottomRight;
    }

    public CornerRadii(int topLeft, int topRight, int bottomLeft, int bottomRight) {
        if (topLeft < 0) {
            throw new IllegalArgumentException("topLeft is negative.");
        }
        if (topRight < 0) {
            throw new IllegalArgumentException("topRight is negative.");
        }
        if (bottomLeft < 0) {
            throw new IllegalArgumentException("bottomLeft is negative.");
        }
        if (bottomRight < 0) {
            throw new IllegalArgumentException("bottomRight is negative.");
        }
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomLeft = bottomLeft;
        this.bottomRight = bottomRight;
    }

    public CornerRadii(Dictionary<String, ?> cornerRadii) {
        if (cornerRadii == null) {
            throw new IllegalArgumentException("cornerRadii is null.");
        }
        if (cornerRadii.containsKey((Object)TOP_LEFT_KEY)) {
            this.topLeft = (Integer)cornerRadii.get((Object)TOP_LEFT_KEY);
            if (this.topLeft < 0) {
                throw new IllegalArgumentException("\"topLeft\" is negative.");
            }
        } else {
            this.topLeft = 0;
        }
        if (cornerRadii.containsKey((Object)TOP_RIGHT_KEY)) {
            this.topRight = (Integer)cornerRadii.get((Object)TOP_RIGHT_KEY);
            if (this.topRight < 0) {
                throw new IllegalArgumentException("\"topRight\" is negative.");
            }
        } else {
            this.topRight = 0;
        }
        if (cornerRadii.containsKey((Object)BOTTOM_LEFT_KEY)) {
            this.bottomLeft = (Integer)cornerRadii.get((Object)BOTTOM_LEFT_KEY);
            if (this.bottomLeft < 0) {
                throw new IllegalArgumentException("\"bottomLeft\" is negative.");
            }
        } else {
            this.bottomLeft = 0;
        }
        if (cornerRadii.containsKey((Object)BOTTOM_RIGHT_KEY)) {
            this.bottomRight = (Integer)cornerRadii.get((Object)BOTTOM_RIGHT_KEY);
            if (this.bottomRight < 0) {
                throw new IllegalArgumentException("\"bottomRight\" is negative.");
            }
        } else {
            this.bottomRight = 0;
        }
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object instanceof CornerRadii) {
            CornerRadii cornerRadii = (CornerRadii)object;
            equals = this.topLeft == cornerRadii.topLeft && this.topRight == cornerRadii.topRight && this.bottomLeft == cornerRadii.bottomLeft && this.bottomRight == cornerRadii.bottomRight;
        }
        return equals;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.topLeft;
        result = 31 * result + this.topRight;
        result = 31 * result + this.bottomLeft;
        result = 31 * result + this.bottomRight;
        return result;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.topLeft + ", " + this.topRight + this.bottomLeft + ", " + this.bottomRight + "]";
    }

    public static CornerRadii decode(String value) {
        CornerRadii cornerRadii;
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.startsWith("{")) {
            try {
                cornerRadii = new CornerRadii((Dictionary<String, ?>)JSONSerializer.parseMap((String)value));
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
        } else {
            cornerRadii = new CornerRadii(Integer.parseInt(value));
        }
        return cornerRadii;
    }
}

