/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.DialogCloseListener;
import org.apache.pivot.wtk.DialogListener;
import org.apache.pivot.wtk.DialogStateListener;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Frame;
import org.apache.pivot.wtk.Window;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dialog
extends Frame {
    private boolean modal;
    private DialogCloseListener dialogCloseListener = null;
    private boolean result = false;
    private boolean closing = false;
    private DialogListenerList dialogListeners = new DialogListenerList();
    private DialogStateListenerList dialogStateListeners = new DialogStateListenerList();

    public Dialog() {
        this(true);
    }

    public Dialog(boolean modal) {
        this(null, null, modal);
    }

    public Dialog(String title) {
        this(title, true);
    }

    public Dialog(String title, boolean modal) {
        this(title, null, modal);
    }

    public Dialog(Component content) {
        this(content, true);
    }

    public Dialog(Component content, boolean modal) {
        this(null, content, modal);
    }

    public Dialog(String title, Component content) {
        this(title, content, true);
    }

    public Dialog(String title, Component content, boolean modal) {
        super(title, content);
        this.modal = modal;
        this.installSkin(Dialog.class);
    }

    public boolean isModal() {
        return this.modal;
    }

    public void setModal(boolean modal) {
        if (this.modal != modal) {
            this.modal = modal;
            this.dialogListeners.modalChanged(this);
        }
    }

    @Override
    public final void open(Display display, Window owner) {
        this.open(display, owner, null);
    }

    public final void open(Display display, DialogCloseListener dialogCloseListener) {
        this.open(display, null, dialogCloseListener);
    }

    public final void open(Window owner, DialogCloseListener dialogCloseListener) {
        if (owner == null) {
            throw new IllegalArgumentException();
        }
        this.open(owner.getDisplay(), owner, dialogCloseListener);
    }

    public void open(Display display, Window owner, DialogCloseListener dialogCloseListener) {
        if (this.modal && owner == null) {
            throw new IllegalArgumentException("Modal dialogs must have an owner.");
        }
        this.dialogCloseListener = dialogCloseListener;
        this.result = false;
        super.open(display, owner);
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public final void close() {
        this.close(false);
    }

    public void close(boolean result) {
        if (!this.isClosed()) {
            this.closing = true;
            Vote vote = this.dialogStateListeners.previewDialogClose(this, result);
            if (vote == Vote.APPROVE) {
                Window owner = this.getOwner();
                super.close();
                this.closing = super.isClosing();
                if (this.isClosed()) {
                    this.result = result;
                    if (owner != null && owner.isOpen()) {
                        owner.moveToFront();
                    }
                    this.dialogStateListeners.dialogClosed(this, this.modal);
                    if (this.dialogCloseListener != null) {
                        this.dialogCloseListener.dialogClosed(this, this.modal);
                        this.dialogCloseListener = null;
                    }
                }
            } else {
                if (vote == Vote.DENY) {
                    this.closing = false;
                }
                this.dialogStateListeners.dialogCloseVetoed(this, vote);
            }
        }
    }

    public DialogCloseListener getDialogCloseListener() {
        return this.dialogCloseListener;
    }

    public boolean getResult() {
        return this.result;
    }

    public ListenerList<DialogListener> getDialogListeners() {
        return this.dialogListeners;
    }

    public ListenerList<DialogStateListener> getDialogStateListeners() {
        return this.dialogStateListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DialogStateListenerList
    extends ListenerList<DialogStateListener>
    implements DialogStateListener {
        private DialogStateListenerList() {
        }

        @Override
        public Vote previewDialogClose(Dialog dialog, boolean result) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                DialogStateListener listener = (DialogStateListener)i$.next();
                vote = vote.tally(listener.previewDialogClose(dialog, result));
            }
            return vote;
        }

        @Override
        public void dialogCloseVetoed(Dialog dialog, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                DialogStateListener listener = (DialogStateListener)i$.next();
                listener.dialogCloseVetoed(dialog, reason);
            }
        }

        @Override
        public void dialogClosed(Dialog dialog, boolean modal) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                DialogStateListener listener = (DialogStateListener)i$.next();
                listener.dialogClosed(dialog, modal);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DialogListenerList
    extends ListenerList<DialogListener>
    implements DialogListener {
        private DialogListenerList() {
        }

        @Override
        public void modalChanged(Dialog dialog) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                DialogListener listener = (DialogListener)i$.next();
                listener.modalChanged(dialog);
            }
        }
    }
}

