/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ExpanderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="content")
public class Expander
extends Container {
    private String title = null;
    private boolean collapsible = true;
    private boolean expanded = true;
    private Component content = null;
    private ExpanderListenerList expanderListeners = new ExpanderListenerList();

    public Expander() {
        this.installSkin(Expander.class);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String previousTitle = this.title;
        if (title != previousTitle) {
            this.title = title;
            this.expanderListeners.titleChanged(this, previousTitle);
        }
    }

    public boolean isCollapsible() {
        return this.collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        if (collapsible != this.collapsible) {
            if (!collapsible && !this.expanded) {
                throw new IllegalStateException();
            }
            this.collapsible = collapsible;
            this.expanderListeners.collapsibleChanged(this);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (expanded != this.expanded) {
            if (!this.collapsible && !expanded) {
                throw new IllegalStateException();
            }
            Vote vote = this.expanderListeners.previewExpandedChange(this);
            if (vote == Vote.APPROVE) {
                this.expanded = expanded;
                this.expanderListeners.expandedChanged(this);
            } else {
                this.expanderListeners.expandedChangeVetoed(this, vote);
            }
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setContent(Component content) {
        Component previousContent = this.content;
        if (content != previousContent) {
            this.content = null;
            if (previousContent != null) {
                this.remove(previousContent);
            }
            if (content != null) {
                this.add(content);
            }
            this.content = content;
            this.expanderListeners.contentChanged(this, previousContent);
        }
    }

    @Override
    public Sequence<Component> remove(int index, int count) {
        int n = index + count;
        for (int i = index; i < n; ++i) {
            Component component = this.get(i);
            if (component != this.content) continue;
            throw new UnsupportedOperationException();
        }
        return super.remove(index, count);
    }

    public ListenerList<ExpanderListener> getExpanderListeners() {
        return this.expanderListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExpanderListenerList
    extends ListenerList<ExpanderListener>
    implements ExpanderListener {
        private ExpanderListenerList() {
        }

        @Override
        public void titleChanged(Expander expander, String previousTitle) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ExpanderListener listener = (ExpanderListener)i$.next();
                listener.titleChanged(expander, previousTitle);
            }
        }

        @Override
        public void collapsibleChanged(Expander expander) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ExpanderListener listener = (ExpanderListener)i$.next();
                listener.collapsibleChanged(expander);
            }
        }

        @Override
        public Vote previewExpandedChange(Expander expander) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ExpanderListener listener = (ExpanderListener)i$.next();
                vote = vote.tally(listener.previewExpandedChange(expander));
            }
            return vote;
        }

        @Override
        public void expandedChangeVetoed(Expander expander, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ExpanderListener listener = (ExpanderListener)i$.next();
                listener.expandedChangeVetoed(expander, reason);
            }
        }

        @Override
        public void expandedChanged(Expander expander) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ExpanderListener listener = (ExpanderListener)i$.next();
                listener.expandedChanged(expander);
            }
        }

        @Override
        public void contentChanged(Expander expander, Component previousContent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ExpanderListener listener = (ExpanderListener)i$.next();
                listener.contentChanged(expander, previousContent);
            }
        }
    }
}

