/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.io.IOException;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Map;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.json.JSON;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.BindType;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ListViewBindingListener;
import org.apache.pivot.wtk.ListViewItemListener;
import org.apache.pivot.wtk.ListViewItemStateListener;
import org.apache.pivot.wtk.ListViewListener;
import org.apache.pivot.wtk.ListViewSelectionListener;
import org.apache.pivot.wtk.RangeSelection;
import org.apache.pivot.wtk.Renderer;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.content.ListViewItemRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="listData")
public class ListView
extends Component {
    private List<?> listData = null;
    private ItemRenderer itemRenderer = null;
    private ItemEditor itemEditor = null;
    private RangeSelection rangeSelection = new RangeSelection();
    private SelectMode selectMode = SelectMode.SINGLE;
    private boolean checkmarksEnabled = false;
    private ArrayList<Integer> checkedIndexes = new ArrayList();
    private Filter<?> disabledItemFilter = null;
    private Filter<?> disabledCheckmarkFilter = null;
    private String listDataKey = null;
    private BindType listDataBindType = BindType.BOTH;
    private ListDataBindMapping listDataBindMapping = null;
    private String selectedItemKey = null;
    private BindType selectedItemBindType = BindType.BOTH;
    private ItemBindMapping selectedItemBindMapping = null;
    private String selectedItemsKey = null;
    private BindType selectedItemsBindType = BindType.BOTH;
    private ItemBindMapping selectedItemsBindMapping = null;
    private String checkedItemsKey = null;
    private BindType checkedItemsBindType = BindType.BOTH;
    private ItemBindMapping checkedItemsBindMapping = null;
    private ListListener<Object> listDataListener = new ListListener<Object>(){

        public void itemInserted(List<Object> list, int index) {
            int updated = ListView.this.rangeSelection.insertIndex(index);
            int i = ArrayList.binarySearch((ArrayList)ListView.this.checkedIndexes, (Comparable)Integer.valueOf(index));
            if (i < 0) {
                i = -(i + 1);
            }
            int n = ListView.this.checkedIndexes.getLength();
            while (i < n) {
                ListView.this.checkedIndexes.update(i, (Object)((Integer)ListView.this.checkedIndexes.get(i) + 1));
                ++i;
            }
            ListView.this.listViewItemListeners.itemInserted(ListView.this, index);
            if (updated > 0) {
                ListView.this.listViewSelectionListeners.selectedRangesChanged(ListView.this, (Sequence<Span>)ListView.this.getSelectedRanges());
            }
        }

        public void itemsRemoved(List<Object> list, int index, Sequence<Object> items) {
            int j;
            int count = items.getLength();
            int previousSelectedIndex = ListView.this.selectMode == SelectMode.SINGLE && ListView.this.rangeSelection.getLength() > 0 ? ((ListView)ListView.this).rangeSelection.get((int)0).start : -1;
            int updated = ListView.this.rangeSelection.removeIndexes(index, count);
            int i = ArrayList.binarySearch((ArrayList)ListView.this.checkedIndexes, (Comparable)Integer.valueOf(index));
            if (i < 0) {
                i = -(i + 1);
            }
            j = (j = ArrayList.binarySearch((ArrayList)ListView.this.checkedIndexes, (Comparable)Integer.valueOf(index + count - 1))) < 0 ? -(j + 1) : ++j;
            ListView.this.checkedIndexes.remove(i, j - i);
            int n = ListView.this.checkedIndexes.getLength();
            while (i < n) {
                ListView.this.checkedIndexes.update(i, (Object)((Integer)ListView.this.checkedIndexes.get(i) - count));
                ++i;
            }
            ListView.this.listViewItemListeners.itemsRemoved(ListView.this, index, count);
            if (updated > 0) {
                ListView.this.listViewSelectionListeners.selectedRangesChanged(ListView.this, (Sequence<Span>)ListView.this.getSelectedRanges());
                if (ListView.this.selectMode == SelectMode.SINGLE && ListView.this.getSelectedIndex() != previousSelectedIndex) {
                    ListView.this.listViewSelectionListeners.selectedItemChanged(ListView.this, null);
                }
            }
        }

        public void itemUpdated(List<Object> list, int index, Object previousItem) {
            ListView.this.listViewItemListeners.itemUpdated(ListView.this, index);
        }

        public void listCleared(List<Object> list) {
            int cleared = ListView.this.rangeSelection.getLength();
            ListView.this.rangeSelection.clear();
            ListView.this.checkedIndexes.clear();
            ListView.this.listViewItemListeners.itemsCleared(ListView.this);
            if (cleared > 0) {
                ListView.this.listViewSelectionListeners.selectedRangesChanged(ListView.this, (Sequence<Span>)ListView.this.getSelectedRanges());
                if (ListView.this.selectMode == SelectMode.SINGLE) {
                    ListView.this.listViewSelectionListeners.selectedItemChanged(ListView.this, null);
                }
            }
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> previousComparator) {
            if (list.getComparator() != null) {
                int cleared = ListView.this.rangeSelection.getLength();
                ListView.this.rangeSelection.clear();
                ListView.this.checkedIndexes.clear();
                ListView.this.listViewItemListeners.itemsSorted(ListView.this);
                if (cleared > 0) {
                    ListView.this.listViewSelectionListeners.selectedRangesChanged(ListView.this, (Sequence<Span>)ListView.this.getSelectedRanges());
                    if (ListView.this.selectMode == SelectMode.SINGLE) {
                        ListView.this.listViewSelectionListeners.selectedItemChanged(ListView.this, null);
                    }
                }
            }
        }
    };
    private ListViewListenerList listViewListeners = new ListViewListenerList();
    private ListViewItemListenerList listViewItemListeners = new ListViewItemListenerList();
    private ListViewItemStateListenerList listViewItemStateListeners = new ListViewItemStateListenerList();
    private ListViewSelectionListenerList listViewSelectionListeners = new ListViewSelectionListenerList();
    private ListViewBindingListenerList listViewBindingListeners = new ListViewBindingListenerList();
    private static final ItemRenderer DEFAULT_ITEM_RENDERER = new ListViewItemRenderer();

    public ListView() {
        this((List<?>)new ArrayList());
    }

    public ListView(List<?> listData) {
        this.setItemRenderer(DEFAULT_ITEM_RENDERER);
        this.setListData(listData);
        this.installSkin(ListView.class);
    }

    public List<?> getListData() {
        return this.listData;
    }

    public void setListData(List<?> listData) {
        if (listData == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        List<?> previousListData = this.listData;
        if (previousListData != listData) {
            int cleared;
            if (previousListData != null) {
                cleared = this.rangeSelection.getLength();
                this.rangeSelection.clear();
                this.checkedIndexes.clear();
                previousListData.getListListeners().remove(this.listDataListener);
            } else {
                cleared = 0;
            }
            listData.getListListeners().add(this.listDataListener);
            this.listData = listData;
            this.listViewListeners.listDataChanged(this, previousListData);
            if (cleared > 0) {
                this.listViewSelectionListeners.selectedRangesChanged(this, (Sequence<Span>)this.getSelectedRanges());
                if (this.selectMode == SelectMode.SINGLE) {
                    this.listViewSelectionListeners.selectedItemChanged(this, null);
                }
            }
        }
    }

    public final void setListData(String listData) {
        if (listData == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        try {
            this.setListData(JSONSerializer.parseList((String)listData));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public void setListData(URL listData) {
        if (listData == null) {
            throw new IllegalArgumentException("listData is null.");
        }
        JSONSerializer jsonSerializer = new JSONSerializer();
        try {
            this.setListData((List)jsonSerializer.readObject(listData.openStream()));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        catch (IOException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public ItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    public void setItemRenderer(ItemRenderer itemRenderer) {
        if (itemRenderer == null) {
            throw new IllegalArgumentException("itemRenderer is null.");
        }
        ItemRenderer previousItemRenderer = this.itemRenderer;
        if (previousItemRenderer != itemRenderer) {
            this.itemRenderer = itemRenderer;
            this.listViewListeners.itemRendererChanged(this, previousItemRenderer);
        }
    }

    public ItemEditor getItemEditor() {
        return this.itemEditor;
    }

    public void setItemEditor(ItemEditor itemEditor) {
        ItemEditor previousItemEditor = this.itemEditor;
        if (previousItemEditor != itemEditor) {
            this.itemEditor = itemEditor;
            this.listViewListeners.itemEditorChanged(this, previousItemEditor);
        }
    }

    public int getSelectedIndex() {
        if (this.selectMode != SelectMode.SINGLE) {
            throw new IllegalStateException("List view is not in single-select mode.");
        }
        return this.rangeSelection.getLength() == 0 ? -1 : this.rangeSelection.get((int)0).start;
    }

    public void setSelectedIndex(int index) {
        if (index == -1) {
            this.clearSelection();
        } else {
            this.setSelectedRange(index, index);
        }
    }

    public void setSelectedRange(int start, int end) {
        ArrayList selectedRanges = new ArrayList();
        selectedRanges.add((Object)new Span(start, end));
        this.setSelectedRanges((Sequence<Span>)selectedRanges);
    }

    public ImmutableList<Span> getSelectedRanges() {
        return this.rangeSelection.getSelectedRanges();
    }

    public Sequence<Span> setSelectedRanges(Sequence<Span> selectedRanges) {
        if (selectedRanges == null) {
            throw new IllegalArgumentException("selectedRanges is null.");
        }
        if (this.selectMode == SelectMode.NONE && selectedRanges.getLength() > 0) {
            throw new IllegalArgumentException("Selection is not enabled.");
        }
        ImmutableList<Span> previousSelectedRanges = this.rangeSelection.getSelectedRanges();
        Object previousSelectedItem = this.selectMode == SelectMode.SINGLE ? this.getSelectedItem() : null;
        RangeSelection listSelection = new RangeSelection();
        int n = selectedRanges.getLength();
        for (int i = 0; i < n; ++i) {
            Span range = (Span)selectedRanges.get(i);
            if (range == null) {
                throw new IllegalArgumentException("range is null.");
            }
            if (range.start < 0 || range.end >= this.listData.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            listSelection.addRange(range.start, range.end);
        }
        this.rangeSelection = listSelection;
        this.listViewSelectionListeners.selectedRangesChanged(this, (Sequence<Span>)previousSelectedRanges);
        if (this.selectMode == SelectMode.SINGLE) {
            this.listViewSelectionListeners.selectedItemChanged(this, previousSelectedItem);
        }
        return this.getSelectedRanges();
    }

    public final Sequence<Span> setSelectedRanges(String selectedRanges) {
        if (selectedRanges == null) {
            throw new IllegalArgumentException("selectedRanges is null.");
        }
        try {
            this.setSelectedRanges(this.parseSelectedRanges(selectedRanges));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
        return this.getSelectedRanges();
    }

    private Sequence<Span> parseSelectedRanges(String json) throws SerializationException {
        ArrayList selectedRanges = new ArrayList();
        List list = JSONSerializer.parseList((String)json);
        for (Object item : list) {
            Map map = (Map)item;
            selectedRanges.add((Object)new Span((Dictionary<String, ?>)map));
        }
        return selectedRanges;
    }

    public int getFirstSelectedIndex() {
        return this.rangeSelection.getLength() > 0 ? this.rangeSelection.get((int)0).start : -1;
    }

    public int getLastSelectedIndex() {
        return this.rangeSelection.getLength() > 0 ? this.rangeSelection.get((int)(this.rangeSelection.getLength() - 1)).end : -1;
    }

    public boolean addSelectedIndex(int index) {
        Sequence<Span> addedRanges = this.addSelectedRange(index, index);
        return addedRanges.getLength() > 0;
    }

    public Sequence<Span> addSelectedRange(int start, int end) {
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("List view is not in multi-select mode.");
        }
        if (start < 0 || end >= this.listData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence<Span> addedRanges = this.rangeSelection.addRange(start, end);
        int n = addedRanges.getLength();
        for (int i = 0; i < n; ++i) {
            Span addedRange = (Span)addedRanges.get(i);
            this.listViewSelectionListeners.selectedRangeAdded(this, addedRange.start, addedRange.end);
        }
        if (n > 0) {
            this.listViewSelectionListeners.selectedRangesChanged(this, null);
        }
        return addedRanges;
    }

    public Sequence<Span> addSelectedRange(Span range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        return this.addSelectedRange(range.start, range.end);
    }

    public boolean removeSelectedIndex(int index) {
        Sequence<Span> removedRanges = this.removeSelectedRange(index, index);
        return removedRanges.getLength() > 0;
    }

    public Sequence<Span> removeSelectedRange(int start, int end) {
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("List view is not in multi-select mode.");
        }
        if (start < 0 || end >= this.listData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        Sequence<Span> removedRanges = this.rangeSelection.removeRange(start, end);
        int n = removedRanges.getLength();
        for (int i = 0; i < n; ++i) {
            Span removedRange = (Span)removedRanges.get(i);
            this.listViewSelectionListeners.selectedRangeRemoved(this, removedRange.start, removedRange.end);
        }
        if (n > 0) {
            this.listViewSelectionListeners.selectedRangesChanged(this, null);
        }
        return removedRanges;
    }

    public Sequence<Span> removeSelectedRange(Span range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        return this.removeSelectedRange(range.start, range.end);
    }

    public void selectAll() {
        this.setSelectedRange(0, this.listData.getLength() - 1);
    }

    public void clearSelection() {
        if (this.rangeSelection.getLength() > 0) {
            this.setSelectedRanges((Sequence<Span>)new ArrayList(0));
        }
    }

    public boolean isItemSelected(int index) {
        if (index < 0 || index >= this.listData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return this.rangeSelection.containsIndex(index);
    }

    public Object getSelectedItem() {
        int index = this.getSelectedIndex();
        Object item = null;
        if (index >= 0) {
            item = this.listData.get(index);
        }
        return item;
    }

    public void setSelectedItem(Object item) {
        this.setSelectedIndex(item == null ? -1 : this.listData.indexOf(item));
    }

    public Sequence<?> getSelectedItems() {
        ArrayList items = new ArrayList();
        int n = this.rangeSelection.getLength();
        for (int i = 0; i < n; ++i) {
            Span range = this.rangeSelection.get(i);
            for (int index = range.start; index <= range.end; ++index) {
                Object item = this.listData.get(index);
                items.add(item);
            }
        }
        return items;
    }

    public void setSelectedItems(Sequence<Object> items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        ArrayList selectedRanges = new ArrayList();
        int n = items.getLength();
        for (int i = 0; i < n; ++i) {
            Object item = items.get(i);
            if (item == null) {
                throw new IllegalArgumentException("item is null");
            }
            int index = this.listData.indexOf(item);
            if (index == -1) {
                throw new IllegalArgumentException("\"" + item + "\" is not a valid selection.");
            }
            selectedRanges.add((Object)new Span(index));
        }
        this.setSelectedRanges((Sequence<Span>)selectedRanges);
    }

    public SelectMode getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(SelectMode selectMode) {
        if (selectMode == null) {
            throw new IllegalArgumentException("selectMode is null.");
        }
        SelectMode previousSelectMode = this.selectMode;
        if (previousSelectMode != selectMode) {
            this.clearSelection();
            this.selectMode = selectMode;
            this.listViewListeners.selectModeChanged(this, previousSelectMode);
        }
    }

    public boolean getCheckmarksEnabled() {
        return this.checkmarksEnabled;
    }

    public void setCheckmarksEnabled(boolean checkmarksEnabled) {
        if (this.checkmarksEnabled != checkmarksEnabled) {
            this.checkedIndexes.clear();
            this.checkmarksEnabled = checkmarksEnabled;
            this.listViewListeners.checkmarksEnabledChanged(this);
        }
    }

    public boolean isItemChecked(int index) {
        return ArrayList.binarySearch(this.checkedIndexes, (Comparable)Integer.valueOf(index)) >= 0;
    }

    public void setItemChecked(int index, boolean checked) {
        if (!this.checkmarksEnabled) {
            throw new IllegalStateException("Checkmarks are not enabled.");
        }
        int i = ArrayList.binarySearch(this.checkedIndexes, (Comparable)Integer.valueOf(index));
        if (i < 0 && checked || i >= 0 && !checked) {
            if (checked) {
                this.checkedIndexes.insert((Object)index, -(i + 1));
            } else {
                this.checkedIndexes.remove(i, 1);
            }
            this.listViewItemStateListeners.itemCheckedChanged(this, index);
        }
    }

    public ImmutableList<Integer> getCheckedIndexes() {
        return new ImmutableList(this.checkedIndexes);
    }

    public void clearCheckmarks() {
        ArrayList<Integer> checkedIndexes = this.checkedIndexes;
        this.checkedIndexes = new ArrayList();
        for (Integer index : checkedIndexes) {
            this.listViewItemStateListeners.itemCheckedChanged(this, index);
        }
    }

    public boolean isCheckmarkDisabled(int index) {
        boolean disabled = false;
        if (this.disabledCheckmarkFilter != null) {
            Object item = this.listData.get(index);
            disabled = this.disabledCheckmarkFilter.include(item);
        }
        return disabled;
    }

    public Filter<?> getDisabledCheckmarkFilter() {
        return this.disabledCheckmarkFilter;
    }

    public void setDisabledCheckmarkFilter(Filter<?> disabledCheckmarkFilter) {
        Filter<?> previousDisabledCheckmarkFilter = this.disabledCheckmarkFilter;
        if (previousDisabledCheckmarkFilter != disabledCheckmarkFilter) {
            this.disabledCheckmarkFilter = disabledCheckmarkFilter;
            this.listViewListeners.disabledCheckmarkFilterChanged(this, previousDisabledCheckmarkFilter);
        }
    }

    public boolean isItemDisabled(int index) {
        boolean disabled = false;
        if (this.disabledItemFilter != null) {
            Object item = this.listData.get(index);
            disabled = this.disabledItemFilter.include(item);
        }
        return disabled;
    }

    public Filter<?> getDisabledItemFilter() {
        return this.disabledItemFilter;
    }

    public void setDisabledItemFilter(Filter<?> disabledItemFilter) {
        Filter<?> previousDisabledItemFilter = this.disabledItemFilter;
        if (previousDisabledItemFilter != disabledItemFilter) {
            this.disabledItemFilter = disabledItemFilter;
            this.listViewListeners.disabledItemFilterChanged(this, previousDisabledItemFilter);
        }
    }

    public String getListDataKey() {
        return this.listDataKey;
    }

    public void setListDataKey(String listDataKey) {
        String previousListDataKey = this.listDataKey;
        if (previousListDataKey != listDataKey) {
            this.listDataKey = listDataKey;
            this.listViewBindingListeners.listDataKeyChanged(this, previousListDataKey);
        }
    }

    public BindType getListDataBindType() {
        return this.listDataBindType;
    }

    public void setListDataBindType(BindType listDataBindType) {
        if (listDataBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousListDataBindType = this.listDataBindType;
        if (previousListDataBindType != listDataBindType) {
            this.listDataBindType = listDataBindType;
            this.listViewBindingListeners.listDataBindTypeChanged(this, previousListDataBindType);
        }
    }

    public ListDataBindMapping getListDataBindMapping() {
        return this.listDataBindMapping;
    }

    public void setListDataBindMapping(ListDataBindMapping listDataBindMapping) {
        ListDataBindMapping previousListDataBindMapping = this.listDataBindMapping;
        if (previousListDataBindMapping != listDataBindMapping) {
            this.listDataBindMapping = listDataBindMapping;
            this.listViewBindingListeners.listDataBindMappingChanged(this, previousListDataBindMapping);
        }
    }

    public String getSelectedItemKey() {
        return this.selectedItemKey;
    }

    public void setSelectedItemKey(String selectedItemKey) {
        String previousSelectedItemKey = this.selectedItemKey;
        if (previousSelectedItemKey != selectedItemKey) {
            this.selectedItemKey = selectedItemKey;
            this.listViewBindingListeners.selectedItemKeyChanged(this, previousSelectedItemKey);
        }
    }

    public BindType getSelectedItemBindType() {
        return this.selectedItemBindType;
    }

    public void setSelectedItemBindType(BindType selectedItemBindType) {
        if (selectedItemBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedItemBindType = this.selectedItemBindType;
        if (previousSelectedItemBindType != selectedItemBindType) {
            this.selectedItemBindType = selectedItemBindType;
            this.listViewBindingListeners.selectedItemBindTypeChanged(this, previousSelectedItemBindType);
        }
    }

    public ItemBindMapping getSelectedItemBindMapping() {
        return this.selectedItemBindMapping;
    }

    public void setSelectedItemBindMapping(ItemBindMapping selectedItemBindMapping) {
        ItemBindMapping previousSelectedItemBindMapping = this.selectedItemBindMapping;
        if (previousSelectedItemBindMapping != selectedItemBindMapping) {
            this.selectedItemBindMapping = selectedItemBindMapping;
            this.listViewBindingListeners.selectedItemBindMappingChanged(this, previousSelectedItemBindMapping);
        }
    }

    public String getSelectedItemsKey() {
        return this.selectedItemsKey;
    }

    public void setSelectedItemsKey(String selectedItemsKey) {
        String previousSelectedItemsKey = this.selectedItemsKey;
        if (previousSelectedItemsKey != selectedItemsKey) {
            this.selectedItemsKey = selectedItemsKey;
            this.listViewBindingListeners.selectedItemsKeyChanged(this, previousSelectedItemsKey);
        }
    }

    public BindType getSelectedItemsBindType() {
        return this.selectedItemsBindType;
    }

    public void setSelectedItemsBindType(BindType selectedItemsBindType) {
        if (selectedItemsBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousSelectedItemsBindType = this.selectedItemsBindType;
        if (previousSelectedItemsBindType != selectedItemsBindType) {
            this.selectedItemsBindType = selectedItemsBindType;
            this.listViewBindingListeners.selectedItemsBindTypeChanged(this, previousSelectedItemsBindType);
        }
    }

    public ItemBindMapping getSelectedItemsBindMapping() {
        return this.selectedItemsBindMapping;
    }

    public void setSelectedItemsBindMapping(ItemBindMapping selectedItemsBindMapping) {
        ItemBindMapping previousSelectedItemsBindMapping = this.selectedItemsBindMapping;
        if (previousSelectedItemsBindMapping != selectedItemsBindMapping) {
            this.selectedItemsBindMapping = selectedItemsBindMapping;
            this.listViewBindingListeners.selectedItemsBindMappingChanged(this, previousSelectedItemsBindMapping);
        }
    }

    public String getCheckedItemsKey() {
        return this.checkedItemsKey;
    }

    public void setCheckedItemsKey(String checkedItemsKey) {
        String previousCheckedItemsKey = this.checkedItemsKey;
        if (previousCheckedItemsKey != checkedItemsKey) {
            this.checkedItemsKey = checkedItemsKey;
            this.listViewBindingListeners.checkedItemsKeyChanged(this, previousCheckedItemsKey);
        }
    }

    public BindType getCheckedItemsBindType() {
        return this.checkedItemsBindType;
    }

    public void setCheckedItemsBindType(BindType checkedItemsBindType) {
        if (checkedItemsBindType == null) {
            throw new IllegalArgumentException();
        }
        BindType previousCheckedItemsBindType = this.checkedItemsBindType;
        if (previousCheckedItemsBindType != checkedItemsBindType) {
            this.checkedItemsBindType = checkedItemsBindType;
            this.listViewBindingListeners.checkedItemsBindTypeChanged(this, previousCheckedItemsBindType);
        }
    }

    public ItemBindMapping getCheckedItemsBindMapping() {
        return this.checkedItemsBindMapping;
    }

    public void setCheckedItemsBindMapping(ItemBindMapping checkedItemsBindMapping) {
        ItemBindMapping previousCheckedItemsBindMapping = this.checkedItemsBindMapping;
        if (previousCheckedItemsBindMapping != checkedItemsBindMapping) {
            this.checkedItemsBindMapping = checkedItemsBindMapping;
            this.listViewBindingListeners.checkedItemsBindMappingChanged(this, previousCheckedItemsBindMapping);
        }
    }

    @Override
    public void load(Object context) {
        int index;
        Object item;
        int n;
        Sequence items;
        if (this.listDataKey != null && this.listDataBindType != BindType.STORE && JSON.containsKey((Object)context, (String)this.listDataKey)) {
            Object value = JSON.get((Object)context, (String)this.listDataKey);
            List<?> listData = this.listDataBindMapping == null ? (List<?>)value : this.listDataBindMapping.toListData(value);
            this.setListData(listData);
        }
        switch (this.selectMode) {
            case SINGLE: {
                if (this.selectedItemKey == null || this.selectedItemBindType == BindType.STORE || !JSON.containsKey((Object)context, (String)this.selectedItemKey)) break;
                Object item2 = JSON.get((Object)context, (String)this.selectedItemKey);
                int index2 = this.selectedItemBindMapping == null ? this.listData.indexOf(item2) : this.selectedItemBindMapping.indexOf(this.listData, item2);
                this.setSelectedIndex(index2);
                break;
            }
            case MULTI: {
                if (this.selectedItemsKey == null || this.selectedItemsBindType == BindType.STORE || !JSON.containsKey((Object)context, (String)this.selectedItemsKey)) break;
                items = (Sequence)JSON.get((Object)context, (String)this.selectedItemsKey);
                this.clearSelection();
                n = items.getLength();
                for (int i = 0; i < n; ++i) {
                    item = items.get(i);
                    index = this.selectedItemsBindMapping == null ? this.listData.indexOf(item) : this.selectedItemsBindMapping.indexOf(this.listData, item);
                    if (index == -1) continue;
                    this.addSelectedIndex(index);
                }
                break;
            }
        }
        if (this.checkmarksEnabled && this.checkedItemsKey != null && JSON.containsKey((Object)context, (String)this.checkedItemsKey) && this.checkedItemsBindType != BindType.STORE) {
            items = (Sequence)JSON.get((Object)context, (String)this.checkedItemsKey);
            this.clearCheckmarks();
            n = items.getLength();
            for (int i = 0; i < n; ++i) {
                item = items.get(i);
                index = this.checkedItemsBindMapping == null ? this.listData.indexOf(item) : this.checkedItemsBindMapping.indexOf(this.listData, item);
                if (index == -1) continue;
                this.setItemChecked(index, true);
            }
        }
    }

    @Override
    public void store(Object context) {
        ArrayList items;
        if (this.listDataKey != null && this.listDataBindType != BindType.LOAD) {
            Object value = this.listDataBindMapping == null ? this.listData : this.listDataBindMapping.valueOf(this.listData);
            JSON.put((Object)context, (String)this.listDataKey, value);
        }
        switch (this.selectMode) {
            case SINGLE: {
                if (this.selectedItemKey == null || this.selectedItemBindType == BindType.LOAD) break;
                int selectedIndex = this.getSelectedIndex();
                Object item = selectedIndex == -1 ? null : (this.selectedItemBindMapping == null ? this.listData.get(selectedIndex) : this.selectedItemBindMapping.get(this.listData, selectedIndex));
                JSON.put((Object)context, (String)this.selectedItemKey, item);
                break;
            }
            case MULTI: {
                if (this.selectedItemsKey == null || this.selectedItemsBindType == BindType.LOAD) break;
                items = new ArrayList();
                ImmutableList<Span> selectedRanges = this.getSelectedRanges();
                int n = selectedRanges.getLength();
                for (int i = 0; i < n; ++i) {
                    Span range = (Span)selectedRanges.get(i);
                    for (int index = range.start; index <= range.end; ++index) {
                        Object item = this.selectedItemsBindMapping == null ? this.listData.get(index) : this.selectedItemsBindMapping.get(this.listData, index);
                        items.add(item);
                    }
                }
                JSON.put((Object)context, (String)this.selectedItemsKey, (Object)items);
            }
        }
        if (this.checkmarksEnabled && this.checkedItemsKey != null && JSON.containsKey((Object)context, (String)this.checkedItemsKey) && this.checkedItemsBindType != BindType.LOAD) {
            items = new ArrayList();
            int n = this.checkedIndexes.getLength();
            for (int i = 0; i < n; ++i) {
                Integer index = (Integer)this.checkedIndexes.get(i);
                Object item = this.checkedItemsBindMapping == null ? this.listData.get(index.intValue()) : this.checkedItemsBindMapping.get(this.listData, index);
                items.add(item);
            }
            JSON.put((Object)context, (String)this.checkedItemsKey, (Object)items);
        }
    }

    @Override
    public void clear() {
        if (this.listDataKey != null) {
            this.setListData((List<?>)new ArrayList());
        }
        if (this.selectedItemKey != null || this.selectedItemsKey != null) {
            this.setSelectedItem(null);
        }
        if (this.checkedItemsKey != null) {
            this.clearCheckmarks();
        }
    }

    public int getItemAt(int y) {
        Skin listViewSkin = (Skin)((Object)this.getSkin());
        return listViewSkin.getItemAt(y);
    }

    public Bounds getItemBounds(int index) {
        Skin listViewSkin = (Skin)((Object)this.getSkin());
        return listViewSkin.getItemBounds(index);
    }

    public int getItemIndent() {
        Skin listViewSkin = (Skin)((Object)this.getSkin());
        return listViewSkin.getItemIndent();
    }

    public ListenerList<ListViewListener> getListViewListeners() {
        return this.listViewListeners;
    }

    public ListenerList<ListViewItemListener> getListViewItemListeners() {
        return this.listViewItemListeners;
    }

    public ListenerList<ListViewItemStateListener> getListViewItemStateListeners() {
        return this.listViewItemStateListeners;
    }

    public ListenerList<ListViewSelectionListener> getListViewSelectionListeners() {
        return this.listViewSelectionListeners;
    }

    public ListenerList<ListViewBindingListener> getListViewBindingListeners() {
        return this.listViewBindingListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListViewBindingListenerList
    extends ListenerList<ListViewBindingListener>
    implements ListViewBindingListener {
        private ListViewBindingListenerList() {
        }

        @Override
        public void listDataKeyChanged(ListView listView, String previousListDataKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.listDataKeyChanged(listView, previousListDataKey);
            }
        }

        @Override
        public void listDataBindTypeChanged(ListView listView, BindType previousListDataBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.listDataBindTypeChanged(listView, previousListDataBindType);
            }
        }

        @Override
        public void listDataBindMappingChanged(ListView listView, ListDataBindMapping previousListDataBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.listDataBindMappingChanged(listView, previousListDataBindMapping);
            }
        }

        @Override
        public void selectedItemKeyChanged(ListView listView, String previousSelectedItemKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.selectedItemKeyChanged(listView, previousSelectedItemKey);
            }
        }

        @Override
        public void selectedItemBindTypeChanged(ListView listView, BindType previousSelectedItemBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.selectedItemBindTypeChanged(listView, previousSelectedItemBindType);
            }
        }

        @Override
        public void selectedItemBindMappingChanged(ListView listView, ItemBindMapping previousSelectedItemBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.selectedItemBindMappingChanged(listView, previousSelectedItemBindMapping);
            }
        }

        @Override
        public void selectedItemsKeyChanged(ListView listView, String previousSelectedItemsKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.selectedItemsKeyChanged(listView, previousSelectedItemsKey);
            }
        }

        @Override
        public void selectedItemsBindTypeChanged(ListView listView, BindType previousSelectedItemsBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.selectedItemsBindTypeChanged(listView, previousSelectedItemsBindType);
            }
        }

        @Override
        public void selectedItemsBindMappingChanged(ListView listView, ItemBindMapping previousSelectedItemsBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.selectedItemsBindMappingChanged(listView, previousSelectedItemsBindMapping);
            }
        }

        @Override
        public void checkedItemsKeyChanged(ListView listView, String previousCheckedItemsKey) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.checkedItemsKeyChanged(listView, previousCheckedItemsKey);
            }
        }

        @Override
        public void checkedItemsBindTypeChanged(ListView listView, BindType previousCheckedItemsBindType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.checkedItemsBindTypeChanged(listView, previousCheckedItemsBindType);
            }
        }

        @Override
        public void checkedItemsBindMappingChanged(ListView listView, ItemBindMapping previousCheckedItemsBindMapping) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewBindingListener listener = (ListViewBindingListener)i$.next();
                listener.checkedItemsBindMappingChanged(listView, previousCheckedItemsBindMapping);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListViewSelectionListenerList
    extends ListenerList<ListViewSelectionListener>
    implements ListViewSelectionListener {
        private ListViewSelectionListenerList() {
        }

        @Override
        public void selectedRangeAdded(ListView listView, int rangeStart, int rangeEnd) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewSelectionListener listener = (ListViewSelectionListener)i$.next();
                listener.selectedRangeAdded(listView, rangeStart, rangeEnd);
            }
        }

        @Override
        public void selectedRangeRemoved(ListView listView, int rangeStart, int rangeEnd) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewSelectionListener listener = (ListViewSelectionListener)i$.next();
                listener.selectedRangeRemoved(listView, rangeStart, rangeEnd);
            }
        }

        @Override
        public void selectedRangesChanged(ListView listView, Sequence<Span> previousSelection) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewSelectionListener listener = (ListViewSelectionListener)i$.next();
                listener.selectedRangesChanged(listView, previousSelection);
            }
        }

        @Override
        public void selectedItemChanged(ListView listView, Object previousSelectedItem) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewSelectionListener listener = (ListViewSelectionListener)i$.next();
                listener.selectedItemChanged(listView, previousSelectedItem);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListViewItemStateListenerList
    extends ListenerList<ListViewItemStateListener>
    implements ListViewItemStateListener {
        private ListViewItemStateListenerList() {
        }

        @Override
        public void itemCheckedChanged(ListView listView, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewItemStateListener listener = (ListViewItemStateListener)i$.next();
                listener.itemCheckedChanged(listView, index);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListViewItemListenerList
    extends ListenerList<ListViewItemListener>
    implements ListViewItemListener {
        private ListViewItemListenerList() {
        }

        @Override
        public void itemInserted(ListView listView, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewItemListener listener = (ListViewItemListener)i$.next();
                listener.itemInserted(listView, index);
            }
        }

        @Override
        public void itemsRemoved(ListView listView, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewItemListener listener = (ListViewItemListener)i$.next();
                listener.itemsRemoved(listView, index, count);
            }
        }

        @Override
        public void itemUpdated(ListView listView, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewItemListener listener = (ListViewItemListener)i$.next();
                listener.itemUpdated(listView, index);
            }
        }

        @Override
        public void itemsCleared(ListView listView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewItemListener listener = (ListViewItemListener)i$.next();
                listener.itemsCleared(listView);
            }
        }

        @Override
        public void itemsSorted(ListView listView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewItemListener listener = (ListViewItemListener)i$.next();
                listener.itemsSorted(listView);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListViewListenerList
    extends ListenerList<ListViewListener>
    implements ListViewListener {
        private ListViewListenerList() {
        }

        @Override
        public void listDataChanged(ListView listView, List<?> previousListData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewListener listener = (ListViewListener)i$.next();
                listener.listDataChanged(listView, previousListData);
            }
        }

        @Override
        public void itemRendererChanged(ListView listView, ItemRenderer previousItemRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewListener listener = (ListViewListener)i$.next();
                listener.itemRendererChanged(listView, previousItemRenderer);
            }
        }

        @Override
        public void itemEditorChanged(ListView listView, ItemEditor previousItemEditor) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewListener listener = (ListViewListener)i$.next();
                listener.itemEditorChanged(listView, previousItemEditor);
            }
        }

        @Override
        public void selectModeChanged(ListView listView, SelectMode previousSelectMode) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewListener listener = (ListViewListener)i$.next();
                listener.selectModeChanged(listView, previousSelectMode);
            }
        }

        @Override
        public void checkmarksEnabledChanged(ListView listView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewListener listener = (ListViewListener)i$.next();
                listener.checkmarksEnabledChanged(listView);
            }
        }

        @Override
        public void disabledItemFilterChanged(ListView listView, Filter<?> previousDisabledItemFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewListener listener = (ListViewListener)i$.next();
                listener.disabledItemFilterChanged(listView, previousDisabledItemFilter);
            }
        }

        @Override
        public void disabledCheckmarkFilterChanged(ListView listView, Filter<?> previousDisabledCheckmarkFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ListViewListener listener = (ListViewListener)i$.next();
                listener.disabledCheckmarkFilterChanged(listView, previousDisabledCheckmarkFilter);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ItemBindMapping {
        public int indexOf(List<?> var1, Object var2);

        public Object get(List<?> var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ListDataBindMapping {
        public List<?> toListData(Object var1);

        public Object valueOf(List<?> var1);
    }

    public static interface Skin {
        public int getItemAt(int var1);

        public Bounds getItemBounds(int var1);

        public int getItemIndent();
    }

    public static interface ItemEditor {
        public void beginEdit(ListView var1, int var2);

        public void endEdit(boolean var1);

        public boolean isEditing();
    }

    public static interface ItemRenderer
    extends Renderer {
        public void render(Object var1, int var2, ListView var3, boolean var4, boolean var5, boolean var6, boolean var7);

        public String toString(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectMode {
        NONE,
        SINGLE,
        MULTI;

    }
}

