/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.io.FileList;
import org.apache.pivot.wtk.LocalManifest;
import org.apache.pivot.wtk.media.Picture;

class LocalManifestAdapter
implements Transferable {
    private LocalManifest localManifest;
    private ArrayList<DataFlavor> transferDataFlavors = new ArrayList();
    private static final String URI_LIST_MIME_TYPE = "text/uri-list; class=java.lang.String";

    public LocalManifestAdapter(LocalManifest localManifest) {
        this.localManifest = localManifest;
        if (localManifest.containsText()) {
            this.transferDataFlavors.add((Object)DataFlavor.stringFlavor);
        }
        if (localManifest.containsImage()) {
            this.transferDataFlavors.add((Object)DataFlavor.imageFlavor);
        }
        if (localManifest.containsFileList()) {
            this.transferDataFlavors.add((Object)DataFlavor.javaFileListFlavor);
            try {
                this.transferDataFlavors.add((Object)new DataFlavor(URI_LIST_MIME_TYPE));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        Object transferData = null;
        int index = this.transferDataFlavors.indexOf((Object)dataFlavor);
        if (index == -1) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            transferData = this.localManifest.getText();
        } else if (dataFlavor.equals(DataFlavor.imageFlavor)) {
            Picture picture = (Picture)this.localManifest.getImage();
            transferData = picture.getBufferedImage();
        } else if (dataFlavor.equals(DataFlavor.javaFileListFlavor)) {
            FileList fileList = this.localManifest.getFileList();
            transferData = fileList.getList();
        } else if (dataFlavor.getMimeType().equals(URI_LIST_MIME_TYPE)) {
            FileList fileList = this.localManifest.getFileList();
            StringBuilder buf = new StringBuilder();
            for (File file : fileList) {
                buf.append(file.toURI().toString()).append("\r\n");
            }
            transferData = buf.toString();
        }
        return transferData;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])this.transferDataFlavors.toArray(DataFlavor[].class);
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return this.transferDataFlavors.indexOf((Object)dataFlavor) != -1;
    }
}

