/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuButtonListener;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.ButtonDataRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="menu")
public class MenuButton
extends Button {
    private Menu menu = null;
    private MenuButtonListenerList menuButtonListeners = new MenuButtonListenerList();
    private static final Button.DataRenderer DEFAULT_DATA_RENDERER = new ButtonDataRenderer();

    public MenuButton() {
        this.setDataRenderer(DEFAULT_DATA_RENDERER);
        this.installSkin(MenuButton.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public Window getListPopup() {
        return ((Skin)((Object)this.getSkin())).getMenuPopup();
    }

    @Override
    public void setToggleButton(boolean toggleButton) {
        throw new UnsupportedOperationException("Menu buttons cannot be toggle buttons.");
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void setMenu(Menu menu) {
        if (menu != null && menu.getItem() != null) {
            throw new IllegalArgumentException("menu already belongs to an item.");
        }
        Menu previousMenu = this.menu;
        if (previousMenu != menu) {
            this.menu = menu;
            this.menuButtonListeners.menuChanged(this, previousMenu);
        }
    }

    public ListenerList<MenuButtonListener> getMenuButtonListeners() {
        return this.menuButtonListeners;
    }

    public static interface Skin {
        public Window getMenuPopup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MenuButtonListenerList
    extends ListenerList<MenuButtonListener>
    implements MenuButtonListener {
        private MenuButtonListenerList() {
        }

        @Override
        public void menuChanged(MenuButton menuButton, Menu previousMenu) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                MenuButtonListener listener = (MenuButtonListener)i$.next();
                listener.menuChanged(menuButton, previousMenu);
            }
        }
    }
}

