/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ImmutableIterator;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Resources;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.PromptListener;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.SheetCloseListener;
import org.apache.pivot.wtk.Window;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="body")
public class Prompt
extends Sheet {
    private MessageType messageType = null;
    private String message = null;
    private Component body = null;
    private ArrayList<Object> options = new ArrayList();
    private OptionSequence optionSequence = new OptionSequence();
    private int selectedOptionIndex = -1;
    private PromptListenerList promptListeners = new PromptListenerList();
    private static Resources resources = null;

    public Prompt() {
        this(null, null, null);
    }

    public Prompt(MessageType messageType, String message, Sequence<?> options) {
        this(messageType, message, options, null);
    }

    public Prompt(MessageType messageType, String message, Sequence<?> options, Component body) {
        this.setMessageType(messageType == null ? MessageType.INFO : messageType);
        this.setMessage(message);
        this.setOptions((Sequence<?>)(options == null ? new ArrayList(new Object[]{resources.get("defaultOption")}) : options));
        this.setBody(body);
        this.installSkin(Prompt.class);
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        if (messageType == null) {
            throw new IllegalArgumentException();
        }
        MessageType previousMessageType = this.messageType;
        if (previousMessageType != messageType) {
            this.messageType = messageType;
            this.promptListeners.messageTypeChanged(this, previousMessageType);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        String previousMessage = this.message;
        if (previousMessage != message) {
            this.message = message;
            this.promptListeners.messageChanged(this, previousMessage);
        }
    }

    public Component getBody() {
        return this.body;
    }

    public void setBody(Component body) {
        Component previousBody = this.body;
        if (previousBody != body) {
            this.body = body;
            this.promptListeners.bodyChanged(this, previousBody);
        }
    }

    public OptionSequence getOptions() {
        return this.optionSequence;
    }

    public void setOptions(Sequence<?> options) {
        this.optionSequence.remove(0, this.optionSequence.getLength());
        if (options != null) {
            int n = options.getLength();
            for (int i = 0; i < n; ++i) {
                this.optionSequence.add(options.get(i));
            }
            this.setSelectedOptionIndex(0);
        }
    }

    public void setOptions(String options) {
        try {
            this.setOptions((Sequence<?>)JSONSerializer.parseList((String)options));
        }
        catch (SerializationException exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    public int getSelectedOptionIndex() {
        return this.selectedOptionIndex;
    }

    public void setSelectedOptionIndex(int selectedOption) {
        if (selectedOption < -1 || selectedOption > this.options.getLength() - 1) {
            throw new IndexOutOfBoundsException();
        }
        int previousSelectedOption = this.selectedOptionIndex;
        if (selectedOption != previousSelectedOption) {
            this.selectedOptionIndex = selectedOption;
            this.promptListeners.selectedOptionChanged(this, previousSelectedOption);
        }
    }

    public Object getSelectedOption() {
        return this.selectedOptionIndex == -1 ? null : this.options.get(this.selectedOptionIndex);
    }

    public void setSelectedOption(Object selectedOption) {
        this.setSelectedOptionIndex(this.options.indexOf(selectedOption));
    }

    public ListenerList<PromptListener> getPromptListeners() {
        return this.promptListeners;
    }

    public static void prompt(String message, Window owner) {
        Prompt.prompt(MessageType.INFO, message, null, owner, null);
    }

    public static void prompt(MessageType messageType, String message, Window owner) {
        Prompt.prompt(messageType, message, null, owner, null);
    }

    public static void prompt(MessageType messageType, String message, Window owner, SheetCloseListener sheetCloseListener) {
        Prompt.prompt(messageType, message, null, owner, sheetCloseListener);
    }

    public static void prompt(MessageType messageType, String message, Component body, Window owner) {
        Prompt.prompt(messageType, message, body, owner, null);
    }

    public static void prompt(MessageType messageType, String message, Component body, Window owner, SheetCloseListener sheetCloseListener) {
        Prompt prompt = new Prompt(messageType, message, null, body);
        prompt.open(owner, sheetCloseListener);
    }

    static {
        try {
            resources = new Resources(Prompt.class.getName());
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PromptListenerList
    extends ListenerList<PromptListener>
    implements PromptListener {
        private PromptListenerList() {
        }

        @Override
        public void messageTypeChanged(Prompt prompt, MessageType previousMessageType) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                PromptListener listener = (PromptListener)i$.next();
                listener.messageTypeChanged(prompt, previousMessageType);
            }
        }

        @Override
        public void messageChanged(Prompt prompt, String previousMessage) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                PromptListener listener = (PromptListener)i$.next();
                listener.messageChanged(prompt, previousMessage);
            }
        }

        @Override
        public void bodyChanged(Prompt prompt, Component previousBody) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                PromptListener listener = (PromptListener)i$.next();
                listener.bodyChanged(prompt, previousBody);
            }
        }

        @Override
        public void optionInserted(Prompt prompt, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                PromptListener listener = (PromptListener)i$.next();
                listener.optionInserted(prompt, index);
            }
        }

        @Override
        public void optionsRemoved(Prompt prompt, int index, Sequence<?> removed) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                PromptListener listener = (PromptListener)i$.next();
                listener.optionsRemoved(prompt, index, removed);
            }
        }

        @Override
        public void selectedOptionChanged(Prompt prompt, int previousSelectedOption) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                PromptListener listener = (PromptListener)i$.next();
                listener.selectedOptionChanged(prompt, previousSelectedOption);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class OptionSequence
    implements Sequence<Object>,
    Iterable<Object> {
        private OptionSequence() {
        }

        public int add(Object option) {
            int index = this.getLength();
            this.insert(option, index);
            return index;
        }

        public void insert(Object option, int index) {
            if (option == null) {
                throw new IllegalArgumentException("option is null.");
            }
            Prompt.this.options.insert(option, index);
            if (Prompt.this.selectedOptionIndex >= index) {
                Prompt.this.selectedOptionIndex++;
            }
            Prompt.this.promptListeners.optionInserted(Prompt.this, index);
        }

        public Component update(int index, Object option) {
            throw new UnsupportedOperationException();
        }

        public int remove(Object option) {
            int index = this.indexOf(option);
            if (index != -1) {
                this.remove(index, 1);
            }
            return index;
        }

        public Sequence<Object> remove(int index, int count) {
            Sequence removed = Prompt.this.options.remove(index, count);
            if (removed.getLength() > 0) {
                if (Prompt.this.selectedOptionIndex >= index) {
                    if (Prompt.this.selectedOptionIndex < index + count) {
                        Prompt.this.selectedOptionIndex = -1;
                    } else {
                        Prompt.this.selectedOptionIndex -= count;
                    }
                }
                Prompt.this.promptListeners.optionsRemoved(Prompt.this, index, removed);
            }
            return removed;
        }

        public Object get(int index) {
            return Prompt.this.options.get(index);
        }

        public int indexOf(Object option) {
            return Prompt.this.options.indexOf(option);
        }

        public int getLength() {
            return Prompt.this.options.getLength();
        }

        @Override
        public Iterator<Object> iterator() {
            return new ImmutableIterator((Iterator)Prompt.this.options.iterator());
        }
    }
}

