/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Iterator;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.json.JSONSerializer;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.ScrollBarListener;
import org.apache.pivot.wtk.ScrollBarValueListener;
import org.apache.pivot.wtk.Span;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollBar
extends Container {
    private Orientation orientation;
    private int start = 0;
    private int end = 100;
    private int extent = 1;
    private int value = 0;
    private int unitIncrement = 1;
    private int blockIncrement = 1;
    private ScrollBarListenerList scrollBarListeners = new ScrollBarListenerList();
    private ScrollBarValueListenerList scrollBarValueListeners = new ScrollBarValueListenerList();

    public ScrollBar() {
        this(Orientation.HORIZONTAL);
    }

    public ScrollBar(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null");
        }
        this.orientation = orientation;
        this.installSkin(ScrollBar.class);
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation is null");
        }
        Orientation previousOrientation = this.orientation;
        if (orientation != previousOrientation) {
            this.orientation = orientation;
            this.scrollBarListeners.orientationChanged(this, previousOrientation);
        }
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.setScope(start, this.end, this.extent);
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.setScope(this.start, end, this.extent);
    }

    public Span getRange() {
        return new Span(this.start, this.end);
    }

    public void setRange(int start, int end) {
        this.setScope(start, end, this.extent);
    }

    public final void setRange(Span range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(range.start, range.end);
    }

    public final void setRange(Dictionary<String, ?> range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(new Span(range));
    }

    public final void setRange(String range) {
        if (range == null) {
            throw new IllegalArgumentException("range is null.");
        }
        this.setRange(Span.decode(range));
    }

    public int getExtent() {
        return this.extent;
    }

    public void setExtent(int extent) {
        this.setScope(this.start, this.end, extent);
    }

    public Scope getScope() {
        return new Scope(this.start, this.end, this.extent);
    }

    public void setScope(int start, int end, int extent) {
        int previousStart = this.start;
        int previousEnd = this.end;
        int previousExtent = this.extent;
        if (start != previousStart || end != previousEnd || extent != previousExtent) {
            if (start > this.value) {
                throw new IllegalArgumentException(String.format("start (%d) is greater than value (%d)", start, this.value));
            }
            if (extent < 0) {
                throw new IllegalArgumentException(String.format("extent (%d) is negative", extent));
            }
            if (end < this.value + extent) {
                throw new IllegalArgumentException(String.format("end (%d) is less than value (%d) + extent (%d)", end, this.value, extent));
            }
            this.start = start;
            this.end = end;
            this.extent = extent;
            this.scrollBarListeners.scopeChanged(this, previousStart, previousEnd, previousExtent);
        }
    }

    public final void setScope(Scope scope) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null.");
        }
        this.setScope(scope.start, scope.end, scope.extent);
    }

    public final void setScope(Dictionary<String, ?> scope) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null.");
        }
        this.setScope(new Scope(scope));
    }

    public final void setScope(String scope) {
        if (scope == null) {
            throw new IllegalArgumentException("scope is null.");
        }
        this.setScope(Scope.decode(scope));
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        int previousValue = this.value;
        if (value != previousValue) {
            if (value < this.start) {
                throw new IllegalArgumentException(String.format("value (%d) is less than start (%d)", value, this.start));
            }
            if (value + this.extent > this.end) {
                throw new IllegalArgumentException(String.format("value (%d) + extent (%d) is greater than end (%d)", value, this.extent, this.end));
            }
            this.value = value;
            this.scrollBarValueListeners.valueChanged(this, previousValue);
        }
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public void setUnitIncrement(int unitIncrement) {
        if (unitIncrement < 0) {
            throw new IllegalArgumentException("unitIncrement is negative");
        }
        int previousUnitIncrement = this.unitIncrement;
        if (unitIncrement != previousUnitIncrement) {
            this.unitIncrement = unitIncrement;
            this.scrollBarListeners.unitIncrementChanged(this, previousUnitIncrement);
        }
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public void setBlockIncrement(int blockIncrement) {
        if (blockIncrement < 0) {
            throw new IllegalArgumentException("blockIncrement is negative");
        }
        int previousBlockIncrement = this.blockIncrement;
        if (blockIncrement != previousBlockIncrement) {
            this.blockIncrement = blockIncrement;
            this.scrollBarListeners.blockIncrementChanged(this, previousBlockIncrement);
        }
    }

    public ListenerList<ScrollBarListener> getScrollBarListeners() {
        return this.scrollBarListeners;
    }

    public ListenerList<ScrollBarValueListener> getScrollBarValueListeners() {
        return this.scrollBarValueListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScrollBarValueListenerList
    extends ListenerList<ScrollBarValueListener>
    implements ScrollBarValueListener {
        private ScrollBarValueListenerList() {
        }

        @Override
        public void valueChanged(ScrollBar scrollBar, int previousValue) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollBarValueListener listener = (ScrollBarValueListener)i$.next();
                listener.valueChanged(scrollBar, previousValue);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScrollBarListenerList
    extends ListenerList<ScrollBarListener>
    implements ScrollBarListener {
        private ScrollBarListenerList() {
        }

        @Override
        public void orientationChanged(ScrollBar scrollBar, Orientation previousOrientation) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollBarListener listener = (ScrollBarListener)i$.next();
                listener.orientationChanged(scrollBar, previousOrientation);
            }
        }

        @Override
        public void scopeChanged(ScrollBar scrollBar, int previousStart, int previousEnd, int previousExtent) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollBarListener listener = (ScrollBarListener)i$.next();
                listener.scopeChanged(scrollBar, previousStart, previousEnd, previousExtent);
            }
        }

        @Override
        public void unitIncrementChanged(ScrollBar scrollBar, int previousUnitIncrement) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollBarListener listener = (ScrollBarListener)i$.next();
                listener.unitIncrementChanged(scrollBar, previousUnitIncrement);
            }
        }

        @Override
        public void blockIncrementChanged(ScrollBar scrollBar, int previousBlockIncrement) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                ScrollBarListener listener = (ScrollBarListener)i$.next();
                listener.blockIncrementChanged(scrollBar, previousBlockIncrement);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Scope {
        public final int start;
        public final int end;
        public final int extent;
        public static final String START_KEY = "start";
        public static final String END_KEY = "end";
        public static final String EXTENT_KEY = "extent";

        public Scope(int start, int end, int extent) {
            this.start = start;
            this.end = end;
            this.extent = extent;
        }

        public Scope(Dictionary<String, ?> scope) {
            if (scope == null) {
                throw new IllegalArgumentException("scope is null.");
            }
            if (!scope.containsKey((Object)START_KEY)) {
                throw new IllegalArgumentException("start is required.");
            }
            if (!scope.containsKey((Object)END_KEY)) {
                throw new IllegalArgumentException("end is required.");
            }
            if (!scope.containsKey((Object)EXTENT_KEY)) {
                throw new IllegalArgumentException("extent is required.");
            }
            this.start = (Integer)scope.get((Object)START_KEY);
            this.end = (Integer)scope.get((Object)END_KEY);
            this.extent = (Integer)scope.get((Object)EXTENT_KEY);
        }

        public String toString() {
            return "{start: " + this.start + ", end: " + this.end + ", extent: " + this.extent + "}";
        }

        public static Scope decode(String value) {
            Scope scope;
            if (value == null) {
                throw new IllegalArgumentException();
            }
            try {
                scope = new Scope((Dictionary<String, ?>)JSONSerializer.parseMap((String)value));
            }
            catch (SerializationException exception) {
                throw new IllegalArgumentException(exception);
            }
            return scope;
        }
    }
}

