/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.SuggestionPopupCloseListener;
import org.apache.pivot.wtk.SuggestionPopupItemListener;
import org.apache.pivot.wtk.SuggestionPopupListener;
import org.apache.pivot.wtk.SuggestionPopupSelectionListener;
import org.apache.pivot.wtk.SuggestionPopupStateListener;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.content.ListViewItemRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionPopup
extends Window {
    private TextInput textInput = null;
    private SuggestionPopupCloseListener suggestionPopupCloseListener = null;
    private List<?> suggestionData;
    private ListView.ItemRenderer suggestionRenderer;
    private int selectedIndex = -1;
    private int listSize = -1;
    private boolean result = false;
    private boolean closing = false;
    private ListListener<Object> suggestionDataListener = new ListListener<Object>(){

        public void itemInserted(List<Object> list, int index) {
            int previousSelectedIndex = SuggestionPopup.this.selectedIndex;
            if (index <= SuggestionPopup.this.selectedIndex) {
                SuggestionPopup.this.selectedIndex++;
            }
            SuggestionPopup.this.suggestionPopupItemListeners.itemInserted(SuggestionPopup.this, index);
            if (SuggestionPopup.this.selectedIndex != previousSelectedIndex) {
                SuggestionPopup.this.suggestionPopupSelectionListeners.selectedIndexChanged(SuggestionPopup.this, SuggestionPopup.this.selectedIndex);
            }
        }

        public void itemsRemoved(List<Object> list, int index, Sequence<Object> items) {
            int count = items.getLength();
            int previousSelectedIndex = SuggestionPopup.this.selectedIndex;
            if (SuggestionPopup.this.selectedIndex >= index) {
                if (SuggestionPopup.this.selectedIndex < index + count) {
                    SuggestionPopup.this.selectedIndex = -1;
                } else {
                    SuggestionPopup.this.selectedIndex -= count;
                }
            }
            SuggestionPopup.this.suggestionPopupItemListeners.itemsRemoved(SuggestionPopup.this, index, count);
            if (SuggestionPopup.this.selectedIndex != previousSelectedIndex) {
                SuggestionPopup.this.suggestionPopupSelectionListeners.selectedIndexChanged(SuggestionPopup.this, SuggestionPopup.this.selectedIndex);
                if (SuggestionPopup.this.selectedIndex == -1) {
                    SuggestionPopup.this.suggestionPopupSelectionListeners.selectedSuggestionChanged(SuggestionPopup.this, null);
                }
            }
        }

        public void itemUpdated(List<Object> list, int index, Object previousItem) {
            SuggestionPopup.this.suggestionPopupItemListeners.itemUpdated(SuggestionPopup.this, index);
        }

        public void listCleared(List<Object> list) {
            int previousSelectedIndex = SuggestionPopup.this.selectedIndex;
            SuggestionPopup.this.selectedIndex = -1;
            SuggestionPopup.this.suggestionPopupItemListeners.itemsCleared(SuggestionPopup.this);
            if (previousSelectedIndex != SuggestionPopup.this.selectedIndex) {
                SuggestionPopup.this.suggestionPopupSelectionListeners.selectedIndexChanged(SuggestionPopup.this, SuggestionPopup.this.selectedIndex);
                SuggestionPopup.this.suggestionPopupSelectionListeners.selectedSuggestionChanged(SuggestionPopup.this, SuggestionPopup.this.getSelectedSuggestion());
            }
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> previousComparator) {
            if (list.getComparator() != null) {
                int previousSelectedIndex = SuggestionPopup.this.selectedIndex;
                SuggestionPopup.this.selectedIndex = -1;
                SuggestionPopup.this.suggestionPopupItemListeners.itemsSorted(SuggestionPopup.this);
                if (previousSelectedIndex != SuggestionPopup.this.selectedIndex) {
                    SuggestionPopup.this.suggestionPopupSelectionListeners.selectedIndexChanged(SuggestionPopup.this, SuggestionPopup.this.selectedIndex);
                    SuggestionPopup.this.suggestionPopupSelectionListeners.selectedSuggestionChanged(SuggestionPopup.this, SuggestionPopup.this.getSelectedSuggestion());
                }
            }
        }
    };
    private SuggestionPopupListenerList suggestionPopupListeners = new SuggestionPopupListenerList();
    private SuggestionPopupItemListenerList suggestionPopupItemListeners = new SuggestionPopupItemListenerList();
    private SuggestionPopupSelectionListenerList suggestionPopupSelectionListeners = new SuggestionPopupSelectionListenerList();
    private SuggestionPopupStateListenerList suggestionPopupStateListeners = new SuggestionPopupStateListenerList();
    private static final ListView.ItemRenderer DEFAULT_SUGGESTION_RENDERER = new ListViewItemRenderer();

    public SuggestionPopup() {
        this((List<?>)new ArrayList());
    }

    public SuggestionPopup(List<?> suggestions) {
        this.setSuggestionRenderer(DEFAULT_SUGGESTION_RENDERER);
        this.setSuggestionData(suggestions);
        this.installSkin(SuggestionPopup.class);
    }

    public TextInput getTextInput() {
        return this.textInput;
    }

    public List<?> getSuggestionData() {
        return this.suggestionData;
    }

    public void setSuggestionData(List<?> suggestionData) {
        if (suggestionData == null) {
            throw new IllegalArgumentException("suggestionData is null.");
        }
        List<?> previousSuggestionData = this.suggestionData;
        if (previousSuggestionData != suggestionData) {
            int previousSelectedIndex = this.selectedIndex;
            if (previousSuggestionData != null) {
                this.selectedIndex = -1;
                previousSuggestionData.getListListeners().remove(this.suggestionDataListener);
            }
            suggestionData.getListListeners().add(this.suggestionDataListener);
            this.suggestionData = suggestionData;
            this.suggestionPopupListeners.suggestionDataChanged(this, previousSuggestionData);
            if (this.selectedIndex != previousSelectedIndex) {
                this.suggestionPopupSelectionListeners.selectedIndexChanged(this, this.selectedIndex);
                this.suggestionPopupSelectionListeners.selectedSuggestionChanged(this, null);
            }
        }
    }

    public ListView.ItemRenderer getSuggestionRenderer() {
        return this.suggestionRenderer;
    }

    public void setSuggestionRenderer(ListView.ItemRenderer suggestionRenderer) {
        ListView.ItemRenderer previousSuggestionRenderer = this.suggestionRenderer;
        if (previousSuggestionRenderer != suggestionRenderer) {
            this.suggestionRenderer = suggestionRenderer;
            this.suggestionPopupListeners.suggestionRendererChanged(this, previousSuggestionRenderer);
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (selectedIndex < -1 || selectedIndex >= this.suggestionData.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        int previousSelectedIndex = this.selectedIndex;
        if (previousSelectedIndex != selectedIndex) {
            this.selectedIndex = selectedIndex;
            this.suggestionPopupSelectionListeners.selectedIndexChanged(this, previousSelectedIndex);
            this.suggestionPopupSelectionListeners.selectedSuggestionChanged(this, previousSelectedIndex == -1 ? null : this.suggestionData.get(previousSelectedIndex));
        }
    }

    public Object getSelectedSuggestion() {
        int index = this.getSelectedIndex();
        Object item = null;
        if (index >= 0) {
            item = this.suggestionData.get(index);
        }
        return item;
    }

    public void setSelectedSuggestion(Object suggestion) {
        this.setSelectedIndex(suggestion == null ? -1 : this.suggestionData.indexOf(suggestion));
    }

    public int getListSize() {
        return this.listSize;
    }

    public void setListSize(int listSize) {
        if (listSize < -1) {
            throw new IllegalArgumentException("Invalid list size.");
        }
        int previousListSize = this.listSize;
        if (previousListSize != listSize) {
            this.listSize = listSize;
            this.suggestionPopupListeners.listSizeChanged(this, previousListSize);
        }
    }

    @Override
    public final void open(Display display, Window owner) {
        if (this.textInput == null) {
            throw new IllegalStateException("textInput is null.");
        }
        this.setSelectedIndex(-1);
        super.open(display, owner);
    }

    public final void open(TextInput textInput) {
        this.open(textInput, null);
    }

    public void open(TextInput textInput, SuggestionPopupCloseListener suggestionPopupCloseListener) {
        if (textInput == null) {
            throw new IllegalArgumentException();
        }
        this.textInput = textInput;
        this.suggestionPopupCloseListener = suggestionPopupCloseListener;
        this.result = false;
        super.open(textInput.getWindow());
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public final void close() {
        this.close(false);
    }

    public void close(boolean result) {
        if (!this.isClosed()) {
            this.closing = true;
            Vote vote = this.suggestionPopupStateListeners.previewSuggestionPopupClose(this, result);
            if (vote == Vote.APPROVE) {
                super.close();
                this.closing = super.isClosing();
                if (this.isClosed()) {
                    this.result = result;
                    this.suggestionPopupStateListeners.suggestionPopupClosed(this);
                    if (this.suggestionPopupCloseListener != null) {
                        this.suggestionPopupCloseListener.suggestionPopupClosed(this);
                        this.suggestionPopupCloseListener = null;
                    }
                }
            } else {
                if (vote == Vote.DENY) {
                    this.closing = false;
                }
                this.suggestionPopupStateListeners.suggestionPopupCloseVetoed(this, vote);
            }
        }
    }

    public SuggestionPopupCloseListener getSuggestionPopupCloseListener() {
        return this.suggestionPopupCloseListener;
    }

    public boolean getResult() {
        return this.result;
    }

    public ListenerList<SuggestionPopupListener> getSuggestionPopupListeners() {
        return this.suggestionPopupListeners;
    }

    public ListenerList<SuggestionPopupItemListener> getSuggestionPopupItemListeners() {
        return this.suggestionPopupItemListeners;
    }

    public ListenerList<SuggestionPopupSelectionListener> getSuggestionPopupSelectionListeners() {
        return this.suggestionPopupSelectionListeners;
    }

    public ListenerList<SuggestionPopupStateListener> getSuggestionPopupStateListeners() {
        return this.suggestionPopupStateListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuggestionPopupStateListenerList
    extends ListenerList<SuggestionPopupStateListener>
    implements SuggestionPopupStateListener {
        private SuggestionPopupStateListenerList() {
        }

        @Override
        public Vote previewSuggestionPopupClose(SuggestionPopup suggestionPopup, boolean result) {
            Vote vote = Vote.APPROVE;
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupStateListener listener = (SuggestionPopupStateListener)i$.next();
                vote = vote.tally(listener.previewSuggestionPopupClose(suggestionPopup, result));
            }
            return vote;
        }

        @Override
        public void suggestionPopupCloseVetoed(SuggestionPopup suggestionPopup, Vote reason) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupStateListener listener = (SuggestionPopupStateListener)i$.next();
                listener.suggestionPopupCloseVetoed(suggestionPopup, reason);
            }
        }

        @Override
        public void suggestionPopupClosed(SuggestionPopup suggestionPopup) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupStateListener listener = (SuggestionPopupStateListener)i$.next();
                listener.suggestionPopupClosed(suggestionPopup);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuggestionPopupSelectionListenerList
    extends ListenerList<SuggestionPopupSelectionListener>
    implements SuggestionPopupSelectionListener {
        private SuggestionPopupSelectionListenerList() {
        }

        @Override
        public void selectedIndexChanged(SuggestionPopup suggestionPopup, int previousSelectedIndex) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupSelectionListener listener = (SuggestionPopupSelectionListener)i$.next();
                listener.selectedIndexChanged(suggestionPopup, previousSelectedIndex);
            }
        }

        @Override
        public void selectedSuggestionChanged(SuggestionPopup suggestionPopup, Object previousSelectedSuggestion) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupSelectionListener listener = (SuggestionPopupSelectionListener)i$.next();
                listener.selectedSuggestionChanged(suggestionPopup, previousSelectedSuggestion);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuggestionPopupItemListenerList
    extends ListenerList<SuggestionPopupItemListener>
    implements SuggestionPopupItemListener {
        private SuggestionPopupItemListenerList() {
        }

        @Override
        public void itemInserted(SuggestionPopup suggestionPopup, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupItemListener listener = (SuggestionPopupItemListener)i$.next();
                listener.itemInserted(suggestionPopup, index);
            }
        }

        @Override
        public void itemsRemoved(SuggestionPopup suggestionPopup, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupItemListener listener = (SuggestionPopupItemListener)i$.next();
                listener.itemsRemoved(suggestionPopup, index, count);
            }
        }

        @Override
        public void itemUpdated(SuggestionPopup suggestionPopup, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupItemListener listener = (SuggestionPopupItemListener)i$.next();
                listener.itemUpdated(suggestionPopup, index);
            }
        }

        @Override
        public void itemsCleared(SuggestionPopup suggestionPopup) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupItemListener listener = (SuggestionPopupItemListener)i$.next();
                listener.itemsCleared(suggestionPopup);
            }
        }

        @Override
        public void itemsSorted(SuggestionPopup suggestionPopup) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupItemListener listener = (SuggestionPopupItemListener)i$.next();
                listener.itemsSorted(suggestionPopup);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuggestionPopupListenerList
    extends ListenerList<SuggestionPopupListener>
    implements SuggestionPopupListener {
        private SuggestionPopupListenerList() {
        }

        @Override
        public void suggestionDataChanged(SuggestionPopup suggestionPopup, List<?> previousSuggestionData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupListener listener = (SuggestionPopupListener)i$.next();
                listener.suggestionDataChanged(suggestionPopup, previousSuggestionData);
            }
        }

        @Override
        public void suggestionRendererChanged(SuggestionPopup suggestionPopup, ListView.ItemRenderer previousSuggestionRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupListener listener = (SuggestionPopupListener)i$.next();
                listener.suggestionRendererChanged(suggestionPopup, previousSuggestionRenderer);
            }
        }

        @Override
        public void listSizeChanged(SuggestionPopup suggestionPopup, int previousListSize) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                SuggestionPopupListener listener = (SuggestionPopupListener)i$.next();
                listener.listSizeChanged(suggestionPopup, previousListSize);
            }
        }
    }
}

