/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.pivot.beans.DefaultProperty;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.ListListener;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.ListenerList;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Renderer;
import org.apache.pivot.wtk.TreeViewBranchListener;
import org.apache.pivot.wtk.TreeViewListener;
import org.apache.pivot.wtk.TreeViewNodeListener;
import org.apache.pivot.wtk.TreeViewNodeStateListener;
import org.apache.pivot.wtk.TreeViewSelectionListener;
import org.apache.pivot.wtk.content.TreeViewNodeRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DefaultProperty(value="treeData")
public class TreeView
extends Component {
    private List<?> treeData = null;
    private ArrayList<Sequence.Tree.Path> expandedPaths = new ArrayList(PATH_COMPARATOR);
    private ArrayList<Sequence.Tree.Path> selectedPaths = new ArrayList(PATH_COMPARATOR);
    private ArrayList<Sequence.Tree.Path> checkedPaths = new ArrayList(PATH_COMPARATOR);
    private SelectMode selectMode = SelectMode.SINGLE;
    private boolean checkmarksEnabled = false;
    private boolean showMixedCheckmarkState = false;
    private Filter<?> disabledNodeFilter = null;
    private Filter<?> disabledCheckmarkFilter = null;
    private BranchHandler rootBranchHandler;
    private NodeRenderer nodeRenderer = DEFAULT_NODE_RENDERER;
    private NodeEditor nodeEditor = null;
    private TreeViewListenerList treeViewListeners = new TreeViewListenerList();
    private TreeViewBranchListenerList treeViewBranchListeners = new TreeViewBranchListenerList();
    private TreeViewNodeListenerList treeViewNodeListeners = new TreeViewNodeListenerList();
    private TreeViewNodeStateListenerList treeViewNodeStateListeners = new TreeViewNodeStateListenerList();
    private TreeViewSelectionListenerList treeViewSelectionListeners = new TreeViewSelectionListenerList();
    private static final NodeRenderer DEFAULT_NODE_RENDERER = new TreeViewNodeRenderer();
    private static final Comparator<Sequence.Tree.Path> PATH_COMPARATOR = new PathComparator();

    public TreeView() {
        this((List<?>)new ArrayList());
    }

    public TreeView(List<?> treeData) {
        this.setTreeData(treeData);
        this.installSkin(TreeView.class);
    }

    @Override
    protected void setSkin(org.apache.pivot.wtk.Skin skin) {
        if (!(skin instanceof Skin)) {
            throw new IllegalArgumentException("Skin class must implement " + Skin.class.getName());
        }
        super.setSkin(skin);
    }

    public List<?> getTreeData() {
        return this.treeData;
    }

    public void setTreeData(List<?> treeData) {
        if (treeData == null) {
            throw new IllegalArgumentException("treeData is null.");
        }
        List<?> previousTreeData = this.treeData;
        if (previousTreeData != treeData) {
            int cleared;
            if (previousTreeData != null) {
                this.expandedPaths.clear();
                cleared = this.selectedPaths.getLength();
                this.selectedPaths.clear();
                this.checkedPaths.clear();
                this.rootBranchHandler.release();
            } else {
                cleared = 0;
            }
            this.rootBranchHandler = new BranchHandler(null, treeData);
            this.treeData = treeData;
            this.treeViewListeners.treeDataChanged(this, previousTreeData);
            if (cleared > 0) {
                this.treeViewSelectionListeners.selectedPathsChanged(this, (Sequence<Sequence.Tree.Path>)this.getSelectedPaths());
                if (this.selectMode == SelectMode.SINGLE) {
                    this.treeViewSelectionListeners.selectedNodeChanged(this, null);
                }
            }
        }
    }

    public NodeRenderer getNodeRenderer() {
        return this.nodeRenderer;
    }

    public void setNodeRenderer(NodeRenderer nodeRenderer) {
        if (nodeRenderer == null) {
            throw new IllegalArgumentException("nodeRenderer is null.");
        }
        NodeRenderer previousNodeRenderer = this.nodeRenderer;
        if (previousNodeRenderer != nodeRenderer) {
            this.nodeRenderer = nodeRenderer;
            this.treeViewListeners.nodeRendererChanged(this, previousNodeRenderer);
        }
    }

    public NodeEditor getNodeEditor() {
        return this.nodeEditor;
    }

    public void setNodeEditor(NodeEditor nodeEditor) {
        NodeEditor previousNodeEditor = this.nodeEditor;
        if (previousNodeEditor != nodeEditor) {
            this.nodeEditor = nodeEditor;
            this.treeViewListeners.nodeEditorChanged(this, previousNodeEditor);
        }
    }

    public SelectMode getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(SelectMode selectMode) {
        if (selectMode == null) {
            throw new IllegalArgumentException("selectMode is null");
        }
        SelectMode previousSelectMode = this.selectMode;
        if (selectMode != previousSelectMode) {
            this.selectedPaths.clear();
            this.selectMode = selectMode;
            this.treeViewListeners.selectModeChanged(this, previousSelectMode);
        }
    }

    public ImmutableList<Sequence.Tree.Path> getSelectedPaths() {
        return new ImmutableList(this.selectedPaths);
    }

    public Sequence<Sequence.Tree.Path> setSelectedPaths(Sequence<Sequence.Tree.Path> selectedPaths) {
        Object previousSelectedNode;
        if (selectedPaths == null) {
            throw new IllegalArgumentException("selectedPaths is null.");
        }
        if (this.selectMode == SelectMode.NONE) {
            throw new IllegalStateException("Selection is not enabled.");
        }
        if (this.selectMode == SelectMode.SINGLE && selectedPaths.getLength() > 1) {
            throw new IllegalArgumentException("Selection length is greater than 1.");
        }
        ArrayList<Sequence.Tree.Path> previousSelectedPaths = this.selectedPaths;
        Object object = previousSelectedNode = this.selectMode == SelectMode.SINGLE ? this.getSelectedNode() : null;
        if (selectedPaths != previousSelectedPaths) {
            this.selectedPaths = new ArrayList(PATH_COMPARATOR);
            int n = selectedPaths.getLength();
            for (int i = 0; i < n; ++i) {
                Sequence.Tree.Path path = (Sequence.Tree.Path)selectedPaths.get(i);
                this.monitorBranch(new Sequence.Tree.Path(path, path.getLength() - 1));
                this.selectedPaths.add((Object)new Sequence.Tree.ImmutablePath(path));
            }
            this.treeViewSelectionListeners.selectedPathsChanged(this, (Sequence<Sequence.Tree.Path>)previousSelectedPaths);
            if (this.selectMode == SelectMode.SINGLE) {
                this.treeViewSelectionListeners.selectedNodeChanged(this, previousSelectedNode);
            }
        }
        return this.getSelectedPaths();
    }

    public Sequence.Tree.Path getFirstSelectedPath() {
        return this.selectedPaths.getLength() > 0 ? (Sequence.Tree.Path)this.selectedPaths.get(0) : null;
    }

    public Sequence.Tree.Path getLastSelectedPath() {
        return this.selectedPaths.getLength() > 0 ? (Sequence.Tree.Path)this.selectedPaths.get(this.selectedPaths.getLength() - 1) : null;
    }

    public Sequence.Tree.Path getSelectedPath() {
        if (this.selectMode != SelectMode.SINGLE) {
            throw new IllegalStateException("Tree view is not in single-select mode.");
        }
        return this.selectedPaths.getLength() > 0 ? (Sequence.Tree.Path)this.selectedPaths.get(0) : null;
    }

    public void setSelectedPath(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        this.setSelectedPaths((Sequence<Sequence.Tree.Path>)new ArrayList((Object[])new Sequence.Tree.Path[]{path}));
    }

    public Object getSelectedNode() {
        Sequence.Tree.Path path = this.getSelectedPath();
        Object node = null;
        if (path != null) {
            node = Sequence.Tree.get(this.treeData, (Sequence.Tree.Path)path);
        }
        return node;
    }

    public boolean addSelectedPath(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("Tree view is not in multi-select mode.");
        }
        int index = this.selectedPaths.indexOf((Object)path);
        if (index < 0) {
            this.monitorBranch(new Sequence.Tree.Path(path, path.getLength() - 1));
            this.selectedPaths.add((Object)new Sequence.Tree.ImmutablePath(path));
            this.treeViewSelectionListeners.selectedPathAdded(this, path);
            this.treeViewSelectionListeners.selectedPathsChanged(this, null);
        }
        return index < 0;
    }

    public boolean removeSelectedPath(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        if (this.selectMode != SelectMode.MULTI) {
            throw new IllegalStateException("Tree view is not in multi-select mode.");
        }
        int index = this.selectedPaths.indexOf((Object)path);
        if (index >= 0) {
            this.selectedPaths.remove(index, 1);
            this.treeViewSelectionListeners.selectedPathRemoved(this, path);
            this.treeViewSelectionListeners.selectedPathsChanged(this, null);
        }
        return index >= 0;
    }

    public void clearSelection() {
        if (this.selectedPaths.getLength() > 0) {
            ArrayList<Sequence.Tree.Path> previousSelectedPaths = this.selectedPaths;
            this.selectedPaths = new ArrayList(PATH_COMPARATOR);
            this.treeViewSelectionListeners.selectedPathsChanged(this, (Sequence<Sequence.Tree.Path>)previousSelectedPaths);
        }
    }

    public boolean isNodeSelected(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        return this.selectedPaths.indexOf((Object)path) >= 0;
    }

    public boolean isNodeDisabled(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        boolean disabled = false;
        if (this.disabledNodeFilter != null) {
            Object node = Sequence.Tree.get(this.treeData, (Sequence.Tree.Path)path);
            disabled = this.disabledNodeFilter.include(node);
        }
        return disabled;
    }

    public Filter<?> getDisabledNodeFilter() {
        return this.disabledNodeFilter;
    }

    public void setDisabledNodeFilter(Filter<?> disabledNodeFilter) {
        Filter<?> previousDisabledNodeFilter = this.disabledNodeFilter;
        if (previousDisabledNodeFilter != disabledNodeFilter) {
            this.disabledNodeFilter = disabledNodeFilter;
            this.treeViewListeners.disabledNodeFilterChanged(this, previousDisabledNodeFilter);
        }
    }

    public boolean getCheckmarksEnabled() {
        return this.checkmarksEnabled;
    }

    public void setCheckmarksEnabled(boolean checkmarksEnabled) {
        if (this.checkmarksEnabled != checkmarksEnabled) {
            this.checkedPaths.clear();
            this.checkmarksEnabled = checkmarksEnabled;
            this.treeViewListeners.checkmarksEnabledChanged(this);
        }
    }

    public boolean getShowMixedCheckmarkState() {
        return this.showMixedCheckmarkState;
    }

    public void setShowMixedCheckmarkState(boolean showMixedCheckmarkState) {
        if (this.showMixedCheckmarkState != showMixedCheckmarkState) {
            this.showMixedCheckmarkState = showMixedCheckmarkState;
            this.treeViewListeners.showMixedCheckmarkStateChanged(this);
        }
    }

    public boolean isNodeChecked(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        return this.checkedPaths.indexOf((Object)path) >= 0;
    }

    public NodeCheckState getNodeCheckState(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        NodeCheckState checkState = NodeCheckState.UNCHECKED;
        if (this.checkmarksEnabled) {
            Sequence.Tree.Path nextCheckedPath;
            int index = ArrayList.binarySearch(this.checkedPaths, (Object)path, PATH_COMPARATOR);
            if (index >= 0) {
                checkState = NodeCheckState.CHECKED;
            } else if (this.showMixedCheckmarkState && (index = -(index + 1)) < this.checkedPaths.getLength() && Sequence.Tree.isDescendant((Sequence.Tree.Path)path, (Sequence.Tree.Path)(nextCheckedPath = (Sequence.Tree.Path)this.checkedPaths.get(index)))) {
                checkState = NodeCheckState.MIXED;
            }
        }
        return checkState;
    }

    public void setNodeChecked(Sequence.Tree.Path path, boolean checked) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        if (!this.checkmarksEnabled) {
            throw new IllegalStateException("Checkmarks are not enabled.");
        }
        int index = this.checkedPaths.indexOf((Object)path);
        if (index < 0 && checked || index >= 0 && !checked) {
            int i;
            Sequence.Tree.Path ancestorPath;
            NodeCheckState previousCheckState = this.getNodeCheckState(path);
            ArrayList ancestorCheckStates = null;
            if (this.showMixedCheckmarkState) {
                ancestorCheckStates = new ArrayList(path.getLength() - 1);
                ancestorPath = new Sequence.Tree.Path(path, path.getLength() - 1);
                for (i = ancestorPath.getLength() - 1; i >= 0; --i) {
                    ancestorCheckStates.insert((Object)this.getNodeCheckState(ancestorPath), 0);
                    ancestorPath.remove(i, 1);
                }
            }
            if (checked) {
                this.monitorBranch(new Sequence.Tree.Path(path, path.getLength() - 1));
                this.checkedPaths.add((Object)new Sequence.Tree.ImmutablePath(path));
            } else {
                this.checkedPaths.remove(index, 1);
            }
            this.treeViewNodeStateListeners.nodeCheckStateChanged(this, path, previousCheckState);
            if (this.showMixedCheckmarkState) {
                ancestorPath = new Sequence.Tree.Path(path, path.getLength() - 1);
                for (i = ancestorPath.getLength() - 1; i >= 0; --i) {
                    NodeCheckState ancestorPreviousCheckState = (NodeCheckState)((Object)ancestorCheckStates.get(i));
                    NodeCheckState ancestorCheckState = this.getNodeCheckState(ancestorPath);
                    if (ancestorCheckState != ancestorPreviousCheckState) {
                        this.treeViewNodeStateListeners.nodeCheckStateChanged(this, ancestorPath, ancestorPreviousCheckState);
                    }
                    ancestorPath.remove(i, 1);
                }
            }
        }
    }

    public Sequence<Sequence.Tree.Path> getCheckedPaths() {
        return new ImmutableList(this.checkedPaths);
    }

    public Filter<?> getDisabledCheckmarkFilter() {
        return this.disabledCheckmarkFilter;
    }

    public void setDisabledCheckmarkFilter(Filter<?> disabledCheckmarkFilter) {
        Filter<?> previousDisabledCheckmarkFilter = this.disabledCheckmarkFilter;
        if (previousDisabledCheckmarkFilter != disabledCheckmarkFilter) {
            this.disabledCheckmarkFilter = disabledCheckmarkFilter;
            this.treeViewListeners.disabledCheckmarkFilterChanged(this, previousDisabledCheckmarkFilter);
        }
    }

    public void setBranchExpanded(Sequence.Tree.Path path, boolean expanded) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        int index = this.expandedPaths.indexOf((Object)path);
        if (expanded && index < 0) {
            this.monitorBranch(path);
            this.expandedPaths.add((Object)new Sequence.Tree.ImmutablePath(path));
            this.treeViewBranchListeners.branchExpanded(this, path);
        } else if (!expanded && index >= 0) {
            this.expandedPaths.remove(index, 1);
            this.treeViewBranchListeners.branchCollapsed(this, path);
        }
    }

    public boolean isBranchExpanded(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        return this.expandedPaths.indexOf((Object)path) >= 0;
    }

    public final void expandBranch(Sequence.Tree.Path path) {
        this.setBranchExpanded(path, true);
    }

    public final void expandAll() {
        Sequence.Tree.ItemIterator itemIterator = Sequence.Tree.depthFirstIterator(this.treeData);
        while (itemIterator.hasNext()) {
            Sequence.Tree.Path path;
            Object node = itemIterator.next();
            if (!(node instanceof List) || (path = itemIterator.getPath()).getLength() <= 0) continue;
            this.expandBranch(path);
        }
    }

    public final void collapseBranch(Sequence.Tree.Path path) {
        this.setBranchExpanded(path, false);
    }

    public final void collapseAll() {
        Sequence.Tree.ItemIterator itemIterator = Sequence.Tree.depthFirstIterator(this.treeData);
        while (itemIterator.hasNext()) {
            Sequence.Tree.Path path;
            Object node = itemIterator.next();
            if (!(node instanceof List) || (path = itemIterator.getPath()).getLength() <= 0) continue;
            this.collapseBranch(path);
        }
    }

    private void monitorBranch(Sequence.Tree.Path path) {
        BranchHandler parent = this.rootBranchHandler;
        int n = path.getLength();
        for (int i = 0; i < n; ++i) {
            int index = path.get(i);
            if (index < 0 || index >= parent.getLength()) {
                throw new IndexOutOfBoundsException("Branch path out of bounds: " + path);
            }
            BranchHandler child = (BranchHandler)((Object)parent.get(index));
            if (child == null) {
                List<?> parentBranchData = parent.getBranchData();
                Object childData = parentBranchData.get(index);
                if (!(childData instanceof List)) {
                    throw new IllegalArgumentException("Unexpected leaf in branch path: " + path);
                }
                child = new BranchHandler(parent, (List)childData);
                parent.update(index, (Object)child);
            }
            parent = child;
        }
    }

    public Sequence.Tree.Path getNodeAt(int y) {
        Skin treeViewSkin = (Skin)((Object)this.getSkin());
        return treeViewSkin.getNodeAt(y);
    }

    public Bounds getNodeBounds(Sequence.Tree.Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is null.");
        }
        if (path.getLength() == 0) {
            throw new IllegalArgumentException("path is empty.");
        }
        Skin treeViewSkin = (Skin)((Object)this.getSkin());
        return treeViewSkin.getNodeBounds(path);
    }

    public int getNodeIndent(int depth) {
        Skin treeViewSkin = (Skin)((Object)this.getSkin());
        return treeViewSkin.getNodeIndent(depth);
    }

    public int getRowIndex(Sequence.Tree.Path path) {
        Skin treeViewSkin = (Skin)((Object)this.getSkin());
        return treeViewSkin.getRowIndex(path);
    }

    public ListenerList<TreeViewListener> getTreeViewListeners() {
        return this.treeViewListeners;
    }

    public ListenerList<TreeViewBranchListener> getTreeViewBranchListeners() {
        return this.treeViewBranchListeners;
    }

    public ListenerList<TreeViewNodeListener> getTreeViewNodeListeners() {
        return this.treeViewNodeListeners;
    }

    public ListenerList<TreeViewNodeStateListener> getTreeViewNodeStateListeners() {
        return this.treeViewNodeStateListeners;
    }

    public ListenerList<TreeViewSelectionListener> getTreeViewSelectionListeners() {
        return this.treeViewSelectionListeners;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BranchHandler
    extends ArrayList<BranchHandler>
    implements ListListener<Object> {
        private static final long serialVersionUID = -6132480635507615071L;
        private BranchHandler parent;
        private List<?> branchData;

        public BranchHandler(BranchHandler parent, List<?> branchData) {
            super(branchData.getLength());
            this.parent = parent;
            this.branchData = branchData;
            branchData.getListListeners().add((Object)this);
            int n = branchData.getLength();
            for (int i = 0; i < n; ++i) {
                this.add(null);
            }
        }

        public List<?> getBranchData() {
            return this.branchData;
        }

        public void release() {
            this.branchData.getListListeners().remove((Object)this);
            int n = this.getLength();
            for (int i = 0; i < n; ++i) {
                BranchHandler branchHandler = (BranchHandler)((Object)this.get(i));
                if (branchHandler == null) continue;
                branchHandler.release();
            }
        }

        private Sequence.Tree.Path getPath() {
            Sequence.Tree.Path path = new Sequence.Tree.Path();
            BranchHandler handler = this;
            while (handler.parent != null) {
                int index = handler.parent.branchData.indexOf(handler.branchData);
                path.insert(Integer.valueOf(index), 0);
                handler = handler.parent;
            }
            return path;
        }

        public void itemInserted(List<Object> list, int index) {
            Sequence.Tree.Path path = this.getPath();
            this.insert(null, index);
            this.incrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path, index);
            int updated = this.incrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path, index);
            this.incrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path, index);
            TreeView.this.treeViewNodeListeners.nodeInserted(TreeView.this, path, index);
            if (updated > 0) {
                TreeView.this.treeViewSelectionListeners.selectedPathsChanged(TreeView.this, (Sequence<Sequence.Tree.Path>)TreeView.this.getSelectedPaths());
            }
        }

        public void itemsRemoved(List<Object> list, int index, Sequence<Object> items) {
            Sequence.Tree.Path path = this.getPath();
            Sequence.Tree.Path previousSelectedPath = TreeView.this.selectMode == SelectMode.SINGLE && TreeView.this.selectedPaths.getLength() > 0 ? (Sequence.Tree.Path)TreeView.this.selectedPaths.get(0) : null;
            int count = items.getLength();
            Sequence removed = this.remove(index, count);
            int n = removed.getLength();
            for (int i = 0; i < n; ++i) {
                BranchHandler handler = (BranchHandler)((Object)removed.get(i));
                if (handler == null) continue;
                handler.release();
            }
            this.clearAndDecrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path, index, count);
            int updated = this.clearAndDecrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path, index, count);
            this.clearAndDecrementPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path, index, count);
            TreeView.this.treeViewNodeListeners.nodesRemoved(TreeView.this, path, index, count);
            if (updated > 0) {
                TreeView.this.treeViewSelectionListeners.selectedPathsChanged(TreeView.this, (Sequence<Sequence.Tree.Path>)TreeView.this.getSelectedPaths());
                if (TreeView.this.selectMode == SelectMode.SINGLE && !TreeView.this.getSelectedPath().equals(previousSelectedPath)) {
                    TreeView.this.treeViewSelectionListeners.selectedNodeChanged(TreeView.this, null);
                }
            }
        }

        public void itemUpdated(List<Object> list, int index, Object previousItem) {
            Sequence.Tree.Path path = this.getPath();
            if (list.get(index) != previousItem) {
                BranchHandler handler = (BranchHandler)((Object)this.update(index, null));
                if (handler != null) {
                    handler.release();
                }
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path, index);
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path, index);
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path, index);
            }
            TreeView.this.treeViewNodeListeners.nodeUpdated(TreeView.this, path, index);
        }

        public void listCleared(List<Object> list) {
            Sequence.Tree.Path path = this.getPath();
            int n = this.getLength();
            for (int i = 0; i < n; ++i) {
                BranchHandler handler = (BranchHandler)((Object)this.get(i));
                if (handler == null) continue;
                handler.release();
            }
            this.clear();
            this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path);
            int cleared = this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path);
            this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path);
            TreeView.this.treeViewNodeListeners.nodesCleared(TreeView.this, path);
            if (cleared > 0) {
                TreeView.this.treeViewSelectionListeners.selectedPathsChanged(TreeView.this, (Sequence<Sequence.Tree.Path>)TreeView.this.getSelectedPaths());
                if (TreeView.this.selectMode == SelectMode.SINGLE) {
                    TreeView.this.treeViewSelectionListeners.selectedNodeChanged(TreeView.this, null);
                }
            }
        }

        public void comparatorChanged(List<Object> list, Comparator<Object> previousComparator) {
            if (list.getComparator() != null) {
                Sequence.Tree.Path path = this.getPath();
                int n = this.getLength();
                for (int i = 0; i < n; ++i) {
                    BranchHandler handler = (BranchHandler)((Object)this.update(i, null));
                    if (handler == null) continue;
                    handler.release();
                }
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.expandedPaths, path);
                int cleared = this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.selectedPaths, path);
                this.clearPaths((ArrayList<Sequence.Tree.Path>)TreeView.this.checkedPaths, path);
                TreeView.this.treeViewNodeListeners.nodesSorted(TreeView.this, path);
                if (cleared > 0) {
                    TreeView.this.treeViewSelectionListeners.selectedPathsChanged(TreeView.this, (Sequence<Sequence.Tree.Path>)TreeView.this.getSelectedPaths());
                    if (TreeView.this.selectMode == SelectMode.SINGLE) {
                        TreeView.this.treeViewSelectionListeners.selectedNodeChanged(TreeView.this, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int incrementPaths(ArrayList<Sequence.Tree.Path> paths, Sequence.Tree.Path basePath, int index) {
            Sequence.Tree.Path childPath = new Sequence.Tree.Path(basePath);
            childPath.add(Integer.valueOf(index));
            int i = ArrayList.binarySearch(paths, (Object)childPath, (Comparator)PATH_COMPARATOR);
            if (i < 0) {
                i = -(i + 1);
            }
            paths.setComparator(null);
            int n = paths.getLength();
            try {
                int depth = basePath.getLength();
                while (i < n) {
                    Integer[] elements;
                    Sequence.Tree.Path affectedPath = (Sequence.Tree.Path)paths.get(i);
                    if (!Sequence.Tree.isDescendant((Sequence.Tree.Path)basePath, (Sequence.Tree.Path)affectedPath)) {
                        break;
                    }
                    Integer[] integerArray = elements = affectedPath.toArray();
                    int n2 = depth;
                    Integer n3 = integerArray[n2];
                    Integer n4 = integerArray[n2] = Integer.valueOf(integerArray[n2] + 1);
                    paths.update(i, (Object)new Sequence.Tree.ImmutablePath(elements));
                    ++i;
                }
            }
            finally {
                paths.setComparator(PATH_COMPARATOR);
            }
            return n - i;
        }

        private int clearAndDecrementPaths(ArrayList<Sequence.Tree.Path> paths, Sequence.Tree.Path basePath, int index, int count) {
            Sequence.Tree.Path affectedPath;
            int depth = basePath.getLength();
            Sequence.Tree.Path testPath = new Sequence.Tree.Path(basePath);
            testPath.add(Integer.valueOf(index));
            int start = ArrayList.binarySearch(paths, (Object)testPath, (Comparator)PATH_COMPARATOR);
            if (start < 0) {
                start = -(start + 1);
            }
            testPath.update(depth, Integer.valueOf(index + count));
            int end = ArrayList.binarySearch(paths, (Object)testPath, (Comparator)PATH_COMPARATOR);
            if (end < 0) {
                end = -(end + 1);
            }
            if (end > start) {
                paths.remove(start, end - start);
            }
            int n = paths.getLength();
            for (int i = start; i < n && Sequence.Tree.isDescendant((Sequence.Tree.Path)basePath, (Sequence.Tree.Path)(affectedPath = (Sequence.Tree.Path)paths.get(i))); ++i) {
                Integer[] elements;
                Integer[] integerArray = elements = affectedPath.toArray();
                int n2 = depth;
                Integer.valueOf(integerArray[n2] - count);
                paths.update(i, (Object)new Sequence.Tree.ImmutablePath(elements));
            }
            return n - start;
        }

        private void clearPaths(ArrayList<Sequence.Tree.Path> paths, Sequence.Tree.Path basePath, int index) {
            Sequence.Tree.Path affectedPath;
            Sequence.Tree.Path childPath = new Sequence.Tree.Path(basePath);
            childPath.add(Integer.valueOf(index));
            int clearIndex = ArrayList.binarySearch(paths, (Object)childPath, (Comparator)PATH_COMPARATOR);
            if (clearIndex < 0) {
                clearIndex = -(clearIndex + 1);
            }
            int n = paths.getLength();
            for (int i = clearIndex; i < n && Sequence.Tree.isDescendant((Sequence.Tree.Path)childPath, (Sequence.Tree.Path)(affectedPath = (Sequence.Tree.Path)paths.get(clearIndex))); ++i) {
                paths.remove(clearIndex, 1);
            }
        }

        private int clearPaths(ArrayList<Sequence.Tree.Path> paths, Sequence.Tree.Path basePath) {
            Sequence.Tree.Path affectedPath;
            int index = ArrayList.binarySearch(paths, (Object)basePath, (Comparator)PATH_COMPARATOR);
            index = index < 0 ? -(index + 1) : index + 1;
            int n = paths.getLength();
            for (int i = index; i < n && Sequence.Tree.isDescendant((Sequence.Tree.Path)basePath, (Sequence.Tree.Path)(affectedPath = (Sequence.Tree.Path)paths.get(index))); ++i) {
                paths.remove(index, 1);
            }
            return n - index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PathComparator
    implements Comparator<Sequence.Tree.Path> {
        @Override
        public int compare(Sequence.Tree.Path path1, Sequence.Tree.Path path2) {
            int path1Length = path1.getLength();
            int path2Length = path2.getLength();
            int n = Math.min(path1Length, path2Length);
            for (int i = 0; i < n; ++i) {
                int pathElement2;
                int pathElement1 = path1.get(i);
                if (pathElement1 == (pathElement2 = path2.get(i).intValue())) continue;
                return pathElement1 - pathElement2;
            }
            return path1Length - path2Length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeViewSelectionListenerList
    extends ListenerList<TreeViewSelectionListener>
    implements TreeViewSelectionListener {
        private TreeViewSelectionListenerList() {
        }

        @Override
        public void selectedPathAdded(TreeView treeView, Sequence.Tree.Path path) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewSelectionListener listener = (TreeViewSelectionListener)i$.next();
                listener.selectedPathAdded(treeView, path);
            }
        }

        @Override
        public void selectedPathRemoved(TreeView treeView, Sequence.Tree.Path path) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewSelectionListener listener = (TreeViewSelectionListener)i$.next();
                listener.selectedPathRemoved(treeView, path);
            }
        }

        @Override
        public void selectedPathsChanged(TreeView treeView, Sequence<Sequence.Tree.Path> previousSelectedPaths) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewSelectionListener listener = (TreeViewSelectionListener)i$.next();
                listener.selectedPathsChanged(treeView, previousSelectedPaths);
            }
        }

        @Override
        public void selectedNodeChanged(TreeView treeView, Object previousSelectedNode) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewSelectionListener listener = (TreeViewSelectionListener)i$.next();
                listener.selectedNodeChanged(treeView, previousSelectedNode);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeViewNodeStateListenerList
    extends ListenerList<TreeViewNodeStateListener>
    implements TreeViewNodeStateListener {
        private TreeViewNodeStateListenerList() {
        }

        @Override
        public void nodeCheckStateChanged(TreeView treeView, Sequence.Tree.Path path, NodeCheckState previousCheckState) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewNodeStateListener listener = (TreeViewNodeStateListener)i$.next();
                listener.nodeCheckStateChanged(treeView, path, previousCheckState);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeViewNodeListenerList
    extends ListenerList<TreeViewNodeListener>
    implements TreeViewNodeListener {
        private TreeViewNodeListenerList() {
        }

        @Override
        public void nodeInserted(TreeView treeView, Sequence.Tree.Path path, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewNodeListener listener = (TreeViewNodeListener)i$.next();
                listener.nodeInserted(treeView, path, index);
            }
        }

        @Override
        public void nodesRemoved(TreeView treeView, Sequence.Tree.Path path, int index, int count) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewNodeListener listener = (TreeViewNodeListener)i$.next();
                listener.nodesRemoved(treeView, path, index, count);
            }
        }

        @Override
        public void nodeUpdated(TreeView treeView, Sequence.Tree.Path path, int index) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewNodeListener listener = (TreeViewNodeListener)i$.next();
                listener.nodeUpdated(treeView, path, index);
            }
        }

        @Override
        public void nodesCleared(TreeView treeView, Sequence.Tree.Path path) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewNodeListener listener = (TreeViewNodeListener)i$.next();
                listener.nodesCleared(treeView, path);
            }
        }

        @Override
        public void nodesSorted(TreeView treeView, Sequence.Tree.Path path) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewNodeListener listener = (TreeViewNodeListener)i$.next();
                listener.nodesSorted(treeView, path);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeViewBranchListenerList
    extends ListenerList<TreeViewBranchListener>
    implements TreeViewBranchListener {
        private TreeViewBranchListenerList() {
        }

        @Override
        public void branchExpanded(TreeView treeView, Sequence.Tree.Path path) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewBranchListener listener = (TreeViewBranchListener)i$.next();
                listener.branchExpanded(treeView, path);
            }
        }

        @Override
        public void branchCollapsed(TreeView treeView, Sequence.Tree.Path path) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewBranchListener listener = (TreeViewBranchListener)i$.next();
                listener.branchCollapsed(treeView, path);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeViewListenerList
    extends ListenerList<TreeViewListener>
    implements TreeViewListener {
        private TreeViewListenerList() {
        }

        @Override
        public void treeDataChanged(TreeView treeView, List<?> previousTreeData) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewListener listener = (TreeViewListener)i$.next();
                listener.treeDataChanged(treeView, previousTreeData);
            }
        }

        @Override
        public void nodeRendererChanged(TreeView treeView, NodeRenderer previousNodeRenderer) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewListener listener = (TreeViewListener)i$.next();
                listener.nodeRendererChanged(treeView, previousNodeRenderer);
            }
        }

        @Override
        public void nodeEditorChanged(TreeView treeView, NodeEditor previousNodeEditor) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewListener listener = (TreeViewListener)i$.next();
                listener.nodeEditorChanged(treeView, previousNodeEditor);
            }
        }

        @Override
        public void selectModeChanged(TreeView treeView, SelectMode previousSelectMode) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewListener listener = (TreeViewListener)i$.next();
                listener.selectModeChanged(treeView, previousSelectMode);
            }
        }

        @Override
        public void checkmarksEnabledChanged(TreeView treeView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewListener listener = (TreeViewListener)i$.next();
                listener.checkmarksEnabledChanged(treeView);
            }
        }

        @Override
        public void showMixedCheckmarkStateChanged(TreeView treeView) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewListener listener = (TreeViewListener)i$.next();
                listener.showMixedCheckmarkStateChanged(treeView);
            }
        }

        @Override
        public void disabledNodeFilterChanged(TreeView treeView, Filter<?> previousDisabledNodeFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewListener listener = (TreeViewListener)i$.next();
                listener.disabledNodeFilterChanged(treeView, previousDisabledNodeFilter);
            }
        }

        @Override
        public void disabledCheckmarkFilterChanged(TreeView treeView, Filter<?> previousDisabledCheckmarkFilter) {
            Iterator i$ = this.iterator();
            while (i$.hasNext()) {
                TreeViewListener listener = (TreeViewListener)i$.next();
                listener.disabledCheckmarkFilterChanged(treeView, previousDisabledCheckmarkFilter);
            }
        }
    }

    public static interface Skin {
        public Sequence.Tree.Path getNodeAt(int var1);

        public Bounds getNodeBounds(Sequence.Tree.Path var1);

        public int getNodeIndent(int var1);

        public int getRowIndex(Sequence.Tree.Path var1);
    }

    public static interface NodeEditor {
        public void beginEdit(TreeView var1, Sequence.Tree.Path var2);

        public void endEdit(boolean var1);

        public boolean isEditing();
    }

    public static interface NodeRenderer
    extends Renderer {
        public void render(Object var1, Sequence.Tree.Path var2, int var3, TreeView var4, boolean var5, boolean var6, NodeCheckState var7, boolean var8, boolean var9);

        public String toString(Object var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeCheckState {
        CHECKED,
        UNCHECKED,
        MIXED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SelectMode {
        NONE,
        SINGLE,
        MULTI;

    }
}

